#!/usr/local/bin/perl

#┌─────────────────────────────────
#│ SMART BLOG : admin.cgi - 2022/03/21
#│ copyright (c) kentweb, 1997-2022
#│ https://www.kent-web.com/
#└─────────────────────────────────

# モジュール宣言
use strict;
use CGI::Carp qw(fatalsToBrowser);
use vars qw(%in %cf);
use lib "./lib";
use CGI::Minimal;
use CGI::Session;
use Digest::SHA::PurePerl qw(sha256_base64);

# 設定ファイル認識
require "./init.cgi";
%cf = set_init();

# データ受理
CGI::Minimal::max_read_size($cf{maxdata});
my $cgi = CGI::Minimal->new;
error('容量オーバー') if ($cgi->truncated);
%in = parse_form($cgi);

# 認証
require "./lib/login.pl";
auth_login();

# 処理分岐
if ($in{set_base}) { set_base(); }
if ($in{data_new}) { data_new(); }
if ($in{data_mgr}) { data_mgr(); }
if ($in{come_new}) { come_new(); }
if ($in{come_mgr}) { come_mgr(); }
if ($in{pass_mgr}) { pass_mgr(); }

# メニュー画面
menu_html();

#-----------------------------------------------------------
#  メニュー画面
#-----------------------------------------------------------
sub menu_html {
	header("管理メニュー");
	print <<EOM;
<div id="body">
<p>選択ボタンを押してください。</p>
<form action="$cf{admin_cgi}" method="post">
<input type="hidden" name="sid" value="$in{sid}">
<table class="form-tbl">
<tr>
	<th></th>
	<th class="w-16">管理メニュー</th>
</tr><tr>
	<td><input type="submit" name="data_new" value="選択"></td>
	<td>新規記事作成</td>
</tr><tr>
	<td><input type="submit" name="data_mgr" value="選択"></td>
	<td>記事データ管理</td>
</tr><tr>
	<td><input type="submit" name="come_new" value="選択"></td>
	<td>コメント承認</td>
</tr><tr>
	<td><input type="submit" name="come_mgr" value="選択"></td>
	<td>コメント管理</td>
</tr><tr>
	<td><input type="submit" name="set_base" value="選択"></td>
	<td>基本設定</td>
</tr><tr>
	<td><input type="submit" name="pass_mgr" value="選択"></td>
	<td>パスワード管理</td>
</tr><tr>
	<td><input type="submit" name="logoff" value="選択"></td>
	<td>ログアウト</td>
</tr>
</table>
</form>
</div>
</body>
</html>
EOM
	exit;
}

#-----------------------------------------------------------
#  日記書き込み
#-----------------------------------------------------------
sub data_new {
	my $log = shift;
	my ($no,$y,$m,$d,$time,$cat,$res,$ttl,$com1,$com2,$com3,$ex1,$w1,$h1,$ex2,$w2,$h2,$ex3,$w3,$h3) = split(/<>/,$log);
	my %ex = (1 => $ex1, 2 => $ex2, 3 => $ex3);
	my %com = (1 => $com1, 2 => $com2, 3 => $com3);
	
	# 設定ファイル
	my %set = read_set();
	
	# 新規
	if ($in{job} eq 'reg') {
		
		my $err;
		if ($in{ttl} eq "") { $err .= "タイトルが未入力です<br>\n"; }
		if ($in{com1} eq "") { $err .= "本文1が未入力です<br>\n"; }
		if ($err) { error($err); }
		
		if (!-e "$cf{datadir}/log/$in{y}-$in{m}.dat") {
			open(DAT,"> $cf{datadir}/log/$in{y}-$in{m}.dat");
			close(DAT);
			
			chmod(0666,"$cf{datadir}/log/$in{y}-$in{m}.dat");
		}
		
		# 採番
		open(DAT,"+< $cf{datadir}/num.dat");
		my $num = <DAT> + 1;
		seek(DAT,0,0);
		print DAT $num;
		truncate(DAT,tell(DAT));
		close(DAT);
		
		# 画像アップ
		my ($ex1,$w1,$h1,$ex2,$w2,$h2,$ex3,$w3,$h3)
				= upload($num) if ($in{upfile1} or $in{upfile2} or $in{upfile3});
		
		# 月次ログ更新
		my (@sort,@data);
		open(DAT,"+< $cf{datadir}/log/$in{y}-$in{m}.dat");
		while(<DAT>) {
			my ($no,$y,$m,$d,$time,$cat,$res,$ttl,$com1,$com2,$com3,$ex1,$w1,$h1,$ex2,$w2,$h2,$ex3,$w3,$h3) = split(/<>/);
			
			$time =~ s/\D//g;
			push(@sort,"$d$time");
			push(@data,$_);
		}
		
		my $time = $in{time};
		$time =~ s/\D//g;
		
		unshift(@sort,"$in{d}$time");
		unshift(@data,"$num<>$in{y}<>$in{m}<>$in{d}<>$in{time}<>$in{cate}<>$in{res}<>$in{ttl}<>$in{com1}<>$in{com2}<>$in{com3}<>$ex1<>$w1<>$h1<>$ex2<>$w2<>$h2<>$ex3<>$w3<>$h3<>\n");
		
		# ソート
		@data = @data[sort{$sort[$b] <=> $sort[$a]} 0 .. $#sort];
		
		# 更新
		seek(DAT,0,0);
		print DAT @data;
		truncate(DAT,tell(DAT));
		close(DAT);
		
		# 年月書庫
		@data = ();
		my $flg;
		open(DAT,"+< $cf{datadir}/archive.dat");
		while(<DAT>) {
			my ($y,$m,$cnt) = split(/,/);
			
			if ($in{y} == $y && $in{m} == $m) {
				$flg++;
				
				chomp $cnt;
				$cnt++;
				$_ = "$y,$m,$cnt\n";
			}
			push(@data,$_);
		}
		
		# 新規年月の場合
		if (!$flg) {
			
			# ソートするため再度展開
			my (@jun,@log);
			for (@data) {
				my ($y,$m,$cnt) = split(/,/);
				
				push(@jun,"$y$m");
				push(@log,$_);
			}
			
			# 新規データ追加
			push(@jun,"$in{y}$in{m}");
			push(@log,"$in{y},$in{m},1\n");
			
			# ソート
			@data = @log[sort{$jun[$b] <=> $jun[$a]} 0 .. $#jun];
		}
		
		seek(DAT,0,0);
		print DAT @data;
		truncate(DAT,tell(DAT));
		close(DAT);
		
		# index更新
		my (@log,@tmp);
		open(DAT,"+< $cf{datadir}/index.dat");
		while(<DAT>) {
			my ($no,$y,$m,$d,$tm,$cat) = split(/,/);
			
			push(@tmp,"$y$m$d$tm");
			push(@log,$_);
		}
		$in{time} =~ s/\D//g;
		unshift(@tmp,"$in{y}$in{m}$in{d}$in{time}");
		unshift(@log,"$num,$in{y},$in{m},$in{d},$in{time},$in{cate}\n");
		
		@log = @log[sort {$tmp[$b] <=> $tmp[$a]} 0 .. $#tmp];
		
		seek(DAT,0,0);
		print DAT @log;
		truncate(DAT,tell(DAT));
		close(DAT);
		
		# カテゴリindex
		cat_index() if ($in{cate} ne '');
		
		# 新規記事index
		my @new;
		for (0 .. $set{max_entry} - 1) {
			push(@new,$log[$_]);
		}
		entry_index($num,\@new);
		
		# 完了メッセージ
		message("新規書き込みを完了しました");
	}
	
	# メンテのとき
	my $hidden;
	if ($in{data_mgr}) {
		for my $i (1 .. 5) {
			$com{$i} =~ s/<br>/\n/g;
		}
		$hidden .= qq|<input type="hidden" name="data_mgr" value="1">\n|;
		$hidden .= qq|<input type="hidden" name="job" value="men">\n|;
		$hidden .= qq|<input type="hidden" name="ym" value="$in{ym}">\n|;
		$hidden .= qq|<input type="hidden" name="no" value="$in{no}">\n|;
	
	# 新規のとき
	} else {
		my ($min,$hr,$day,$mon,$yr) = (localtime(time))[1..5];
		$y = $yr + 1900;
		$m = sprintf("%02d",$mon+1);
		$d = sprintf("%02d",$day);
		$time = sprintf("%02d:%02d",$hr,$min);
		
		$hidden .= qq|<input type="hidden" name="data_new" value="1">\n|;
		$hidden .= qq|<input type="hidden" name="job" value="reg">\n|;
	}
	
	# 表示開始
	header("登録フォーム");
	print <<EOM;
<div id="body">
<div class="back-btn">
<form action="$cf{admin_cgi}" method="post">
<input type="hidden" name="sid" value="$in{sid}">
<input type="submit" value="&lt; メニュー">
</form>
</div>
<div class="ttl">■ 記事投稿フォーム</div>
<form action="$cf{admin_cgi}" method="post" enctype="multipart/form-data">
<input type="hidden" name="sid" value="$in{sid}">
$hidden
<p>
	・ タイトル及び本文1は入力必須です。
	<a href="#" onclick="window.open('$cf{cmnurl}/hint.html',null,'width=600,height=400');"><img src="$cf{cmnurl}/question.png" alt="ヒント" class="icon"></a>
</p>
<table class="form-tbl">
<tr>
	<th>年月日</th>
	<td>
EOM

	if ($in{data_mgr}) {
		my ($yr,$mon) = $in{ym} =~ /^(\d+)-(\d+)/ && ($1,$2);
		print qq|$yr年 $mon月\n|;
	} else {
		print qq|<input type="text" name="y" value="$y" size="4"> 年\n|;
		print qq|<select name="m">\n|;
		for my $i (1 .. 12) {
			$i = sprintf("%02d",$i);
			if ($m == $i) {
				print qq |<option value="$i" selected>$i\n|;
			} else {
				print qq |<option value="$i">$i\n|;
			}
		}
		print qq|</select> 月\n|;
	}
	
	print qq|<select name="d">\n|;
	
	for my $i (1 .. 31) {
		$i = sprintf("%02d",$i);
		if ($d == $i) {
			print qq |<option value="$i" selected>$i\n|;
		} else {
			print qq |<option value="$i">$i\n|;
		}
	}
	
	print <<EOM;
		</select> 日
		&nbsp; 時刻：<input type="text" name="time" value="$time" size="8">
	</td>
</tr><tr>
	<th>タイトル</th>
	<td>
		カテゴリ：<select name="cate">
		<option value="">未分類
EOM

	for ( split(/,/,$set{categ}) ) {
		my ($no,$cate) = split(/:/);
		
		if ($cat == $no) {
			print qq|<option value="$no" selected>$cate\n|;
		} else {
			print qq|<option value="$no">$cate\n|;
		}
	}
	
	print <<EOM;
		</select><br>
		<input type="text" name="ttl" size="55" value="$ttl">
	</td>
</tr>
EOM

	for my $i (1 .. 3) {
		print qq|<tr><th>本文$i</th>\n|;
		print qq|<td><textarea name="com$i" class="editor">$com{$i}</textarea><br>\n|;
		print qq|画像 <input type="file" name="upfile$i" size="45">\n|;
		if ($ex{$i}) {
			print qq |<input type="checkbox" name="imgdel$i" value="1">削除\n|;
			print qq |[<a href="$cf{uplurl}/$no-$i$ex{$i}" target="_blank">画像</a>]\n|;
		}
		print qq|</td></tr>\n|;
	}
	
	print <<EOM;
<tr>
	<th>コメント</th>
	<td>
EOM

	my %ox = (1 => '受理する', 0 => '受理しない');
	for (0,1) {
		if ($res == $_) {
			print qq|<input type="radio" name="res" value="$_" checked>$ox{$_}\n|;
		} else {
			print qq|<input type="radio" name="res" value="$_">$ox{$_}\n|;
		}
	}
	
	print <<EOM;
</td>
</tr><tr>
	<th></th>
	<td><input type="submit" value="送信する" class="big-btn"></td>
</tr>
</table>
</form>
</div>
<script src="$cf{cmnurl}/nicEdit/nicEdit.js"></script>
<script>
	bkLib.onDomLoaded(function() { nicEditors.allTextAreas() });
</script>
</div>
</body>
</html>
EOM
	exit;
}

#-----------------------------------------------------------
#  日記メンテナンス
#-----------------------------------------------------------
sub data_mgr {
	# 修正フォーム
	if ($in{submit} && $in{job} eq "edit" && $in{no}) {
		
		my $log;
		open(DAT,"$cf{datadir}/log/$in{ym}.dat");
		while(<DAT>) {
			my ($no) = (split(/<>/))[0];
			
			if ($in{no} == $no) {
				chomp;
				$log = $_;
				last;
			}
		}
		close(DAT);
		
		data_new($log);
	
	# 修正実行
	} elsif ($in{job} eq "men" && $in{no}) {
		
		# 画像アップ
		my ($ex1n,$w1n,$h1n,$ex2n,$w2n,$h2n,$ex3n,$w3n,$h3n)
				= upload($in{no}) if ($in{upfile1} or $in{upfile2} or $in{upfile3});
		
		my ($flg,$chg,@sort,@data);
		open(DAT,"+< $cf{datadir}/log/$in{ym}.dat") or die;
		while(<DAT>) {
			my ($no,$y,$m,$d,$time,$cat,$res,$ttl,$com1,$com2,$com3,$ex1,$w1,$h1,$ex2,$w2,$h2,$ex3,$w3,$h3) = split(/<>/);
			
			if ($in{no} == $no) {
				
				# 画像削除
				if ($in{"imgdel1"} == 1) {
					unlink("$cf{upldir}/$no-1$ex1");
					$ex1 = $w1 = $h1 = '';
				}
				if ($in{"imgdel2"} == 1) {
					unlink("$cf{upldir}/$no-2$ex2");
					$ex2 = $w2 = $h2 = '';
				}
				if ($in{"imgdel3"} == 1) {
					unlink("$cf{upldir}/$no-3$ex3");
					$ex3 = $w3 = $h3 = '';
				}
				
				# 画像再アップのとき
				if ($ex1n) {
					if ($ex1 && $ex1n ne $ex1) {
						unlink("$cf{upldir}/$no-1$ex1");
					}
					$ex1 = $ex1n; $w1 = $w1n; $h1 = $h1n;
				}
				if ($ex2n) {
					if ($ex2 && $ex2n ne $ex2) {
						unlink("$cf{upldir}/$no-2$ex2");
					}
					$ex2 = $ex2n; $w2 = $w2n; $h2 = $h2n;
				}
				if ($ex3n) {
					if ($ex3 && $ex3n ne $ex3) {
						unlink("$cf{upldir}/$no-3$ex3");
					}
					$ex3 = $ex3n; $w3 = $w3n; $h3 = $h3n;
				}
				$d = $in{d};
				$time = $in{time};
				
				$_ = "$no<>$y<>$m<>$d<>$time<>$in{cate}<>$in{res}<>$in{ttl}<>$in{com1}<>$in{com2}<>$in{com3}<>$ex1<>$w1<>$h1<>$ex2<>$w2<>$h2<>$ex3<>$w3<>$h3<>\n";
				
				# カテゴリ変更のとき
				if ($in{cate} ne $cat) {
					$flg++;
					$chg = $cat;
				}
			}
			$time =~ s/\D//g;
			push(@sort,"$d$time");
			push(@data,$_);
		}
		
		# ソート
		@data = @data[sort{$sort[$b] <=> $sort[$a]} 0 .. $#sort];
		
		# 更新
		seek(DAT,0,0);
		print DAT @data;
		truncate(DAT,tell(DAT));
		close(DAT);
		
		# index更新
		$in{time} =~ s/\D//g;
		my (@log,@tmp);
		open(DAT,"+< $cf{datadir}/index.dat");
		while(<DAT>) {
			my ($no,$y,$m,$d,$tm,$cat) = split(/,/);
			
			if ($in{no} == $no) {
				$d = $in{d};
				$tm = $in{time};
				
				chomp $cat;
				$_ = "$no,$y,$m,$d,$tm,$in{cate}\n";
			}
			push(@tmp,"$y$m$d$tm");
			push(@log,$_);
		}
		
		@log = @log[sort {$tmp[$b] <=> $tmp[$a]} 0 .. $#tmp];
		
		seek(DAT,0,0);
		print DAT @log;
		truncate(DAT,tell(DAT));
		close(DAT);
		
		# カテゴリ変更のとき
		if ($flg) {
			my ($cflg,@log);
			open(DAT,"+< $cf{datadir}/categ.dat");
			while(<DAT>) {
				my ($no,$cnt) = split(/,/);
				
				if ($in{cate} > 0 && $in{cate} == $no) {
					$cflg++;
					chomp $cnt;
					$cnt++;
					$_ = "$no,$cnt\n";
				} elsif ($chg > 0 && $chg == $no) {
					chomp $cnt;
					$cnt--;
					$_ = "$no,$cnt\n";
				}
				push(@log,$_);
			}
			if ($in{cate} > 0 && !$cflg) { push(@log,"$in{cate},1\n"); }
			seek(DAT,0,0);
			print DAT @log;
			truncate(DAT,tell(DAT));
			close(DAT);
		}
		
		# エントリーindex
		my %set = read_set();
		my @new;
		for (0 .. $set{max_entry} - 1) {
			push(@new,$log[$_]);
		}
		entry_idx_edit(@new);
		
		# 完了画面
		message("修正を完了しました");
	
	# 削除
	} elsif ($in{submit} && $in{job} eq "dele" && $in{no}) {
		
		# 削除情報
		my %del;
		for ( $cgi->param('no') ) {
			$del{$_}++;
		}
		
		# 記事ログオープン
		my (@data,%chg);
		open(DAT,"+< $cf{datadir}/log/$in{ym}.dat");
		while(<DAT>) {
			my ($no,$y,$m,$d,$time,$cat,$res,$ttl,$com1,$com2,$com3,$ex1,$w1,$h1,$ex2,$w2,$h2,$ex3,$w3,$h3) = split(/<>/);
			
			# 削除対象
			if (defined $del{$no}) {
				if ($ex1) { unlink("$cf{upldir}/$no-1$ex1"); }
				if ($ex2) { unlink("$cf{upldir}/$no-2$ex2"); }
				if ($ex3) { unlink("$cf{upldir}/$no-3$ex3"); }
				if ($cat > 0) { $chg{$cat}++; }
				next;
			}
			push(@data,$_);
		}
		
		# 記事ログ更新
		seek(DAT,0,0);
		print DAT @data;
		truncate(DAT,tell(DAT));
		close(DAT);
		
		# 年月を分解
		my ($yr,$mon) = split(/-/,$in{ym});
		
		# もしデータが空のときは年月データ削除
		if (@data == 0) {
			unlink("$cf{datadir}/log/$in{ym}.dat");
			unlink("$cf{datadir}/com/$in{ym}.dat");
		
		# 空でないときは返信ログから関連レスを削除
		} else {
			
			# 返信ログオープン
			my @data;
			open(DAT,"+< $cf{datadir}/com/$in{ym}.dat");
			eval "flock(DAT,2);";
			while(<DAT>) {
				my ($no,$y,$m,$d,$time,$cat,$res,$ttl,$com1,$com2,$com3,$ex1,$w1,$h1,$ex2,$w2,$h2,$ex3,$w3,$h3) = split(/<>/);
				
				if (defined $del{$no}) {
					next;
				}
				push(@data,$_);
			}
			
			# 返信ログ更新
			seek(DAT,0,0);
			print DAT @data;
			truncate(DAT,tell(DAT));
			close(DAT);
		}
		
		# 年月書庫
		my @file;
		open(DAT,"+< $cf{datadir}/archive.dat");
		while(<DAT>) {
			my ($y,$m,$cnt) = split(/,/);
			
			if ($yr == $y && $mon == $m) {
				
				# データが空のときは行を削除
				next if (@data == 0);
				
				chomp;
				$cnt--;
				$_ = "$y,$m,$cnt\n";
			}
			push(@file,$_);
		}
		seek(DAT,0,0);
		print DAT @file;
		truncate(DAT,tell(DAT));
		close(DAT);
		
		my @log;
		open(DAT,"+< $cf{datadir}/index.dat");
		while(<DAT>) {
			my ($no) = (split(/,/))[0];
			next if (defined $del{$no});
			
			push(@log,$_);
		}
		seek(DAT,0,0);
		print DAT @log;
		truncate(DAT,tell(DAT));
		close(DAT);
		
		undef $in{ym};
		
		# カテゴリ変更のとき
		if (%chg > 0) {
			my ($flg,@log);
			open(DAT,"+< $cf{datadir}/categ.dat");
			while(<DAT>) {
				my ($no,$cnt) = split(/,/);
				
				if (defined $chg{$no}) {
					chomp $cnt;
					$cnt -= $chg{$no};
					$_ = "$no,$cnt\n";
				}
				push(@log,$_);
			}
			seek(DAT,0,0);
			print DAT @log;
			truncate(DAT,tell(DAT));
			close(DAT);
		}
		
		# エントリーindex
		my @log;
		open(DAT,"+< $cf{datadir}/entry.dat");
		while(<DAT>) {
			my ($no,$y,$m,$d,$sub) = split(/,/);
			next if (defined $del{$no});
			
			push(@log,$_);
		}
		seek(DAT,0,0);
		print DAT @log;
		truncate(DAT,tell(DAT));
		close(DAT);
	}
	
	header("日記の修正＆削除");
	print <<EOM;
<div id="body">
<div class="back-btn">
<form action="$cf{admin_cgi}" method="post">
<input type="hidden" name="sid" value="$in{sid}">
<input type="submit" value="&lt; メニュー">
</form>
</div>
<div class="ttl">■ 記事データ管理</div>
<form action="$cf{admin_cgi}" method="post">
<input type="hidden" name="sid" value="$in{sid}">
<input type="hidden" name="data_mgr" value="1">
年月：
<select name="ym">
EOM

	# 書庫indexオープン
	open(DAT,"$cf{datadir}/archive.dat");
	
	# 年月パラメータがないときはデータのトップを初期値とする
	if (!$in{ym}) {
		my $top = <DAT>;
		my ($y,$m,$cnt) = split(/,/,$top);
		
		$in{ym} = "$y-$m";
		
		# TOPに巻き戻す
		seek(DAT,0,0);
	}
	
	while(<DAT>) {
		chomp;
		my ($y,$m,$cnt) = split(/,/);
		
		if ($in{ym} eq "$y-$m") {
			print qq |<option value="$y-$m" selected>$y年$m月\n|;
		} else {
			print qq |<option value="$y-$m">$y年$m月\n|;
		}
	}
	close(DAT);
	
	print <<EOM;
</select>
<input type="submit" name="chg" value="切替">
<p>
処理：
<select name="job">
<option value="edit">修正
<option value="dele">削除
</select>
<input type="submit" name="submit" value="送信する">
</p>
<table class="form-tbl">
<tr>
  <th>選択</th>
  <th>日時</th>
  <th>タイトル</th>
</tr>
EOM

	my $i = 0;
	open(IN,"$cf{datadir}/log/$in{ym}.dat");
	while(<IN>) {
		$i++;
		my ($no,$y,$m,$d,$time,$cat,$res,$ttl,$com1,$com2,$com3,$ex1,$w1,$h1,$ex2,$w2,$h2,$ex3,$w3,$h3) = split(/<>/);
		
		print qq |<tr><td class="ta-c"><input type="checkbox" name="no" value="$no"></td>|;
		print qq |<td>$y/$m/$d $time</td>|;
		print qq |<td>$ttl</td></tr>\n|;
	}
	close(IN);
	
	if ($i == 0) {
		print qq |<td colspan="4" class="ta-c">データがありません</td>|;
	}
	
	print <<EOM;
</table>
</form>
</div>
</body>
</html>
EOM
	exit;
}

#-----------------------------------------------------------
#  コメント承認
#-----------------------------------------------------------
sub come_new {
	my ($auth,$dele);
	for ( keys %in ) {
		if (/^auth:(\w+)/) {
			$auth = $1;
			last;
		} elsif (/^dele:(\w+)/) {
			$dele = $1;
			last;
		}
	}
	if ($auth) {
		my ($log,@log);
		open(DAT,"+< $cf{datadir}/temp.dat");
		eval "flock(DAT,2);";
		while(<DAT>) {
			my ($id,$ym,$no,$date,$name,$com,$ip,$ttl,$d) = split(/<>/);
			if ($auth eq $id) {
				$log = $_;
				next;
			}
			
			push(@log,$_);
		}
		seek(DAT,0,0);
		print DAT @log;
		truncate(DAT,tell(DAT));
		close(DAT);
		
		my ($id,$ym,$no,$date,$name,$com,$ip,$ttl,$d) = split(/<>/,$log);
		$ym =~ s/^(\d{4})(\d{2})/$1-$2/;
		
		if (!-e "$cf{datadir}/com/$ym.dat") {
			open(DAT,"> $cf{datadir}/com/$ym.dat");
			close(DAT);
		}
		
		open(DAT,"+< $cf{datadir}/resno.dat");
		my $num = <DAT>  + 1;
		seek(DAT,0,0);
		print DAT $num;
		truncate(DAT,tell(DAT));
		close(DAT);
		
		my @log;
		open(DAT,">> $cf{datadir}/com/$ym.dat");
		print DAT "$num<>$no<>$date<>$name<>$com<>$ip\n";
		close(DAT);
	
	} elsif ($dele) {
		my @log;
		open(DAT,"+< $cf{datadir}/temp.dat");
		eval "flock(DAT,2);";
		while(<DAT>) {
			my ($id) = (split(/<>/))[0];
			next if ($dele eq $id);
			
			push(@log,$_);
		}
		seek(DAT,0,0);
		print DAT @log;
		truncate(DAT,tell(DAT));
		close(DAT);
	}
	
	header("コメント承認");
	print <<EOM;
<div id="body">
<div class="back-btn">
<form action="$cf{admin_cgi}" method="post">
<input type="hidden" name="sid" value="$in{sid}">
<input type="submit" value="&lt; メニュー">
</form>
</div>
<div class="ttl">■ コメント承認</div>
<form action="$cf{admin_cgi}" method="post">
<input type="hidden" name="sid" value="$in{sid}">
<input type="hidden" name="come_new" value="1">
<dl id="list-com">
EOM

	my $i;
	open(IN,"$cf{datadir}/temp.dat");
	while(<IN>) {
		chomp;
		$i++;
		my ($id,$ym,$no,$date,$name,$com,$ip,$ttl,$d) = split(/<>/);
		$ym =~ s|^(\d{4})(\d{2})|$1/$2|;
		
		print qq|<dt><input type="submit" name="auth:$id" value="承認">\n|;
		print qq|<input type="submit" name="dele:$id" value="削除" onclick="return confirm('削除しますか？');">\n|;
		print qq|<b>「$ttl」</b> ($ym/$d) へのコメント</dt>\n|;
		print qq!<dt><b>$name</b> | $date | $ip</dt>\n!;
		print qq|<dd class="com">$com</dd>\n|;
		print qq|<dt class="line">&nbsp;</dt>\n|;
	}
	close(IN);
	
	if (!$i) {
		print qq|<dt>現在承認待ちのコメントはありません。</dt>|;
	}
	
	print <<EOM;
</dl>
</div>
</body>
</html>
EOM
	exit;
}

#-----------------------------------------------------------
#  コメント管理
#-----------------------------------------------------------
sub come_mgr {
	# 削除
	if ($in{del_com} && $in{no}) {
		
		# 削除情報
		my %del;
		for ( $cgi->param('no') ) {
			$del{$_}++;
		}
		
		# コメントデータ
		my @data;
		open(DAT,"+< $cf{datadir}/com/$in{ym}.dat");
		while(<DAT>) {
			my ($no,$ent,$date,$name,$com,$ip) = split(/<>/);
			next if (defined $del{$no});
			
			push(@data,$_);
		}
		seek(DAT,0,0);
		print DAT @data;
		truncate(DAT,tell(DAT));
		close(DAT);
	}
	
	header("コメント管理");
	print <<EOM;
<div id="body">
<div class="back-btn">
<form action="$cf{admin_cgi}" method="post">
<input type="hidden" name="sid" value="$in{sid}">
<input type="submit" value="&lt; メニュー">
</form>
</div>
<div class="ttl">■ コメント管理</div>
<form action="$cf{admin_cgi}" method="post">
<input type="hidden" name="sid" value="$in{sid}">
<input type="hidden" name="come_mgr" value="1">
年月：
<select name="ym">
EOM

	# 書庫indexオープン
	open(DAT,"$cf{datadir}/archive.dat");
	
	# 年月パラメータがないときはデータのトップを初期値とする
	if (!$in{ym}) {
		my $top = <DAT>;
		my ($y,$m,$cnt) = split(/,/,$top);
		
		$in{ym} = "$y-$m";
		
		# TOPに巻き戻す
		seek(DAT,0,0);
	}
	
	while(<DAT>) {
		chomp;
		my ($y,$m,$cnt) = split(/,/);
		
		if ($in{ym} eq "$y-$m") {
			print qq |<option value="$y-$m" selected>$y年$m月\n|;
		} else {
			print qq |<option value="$y-$m">$y年$m月\n|;
		}
	}
	close(DAT);
	
	print <<EOM;
</select>
<input type="submit" value="切替">
<table class="form-tbl">
<tr>
  <th><input type="submit" name="del_com" value="削除"></th>
  <th>日時/元記事</th>
  <th>名前</th>
  <th>内容</th>
  <th>IP</th>
</tr>
EOM

	# 記事
	my %ttl;
	open(IN,"$cf{datadir}/log/$in{ym}.dat");
	while(<IN>) {
		my ($no,$y,$m,$d,$time,$cat,$res,$ttl,$com1,$com2,$com3,$ex1,$w1,$h1,$ex2,$w2,$h2,$ex3,$w3,$h3) = split(/<>/);
		
		$ttl{$no} = "$ttl ($y/$m/$d)";
	}
	close(IN);
	
	# 返信
	my $i = 0;
	open(IN,"$cf{datadir}/com/$in{ym}.dat");
	while(<IN>) {
		$i++;
		chomp;
		my ($no,$ent,$date,$name,$com,$ip) = split(/<>/);
		
		print qq |<tr><td class="ta-c"><input type="checkbox" name="no" value="$no"></td>|;
		print qq |<td class="small">$date<br>$ttl{$ent}</td>|;
		print qq |<td class="small">$name</td>|;
		print qq |<td class="small w-25">| . cut_str($com,40) . qq|</td>|;
		print qq |<td class="small">$ip</td></tr>\n|;
	}
	close(IN);
	
	if ($i == 0) {
		print qq |<td class="ta-c" colspan="5">コメントがありません</td>|;
	}
	
	print <<EOM;
</table>
</form>
</div>
</body>
</html>
EOM
	exit;
}

#-----------------------------------------------------------
#  基本設定
#-----------------------------------------------------------
sub set_base {
	my %set = read_set();
	$set{subtitle} =~ s/<br>/\n/g;
	$set{profile} =~ s/<br>/\n/g;
	
	# --- 更新
	if ($in{submit}) {
		
		my @sort;
		for ( keys %in ) {
			if (/^cat:(\d+)/) {
				push(@sort,$1);
			}
		}
		@sort = sort{ $b <=> $a } @sort;
		
		my $cate;
		for (@sort) {
			next if ($in{"del:$_"} == 1);
			
			$cate .= qq|$_:$in{"cat:$_"},|;
		}
		$cate =~ s/,$//;
		if ($in{cat_new}) {
			my $key = $sort[0] + 1;
			$cate = "$key:$in{cat_new}," . $cate;
		}
		$in{categ} = $cate;
		
		# 画像削除
		if ($in{imgdel} == 1) {
			unlink("$cf{upldir}/$set{prof_image}");
			$in{prof_image} = "";
			$set{prof_image} = "";
		}
		
		# 画像アップ
		if ($in{upfile1}) {
			my ($ex,$w,$h) = upload("prof");
			if ($ex) {
				if ($set{prof_image} && $set{prof_image} ne "prof-1$ex") {
					unlink("$cf{upldir}/$set{prof_image}");
				}
				$in{prof_image} = "prof-1" . $ex;
			} else {
				$in{prof_image} = "";
			}
		} else {
			$in{prof_image} = $set{prof_image};
		}
		
		$in{subtitle} =~ s/(<br>)+$//;
		$in{profile} =~ s/(<br>)+$//;
		
		# ファイル上書き
		my @log;
		for (qw(title subtitle max_page max_entry max_res max_img_w max_img_h prof_image prof_img_w profile categ)) {
			push(@log,"$_<>$in{$_}\n");
		}
		open(DAT,"> $cf{datadir}/set.dat");
		print DAT @log;
		close(DAT);
		
		# 完了メッセージ
		message("基本設定を更新しました");
	}
	
	header("基本設定");
	print <<EOM;
<div id="body">
<div class="back-btn">
<form action="$cf{admin_cgi}" method="post">
<input type="hidden" name="sid" value="$in{sid}">
<input type="submit" value="&lt; メニュー">
</form>
</div>
<div class="ttl">■ 基本設定</div>
<form action="$cf{admin_cgi}" method="post" enctype="multipart/form-data">
<input type="hidden" name="sid" value="$in{sid}">
<input type="hidden" name="set_base" value="1">
<table class="form-tbl">
<tr>
	<th>タイトル</th>
	<td><input type="text" name="title" size="50" value="$set{title}"></td>
</tr><tr>
	<th>タイトル下<br>メッセージ</th>
	<td><textarea name="subtitle" cols="60" rows="3">$set{subtitle}</textarea></td>
</tr><tr>
	<th>表示記事数</th>
	<td>
		【メニュー内最近の記事】
		<input type="tel" name="max_entry" size="2" value="$set{max_entry}"> 件<br>
		【ページ当たり記事表示数】
		<input type="tel" name="max_page" size="2" value="$set{max_page}"> 件
	</td>
</tr><tr>
	<th>画像サイズ</th>
	<td>【最大幅】
	<input type="tel" name="max_img_w" size="5" value="$set{max_img_w}"> pix
	&nbsp;【最大高さ】
	<input type="tel" name="max_img_h" size="5" value="$set{max_img_h}"> pix<br>
	（これを超えるサイズは自動縮小）
	</td>
</tr><tr>
	<th>返信制限</th>
	<td><input type="tel" name="max_res" size="3" value="$set{max_res}"> 件
		（1記事当りに返信できる最大コメント数）
  </td>
</tr><tr>
	<th>プロフ画像</th>
	<td>
  		【最大幅】<input type="tel" name="prof_img_w" size="3" value="$set{prof_img_w}"> pix
  		（これを超えると自動縮小）<br>
  		<input type="file" name="upfile1" size="30">
EOM

	# トップ画像
	if ($set{prof_image}) {
		print qq |<input type="checkbox" name="imgdel" value="1">削除\n|;
		print qq |[<a href="$cf{uplurl}/$set{prof_image}" target="_blank">画像</a>]\n|;
	}
	
	print <<EOM;
  </td>
</tr><tr>
	<th>プロフィール</th>
	<td><textarea name="profile" cols="60" rows="2">$set{profile}</textarea></td>
</tr><tr>
	<th>カテゴリー</th>
	<td>
		<input type="text" name="cat_new" size="20">
		[追加] ← 新規に追加する場合<br>
EOM

	for ( split(/,/,$set{categ}) ) {
		my ($key,$val) = split(/:/);
		
		print qq|<input type="text" name="cat:$key" value="$val" size="20">\n|;
		print qq|<input type="checkbox" name="del:$key" value="1">削除<br>\n|;
	}
	
	print <<EOM;
	</td>
</tr><tr>
	<th></th>
	<td><input type="submit" name="submit" value="送信する" class="big-btn"></td>
</tr>
</table>
</form>
</div>
</body>
</html>
EOM
	exit;
}

#-----------------------------------------------------------
#  HTMLヘッダ
#-----------------------------------------------------------
sub header {
	my $ttl = shift;
	
	print <<EOM;
Content-type: text/html; charset=utf-8

<!doctype html>
<html lang="ja">
<head>
<meta charset="UTF-8">
<link href="$cf{cmnurl}/admin.css" rel="stylesheet">
<title>$ttl</title>
</head>
<body>
<div id="head">
	<img src="$cf{cmnurl}/star.png" alt="star" class="icon">
	SMART BLOG 管理画面 :: </div>
EOM
}

#-----------------------------------------------------------
#  エラー画面
#-----------------------------------------------------------
sub error {
	my $err = shift;
	
	header("エラー");
	print <<EOM;
<div id="err-box">
<p>$err</p>
<p><input type="button" value="前画面に戻る" onclick="history.back()"></p>
</div>
</body>
</html>
EOM
	exit;
}

#-----------------------------------------------------------
#  完了画面
#-----------------------------------------------------------
sub message {
	my $msg = shift;
	
	header("完了メッセージ");
	print <<EOM;
<div id="msg-box">
<p>$msg</p>
<form action="$cf{admin_cgi}" method="post">
<input type="hidden" name="sid" value="$in{sid}">
EOM

	for (qw(set_base data_new data_mgr come_new come_mgr)) {
		if ($in{$_}) {
			print qq|<input type="hidden" name="$_" value="1">\n|;
			last;
		}
	}
	
	print <<EOM;
<p><input type="submit" value="元の画面へ戻る"></p>
</form>
</div>
</body>
</html>
EOM
	exit;
}

#-----------------------------------------------------------
#  画像アップロード
#-----------------------------------------------------------
sub upload {
	my $no = shift;
	
	my @ret;
	for my $i (1 .. 3) {
		
		# mimeタイプ
		my $mime = $cgi->param_mime("upfile$i");
		
		# ファイル名
		my $fname = $cgi->param_filename("upfile$i");
		if ($fname =~ /(\.jpe?g|\.png|\.gif)$/i) {
			my $ex = $1;
			$ex =~ tr/A-Z/a-z/;
			if ($ex eq '.jpeg') { $ex = '.jpg'; }
			
			# 整合性チェック
			unless (($mime =~ /^image\/gif$/i and $ex eq '.gif') or ($mime =~ /^image\/p?jpe?g$/i and $ex eq '.jpg') or ($mime =~ /^image\/(x-)?png$/i and $ex eq '.png')) {
				push(@ret,('','',''));
				next;
			}
			
			# アップファイル定義
			my $imgfile = "$cf{upldir}/$no-$i$ex";
			
			# 書き込み
			open(OUT,"> $imgfile") or error("画像アップ失敗");
			binmode(OUT);
			print OUT $in{"upfile$i"};
			close(OUT);
			
			# パーミッション変更
			chmod(0666,$imgfile);
			
			# 画像サイズ取得
			my ($w,$h);
			if ($ex eq ".jpg") { ($w,$h) = j_size($imgfile); }
			elsif ($ex eq ".gif") { ($w,$h) = g_size($imgfile); }
			elsif ($ex eq ".png") { ($w,$h) = p_size($imgfile); }
			
			push(@ret,($ex,$w,$h));
		} else {
			push(@ret,('','',''));
		}
	}
	# 返り値
	return @ret;
}

#-----------------------------------------------------------
#  JPEGサイズ認識
#-----------------------------------------------------------
sub j_size {
	my $jpg = shift;
	
	my ($h,$w,$t);
	open(IMG,"$jpg");
	binmode(IMG);
	read(IMG,$t,2);
	while (1) {
		read(IMG, $t, 4);
		my ($m,$c,$l) = unpack("a a n", $t);
		
		if ($m ne "\xFF") {
			$w = $h = 0;
			last;
		} elsif ((ord($c) >= 0xC0) && (ord($c) <= 0xC3)) {
			read(IMG, $t, 5);
			($h,$w) = unpack("xnn",$t);
			last;
		} else {
			read(IMG,$t,($l - 2));
		}
	}
	close(IMG);
	
	return ($w,$h);
}

#-----------------------------------------------------------
#  GIFサイズ認識
#-----------------------------------------------------------
sub g_size {
	my $gif = shift;
	
	my $data;
	open(IMG,"$gif");
	binmode(IMG);
	sysread(IMG, $data, 10);
	close(IMG);
	
	if ($data =~ /^GIF/) { $data = substr($data, -4); }
	my $w = unpack("v", substr($data,0,2));
	my $h = unpack("v", substr($data,2,2));
	
	return ($w,$h);
}

#-----------------------------------------------------------
#  PNGサイズ認識
#-----------------------------------------------------------
sub p_size {
	my $png = shift;
	
	my $data;
	open(IMG,"$png");
	binmode(IMG);
	read(IMG,$data,24);
	close(IMG);
	
	my $w = unpack("N", substr($data,16,20));
	my $h = unpack("N", substr($data,20,24));
	
	return ($w,$h);
}

#-----------------------------------------------------------
#  カテゴリインデックス
#-----------------------------------------------------------
sub cat_index {
	my ($flg,@log);
	open(DAT,"+< $cf{datadir}/categ.dat");
	while(<DAT>) {
		my ($no,$cnt) = split(/,/);
		
		if ($in{cate} == $no) {
			chomp $cnt;
			$cnt++;
			$flg++;
			$_ = "$no,$cnt\n";
		}
		push(@log,$_);
	}
	if (!$flg) { push(@log,"$in{cate},1\n"); }
	seek(DAT,0,0);
	print DAT @log;
	truncate(DAT,tell(DAT));
	close(DAT);
}

#-----------------------------------------------------------
#  新規記事インデックス
#-----------------------------------------------------------
sub entry_index {
	my ($num,$new) = @_;
	
	my (@log,%log);
	open(DAT,"+< $cf{datadir}/entry.dat");
	while(<DAT>) {
		my ($no,$y,$m,$d,$sub) = split(/,/);
		
		$log{$no} = $_;
	}
	for (@$new) {
		my ($no,$y,$m,$d,$tm,$cat) = split(/,/);
		
		if ($num == $no) {
			push(@log,"$no,$y,$m,$d,$in{ttl}\n");
		} elsif (defined $log{$no}) {
			push(@log,$log{$no});
		}
	}
	seek(DAT,0,0);
	print DAT @log;
	truncate(DAT,tell(DAT));
	close(DAT);
}

#-----------------------------------------------------------
#  新規記事インデックス修正
#-----------------------------------------------------------
sub entry_idx_edit {
	my @new = @_;
	
	my ($flg,@log,%log);
	open(DAT,"+< $cf{datadir}/entry.dat");
	while(<DAT>) {
		my ($no,$y,$m,$d,$sub) = split(/,/);
		
		$log{$no} = $_;
	}
	for (@new) {
		my ($no,$y,$m,$d,$tm,$cat) = split(/,/);
		
		if ($in{no} == $no) {
			push(@log,"$no,$y,$m,$d,$in{ttl}\n");
		} elsif (defined $log{$no}) {
			push(@log,$log{$no});
		}
	}
	seek(DAT,0,0);
	print DAT @log;
	truncate(DAT,tell(DAT));
	close(DAT);
}

#-----------------------------------------------------------
#  文字カット for UTF-8
#-----------------------------------------------------------
sub cut_str {
	my ($str,$all) = @_;
	$str =~ s|<br>||g;
	
	my $i = 0;
	my ($ret,$flg);
	while ($str =~ /([\x00-\x7f]|[\xC0-\xDF][\x80-\xBF]|[\xE0-\xEF][\x80-\xBF]{2}|[\xF0-\xF7][\x80-\xBF]{3})/gx) {
		$i++;
		$ret .= $1;
		if ($i >= $all) {
			$flg++;
			last;
		}
	}
	$ret .= '...' if ($flg);
	
	return $ret;
}

