#┌──────────────────────────────
#│ HAPPY CART : main_cart.pl - 2022/04/07
#│ copyright (c) kentweb, 1997-2022
#│ https://www.kent-web.com/
#└──────────────────────────────

use strict;
use DBM::Deep;

#-----------------------------------------------------------
#  メニュー表示
#-----------------------------------------------------------
sub main_cart_pl {
	$in{detail} =~ s/\D//g;
	
	# カートに入れる場合
	my $cart;
	for ( keys %in ) {
		if (/^cart:(\d+)$/) {
			$cart = $1;
			last;
		}
	}
	
	# 在庫情報
	my %zan = read_stock() if ($cf{stock} == 1);
	
	# DB定義
	my $db = DBM::Deep->new(
		file    => "$cf{datadir}/db/data.db",
	);
	
	my ($sid,$cart_now,$total) = cart_in($cart,$db,\%zan);
	if (!$in{sid} && $sid) { $in{sid} = $sid; }
	
	if ($cart) {
		require './lib/chck_cart.pl';
		chck_cart_pl();
	}
	
	# 基本データ
	my %top = read_base();
	
	# ジョブ形式
	my $job = 'n';
	
	# 商品詳細のとき
	my @log;
	if ($in{detail} > 0) {
		$job = 'd';
		my $data = $db->get($in{detail});
		push(@log,"$in{detail}\t$data");
	}
	
	# 検索時
	my @wd;
	if ($in{find} && $in{word}) {
		$job = 'f';
		$in{word} =~ s/　/ /g;
		@wd = split(/\s+/,$in{word});
	}
	
	# UTF-8定義
	my $byte1 = '[\x00-\x7f]';
	my $byte2 = '[\xC0-\xDF][\x80-\xBF]';
	my $byte3 = '[\xE0-\xEF][\x80-\xBF]{2}';
	my $byte4 = '[\xF0-\xF7][\x80-\xBF]{3}';
	
	# 商品データ
	$in{pg} =~ s/\D//g;
	my $pg = $in{pg} || 0;
	my $find = 0;
	my $i;
	if ($job ne 'd') {
		open(IN,"$cf{datadir}/index.dat");
		while(<IN>) {
			chomp;
			my ($no,$cat) = split(/,/);
			
			# 検索のとき
			if (@wd > 0) {
				my $data = $db->get($no);
				my ($item,$price,$size,$col,$memo,$code,$cate,$rtax,$ex1,$w1,$h1,$ex2,$w2,$h2,$ex3,$w3,$h3,$ex4,$w4,$h4,$ex5,$w5,$h5) = split(/\t/,$data);
				my $flg;
				for my $wd (@wd) {
					if ("$item $memo"=~ /^(?:$byte1|$byte2|$byte3|$byte4)*?\Q$wd\E/i) {
						$flg++;
					} else {
						$flg = 0;
						last;
					}
				}
				if ($flg) {
					$find++;
					push(@log,"$no\t$data");
				}
				next;
			
			# 通常表示のとき
			} else {
				# カテゴリ指定
				next if ($in{cate} ne '' && $in{cate} != $cat);
				
				$i++;
				next if ($i < $pg + 1);
				next if ($i > $pg + $cf{pg_max});
				
				my $data = $db->get($no);
				push(@log,"$no\t$data");
			}
		}
		close(IN);
	}
	
	# ペイジャー
	my $page_btn = make_pgbtn($i,$pg) if ($job eq 'n');
	
	# カテゴリ
	my %categ;
	for ( @{$cf{category}} ) {
		my ($key,$val) = split(/:/);
		
		$categ{$key} = $val;
	}
	
	# 案内タイトル
	my $navi;
	if ($find ne '' && @wd > 0) {
		$navi = "検索： $find件表示";
	} else {
		$navi = $in{cate} eq '' ? '全商品' : $categ{$in{cate}};
	}
	
	# テンプレート読込
	open(IN,"$cf{tmpldir}/cart.html") or error("open err: cart.html");
	my $tmpl = join('',<IN>);
	close(IN);
	
	# 文字置き換え
	$tmpl =~ s|<!-- stock -->.+?<!-- /stock -->||s if (!$cf{stock});
	$tmpl =~ s/!(cmnurl|title|index_cgi|news)!/$cf{$1}/g;
	$tmpl =~ s/!sid!/$sid/g;
	$tmpl =~ s/!cart-now!/$cart_now/g;
	$tmpl =~ s/!total!/comma($total)/eg;
	$tmpl =~ s/!navi!/$navi/g;
	$tmpl =~ s/!word!/$in{word}/g;
	$tmpl =~ s/!page-btn!/$page_btn/g;
	$tmpl =~ s/!cate!/$in{cate}/g;
	$tmpl =~ s/!pg!/$pg/g;
	$tmpl =~ s|!icon:(\w+\.\w+)!|<img src="$cf{cmnurl}/$1" alt="" class="icon">|g;
	$tmpl =~ s/<!-- cat_list -->/cat_list()/e;
	
	# テンプレート分割
	my ($head,$loop,$foot) = $tmpl =~ m|(.+)<!-- loop -->(.+?)<!-- /loop -->(.+)|s
			? ($1,$2,$3)
			: error("テンプレート不正");
	
	# 詳細画面用
	if ($in{detail} > 0) {
		my $css;
		$css .= qq|<link href="$cf{cmnurl}/swiper/swiper-bundle.min.css" rel="stylesheet">\n|;
		$css .= qq|<link href="$cf{cmnurl}/swiper/swiper.css" rel="stylesheet">\n|;
		$head =~ s/<!-- swiper -->/$css/;
		
		$loop = detail_data();
	}
	
	# ヘッダ表示
	print "Content-type: text/html; charset=utf-8\n\n";
	print $head;
	
	# 商品カゴ表示
	my $i;
	for (@log) {
		$i++;
		my ($no,$item,$price,$size,$col,$memo,$code,$cate,$rtax,$ex1,$w1,$h1,$ex2,$w2,$h2,$ex3,$w3,$h3,$ex4,$w4,$h4,$ex5,$w5,$h5) = split(/\t/);
		
		# 画像
		my $image;
		if ($in{detail} > 0) {
			my $i;
			for my $ex ($ex1,$ex2,$ex3,$ex4,$ex5) {
				$i++;
				if ($ex) {
					$image .= qq|<div class="swiper-slide">\n|;
					$image .= qq|<img src="$cf{imgurl}/$no-$i$ex" alt="">\n</div>\n|;
				}
			}
		} elsif ($ex1) {
			my $param = "detail=$no";
			$param .= "&amp;cate=$in{cate}" if ($in{cate} ne '');
			$param .= "&amp;sid=$sid" if ($sid);
			$param .= "&amp;pg=$pg" if ($pg);
			
			$image = img_link(1,$no,$ex1,$w1,$h1,$item,$param);
		}
		
		my $tmp = $loop;
		
		# 在庫の場合
		if ($cf{stock} == 1) {
			$tmp =~ s/!zan!/$zan{$no} ? $zan{$no} : 0/e;
			if ($zan{$no} <= 0) {
				$tmp =~ s|<!-- submit -->.*<input ([^<>]+)>.*<!-- /submit -->|<input type="button" value="品切れ" disabled>|s;
			}
		} else {
			$tmp =~ s|<!-- stock -->.+?<!-- /stock -->||s;
		}
		
		$tmp =~ s/!seq!/$no/g;
		$tmp =~ s/!item-name!/$item/g;
		$tmp =~ s/!code!/$code/g;
		$tmp =~ s/!price!/comma($price)/eg;
		$tmp =~ s/<!-- memo -->/tag_chg($memo)/eg;
		$tmp =~ s/!image!/$image/g;
		$tmp =~ s/!cat_id!/$cate/g;
		$tmp =~ s/!categ!/$categ{$cate}/g;
		
		# 税表示
		if ($cf{tax_per} > 0) {
			$tmp =~ s/!tax!/$rtax == 1 ? "外税:軽減税率対象" : "外税"/e;
		} else {
			$tmp =~ s/!tax!/内税/;
		}
		
		# サイズ
		if ($size) {
			$tmp =~ s/<!-- op_size -->/option($size)/e;
		} else {
			$tmp =~ s|<!-- size -->.+?<!-- /size -->||s;
		}
		# カラー
		if ($col) {
			$tmp =~ s/<!-- op_color -->/option($col)/e;
		} else {
			$tmp =~ s|<!-- color -->.+?<!-- /color -->||s;
		}
		
		print $tmp;
	}
	
	# フッタ
	footer($foot);
}

#-----------------------------------------------------------
#  詳細内容
#-----------------------------------------------------------
sub detail_data {
	open(IN,"$cf{tmpldir}/detail.html");
	my $tmpl = join('',<IN>);
	close(IN);
	
	$tmpl =~ s/!(cmnurl|index_cgi)!/$cf{$1}/g;
	$tmpl =~ s/!sid!/$in{sid}/g;
	$tmpl =~ s/!pg!/$in{pg}/g;
	
	open(IN,"$cf{datadir}/detail/$in{detail}.dat");
	my $data = join('',<IN>);
	close(IN);
	
	$data =~ s/\n/<br>/g;
	$tmpl =~ s/!detail!/$data/g;
	
	return $tmpl;
}

#-----------------------------------------------------------
#  カート追加
#-----------------------------------------------------------
sub cart_in {
	my ($key,$db,$zan) = @_;
	
	# カート追加の場合
	my ($pick,$pk_item,$pk_pri,$pk_num,$flg);
	if ($key) {
		my $data = $db->get($key);
		my ($item,$price,$size,$col,$memo,$code,$cate,$rtax,$ex1,$w1,$h1,$ex2,$w2,$h2,$ex3,$w3,$h3,$ex4,$w4,$h4,$ex5,$w5,$h5) = split(/\t/,$data);
		
		# 在庫オーバー
		if ($cf{stock} == 1 && $$zan{$key} < $in{"num:$key"}) {
			$flg++;
			$pk_item = $item;
			last;
		}
		
		# 追加データ定義
		$pick = qq|$key<>$in{"num:$key"}<>$in{"size:$key"}<>$in{"color:$key"}<>$item<>$price<>$code<>$cate<>$ex1<>$rtax|;
		$pk_item = $item;
		$pk_pri  = $price;
	}
	
	# 在庫不足
	error("「$pk_item」の在庫数は$$zan{$key}個のため購入できません") if ($flg);
	
	# セッションを開く（更新モード）
	my $ses;
	if ($key) {
		$ses = CGI::Session->new(undef,$in{sid},{Directory => "$cf{datadir}/ses"});
		
		# 有効時間指定
		$ses->expire($cf{ses_expire});
	
	# Read Only
	} else {
		$ses = CGI::Session->load(undef,$in{sid},{Directory => "$cf{datadir}/ses"});
	}
	
	# カートID取得
	my $id = $ses->param('id');
	
	# カート内取得
	my $cart_now;
	my $all = 0;
	my ($wflg,$zflg,$wid,$wpic);
	if ($id >= 1) {
		for (1 .. $id) {
			my $cart = $ses->param("cart:$_");
			next if (!$cart);
			my ($no,$num,$size,$col,$item,$pri,$code,$cat,$img,$rtax) = split(/<>/,$cart);
			
			# 同一商品購入の場合
			if ($key eq $no && $in{"size:$key"} eq $size && $in{"color:$key"} eq $col) {
				
				# フラグを立てる
				$wflg++;
				
				# 個数変更のIDを覚える
				$wid = $_;
				
				# 個数変更
				$num += $in{"num:$key"};
				
				# 在庫チェック
				if ($cf{stock} == 1 && $$zan{$no} < $num) {
					$zflg++;
					$pk_item = $item;
					last;
				}
				
				# 格納データ
				$wpic = "$no<>$num<>$size<>$col<>$item<>$pri<>$code<>$cat<>$img<>$rtax";
			}
			
			my $kei = $pri * $num;
			$all += $kei;
			$pri = comma($pri);
			$kei = comma($kei);
			$cart_now .= qq|・$item<div class="ta-r eiji">$pri x $num = $kei</div>\n|;
		}
	}
	
	# 在庫オーバー
	error("「$pk_item」の在庫数は$$zan{$key}個のため購入できません.") if ($zflg);
	
	# 追加の場合
	if ($key) {
		# 新規追加
		if (!$wflg) {
			my $kei = $pk_pri * $in{"num:$key"};
			$all += $kei;
			$pk_pri = comma($pk_pri);
			$kei = comma($kei);
			$cart_now .= qq|・$pk_item<div class="ta-r eiji">$pk_pri x $in{"num:$key"} = $kei</div>\n|;
			
			# セッション格納
			$id++;
			$ses->param('id', $id);
			$ses->param("cart:$id", $pick);
		
		# 個数変更
		} else {
			# セッション格納
			$ses->param("cart:$wid", $wpic);
		}
	}
	
	# 有効セッションID
	my $sid = $ses->id();
	
	# 返り値
	return ($sid,$cart_now,$all);
}

#-----------------------------------------------------------
#  繰越ボタン作成
#-----------------------------------------------------------
sub make_pgbtn {
	my ($i,$pg) = @_;
	$cf{pg_max} ||= 5;
	
	# ページ繰越定義
	my $next = $pg + $cf{pg_max};
	my $back = $pg - $cf{pg_max};
	
	# 引数
	my $param;
	$param .= "&amp;sid=$in{sid}" if ($in{sid});
	$param .= "&amp;cate=$in{cate}" if ($in{cate} ne '');
	
	# ページ繰越ボタン作成
	my @pg;
	if ($back >= 0 or $next < $i) {
		my $flg;
		my ($w,$x,$y,$z) = (0,1,0,$i);
		while ($z > 0) {
			if ($pg == $y) {
				$flg++;
				push(@pg,qq!<li><span>$x</span></li>\n!);
			} else {
				push(@pg,qq!<li><a href="$cf{index_cgi}?pg=$y$param">$x</a></li>\n!);
			}
			$x++;
			$y += $cf{pg_max};
			$z -= $cf{pg_max};
			
			if ($flg) { $w++; }
			last if ($w >= 5 && @pg >= 10);
		}
	}
	while( @pg >= 11 ) { shift(@pg); }
	my $ret = join('', @pg);
	if ($back >= 0) {
		$ret = qq!<li><a href="$cf{index_cgi}?pg=$back$param">&laquo;</a></li>\n! . $ret;
	}
	if ($next < $i) {
		$ret .= qq!<li><a href="$cf{index_cgi}?pg=$next$param">&raquo;</a></li>\n!;
	}
	# 結果を返す
	return $ret ? qq|<ul class="pager">\n$ret</ul>| : '';
}

#-----------------------------------------------------------
#  プルダウン作成
#-----------------------------------------------------------
sub option {
	my $op = shift;
	
	my $ret;
	for ( split(/\s+/,$op) ) {
		$ret .= qq|<option value="$_">$_</option>\n|;
	}
	$ret;
}

#-----------------------------------------------------------
#  画像リンク
#-----------------------------------------------------------
sub img_link {
	my ($i,$no,$ex,$w,$h,$alt,$param) = @_;
	
	($w,$h) = resize($w,$h);
	return qq|<a href="$cf{index_cgi}?$param"><img src="$cf{imgurl}/$no-$i$ex" width="$w" height="$h" alt="$alt"></a>|;
}

#-----------------------------------------------------------
#  タグ変換
#-----------------------------------------------------------
sub tag_chg {
	my $memo = shift;
	
	$memo =~ s/&amp;/&/g;
	$memo =~ s/&lt;/</g;
	$memo =~ s/&gt;/>/g;
	$memo =~ s/&quot;/"/g;
	$memo =~ s/&#39;/'/g;
	
	return $memo ? qq|<p>$memo</p>| : '';
}

#-----------------------------------------------------------
#  カテゴリリスト
#-----------------------------------------------------------
sub cat_list {
	my $ret;
	
	my $ret = qq|<li><a href="$cf{index_cgi}?sid=$in{sid}">全商品</a></li>\n|;
	for ( @{$cf{category}} ) {
		my ($key,$val) = split(/:/);
		
		$ret .= qq|<li><a href="$cf{index_cgi}?cate=$key&amp;sid=$in{sid}">$val</a></li>\n|;
	}
	return $ret;
}


1;

