#┌──────────────────────────────
#│ HAPPY CART : send_form.pl - 2022/04/07
#│ copyright (c) kentweb, 1997-2022
#│ https://www.kent-web.com/
#└──────────────────────────────

use strict;
use Crypt::RC4;

#-----------------------------------------------------------
#  注文確定
#-----------------------------------------------------------
sub send_form_pl {
	# 在庫
	my %zan = read_stock() if ($cf{stock} == 1);
	
	# セッション読み取り
	my $ses = CGI::Session->new(undef,$in{sid},{Directory => "$cf{datadir}/ses"});
	
	# セッションから住所データ抽出
	my $addr  = $ses->param("addr");
	my $addr2 = $ses->param("addr2");
	
	# 分解
	my ($payment,$date,$deli,$ship,$corp,$kana,$name,$email,$zip,$pref,$addr,$adds,$tel,$fax,$memo) = split(/<>/,$addr);
	my ($corp2,$kana2,$name2,$zip2,$pref2,$addr2,$adds2,$tel2,$fax2) = split(/<>/,$addr2);
	
	# 買物情報
	my $id = $ses->param('id');
	my ($order,$err,%stk);
	my $all = 0;
	my $red = 0;
	my $i;
	for (1 .. $id) {
		my $cart = $ses->param("cart:$_");
		next if ($cart eq '');
		$i++;
		my ($no,$num,$size,$col,$item,$pri,$code,$cat,$img,$rtax) = split(/<>/,$cart);
		
		# 在庫チェック
		if ($cf{stock} == 1) {
			if ($zan{$no} < $num) { $err .= "$item (数量:$num),"; }
			else { $zan{$no} -= $num; }
		}
		
		my $kei = $pri * $num;
		$all += $kei;
		
		$order .= "$item [$code]\n";
		$order .= "[$cf{op1}] $size\n" if ($size);
		$order .= "[$cf{op2}] $col\n" if ($col);
		
		# 軽減税率
		if ($cf{tax_per} > 0 && $rtax == 1) {
			$red += $kei;
			$order .= "[軽減税率対象]\n";
		}
		
		# コンマ化
		$pri = comma($pri);
		$kei = comma($kei);
		
		$order .= "$pri x $num = $kei\n\n";
	}
	$order =~ s/\n\n$//g;
	
	if (!$i) {
		my $msg = "買物カゴの中身が空ですので、リストに戻って商品を選択してください。\n";
		$msg .= qq|<p><a href="$cf{index_cgi}">リストTOP画面</a></p>\n|;
		error($msg);
	}
	
	# 在庫不足のとき
	if ($err) {
		$err =~ s/,$//g;
		my $msg = qq|<p>大変申し訳ありません。<br>$errはたった今別注文により在庫不足となりました。</p>\n|;
		$msg .= qq|買物カートから商品を削除する場合：<a href="$cf{index_cgi}?chck_cart=1&amp;sid=$in{sid}">買物カゴ画面へ</a><br>\n|;
		$msg .= qq|リストTOP画面に戻る場合：<a href="$cf{index_cgi}?sid=$in{sid}">リストTOP画面</a>\n|;
		error($msg);
	}
	
	# 支払方法
	my ($pay,$cost) = split(/,/,$cf{payment}[$payment]);
	
	# 配達日
	my $haiso = $date;
	
	# 時間帯
	my $deliv = $cf{deli}[$deli];
	
	# 送料
	my ($prefect1,$soryo)  = split(/,/,$cf{pref}[$pref]);
	my ($prefect2,$soryo2) = split(/,/,$cf{pref}[$pref2]) if ($ship == 2);
	if ($name2 && $addr2) {	$soryo = $soryo2; }
	
	# 送料
	if ($in{name2} && $in{addr2}) {
		$soryo = $soryo2;
	}
	if ($cf{cari_serv} && $cf{cari_serv} <= $all) {
		$soryo = 0;
	}
	$soryo ||= 0;
	
	# 消費税計算
	my ($kei,$tax1,$tax2,$all,$tar) = calc_tax($all + $cost + $soryo,$red);
	if ($cf{tax_per} == 0) {
		$tax1 = $tax2 = '[内税]';
	} else {
		$tax1 = comma($tax1) . "（$cf{tax_per}%対象 " . comma($tar) . "円）";
		$tax2 = comma($tax2) . "（$cf{red_per}%対象 " . comma($red) . "円）";
	}
	
	# 日時
	my $date = get_date();
	
	# 通番
	my $number = make_number();
	
	# ブラウザ
	my $agent = $ENV{HTTP_USER_AGENT};
	$agent =~ s/[<>'"&()+;]//g;
	
	# ホスト
	my $host = get_host();
	
	# メールテンプレート
	open(IN,"$cf{tmpldir}/mail.txt") or error("open err: mail.txt");
	my $mtmpl = join('',<IN>);
	close(IN);
	
	# 返信テンプレート
	open(IN,"$cf{tmpldir}/reply.txt") or error("open err: reply.txt");
	my $rtmpl = join('',<IN>);
	close(IN);
	
	# 置き換え
	my $mail;
	for ($mtmpl,$rtmpl) {
		s/!date!/$date/g;
		s/!number!/$number/g;
		s/!order!/$order/g;
		s/!all!/comma($all)/eg;
		s/!cost!/comma($cost)/eg;
		s/!soryo!/comma($soryo)/eg;
		s/!kei!/comma($kei)/eg;
		s/!tax1!/$tax1/g;
		s/!tax2!/$tax2/g;
		s/!all!/comma($all)/eg;
		s/!corp!/$corp/g;
		s/!kana!/$kana/g;
		s/!name!/$name/g;
		s/!email!/$email/g;
		s/!zip!/$zip/g;
		s/!pref!/$prefect1/g;
		s/!addr!/$addr/g;
		s/!adds!/$adds/g;
		s/!tel!/$tel/g;
		s/!fax!/$fax/g;
		s/!corp2!/$corp2/g;
		s/!kana2!/$kana2/g;
		s/!name2!/$name2/g;
		s/!zip2!/$zip2/g;
		s/!pref2!/$prefect2/g;
		s/!addr2!/$addr2/g;
		s/!adds2!/$adds2/g;
		s/!tel2!/$tel2/g;
		s/!fax2!/$fax2/g;
		s/!payment!/$pay/g;
		s/!haiso!/$haiso/g;
		s/!deliv!/$deliv/g;
		s/!memo!/$memo/g;
		s/!host!/$host/g;
		s/!agent!/$agent/g;
	}
	my $log = $mtmpl;
	
	# コード変換
	my $omail;
	require "./lib/jacode.pl";
	for my $tmp ( split(/\n/,$mtmpl) ) {
		jcode::convert(\$tmp,'jis','utf8');
		$omail .= "$tmp\n";
	}
	my $reply;
	for my $tmp ( split(/\n/,$rtmpl) ) {
		jcode::convert(\$tmp,'jis','utf8');
		$reply .= "$tmp\n";
	}
	
	# sendmailコマンド
	my $scmd1 = "$cf{sendmail} -t -i";
	my $scmd2 = "$cf{sendmail} -t -i";
	if ($cf{sendm_f} == 1) {
		$scmd1 .= qq| -f $email|;
		$scmd2 .= qq| -f $cf{master}|;
	}
	
	# メール件名をMIMEエンコード
	my $msub = mime_unstructured_header("ご注文メール ($name様)");
	my $rsub = mime_unstructured_header("ご注文メール (控え)");
	
	# 管理者へ送信
	open(MAIL,"| $scmd1") or error("送信失敗");
	print MAIL "Subject: $msub\n";
	print MAIL "MIME-Version: 1.0\n";
	print MAIL "Content-type: text/plain; charset=ISO-2022-JP\n";
	print MAIL "Content-Transfer-Encoding: 7bit\n";
	print MAIL "X-Mailer: $cf{version}\n";
	print MAIL "To: $cf{mailto}\n";
	print MAIL "From: $email\n\n";
	print MAIL "$omail\n";
	close(MAIL);
	
	# 注文者へ送信
	open(MAIL,"| $scmd2") or error("返信失敗");
	print MAIL "Subject: $rsub\n";
	print MAIL "MIME-Version: 1.0\n";
	print MAIL "Content-type: text/plain; charset=ISO-2022-JP\n";
	print MAIL "Content-Transfer-Encoding: 7bit\n";
	print MAIL "X-Mailer: $cf{version}\n";
	print MAIL "To: $email\n";
	print MAIL "From: $cf{mailto}\n\n";
	print MAIL "$reply\n";
	close(MAIL);
	
	# セッション削除
	$ses->delete();
	
	# 在庫更新
	if ($cf{stock} == 1) {
		my @data;
		for ( keys %zan ) {
			push(@data,"$_,$zan{$_}\n");
		}
		open(DAT,"> $cf{datadir}/stock.dat") or error("write err: stock.dat");
		eval "flock(DAT,2);";
		print DAT @data;
		close(DAT);
	}
	
	# ログ記録
	save_log($date,$number,$log);
	
	# 注文者情報クッキー保存
	set_cookie($corp,$kana,$name,$email,$zip,$pref,$addr,$adds,$tel,$fax,$corp2,$kana2,$name2,$zip2,$pref2,$addr2,$adds2,$tel2,$fax2);
	
	# 基本データ
	my %top = read_base();
	
	# テンプレート判別
	my $q_pay = $payment;
	my $zeus_num;
	my $tmplfile = "send.html";
	
	# 決済手段
	my $payflg;
	if (($cf{zeus_serv} == 1 && $q_pay == $#{$cf{payment}})
			or ($cf{zeus_serv} == 2 && $q_pay == $#{$cf{payment}}-1)
			or ($cf{zeus_serv} == 3 && $q_pay == $#{$cf{payment}}-1)
			or ($cf{zeus_serv} == 4 && $q_pay == $#{$cf{payment}}-2)) { # クレジット
		$tmplfile = "send-credit.html";
		$zeus_num = $cf{zeus_num};
		$payflg = 'c';
	
	} elsif (($cf{zeus_serv} == 2 && $q_pay == $#{$cf{payment}})
			or ($cf{zeus_serv} == 4 && $q_pay == $#{$cf{payment}}-1)) { # 銀行
		$tmplfile = "send-bank.html";
		$zeus_num = $cf{zeus_bip};
		$payflg = 'b';
	
	} elsif (($cf{zeus_serv} == 3 && $q_pay == $#{$cf{payment}})
			or ($cf{zeus_serv} == 4 && $q_pay == $#{$cf{payment}})) { # コンビニ
		$tmplfile = "send-conv.html";
		$zeus_num = $cf{zeus_cip};
		$payflg = 'v';
	}
	
	# テンプレート読込
	open(IN,"$cf{tmpldir}/$tmplfile") or error("open err: $tmplfile");
	my $tmpl = join('',<IN>);
	close(IN);
	
	# カテゴリリンクからセッション引数を削除
	$top{cat} =~ s/[\&\?]sid=\w+//g;
	
	# 文字置き換え
	$tmpl =~ s/!([a-z]+_cgi)!/$cf{$1}/g;
	$tmpl =~ s/!cmnurl!/$cf{cmnurl}/g;
	$tmpl =~ s/!top-(\w+)!/$top{$1}/g;
	$tmpl =~ s|!icon:(\w+\.\w+)!|<img src="$cf{cmnurl}/$1" alt="" class="icon">|g;
	$tmpl =~ s/!prog_table!/$payflg ? prog_tbl('4p') : prog_tbl(4)/e;
	
	# ゼウス決済のとき
	if ($cf{zeus_serv} > 0) {
		$tel =~ s/\D//g;
		
		$tmpl =~ s/!zeus_num!/$zeus_num/g;
		$tmpl =~ s/!money!/$all/g;
		$tmpl =~ s/!tel!/$tel/g;
		$tmpl =~ s/!email!/$email/g;
		$tmpl =~ s/!sendid!/$number/g;
	}
	
	# ヘッダ表示
	print "Content-type: text/html; charset=utf-8\n\n";
	print $tmpl;
	exit;
}

#-----------------------------------------------------------
#  注文番号作成
#-----------------------------------------------------------
sub make_number {
	open(DAT,"+< $cf{datadir}/order.dat") or error("open err: order.dat");
	eval "flock(DAT,2);";
	my $num = <DAT> + 1;
	seek(DAT,0,0);
	print DAT $num;
	truncate(DAT,tell(DAT));
	close(DAT);
	
	return sprintf("%06d",$num);
}

#-----------------------------------------------------------
#  ログ記録
#-----------------------------------------------------------
sub save_log {
	my ($date,$num,$log) = @_;
	$date =~ /^(\d{4})\/(\d{2})/;
	my $file = "$1$2.cgi";
	
	# 改行変換
	$log =~ s/\n/\t/g;
	
	# ログ存在チェック
	my $flg;
	if (-e "$cf{datadir}/log/$file") { $flg++; }
	
	# 追加上書き
	open(DAT,">> $cf{datadir}/log/$file") or error("write err: $file");
	eval "flock(DAT,2);";
	print DAT "$date<>$num<>$log\n";
	close(DAT);
	
	# 新規生成時はパーミッション
	chmod(0666,"$cf{datadir}/log/$file") if (!$flg);
}

#-----------------------------------------------------------
#  日時取得
#-----------------------------------------------------------
sub get_date {
	my ($sec,$min,$hour,$mday,$mon,$year,$wday,undef,undef) = localtime();
	my @week = qw|日 月 火 水 木 金 土|;
	
	return sprintf("%04d/%02d/%02d(%s) %02d:%02d:%02d",
				$year+1900,$mon+1,$mday,$week[$wday],$hour,$min,$sec);
}

#-----------------------------------------------------------
#  IP/ホスト取得
#-----------------------------------------------------------
sub get_host {
	# IP/ホスト取得
	my $host = $ENV{REMOTE_HOST};
	my $addr = $ENV{REMOTE_ADDR};
	
	if ($cf{gethostbyaddr} && ($host eq "" || $host eq $addr)) {
		$host = gethostbyaddr(pack("C4", split(/\./, $addr)), 2);
	}
	$host ||= $addr;
	return $host;
}

#-----------------------------------------------------------
#  注文者情報クッキー保存
#-----------------------------------------------------------
sub set_cookie {
	my @data = @_;
	
	# 文字列化
	my $data = join("\t",@data);
	
	# 暗号化
	my $crypt = encrypt($data);
	
	# 90日間有効
	my ($sec,$min,$hour,$mday,$mon,$year,$wday,undef,undef) = gmtime(time + 90*24*60*60);
	my @mon  = qw(Jan Feb Mar Apr May Jun Jul Aug Sep Oct Nov Dec);
	my @week = qw(Sun Mon Tue Wed Thu Fri Sat);
	
	# 時刻フォーマット
	my $gmt = sprintf("%s, %02d-%s-%04d %02d:%02d:%02d GMT",
				$week[$wday],$mday,$mon[$mon],$year+1900,$hour,$min,$sec);
	
	# クッキー保存
	print "Set-Cookie: $cf{cookie_id}=$crypt; expires=$gmt\n";
}

#-----------------------------------------------------------
#  RC4暗号
#-----------------------------------------------------------
sub encrypt {
	my ($plain) = @_;
	
	# RC4暗号変換
	my $crypt = RC4($cf{passphrase}, $plain);
	
	# バイナリを16進へ
	$crypt =~ s/(.)/unpack('H2', $1)/eg;
	$crypt =~ s/\n/n/g;
	
	# 出力
	return $crypt;
}

#-----------------------------------------------------------
#  mimeエンコード
#  [quote] http://www.din.or.jp/~ohzaki/perl.htm#JP_Base64
#-----------------------------------------------------------
sub mime_unstructured_header {
  my $oldheader = shift;
  jcode::convert(\$oldheader,'euc','utf8');
  my ($header,@words,@wordstmp,$i);
  my $crlf = $oldheader =~ /\n$/;
  $oldheader =~ s/\s+$//;
  @wordstmp = split /\s+/, $oldheader;
  for ($i = 0; $i < $#wordstmp; $i++) {
    if ($wordstmp[$i] !~ /^[\x21-\x7E]+$/ and
	$wordstmp[$i + 1] !~ /^[\x21-\x7E]+$/) {
      $wordstmp[$i + 1] = "$wordstmp[$i] $wordstmp[$i + 1]";
    } else {
      push(@words, $wordstmp[$i]);
    }
  }
  push(@words, $wordstmp[-1]);
  foreach my $word (@words) {
    if ($word =~ /^[\x21-\x7E]+$/) {
      $header =~ /(?:.*\n)*(.*)/;
      if (length($1) + length($word) > 76) {
	$header .= "\n $word";
      } else {
	$header .= $word;
      }
    } else {
      $header = add_encoded_word($word, $header);
    }
    $header =~ /(?:.*\n)*(.*)/;
    if (length($1) == 76) {
      $header .= "\n ";
    } else {
      $header .= ' ';
    }
  }
  $header =~ s/\n? $//mg;
  $crlf ? "$header\n" : $header;
}
sub add_encoded_word {
  my ($str, $line) = @_;
  my $result;
  my $ascii = '[\x00-\x7F]';
  my $twoBytes = '[\x8E\xA1-\xFE][\xA1-\xFE]';
  my $threeBytes = '\x8F[\xA1-\xFE][\xA1-\xFE]';
  while (length($str)) {
    my $target = $str;
    $str = '';
    if (length($line) + 22 +
	($target =~ /^(?:$twoBytes|$threeBytes)/o) * 8 > 76) {
      $line =~ s/[ \t\n\r]*$/\n/;
      $result .= $line;
      $line = ' ';
    }
    while (1) {
      my $encoded = '=?ISO-2022-JP?B?' .
      b64encode(jcode::jis($target,'euc','z')) . '?=';
      if (length($encoded) + length($line) > 76) {
	$target =~ s/($threeBytes|$twoBytes|$ascii)$//o;
	$str = $1 . $str;
      } else {
	$line .= $encoded;
	last;
      }
    }
  }
  $result . $line;
}
# [quote] http://www.tohoho-web.com/perl/encode.htm
sub b64encode {
    my $buf = shift;
    my ($mode,$tmp,$ret);
    my $b64 = "ABCDEFGHIJKLMNOPQRSTUVWXYZ"
                . "abcdefghijklmnopqrstuvwxyz"
                . "0123456789+/";
	
    $mode = length($buf) % 3;
    if ($mode == 1) { $buf .= "\0\0"; }
    if ($mode == 2) { $buf .= "\0"; }
    $buf =~ s/(...)/{
        $tmp = unpack("B*", $1);
        $tmp =~ s|(......)|substr($b64, ord(pack("B*", "00$1")), 1)|eg;
        $ret .= $tmp;
    }/eg;
    if ($mode == 1) { $ret =~ s/..$/==/; }
    if ($mode == 2) { $ret =~ s/.$/=/; }
    
    return $ret;
}


1;

