#!/usr/local/bin/perl

#┌─────────────────────────────────
#│ CartForm : check.cgi - 2019/09/29
#│ copyright (c) kentweb, 1997-2019
#│ http://www.kent-web.com/
#└─────────────────────────────────

# モジュール宣言
use strict;
use CGI::Carp qw(fatalsToBrowser);

# 外部ファイル取り込み
require './init.cgi';
my %cf = set_init();

print <<EOM;
Content-type: text/html; charset=utf-8

<!doctype html>
<html lang="ja">
<head>
<meta charset="UTF-8">
<title>Check Mode</title>
</head>
<body>
<b>Check Mode: [ $cf{version} ]</b>
<ul>
EOM

$cf{base64} = './lib/base64.pl';
my %file = (
	logfile => 'ログファイル',
	datfile => '商品ファイル',
	numfile => '通番ファイル',
	base64  => 'BASE64ライブラリ',
);
foreach ( keys %file ) {
	if (-f $cf{$_}) {
		print "<li>$file{$_}パス : OK\n";
		if (-r $cf{logfile} && -w $cf{logfile}) {
			print "<li>$file{$_}パーミッション : OK\n";
		} else {
			print "<li>$file{$_}パーミッション : NG\n";
		}
	} else {
		print "<li>$file{$_}パス : NG\n";
	}
}

# ディレクトリ
if (-d $cf{logdir}) {
	print "<li>ログディレクトリ位置 : OK\n";

	if (-r $cf{logdir} && -w $cf{logdir} && -x $cf{logdir}) {
		print "<li>ログディレクトリパーミッション : OK\n";
	} else {
		print "<li>ログディレクトリパーミッション : NG\n";
	}
} else {
	print "<li>ログディレクトリ位置 : NG\n";
}

# メールソフトチェック
print "<li>sendmailパス：";
if (-e $cf{sendmail}) {
	print "OK\n";
} else {
	print "NG → $cf{sendmail}\n";
}

# テンプレート
my @tmpl = qw|conf.html err1.html err2.html send.html send-bank.html send-credit.html mail.txt reply.txt|;
foreach (@tmpl) {
	print "<li>テンプレート ( $_ ) : ";
	
	if (-f "$cf{tmpldir}/$_") {
		print "パスOK\n";
	} else {
		print "パスNG → $_\n";
	}
}

print <<EOM;
</ul>
</body>
</html>
EOM
exit;

