# モジュール宣言/変数初期化
use strict;
my %cf;
#┌─────────────────────────────────
#│ CLIP BOARD : init.cgi - 2022/05/28
#│ copyright (c) kentweb, 1997-2022
#│ https://www.kent-web.com/
#└─────────────────────────────────
$cf{version} = 'ClipBoard v6.2';
#┌─────────────────────────────────
#│ [注意事項]
#│ 1. このプログラムはフリーソフトです。このプログラムを使用した
#│    いかなる損害に対して作者は一切の責任を負いません。
#│ 2. 設置に関する質問はサポート掲示板にお願いいたします。
#│    直接メールによる質問は一切お受けいたしておりません。
#└─────────────────────────────────

#===========================================================
# ■ 基本設定
#===========================================================

# サムネイル画像を作成する（要：Image::Magick）
# → 縮小画像を自動生成し、画像記事の表示速度を軽くする機能
# 0=no 1=yes
$cf{thumbnail} = 0;

# 掲示板タイトル
$cf{bbs_title} = '掲示板 - CLIPBOARD';

# 本体プログラムURL【URLパス】
$cf{bbs_cgi} = './clipbbs.cgi';

# 投稿プログラムURL【URLパス】
$cf{regist_cgi} = './regist.cgi';

# 管理プログラムURL【URLパス】
$cf{admin_cgi} = './admin.cgi';

# データディレクトリ【サーバパス】
$cf{datadir} = './data';

# 最大記事数
# → これを超える記事は古い順に削除されます
$cf{maxlog} = 100;

# 戻り先【URLパス】
$cf{homepage} = "../index.html";

# URL自動リンク
# → 0=no 1=yes
$cf{autolink} = 1;

# １ページあたりの記事表示件数
$cf{pg_max} = 10;

# アップロードディレクトリ【サーバパス】
$cf{imgdir} = "./img";

# アップロードディレクトリ【URLパス】
$cf{imgurl} = "./img";

# テンプレートディレクトリ【サーバパス】
$cf{tmpldir} = "./tmpl";

# 共通ディレクトリ【URLパス】
$cf{cmnurl} = './cmn';

# アップファイル管理者チェック機能
# → アップされた添付ファイルは管理者がチェック後に表示
# 0=no 1=yes
$cf{imgcheck} = 0;

# メール通知機能
# → 0=no  1=yes
$cf{mailing} = 0;

# メール通知先アドレス（メール通知する場合）
$cf{mailto} = 'xxx@xxx.xx';

# sendmailのパス（メール通知する場合）
$cf{sendmail} = '/usr/lib/sendmail';

# sendmailの -fコマンドが必要な場合
# 0=no 1=yes
$cf{sendm_f} = 0;

# ホスト取得方法
# 0 : gethostbyaddr関数を使わない
# 1 : gethostbyaddr関数を使う
$cf{gethostbyaddr} = 0;

# アクセス制限（半角スペースで区切る、アスタリスク可）
# → 拒否ホスト名を記述（後方一致）【例】*.anonymizer.com
$cf{deny_host} = '';
# → 拒否IPアドレスを記述（前方一致）【例】210.12.345.*
$cf{deny_addr} = '';

# 同一ホストからの連続投稿を制限（秒数で指定）
# → 秒数を記述するとその時間以上を経過しないと連続投稿できない
$cf{w_regist} = 60;

# 禁止ワード
# → 投稿時禁止するワードをコンマで区切る
$cf{no_wd} = '';

# 日本語チェック（コメント内に日本語が含まれていなければ拒否）
# 0=no  1=yes
$cf{jp_wd} = 1;

# URL個数チェック
# → 投稿コメント中に含まれるURL個数の最大値
$cf{urlnum} = 2;

# 投稿受理最大サイズ (bytes)
# → 例 : 102400 = 100KB
$cf{maxdata} = 512000;

# 画像ファイルの最大表示の大きさ（単位：ピクセル）
# → これを超える画像は縮小表示します
$cf{max_img_w} = 250;	# 横幅
$cf{max_img_h} = 150;	# 縦幅

# アップロードを許可するファイル（0=no 1=yes）
$cf{ok_text}  = 1;  # TEXT
$cf{ok_gif}   = 1;  # GIF
$cf{ok_png}   = 1;  # PNG
$cf{ok_jpeg}  = 1;  # JPEG
$cf{ok_excel} = 1;  # EXCEL
$cf{ok_word}  = 1;  # WORD
$cf{ok_ppt}   = 1;  # POWER POINT
$cf{ok_zip}   = 1;  # ZIP
$cf{ok_pdf}   = 1;  # PDF

# クッキーID名（特に変更しなくてよい）
# → クッキー保存名
$cf{cookie_id} = "clipboard";

# -------------------------------------------------------------- #
# [ 以下は「画像認証機能」機能（スパム対策）を使用する場合の設定 ]
#
# 画像認証機能の使用
# 0 : しない
# 1 : ライブラリ版（pngren.pl）
# 2 : モジュール版（GD::SecurityImage + Image::Magick）→ Image::Magick必須
$cf{use_captcha} = 1;

# 認証用画像生成ファイル【URLパス】
$cf{captcha_cgi} = './captcha.cgi';

# 画像認証プログラム【サーバパス】
$cf{captcha_pl} = './lib/captcha.pl';
$cf{captsec_pl} = './lib/captsec.pl';
$cf{pngren_pl}  = './lib/pngren.pl';

# 画像認証機能用暗号化キー（暗号化/復号化をするためのキー）
# → 適当に変更してください。
$cf{captcha_key} = 'captclipbbs';

# 投稿キー許容時間（分単位）
# → 投稿フォーム表示後、送信ボタンが押されるまでの可能時間。
$cf{cap_time} = 30;

# 投稿キーの文字数
# ライブラリ版 : 4～8文字で設定
# モジュール版 : 6～8文字で設定
$cf{cap_len} = 6;

# 画像/フォント格納ディレクトリ【サーバパス】
$cf{bin_dir} = './lib/bin';

# [ライブラリ版] 画像ファイル [ ファイル名のみ ]
$cf{si_png} = "stamp.png";

# [モジュール版] 画像フォント [ ファイル名のみ ]
$cf{font_ttl} = "tempest.ttf";

#===========================================================
# ■ 設定完了
#===========================================================

# 設定内容を返す
sub set_init { return %cf; }

#-----------------------------------------------------------
#  フォームデコード
#-----------------------------------------------------------
sub parse_form {
	my $cgi = shift;
	
	my %in;
	foreach ( $cgi->param() ) {
		my $val = $cgi->param($_);
		
		if ($_ ne 'upfile') {
			# 無効化
			$val =~ s/&/&amp;/g;
			$val =~ s/</&lt;/g;
			$val =~ s/>/&gt;/g;
			$val =~ s/"/&quot;/g;
			$val =~ s/'/&#39;/g;
			
			# 改行処理
			$val =~ s|\r\n|<br>|g;
			$val =~ s|[\r\n]|<br>|g;
		}
		$in{$_} = $val;
	}
	return %in;
}

#-----------------------------------------------------------
#  エラー画面
#-----------------------------------------------------------
sub error {
	my $err = shift;
	
	open(IN,"$cf{tmpldir}/error.html") or die;
	my $tmpl = join('',<IN>);
	close(IN);
	
	$tmpl =~ s/!error!/$err/g;
	$tmpl =~ s/!(cmnurl|bbs_title)!/$cf{$1}/g;
	
	print "Content-type: text/html; charset=utf-8\n\n";
	print $tmpl;
	exit;
}

#-----------------------------------------------------------
#  画像リサイズ
#-----------------------------------------------------------
sub resize {
	my ($w,$h) = @_;
	
	# 画像表示縮小
	if ($w > $cf{max_img_w} || $h > $cf{max_img_h}) {
		my $w2 = $cf{max_img_w} / $w;
		my $h2 = $cf{max_img_h} / $h;
		my $key;
		if ($w2 < $h2) { $key = $w2; } else { $key = $h2; }
		$w = int ($w * $key) || 1;
		$h = int ($h * $key) || 1;
	}
	
	return ($w,$h);
}


1;

