#!/usr/local/bin/perl

#
# COM BOARD : combbs.cgi - 2023/09/23
# copyright (c) kentweb, 1997-2023
# https://www.kent-web.com/
#

# W[錾
use strict;
use CGI::Carp qw(fatalsToBrowser);

# ݒt@CF
require "./init.cgi";
my %cf = init();

# f[^
my %in = parse_form();

if ($in{mode} eq "form") { form_page(); }
if ($in{mode} eq 'find') { find_data(); }
if ($in{mode} eq 'note') { note_page(); }
if ($in{mode} eq 'regist') { regist(); }
if ($in{mode} eq 'del_log') { del_log(); }
bbs_list();

#-----------------------------------------------------------
#  etH[
#-----------------------------------------------------------
sub form_page {
	# NbL[擾
	my @cook = get_cookie();

	# ev[gF
	open(IN,"$cf{tmpldir}/form.html") or error("open err: form.tml");
	my $tmpl = join('', <IN>);
	close(IN);

	# u
	$tmpl =~ s/!([a-z]+_cgi)!/$cf{$1}/g;
	$tmpl =~ s/!name!/$cook[0]/g;
	$tmpl =~ s/!email!/$cook[1]/g;

	# 摜F
	my ($str_plain,$str_crypt);
	if ($cf{use_captcha} > 0) {
		require $cf{captcha_pl};
		($str_plain, $str_crypt) = cap::make( $cf{captcha_key}, $cf{cap_len} );
		$tmpl =~ s/!str_crypt!/$str_crypt/g;
	} else {
		$tmpl =~ s/<!-- captcha_begin -->.+<!-- captcha_endn -->//s;
	}

	print "Content-type: text/html; charset=shift_jis\n\n";
	print $tmpl;
	exit;
}

#-----------------------------------------------------------
#  L\
#-----------------------------------------------------------
sub bbs_list {
	# y[W`
	my $pg = $in{pg} || 0;

	my ($i,@log);
	open(IN,"$cf{logfile}") or error("open err: $cf{logfile}");
	while (<IN>) {
		$i++;
		next if ($i < $pg + 1);
		next if ($i > $pg + $cf{pg_max});

		push(@log,$_);
	}
	close(IN);

	# Jz{^쐬
	my $page_btn = make_pgbtn($i,$pg);

	# ev[gǍ
	open(IN,"$cf{tmpldir}/bbs.html") or error("open err: bbs.tml");
	my $tmpl = join('', <IN>);
	close(IN);

	# ev[g
	my ($head,$loop,$foot) = $tmpl =~ /(.+)<!-- loop_begin -->(.+)<!-- loop_end -->(.+)/s
			? ($1,$2,$3) : error("ev[gs");

	# u
	foreach ( $head, $foot ) {
		s/!([a-z]+_cgi)!/$cf{$1}/g;
		s/!page_btn!/$page_btn/g;
		s/!bbs_title!/$cf{bbs_title}/g;
		s/!home!/$cf{homepage}/g;
	}

	print "Content-type: text/html; charset=shift_jis\n\n";
	print $head;

	foreach (@log) {
		my ($no,$date,$nam,$eml,$sub,$com,$url) = split(/<>/);
		$nam = qq|<a href="mailto:$eml">$nam</a>| if ($eml);

		my $tmp = $loop;
		$tmp =~ s/!num!/$no/g;
		$tmp =~ s/!sub!/$sub/g;
		$tmp =~ s/!name!/$nam/g;
		$tmp =~ s/!date!/$date/g;
		$tmp =~ s/!comment!/$com/g;
		$tmp = autolink($tmp) if ($cf{autolink});
		
		print $tmp;
	}

	# tb^
	footer($foot);
}

#-----------------------------------------------------------
#  Le
#-----------------------------------------------------------
sub regist {
	# e`FbN
	if ($cf{postonly} && $ENV{REQUEST_METHOD} ne 'POST') {
		error("sȃNGXgł");
	}

	# svsJbg
	$in{sub}  =~ s/<br>//g;
	$in{name} =~ s/<br>//g;
	$in{pwd}  =~ s/<br>//g;
	$in{captcha} =~ s/<br>//g;
	$in{comment} =~ s/(<br>)+$//g;

	# `FbN
	if ($cf{no_wd}) { &no_wd; }
	if ($cf{jp_wd}) { &jp_wd; }
	if ($cf{urlnum} > 0) { &urlnum; }

	# 摜F؃`FbN
	if ($cf{use_captcha} > 0) {
		require $cf{captcha_pl};
		if ($in{captcha} !~ /^\d{$cf{cap_len}}$/) {
			&error("摜F؂͕słB<br>etH[ɖ߂čēǍ݌Aē͂Ă");
		}

		# eL[`FbN
		# -1 : L[sv
		#  0 : ԃI[o[
		#  1 : L[v
		my $chk = cap::check($in{captcha},$in{str_crypt},$cf{captcha_key},$cf{cap_time},$cf{cap_len});
		if ($chk == 0) {
			error("摜F؂Ԃ𒴉߂܂B<br>etH[ɖ߂čēǍ݌Aw̐ē͂Ă");
		} elsif ($chk == -1) {
			error("摜F؂słB<br>etH[ɖ߂čēǍ݌Aē͂Ă");
		}
	}

	# ͂̏ꍇ
	$in{sub} ||= '';
	if ($in{url} eq 'http://') { $in{url} = ''; }

	# tH[e`FbN
	my $err;
	if ($in{name} eq "") { $err .= "O͂Ă܂<br>"; }
	if ($in{comment} eq "") { $err .= "Rg͂Ă܂<br>"; }
	if ($in{email} ne '' && $in{email}!~ /^[\w\.\-]+\@[\w\.\-]+\.[a-zA-Z]{2,6}$/) {
		$err .= "d[͓̓esł<br>";
	}
	if ($in{url} ne '' && $in{url} !~ /^https?:\/\/[\w-.!~*'();\/?:\@&=+\$,%#]+$/) {
		$err .= "URL͓̓esł<br>";
	}
	error($err) if ($err);

	# R[hϊ
	if ($cf{conv_code} == 1) {
		require './lib/Jcode.pm';
		$in{name} = Jcode->new($in{name})->sjis;
		$in{sub}  = Jcode->new($in{sub})->sjis;
		$in{comment} = Jcode->new($in{comment})->sjis;
	}

	# zXg擾
	my ($host,$addr) = get_host();

	# OJ
	open(DAT,"+< $cf{logfile}") or error("open err: $cf{logfile}");
	eval "flock(DAT, 2);";
	my $top = <DAT>;

	# de`FbN
	my ($no,$dat,$nam,$eml,$sub,$com,$url,$hos,$pw,$tim) = split(/<>/,$top);
	if ($in{name} eq $nam && $in{comment} eq $com) {
		close(DAT);
		error("de͋֎~ł");
	}

	# Ae`FbN
	my $time = time;
	my $flag;
	if ($cf{regCtl} == 1) {
		if ($host eq $hos && $time - $tim < $cf{wait}) { $flag = 1; }
	} elsif ($cf{regCtl} == 2) {
		if ($time - $tim < $cf{wait}) { $flag = 1; }
	}
	if ($flag) {
		close(DAT);
		error("ݓełB΂炭Ă瓊e肢܂");
	}

	# LNo̔
	$no++;

	# 폜L[Í
	my $pwd = encrypt($in{pwd}) if ($in{pwd} ne '');

	# Ԏ擾
	my ($min,$hour,$mday,$mon,$year,$wday) = (localtime($time))[1..6];
	my @wk = ('Sun','Mon','Tue','Wed','Thu','Fri','Sat');
	my $date = sprintf("%04d/%02d/%02d(%s) %02d:%02d",
				$year+1900,$mon+1,$mday,$wk[$wday],$hour,$min);

	# XV
	seek(DAT, 0, 0);
	my ($i,@file);
	while(<DAT>) {
		$i++;
		push(@file,$_);

		last if ($i >= $cf{max} - 1);
	}
	unshift(@file,"$no<>$date<>$in{name}<>$in{email}<>$in{sub}<>$in{comment}<>$in{url}<>$host<>$pwd<>$time<>\n");
	seek(DAT, 0, 0);
	print DAT @file;
	truncate(DAT, tell(DAT));
	close(DAT);

	# NbL[i[
	set_cookie($in{name},$in{email});

	# [ʒm
	mail_to($date,$host) if ($cf{mailing} == 1);

	# 
	message("肪Ƃ܂BL󗝂܂B");
}

#-----------------------------------------------------------
#  [UL폜
#-----------------------------------------------------------
sub del_log {
	# ̓`FbN
	if ($in{num} eq '' || $in{pwd} eq '') {
		error("폜No܂͍폜L[̓ł");
	}

	my ($flg,$crypt,@log);
	open(DAT,"+< $cf{logfile}") or error("open err: $cf{logfile}");
	eval "flock(DAT, 2);";
	while (<DAT>) {
		my ($no,$dat,$nam,$eml,$sub,$com,$url,$hos,$pw,$tim) = split(/<>/);

		if ($in{num} == $no) {
			$flg++;
			$crypt = $pw;
			next;
		}
		push(@log,$_);
	}

	if (!$flg || $crypt eq '') {
		close(DAT);
		error("폜L[ݒ肳ĂȂ͋L܂");
	}

	# 폜L[ƍ
	if (decrypt($in{pwd},$crypt) != 1) {
		close(DAT);
		error("F؂ł܂");
	}

	# OXV
	seek(DAT, 0, 0);
	print DAT @log;
	truncate(DAT, tell(DAT));
	close(DAT);

	message("L폜܂");
}

#-----------------------------------------------------------
#  ӎ\
#-----------------------------------------------------------
sub note_page {
	open(IN,"$cf{tmpldir}/note.html") or error("open err: note.html");
	my $tmpl = join('', <IN>);
	close(IN);

	print "Content-type: text/html; charset=shift_jis\n\n";
	print $tmpl;
	exit;
}

#-----------------------------------------------------------
#  [h
#-----------------------------------------------------------
sub find_data {
	# 
	$in{cond} =~ s/\D//g;

	# v_E
	my %op = (1 => 'AND', 0 => 'OR');
	my $op_cond;
	foreach (1,0) {
		if ($in{cond} eq $_) {
			$op_cond .= qq|<option value="$_" selected>$op{$_}\n|;
		} else {
			$op_cond .= qq|<option value="$_">$op{$_}\n|;
		}
	}

	# s
	if ($cf{conv_code} == 1) {
		require './lib/Jcode.pm';
		$in{word} = Jcode->new($in{word})->sjis;
	}
	my @log = search($in{word},$in{cond}) if ($in{word} ne '');

	# ev[g
	open(IN,"$cf{tmpldir}/find.html") or error("open err: find.html");
	my $tmpl = join('', <IN>);
	close(IN);

	# 
	my ($head,$loop,$foot) = $tmpl =~ /(.+)<!-- loop_begin -->(.+)<!-- loop_end -->(.+)/s
		? ($1,$2,$3) : error('ev[gs');

	foreach ($head, $foot) {
		s/!bbs_cgi!/$cf{bbs_cgi}/g;
		s/<!-- op_cond -->/$op_cond/;
		s/!word!/$in{word}/;
	}

	# wb_
	print "Content-type: text/html; charset=shift_jis\n\n";
	print $head;

	# [v
	foreach my $log (@log) {
		my ($no,$date,$name,$eml,$sub,$com,$url,$host,$pw,$tim) = split(/<>/, $log);
		$name = qq|<a href="mailto:$eml">$name</a>| if ($eml);
		$com  = autolink($com) if ($cf{autolink});
		$com =~ s/([>]|^)(&gt;[^<]*)/$1<span style="color:$cf{ref_col}">$2<\/span>/g if ($cf{ref_col});
		$url  = qq|<a href="$url" target="_blank">$url</a>| if ($url);

		my $tmp = $loop;
		$tmp =~ s/!sub!/$sub/g;
		$tmp =~ s/!date!/$date/g;
		$tmp =~ s/!name!/$name/g;
		$tmp =~ s/!home!/$url/g;
		$tmp =~ s/!comment!/$com/g;
		print $tmp;
	}

	# tb^
	footer($foot);
}

#-----------------------------------------------------------
#  s
#-----------------------------------------------------------
sub search {
	my ($word,$cond) = @_;

	# L[[hz
	$word =~ s/@/ /g;
	my @wd = split(/\s+/, $word);

	# L[[hiShift-JIS`j
	my $ascii = '[\x00-\x7F]';
	my $hanka = '[\xA1-\xDF]';
	my $kanji = '[\x81-\x9F\xE0-\xFC][\x40-\x7E\x80-\xFC]';

	# 
	my @log;
	open(IN,"$cf{logfile}") or error("open err: $cf{logfile}");
	while (<IN>) {
		my ($no,$date,$nam,$eml,$sub,$com,$url,$hos,$pw,$tim) = split(/<>/);

		my $flg;
		foreach my $wd (@wd) {
			if ("$nam $eml $sub $com $url" =~ /^(?:$ascii|$hanka|$kanji)*?\Q$wd\E/i) {
				$flg++;
				if ($cond == 0) { last; }
			} else {
				if ($cond == 1) { $flg = 0; last; }
			}
		}
		next if (!$flg);

		push(@log,$_);
	}
	close(IN);

	# 
	return @log;
}

#-----------------------------------------------------------
#  [M
#-----------------------------------------------------------
sub mail_to {
	my ($date,$host) = @_;

	# MIMEGR[h
	require './lib/Jcode.pm' if ($cf{conv_code} == 0);
	my $msub = Jcode->new("BBS: $in{sub}",'sjis')->mime_encode;

	# Rg̉s
	my $com = $in{comment};
	$com =~ s/<br>/\n/g;
	$com =~ s/&lt;/</g;
	$com =~ s/&gt;/>/g;
	$com =~ s/&quot;/"/g;
	$com =~ s/&amp;/&/g;
	$com =~ s/&#39;/'/g;

	# [{`
	my $mbody = <<"EOM";
fɓe܂B

eF$date
zXgF$host

  F$in{sub}
OF$in{name}
E-mailF$in{email}

$com
EOM

	# JISR[hϊ
	$mbody = Jcode->new($mbody,'sjis')->jis;

	# [AhXȂꍇ͊Ǘ҃[ɒu
	$in{email} ||= $cf{mailto};

	# sendmailR}h
	my $scmd = "$cf{sendmail} -t -i";
	if ($cf{sendm_f}) {
		$scmd .= " -f $in{email}";
	}

	# M
	open(MAIL,"| $scmd") or error("Ms");
	print MAIL "To: $cf{mailto}\n";
	print MAIL "From: $in{email}\n";
	print MAIL "Subject: $msub\n";
	print MAIL "MIME-Version: 1.0\n";
	print MAIL "Content-type: text/plain; charset=ISO-2022-JP\n";
	print MAIL "Content-Transfer-Encoding: 7bit\n";
	print MAIL "X-Mailer: $cf{version}\n\n";
	print MAIL "$mbody\n";
	close(MAIL);
}

#-----------------------------------------------------------
#  tb^[
#-----------------------------------------------------------
sub footer {
	my $foot = shift;

	# 쌠\Li폜Eϋ֎~j
	my $copy = <<EOM;
<p style="margin-top:2em;text-align:center;font-family:Verdana,Helvetica,Arial;font-size:10px;">
- <a href="http://www.kent-web.com/" target="_top">COM BOARD</a> -
</p>
EOM

	if ($foot =~ /(.+)(<\/body[^>]*>.*)/si) {
		print "$1$copy$2\n";
	} else {
		print "$foot$copy\n";
		print "</body></html>\n";
	}
	exit;
}

#-----------------------------------------------------------
#  G[
#-----------------------------------------------------------
sub error {
	my $err = shift;

	open(IN,"$cf{tmpldir}/error.html") or die;
	my $tmpl = join('', <IN>);
	close(IN);

	$tmpl =~ s/!error!/$err/g;

	print "Content-type: text/html; charset=shift_jis\n\n";
	print $tmpl;
	exit;
}

#-----------------------------------------------------------
#  N
#-----------------------------------------------------------
sub autolink {
	my $text = shift;

	$text =~ s/(s?https?:\/\/([\w-.!~*'();\/?:\@=+\$,%#]|&amp;)+)/<a href="$1" target="_blank">$1<\/a>/g;
	return $text;
}

#-----------------------------------------------------------
#  ֎~[h`FbN
#-----------------------------------------------------------
sub no_wd {
	my $flg;
	foreach ( split(/,/, $cf{no_wd}) ) {
		if (index("$in{name} $in{sub} $in{comment}", $_) >= 0) {
			$flg = 1;
			last;
		}
	}
	if ($flg) { error("֎~[h܂܂Ă܂"); }
}

#-----------------------------------------------------------
#  {`FbN
#-----------------------------------------------------------
sub jp_wd {
	if ($in{comment} !~ /[\x81-\x9F\xE0-\xFC][\x40-\x7E\x80-\xFC]/) {
		error("bZ[Wɓ{ꂪ܂܂Ă܂");
	}
}

#-----------------------------------------------------------
#  URL`FbN
#-----------------------------------------------------------
sub urlnum {
	my $com = $in{comment};
	my ($num) = ($com =~ s|(https?://)|$1|ig);
	if ($num > $cf{urlnum}) {
		error("RgURLAhX͍ő$cf{urlnum}܂łł");
	}
}

#-----------------------------------------------------------
#  ANZX
#-----------------------------------------------------------
sub get_host {
	# IP&zXg擾
	my $host = $ENV{REMOTE_HOST};
	my $addr = $ENV{REMOTE_ADDR};

	if ($cf{gethostbyaddr} && ($host eq "" || $host eq $addr)) {
		$host = gethostbyaddr(pack("C4", split(/\./, $addr)), 2);
	}

	# IP`FbN
	my $flg;
	foreach ( split(/\s+/, $cf{deny_addr}) ) {
		s/\./\\\./g;
		s/\*/\.\*/g;

		if ($addr =~ /^$_/i) { $flg = 1; last; }
	}
	if ($flg) {
		error("ANZXĂ܂");

	# zXg`FbN
	} elsif ($host) {

		foreach ( split(/\s+/, $cf{deny_host}) ) {
			s/\./\\\./g;
			s/\*/\.\*/g;

			if ($host =~ /$_$/i) { $flg = 1; last; }
		}
		if ($flg) {
			error("ANZXĂ܂");
		}
	}
	if ($host eq "") { $host = $addr; }
	return ($host,$addr);
}

#-----------------------------------------------------------
#  cryptÍ
#-----------------------------------------------------------
sub encrypt {
	my $in = shift;

	my @wd = ('a'..'z', 'A'..'Z', '0'..'9', '.', '/');
	srand;
	my $salt = $wd[int(rand(@wd))] . $wd[int(rand(@wd))];
	crypt($in, $salt) || crypt ($in, '$1$' . $salt);
}

#-----------------------------------------------------------
#  cryptƍ
#-----------------------------------------------------------
sub decrypt {
	my ($in,$dec) = @_;

	my $salt = $dec =~ /^\$1\$(.*)\$/ ? $1 : substr($dec, 0, 2);
	if (crypt($in, $salt) eq $dec || crypt($in, '$1$' . $salt) eq $dec) {
		return 1;
	} else {
		return 0;
	}
}

#-----------------------------------------------------------
#  bZ[W
#-----------------------------------------------------------
sub message {
	my ($msg) = @_;

	open(IN,"$cf{tmpldir}/message.html") or error("open err: message.html");
	my $tmpl = join('', <IN>);
	close(IN);

	$tmpl =~ s/!bbs_cgi!/$cf{bbs_cgi}/g;
	$tmpl =~ s/!message!/$msg/g;

	print "Content-type: text/html; charset=shift_jis\n\n";
	print $tmpl;
	exit;
}

#-----------------------------------------------------------
#  Jz{^쐬
#-----------------------------------------------------------
sub make_pgbtn {
	my ($i,$pg) = @_;

	# y[WJz`
	my $next = $pg + $cf{pg_max};
	my $back = $pg - $cf{pg_max};

	# y[WJz{^쐬
	my $pg_btn;
	if ($back >= 0 || $next < $i) {
		$pg_btn .= "Page: ";

		my ($x,$y) = (1,0);
		while ($i > 0) {
			if ($pg == $y) {
				$pg_btn .= qq(| <b>$x</b> );
			} else {
				$pg_btn .= qq(| <a href="$cf{bbs_cgi}?pg=$y">$x</a> );
			}
			$x++;
			$y += $cf{pg_max};
			$i -= $cf{pg_max};
		}
		$pg_btn .= "|";
	}
	return $pg_btn;
}

#-----------------------------------------------------------
#  NbL[s
#-----------------------------------------------------------
sub set_cookie {
	my @data = @_;

	my ($sec,$min,$hour,$mday,$mon,$year,$wday,undef,undef) = gmtime(time + 60*24*60*60);
	my @mon  = qw|Jan Feb Mar Apr May Jun Jul Aug Sep Oct Nov Dec|;
	my @week = qw|Sun Mon Tue Wed Thu Fri Sat|;

	# tH[}bg
	my $gmt = sprintf("%s, %02d-%s-%04d %02d:%02d:%02d GMT",
				$week[$wday],$mday,$mon[$mon],$year+1900,$hour,$min,$sec);

	# URLGR[h
	my $cook;
	foreach (@data) {
		s/(\W)/sprintf("%%%02X", unpack("C", $1))/eg;
		$cook .= "$_<>";
	}

	print "Set-Cookie: $cf{cookie_id}=$cook; expires=$gmt\n";
}

#-----------------------------------------------------------
#  NbL[擾
#-----------------------------------------------------------
sub get_cookie {
	# NbL[擾
	my $cook = $ENV{HTTP_COOKIE};

	# YIDo
	my %cook;
	foreach ( split(/;/, $cook) ) {
		my ($key,$val) = split(/=/);
		$key =~ s/\s//g;
		$cook{$key} = $val;
	}

	# URLfR[h
	my @cook;
	foreach ( split(/<>/, $cook{$cf{cookie_id}}) ) {
		s/%([0-9A-Fa-f][0-9A-Fa-f])/pack("H2", $1)/eg;
		s/[&"'<>]//g;

		push(@cook,$_);
	}
	return @cook;
}

