# モジュール宣言/変数初期化
use strict;
my %cf;
#┌─────────────────────────────────
#│ Diary Note : init.cgi - 2021/03/28
#│ copyright (c) kentweb, 1997-2022
#│ https://www.kent-web.com/
#└─────────────────────────────────
$cf{version} = 'Diary Note v5.1';
#┌─────────────────────────────────
#│ [注意事項]
#│ 1. このプログラムはフリーソフトです。このプログラムを使用した
#│    いかなる損害に対して作者は一切の責任を負いません。
#│ 2. 設置に関する質問はサポート掲示板にお願いいたします。
#│    直接メールによる質問は一切お受けいたしておりません。
#└─────────────────────────────────

#===========================================================
# ■ 基本設定
#===========================================================

# タイトル名
$cf{cgi_title} = "気まぐれ日記";

# サムネイル画像を作成する（要：Image::Magick）
# → 縮小画像を自動生成し、画像記事の表示速度を軽くする機能
# 0=no 1=yes
$cf{thumbnail} = 0;

# 本体ファイル【URLパス】
$cf{diary_cgi} = './diary.cgi';

# 管理ファイルURL【URLパス】
$cf{admin_cgi} = './admin.cgi';

# 共通ディレクトリ【URLパス】
$cf{cmnurl} = './cmn';

# データディレクトリ【サーバパス】
$cf{datadir} = './data';

# 画像ディレクトリとそのURL
# → 順に、サーバパス、URLパス
$cf{imgdir} = './img';
$cf{imgurl} = './img';

# テンプレートディレクトリ【サーバパス】
$cf{tmpldir} = './tmpl';

# 週の表示
$cf{week} = ['日','月','火','水','木','金','土'];

# 日の並び順
#  0 : 昇順
#  1 : 降順
$cf{sort_day} = 0;

# 画像ファイルの最大表示の大きさ（単位：ピクセル）
# → これを超える画像は縮小表示します
$cf{img_max_w} = 200;	# 横幅
$cf{img_max_h} = 150;	# 縦幅

# 文字コード自動判別（0=no 1=yes）
# → フォーム入力の文字コード判別を行う場合
$cf{conv_code} = 0;

# １ページあたり表示件数
$cf{pg_max} = 10;

# 戻り先URL【URLパス】
$cf{homepage} = '../index.html';

# URLの自動リンク (0=no 1=yes)
$cf{autolink} = 1;

# カレンダ：曜日ごとの色
# → 順に、日～土、祝日
$cf{week_col} = [
	'red',
	'black',
	'black',
	'black',
	'black',
	'black',
	'blue',
	'#f20da2',
	];

# カレンダ：本日の背景色
$cf{cal_today} = '#aaffaa';

# トップのメッセージ
$cf{message} = <<EOM;
智に立てば角が立ち、情に棹差せば流される。
とかくこの世は住みにくい、そんな世の中に住む私が、
日常の出来事をだらだらと書き綴る
気まぐれ日記です。
EOM

# 投稿受理最大サイズ (bytes)
# → 例 : 102400 = 100KB
$cf{maxdata} = 307200;

# 管理パスワードの最大間違い制限
# → この回数以上パスワードを間違うとロックします
$cf{max_failpass} = 5;

# 管理パスワードのロック期間：自動解除を日数で指定
# → この値を 0 にすると自動解除しません。
$cf{lock_days} = 14;

#===========================================================
# ■ 設定完了
#===========================================================

# 設定値を返す
sub set_init { return %cf; }

#-----------------------------------------------------------
#  フォームデコード
#-----------------------------------------------------------
sub parse_form {
	my $cgi = shift;
	
	my %in;
	for ( $cgi->param() ) {
		my $val = $cgi->param($_);
		
		if ($_ !~ /^upfile[1-3]$/) {
			# 無効化
			$val =~ s/&/&amp;/g;
			$val =~ s/</&lt;/g;
			$val =~ s/>/&gt;/g;
			$val =~ s/"/&quot;/g;
			
			# 改行処理
			$val =~ s|\r\n|<br>|g;
			$val =~ s|[\r\n]|<br>|g;
		}
		$in{$_} = $val;
	}
	return %in;
}

#-----------------------------------------------------------
#  画像リサイズ
#-----------------------------------------------------------
sub resize {
	my ($w,$h) = @_;
	
	# 画像表示縮小
	if ($w > $cf{img_max_w} || $h > $cf{img_max_h}) {
		
		my $w2 = $cf{img_max_w} / $w;
		my $h2 = $cf{img_max_h} / $h;
		my $key;
		if ($w2 < $h2) { $key = $w2; }
		else { $key = $h2; }
		
		$w = int ($w * $key) || 1;
		$h = int ($h * $key) || 1;
	}
	return ($w,$h);
}

#-----------------------------------------------------------
#  月の末日
#-----------------------------------------------------------
sub last_day {
	my ($yy,$mm) = @_;
	
	return (31,28,31,30,31,30,31,31,30,31,30,31) [$mm - 1]
		+ ($mm == 2 && (($yy % 4 == 0 && $yy % 100 != 0) || $yy % 400 == 0));
}

#-----------------------------------------------------------
#  週算出
#-----------------------------------------------------------
sub get_week {
	my ($yy,$mm,$dd) = @_;
	
	if ($mm == 1 || $mm == 2) {
		$yy--;
		$mm += 12;
	}
	int( $yy + int($yy / 4) - int($yy / 100) + int($yy / 400) + int((13 * $mm + 8) / 5) + $dd ) % 7;
}

1;

