#!/usr/local/bin/perl

#┌─────────────────────────────────
#│ FANTASY BOARD : admin.cgi - 2021/07/23
#│ copyright (c) kentweb, 1997-2021
#│ https://www.kent-web.com/
#└─────────────────────────────────

# モジュール宣言
use strict;
use CGI::Carp qw(fatalsToBrowser);
use vars qw(%in %cf);
use lib "./lib";
use CGI::Session;
use Digest::SHA::PurePerl qw(sha256_base64);

# 設定ファイル認識
require "./init.cgi";
%cf = set_init();

# データ受理
%in = parse_form();

# 認証
require "./lib/login.pl";
auth_login();

# 処理分岐
if ($in{data_men}) { data_men(); }
if ($in{pass_mgr}) { pass_mgr(); }

# メニュー画面
menu_html();

#-----------------------------------------------------------
#  メニュー画面
#-----------------------------------------------------------
sub menu_html {
	header("メニューTOP");
	print <<EOM;
<div id="body">
<div class="menu-msg">選択ボタンを押してください。</div>
<form action="$cf{admin_cgi}" method="post">
<input type="hidden" name="sid" value="$in{sid}">
<table class="form-tbl">
<tr>
	<th>選択</th>
	<th width="280">処理メニュー</th>
</tr><tr>
	<td><input type="submit" name="data_men" value="選択"></td>
	<td>データ管理</td>
</tr><tr>
	<td><input type="submit" name="pass_mgr" value="選択"></td>
	<td>パスワード管理</td>
</tr><tr>
	<td><input type="submit" name="logoff" value="選択"></td>
	<td>ログアウト</td>
</tr>
</table>
</form>
</div>
</body>
</html>
EOM
	exit;
}

#-----------------------------------------------------------
#  管理モード
#-----------------------------------------------------------
sub data_men {
	# 削除
	if ($in{job} eq "dele" && $in{no}) {
		
		# 削除情報マッチング
		my @data;
		open(DAT,"+< $cf{datadir}/log.cgi") or error("open err: log.cgi");
		eval "flock(DAT,2);";
		while (<DAT>) {
			my ($no) = (split(/<>/))[0];
			next if ($in{no} == $no);
			
			push(@data,$_);
		}
		seek(DAT,0,0);
		print DAT @data;
		truncate(DAT,tell(DAT));
		close(DAT);
	
	# 修正画面
	} elsif ($in{job} eq "edit" && $in{no}) {
		
		my @log;
		open(IN,"$cf{datadir}/log.cgi") or error("open err: log.cgi");
		while (<IN>) {
			@log = split(/<>/);
			last if ($log[0] == $in{no});
		}
		close(IN);
		
		# 編集画面
		edit_form(@log);
	
	# 編集実行
	} elsif ($in{job} eq "edit2") {
		
		# アイコン
		my $icon = (split(/,/,$cf{icons}[$in{icon}]))[0];
		
		my @data;
		open(DAT,"+< $cf{datadir}/log.cgi") or error("open err: log.cgi");
		eval "flock(DAT,2);";
		while (<DAT>) {
			my ($no,$date,$nam,$eml,$sub,$ico,$ico2,$com,$res,$url,$hos,$pw,$time) = split(/<>/);
			
			if ($in{no} == $no) {
				$_ = "$no<>$date<>$in{name}<>$in{email}<>$in{sub}<>$in{icon}<>$ico2<>$in{comment}<>$in{reply}<>$in{url}<>$hos<>$pw<>$time<>\n";
			}
			push(@data,$_);
		}
		seek(DAT,0,0);
		print DAT @data;
		truncate(DAT,tell(DAT));
		close(DAT);
	}
	
	header("管理モード");
	print <<EOM;
<div id="body">
<div class="back-btn">
<form action="$cf{admin_cgi}" method="post">
<input type="hidden" name="sid" value="$in{sid}">
<input type="submit" value="&lt; メニュー">
</form>
</div>
<form action="$cf{admin_cgi}" method="post">
<input type="hidden" name="sid" value="$in{sid}">
<input type="hidden" name="data_men" value="1">
処理：
<select name="job">
<option value="edit">修正/返信
<option value="dele">削除
</select>
<input type="submit" value="送信する">
EOM

	open(IN,"$cf{datadir}/log.cgi") or error("open err: log.cgi");
	while (<IN>) {
		my ($no,$date,$nam,$eml,$sub,$ico,$ico2,$com,$res,$url,$hos) = split(/<>/);
		
		print qq|<div class="main"><input type="radio" name="no" value="$no">|;
		print qq|<b>$sub</b> $nam - $date No.$no &lt;$hos&gt;</div>\n|;
		print qq|<div class="com">| . cut_str($com,40) . qq|</div>\n|;
		print qq|<div class="res">返信：| . cut_str($res,40) . qq|</div>\n| if ($res);
	}
	close(IN);
	
	print <<EOM;
</form>
</div>
</body>
</html>
EOM
	exit;
}

#-----------------------------------------------------------
#  返信画面
#-----------------------------------------------------------
sub edit_form {
	my ($no,$date,$name,$eml,$sub,$ico,$ico2,$com,$res,$url,$hos,$pw) = @_;
	$com =~ s|<br>|\n|g;
	$res =~ s|<br>|\n|g;
	
	my $op_icon;
	for (0 .. $#{$cf{icons}}) {
		my (undef,$nam) = split(/,/,$cf{icons}[$_]);
		if ($ico == $_) {
			$op_icon .= qq|<option value="$_" selected>$nam</option>\n|;
		} else {
			$op_icon .= qq|<option value="$_">$nam</option>\n|;
		}
	}
	
	header("返信フォーム");
	print <<"EOM";
<div id="body">
<div class="back-btn">
<form action="$cf{admin_cgi}" method="post">
<input type="hidden" name="data_men" value="1">
<input type="hidden" name="sid" value="$in{sid}">
<input type="submit" value="&lt; 前画面">
</form>
</div>
<div class="ttl">■修正・返信フォーム</div>
<form action="$cf{admin_cgi}" method="post">
<input type="hidden" name="data_men" value="1">
<input type="hidden" name="job" value="edit2">
<input type="hidden" name="sid" value="$in{sid}">
<input type="hidden" name="no" value="$no">
<table class="form-tbl">
<tr>
	<th>名前</th>
	<td><input type="text" name="name" value="$name" size="30"></td>
</tr><tr>
	<th>E-mail</th>
	<td><input type="text" name="email" value="$eml" size="30"></td>
</tr><tr>
	<th>件名</th>
	<td><input type="text" name="sub" value="$sub" size="45"></td>
</tr><tr>
	<th>URL</th>
	<td><input type="text" name="url" value="$url" size="45"></td>
</tr><tr>
	<th>アイコン</th>
	<td><select name="icon">$op_icon</select></td>
</tr><tr>
	<th>コメント</th>
	<td><textarea name="comment" cols="50" rows="5">$com</textarea></td>
</tr><tr>
	<th>返信</th>
	<td><textarea name="reply" cols="50" rows="3">$res</textarea></td>
</tr><tr>
	<th></th>
	<td><input type="submit" value="返信する"></td>
</tr>
</table>
</form>
</div>
</body>
</html>
EOM
	exit;
}

#-----------------------------------------------------------
#  HTMLヘッダー
#-----------------------------------------------------------
sub header {
	my $ttl = shift;
	
	print <<EOM;
Content-type: text/html; charset=utf-8

<!DOCTYPE html>
<html lang="ja">
<head>
<meta charset="utf-8">
<link href="$cf{cmnurl}/admin.css" rel="stylesheet">
<title>$ttl</title>
</head>
<body>
<div id="head">
	<img src="$cf{cmnurl}/star.png" alt="star" class="icon">
	Fantasy Board 管理画面 ::
</div>
EOM
}

#-----------------------------------------------------------
#  エラー
#-----------------------------------------------------------
sub error {
	my $err = shift;
	
	header("ERROR!");
	print <<EOM;
<div id="body">
<div id="err">
<p><b>ERROR!</b></p>
<p class="err">$err</p>
<p><input type="button" value="前画面に戻る" onclick="history.back()"></p>
</div>
</div>
</body>
</html>
EOM
	exit;
}

#-----------------------------------------------------------
#  文字カット for UTF-8
#-----------------------------------------------------------
sub cut_str {
	my ($str,$all) = @_;
	$str =~ s|<br( /)?>||g;
	
	my $i = 0;
	my ($ret,$flg);
	while ($str =~ /([\x00-\x7f]|[\xC0-\xDF][\x80-\xBF]|[\xE0-\xEF][\x80-\xBF]{2}|[\xF0-\xF7][\x80-\xBF]{3})/gx) {
		$i++;
		$ret .= $1;
		if ($i >= $all) {
			$flg++;
			last;
		}
	}
	$ret .= '...' if ($flg);
	
	return $ret;
}

