#!/usr/local/bin/perl

#┌─────────────────────────────────
#│ FANTASY BOARD : fantasy.cgi - 2019/12/22
#│ copyright (c) kentweb, 1997-2019
#│ https://www.kent-web.com/
#└─────────────────────────────────

# モジュール宣言
use strict;
use CGI::Carp qw(fatalsToBrowser);

# 設定ファイル認識
require "./init.cgi";
my %cf = set_init();

# データ受理
my %in = parse_form();

# 処理分岐
if ($in{mode} eq 'post') { post_data(); }
if ($in{mode} eq 'dele') { dele_data(); }
if ($in{mode} eq 'form') { form_page(); }
if ($in{mode} eq 'note') { note_page(); }
if ($in{mode} eq 'icon') { icon_page(); }
bbs_list();

#-----------------------------------------------------------
#  掲示板リスト
#-----------------------------------------------------------
sub bbs_list {
	# 削除フォーム
	if ($in{del}) { dele_form(); }
	
	# UTF-8定義
	my $byte1 = '[\x00-\x7f]';
	my $byte2 = '[\xC0-\xDF][\x80-\xBF]';
	my $byte3 = '[\xE0-\xEF][\x80-\xBF]{2}';
	my $byte4 = '[\xF0-\xF7][\x80-\xBF]{3}';
	
	# キーワード配列化
	$in{q} =~ s/　/ /g;
	my @q = split(/\s+/,$in{q});
	
	# ページ数定義
	my $pg = $in{pg} || 0;
	
	my ($i,@log);
	open(IN,"$cf{datadir}/log.cgi") or error("open err: log.cgi");
	while (<IN>) {
		my ($no,$date,$name,$eml,$sub,$ico,$ico2,$com,$res,$url,$hos,$pw,$tim) = split(/<>/);
		
		# --- 検索
		if ($in{q} ne '') {
			my $flg;
			for my $q (@q) {
				if ("$name $sub $com" =~ /^(?:$byte1|$byte2|$byte3|$byte4)*?\Q$q\E/i) {
					$flg++;
				} else {
					$flg = 0;
					last;
				}
			}
			next if (!$flg);
		}
		
		$i++;
		next if ($i < $pg + 1);
		next if ($i > $pg + $cf{pg_max});
		
		push(@log,$_);
	}
	close(IN);
	
	# 繰越ボタン作成
	my $pager = make_pager($i,$pg);
	
	# 顔アイコン
	my @ico;
	for (@{$cf{icons}}) {
		my ($ico,undef) = split(/,/);
		push(@ico,$ico);
	}
	
	# テンプレート読込
	my %tmpl;
	for (qw(bbs com_r com_l)) {
		open(IN,"$cf{tmpldir}/$_.html") or error("open err: $_.html");
		$tmpl{$_} = join('',<IN>);
		close(IN);
	}
	
	# 文字置き換え
	$tmpl{bbs} =~ s/!([a-z]+_cgi)!/$cf{$1}/g;
	$tmpl{bbs} =~ s/!(homepage|cmnurl|bbs_title)!/$cf{$1}/g;
	$tmpl{bbs} =~ s/<!-- pager-->/$pager/g;
	$tmpl{bbs} =~ s/!q!/$in{q}/g;
	if ($in{q} eq '') {
		$tmpl{bbs} =~ s|<!-- find_result -->.+?<!-- /find_result -->||s;
	} else {
		$tmpl{bbs} =~ s/!result!/$i/g;
	}
	
	# 記事
	my $art;
	my $i = 0;
	for (@log) {
		$i++;
		my ($no,$date,$name,$eml,$sub,$ico,$ico2,$com,$res,$url,$hos,$pw,$tim) = split(/<>/);
		$name = qq|<a href="mailto:$eml">$name</a>| if ($eml);
		$com  = autolink($com) if ($cf{autolink});
		
		my $tmp = $i % 2 ? $tmpl{com_l} : $tmpl{com_r};
		$tmp =~ s/!num!/$no/g;
		$tmp =~ s/!comment!/$com/g;
		$tmp =~ s/!date!/$date/g;
		$tmp =~ s/!name!/$name/g;
		$tmp =~ s/!sub!/$sub/g;
		$tmp =~ s|!face!|<img src="$cf{cmnurl}/face/$ico[$ico]" alt="$ico[$ico]">|g;
		$tmp =~ s/!url!/$url/g;
		$tmp =~ s|<!-- res -->|<div class="res">$res</div>|g if ($res ne '');
		$tmp =~ s/!bbs_cgi!/$cf{bbs_cgi}/g;
		$tmp =~ s|!icon:(\w+\.\w+)!|<img src="$cf{cmnurl}/$1" alt="$1" class="icon">|g;
		
		if ($url) {
			$tmp =~ s|<!-- home -->|<a href="$url"><img src="$cf{cmnurl}/home.png" alt="home" class="icon"></a> &nbsp;|g;
		}
		
		$art .= $tmp;
	}
	$tmpl{bbs} =~ s/<!-- article -->/$art/;
	
	# 表示
	print "Content-type: text/html; charset=utf-8\n\n";
	footer($tmpl{bbs});
}

#-----------------------------------------------------------
#  投稿フォーム
#-----------------------------------------------------------
sub form_page {
	my %fm;
	($fm{name},$fm{email},$fm{url},$fm{icon}) = get_cookie();
	if ($fm{url} eq '') { $fm{url} = 'http://'; }
	
	open(IN,"$cf{tmpldir}/form.html") or error("open err: form.html");
	my $tmpl = join('',<IN>);
	close(IN);
	
	# 画像認証作成
	my ($str_plain,$str_crypt);
	if ($cf{use_captcha} > 0) {
		require $cf{captcha_pl};
		($str_plain,$str_crypt) = cap::make($cf{captcha_key},$cf{cap_len});
	} else {
		$tmpl =~ s|<!-- captcha -->.+?<!-- /captcha -->||s;
	}
	
	$tmpl =~ s/!(bbs_title|cmnurl|captcha_cgi|bbs_cgi)!/$cf{$1}/g;
	$tmpl =~ s/!str_crypt!/$str_crypt/g;
	$tmpl =~ s/!(name|email|sub|comment|url)!/$fm{$1}/g;
	$tmpl =~ s/<!-- icons -->/op_icons($fm{icon})/e;
	
	print "Content-type: text/html; charset=utf-8\n\n";
	print $tmpl;
	exit;
}

#-----------------------------------------------------------
#  記事書込
#-----------------------------------------------------------
sub post_data {
	# 投稿チェック
	check_post();
	
	# ホスト取得
	my ($host,$addr) = get_host();
	
	# 削除キー暗号化
	my $pwd = encrypt($in{pwd}) if ($in{pwd} ne "");
	
	# 時間取得
	my $time = time;
	my ($min,$hour,$mday,$mon,$year,$wday) = (localtime($time))[1..6];
	my @wk = ('Sun','Mon','Tue','Wed','Thu','Fri','Sat');
	my $date = sprintf("%04d/%02d/%02d(%s) %02d:%02d",
				$year+1900,$mon+1,$mday,$wk[$wday],$hour,$min);
	
	# 先頭記事読み取り
	open(DAT,"+< $cf{datadir}/log.cgi") or error("open err: log.cgi");
	eval "flock(DAT,2);";
	my $top = <DAT>;
	
	# 重複投稿チェック
	my ($no,$dat,$nam,$eml,$area,$ico,$ico2,$com,$res,$url,$hos,$pw,$tim) = split(/<>/,$top);
	if ($in{name} eq $nam && $in{comment} eq $com) {
		close(DAT);
		error("二重投稿は禁止です");
	}
	
	# 連続投稿チェック
	my $flg;
	if ($cf{regCtl} == 1) {
		if ($host eq $hos && $time - $tim < $cf{wait}) { $flg = 1; }
	} elsif ($cf{regCtl} == 2) {
		if ($time - $tim < $cf{wait}) { $flg = 1; }
	}
	if ($flg) {
		close(DAT);
		error("現在投稿制限中です。もうしばらくたってから投稿をお願いします");
	}
	
	# 記事No採番
	$no++;
	
	# 記事数調整
	my @data = ($top);
	my $i = 0;
	while (<DAT>) {
		$i++;
		push(@data,$_);
		last if ($i >= $cf{maxlog}-1);
	}
	
	# 更新
	seek(DAT,0,0);
	print DAT "$no<>$date<>$in{name}<>$in{email}<>$in{sub}<>$in{icon}<><>$in{comment}<><>$in{url}<>$host<>$pwd<>$time<>\n";
	print DAT @data;
	truncate(DAT,tell(DAT));
	close(DAT);
	
	# メール通知
	mail_to($date,$host) if ($cf{mailing});
	
	# クッキー格納
	set_cookie($in{name},$in{email},$in{url},$in{icon}) if ($in{cookie});
	
	# 完了画面
	message("ありがとうございます。記事を受理しました。");
}

#-----------------------------------------------------------
#  ユーザ記事削除
#-----------------------------------------------------------
sub dele_data {
	# 投稿チェック
	if ($cf{postonly} && $ENV{REQUEST_METHOD} ne 'POST') {
		error("不正なリクエストです");
	}
	
	# 入力チェック
	$in{del} =~ s/\D//g;
	if ($in{del} eq '' or $in{pwd} eq '') {
		error("不正な処理です");
	}
	
	my ($flg,$crypt,@log);
	open(DAT,"+< $cf{datadir}/log.cgi") or error("open err: log.cgi");
	eval "flock(DAT,2);";
	while (<DAT>) {
		my ($no,$date,$name,$eml,$sub,$ico,$ico2,$com,$res,$url,$hos,$pw,$tim) = split(/<>/);
		
		if ($in{del} == $no) {
			$flg++;
			$crypt = $pw;
			next;
		}
		push(@log,$_);
	}
	
	if (!$flg || $crypt eq '') {
		close(DAT);
		error("削除キーが設定されていないか又は記事が見当たりません");
	}
	
	# 削除キーを照合
	if (decrypt($in{pwd},$crypt) != 1) {
		close(DAT);
		error("認証できません");
	}
	
	# ログ更新
	seek(DAT,0,0);
	print DAT @log;
	truncate(DAT,tell(DAT));
	close(DAT);
	
	# 完了メッセージ
	message("記事を削除しました");
}

#-----------------------------------------------------------
#  削除フォーム
#-----------------------------------------------------------
sub dele_form {
	$in{del} =~ s/\D//g;
	
	my $log;
	open(DAT,"$cf{datadir}/log.cgi") or error("open err: log.cgi");
	while (<DAT>) {
		my ($no,$date,$name,$eml,$sub,$ico,$ico2,$com,$res,$url,$hos,$pw,$tim) = split(/<>/);
		
		if ($in{del} == $no) {
			$log = $_;
			last;
		}
	}
	close(DAT);
	
	my ($no,$date,$name,$eml,$sub,$ico,$ico2,$com,$res,$url,$hos,$pw,$tim) = split(/<>/,$log);
	if ($pw eq '') { error("この記事は削除キーが設定されていません"); }
	
	open(IN,"$cf{tmpldir}/dele.html") or error("open err: dele.html");
	my $tmpl = join('',<IN>);
	close(IN);
	
	$tmpl =~ s/!(bbs_title|cmnurl|bbs_cgi)!/$cf{$1}/g;
	$tmpl =~ s/!del!/$in{del}/g;
	$tmpl =~ s/!sub!/$sub/g;
	$tmpl =~ s/!name!/$name/g;
	$tmpl =~ s/!date!/$date/g;
	
	print "Content-type: text/html; charset=utf-8\n\n";
	print $tmpl;
	exit;
}

#-----------------------------------------------------------
#  留意事項表示
#-----------------------------------------------------------
sub note_page {
	open(IN,"$cf{tmpldir}/note.html") or error("open err: note.html");
	my $tmpl = join('',<IN>);
	close(IN);
	
	$tmpl =~ s/!(bbs_title|cmnurl)!/$cf{$1}/g;
	
	print "Content-type: text/html; charset=utf-8\n\n";
	print $tmpl;
	exit;
}

#-----------------------------------------------------------
#  アイコン一覧
#-----------------------------------------------------------
sub icon_page {
	# テンプレート認識
	open(IN,"$cf{tmpldir}/icon.html") or error("open err: icon.html");
	my $tmpl = join('',<IN>);
	close(IN);
	
	$tmpl =~ s/!([a-z]+_cgi)!/$cf{$1}/g;
	$tmpl =~ s/!(bbs_title|cmnurl)!/$cf{$1}/g;
	
	# テンプレート分割
	my ($head,$loop,$foot) = $tmpl =~ m|(.+)<!-- loop -->(.+?)<!-- /loop -->(.+)|s
			? ($1,$2,$3)
			: error("テンプレート不正");
	
	# 画面展開
	print "Content-type: text/html; charset=utf-8\n\n";
	print $head;
	
	for (0 .. $#{$cf{icons}}) {
		my ($ico,$cap) = split(/,/,$cf{icons}[$_]);
		
		my $tmp = $loop;
		$tmp =~ s|!image!|<img src="$cf{cmnurl}/face/$ico" alt="$cap">|g;
		$tmp =~ s/!caption!/$cap/g;
		print $tmp;
	}
	
	# フッタ
	print $foot;
	exit;
}

#-----------------------------------------------------------
#  メール送信
#-----------------------------------------------------------
sub mail_to {
	my ($date,$host) = @_;
	
	# 件名をMIMEエンコード
	require './lib/jacode.pl';
	my $msub = mime_unstructured_header("BBS : $in{sub}");
	
	# コメント内の改行復元
	my $com = tag_chg($in{comment});
	$com =~ s|<br>|\n|g;
	$com =~ s/{ico:\d+}//g;
	
	# メール本文を定義
	my $body = <<EOM;
掲示板に投稿がありました。

投稿日：$date
ホスト：$host
件　名：$in{sub}
お名前：$in{name}

$com
EOM

	# JISコード変換
	my $mbody;
	for my $tmp ( split(/\n/,$body) ) {
		jcode::convert(\$tmp,'jis','utf8');
		$mbody .= "$tmp\n";
	}
	
	# sendmailコマンド
	my $scmd = "$cf{sendmail} -t -i";
	if ($cf{sendm_f}) { $scmd .= " -f $cf{mailto}";	}
	
	$in{email} ||= $cf{mailto};
	
	# 送信
	open(MAIL,"| $scmd") or error("送信失敗");
	print MAIL "To: $cf{mailto}\n";
	print MAIL "From: $cf{mailto}\n";
	print MAIL "Subject: $msub\n";
	print MAIL "MIME-Version: 1.0\n";
	print MAIL "Content-type: text/plain; charset=ISO-2022-JP\n";
	print MAIL "Content-Transfer-Encoding: 7bit\n";
	print MAIL "X-Mailer: $cf{version}\n\n";
	print MAIL "$mbody\n";
	close(MAIL);
}

#-----------------------------------------------------------
#  完了メッセージ
#-----------------------------------------------------------
sub message {
	my ($msg) = @_;
	
	open(IN,"$cf{tmpldir}/mesg.html") or error("open err: mesg.html");
	my $tmpl = join('',<IN>);
	close(IN);
	
	$tmpl =~ s/!(bbs_title|cmnurl|bbs_cgi)!/$cf{$1}/g;
	$tmpl =~ s/!message!/$msg/g;
	
	print "Content-type: text/html; charset=utf-8\n\n";
	print $tmpl;
	exit;
}

#-----------------------------------------------------------
#  フッター
#-----------------------------------------------------------
sub footer {
	my $foot = shift;
	
	# 著作権表記（削除・改変禁止）
	my $copy = <<EOM;
<p style="margin:2.5em;text-align:center;font-family:Verdana,Helvetica,Arial;font-size:10px;">
	- <a href="https://www.kent-web.com/" target="_top">Fantasy Board</a> -
</p>
EOM

	if ($foot =~ /(.+)(<\/body[^>]*>.*)/si) {
		print "$1$copy$2\n";
	} else {
		print "$foot$copy\n";
		print "</body></html>\n";
	}
	exit;
}

#-----------------------------------------------------------
#  エラー画面
#-----------------------------------------------------------
sub error {
	my $err = shift;
	
	open(IN,"$cf{tmpldir}/error.html") or die;
	my $tmpl = join('',<IN>);
	close(IN);
	
	$tmpl =~ s/!error!/$err/g;
	$tmpl =~ s/!(bbs_title|cmnurl)!/$cf{$1}/g;
	
	print "Content-type: text/html; charset=utf-8\n\n";
	print $tmpl;
	exit;
}

#-----------------------------------------------------------
#  ページ送り作成
#-----------------------------------------------------------
sub make_pager {
	my ($i,$pg) = @_;
	
	# 引数
	my $param;
	if ($in{q} ne '') {
		my $q = $in{q};
		$q =~ s/(\W)/'%'.unpack("H2",$1)/ego;
		$q =~ s/ /+/g;
		
		$param = "&amp;q=$q";
	}
	
	# ページ繰越数定義
	$cf{pg_max} ||= 10;
	my $next = $pg + $cf{pg_max};
	my $back = $pg - $cf{pg_max};
	
	# ページ繰越ボタン作成
	my @pg;
	if ($back >= 0 || $next < $i) {
		my $flg;
		my ($w,$x,$y,$z) = (0,1,0,$i);
		while ($z > 0) {
			if ($pg == $y) {
				$flg++;
				push(@pg,qq!<span class="page active">$x</span>\n!);
			} else {
				push(@pg,qq!<a href="$cf{bbs_cgi}?pg=$y$param" class="page gradient">$x</a>\n!);
			}
			$x++;
			$y += $cf{pg_max};
			$z -= $cf{pg_max};
			
			if ($flg) { $w++; }
			last if ($w >= 5 && @pg >= 10);
		}
	}
	while( @pg >= 11 ) { shift(@pg); }
	my $ret = join('', @pg);
	if ($back >= 0) {
		$ret = qq!<a href="$cf{bbs_cgi}?pg=$back$param" class="page gradient">&laquo;</a>\n! . $ret;
	}
	if ($next < $i) {
		$ret .= qq!<a href="$cf{bbs_cgi}?pg=$next$param" class="page gradient">&raquo;</a>\n!;
	}
	
	# 結果を返す
	return $ret ? qq|<div class="pagination">\n$ret</div>| : '';
}

#-----------------------------------------------------------
#  自動リンク
#-----------------------------------------------------------
sub autolink {
	my $text = shift;
	
	$text =~ s/(s?https?:\/\/([\w-.!~*'();\/?:\@=+\$,%#]|&amp;)+)/<a href="$1" target="_blank">$1<\/a>/g;
	return $text;
}

#-----------------------------------------------------------
#  アクセス制限
#-----------------------------------------------------------
sub get_host {
	# IP&ホスト取得
	my $host = $ENV{REMOTE_HOST};
	my $addr = $ENV{REMOTE_ADDR};
	
	if ($cf{gethostbyaddr} && ($host eq "" || $host eq $addr)) {
		$host = gethostbyaddr(pack("C4", split(/\./, $addr)), 2);
	}
	
	# IPチェック
	my $flg;
	foreach ( split(/\s+/, $cf{deny_addr}) ) {
		s/\./\\\./g;
		s/\*/\.\*/g;
		
		if ($addr =~ /^$_/i) { $flg = 1; last; }
	}
	if ($flg) {
		error("アクセスを許可されていません");
	
	# ホストチェック
	} elsif ($host) {
		
		foreach ( split(/\s+/, $cf{deny_host}) ) {
			s/\./\\\./g;
			s/\*/\.\*/g;
			
			if ($host =~ /$_$/i) { $flg = 1; last; }
		}
		if ($flg) {
			error("アクセスを許可されていません");
		}
	}
	if ($host eq "") { $host = $addr; }
	return ($host,$addr);
}

#-----------------------------------------------------------
#  crypt暗号
#-----------------------------------------------------------
sub encrypt {
	my $in = shift;
	
	my @wd = ('a' .. 'z', 'A' .. 'Z', 0 .. 9, '.', '/');
	srand;
	my $salt = $wd[int(rand(@wd))] . $wd[int(rand(@wd))];
	crypt($in, $salt) || crypt ($in, '$1$' . $salt);
}

#-----------------------------------------------------------
#  crypt照合
#-----------------------------------------------------------
sub decrypt {
	my ($in,$dec) = @_;
	
	my $salt = $dec =~ /^\$1\$(.*)\$/ ? $1 : substr($dec, 0, 2);
	if (crypt($in, $salt) eq $dec || crypt($in, '$1$' . $salt) eq $dec) {
		return 1;
	} else {
		return 0;
	}
}

#-----------------------------------------------------------
#  タグ復元
#-----------------------------------------------------------
sub tag_chg {
	local($_) = @_;
	
	s/&lt;/</g;
	s/&gt;/>/g;
	s/&quot;/"/g;
	s/&amp;/&/g;
	s/&#39;/'/g;
	$_;
}

#-----------------------------------------------------------
#  クッキー発行
#-----------------------------------------------------------
sub set_cookie {
	my @data = @_;
	
	my ($sec,$min,$hour,$mday,$mon,$year,$wday,undef,undef) = gmtime(time + 60*24*60*60);
	my @mon  = qw|Jan Feb Mar Apr May Jun Jul Aug Sep Oct Nov Dec|;
	my @week = qw|Sun Mon Tue Wed Thu Fri Sat|;
	
	# 時刻フォーマット
	my $gmt = sprintf("%s, %02d-%s-%04d %02d:%02d:%02d GMT",
				$week[$wday],$mday,$mon[$mon],$year+1900,$hour,$min,$sec);
	
	# URLエンコード
	my $cook;
	foreach (@data) {
		s/(\W)/sprintf("%%%02X", unpack("C", $1))/eg;
		$cook .= "$_<>";
	}
	
	print "Set-Cookie: $cf{cookie_id}=$cook; expires=$gmt\n";
}

#-----------------------------------------------------------
#  クッキー取得
#-----------------------------------------------------------
sub get_cookie {
	# クッキー取得
	my $cook = $ENV{HTTP_COOKIE};
	
	# 該当IDを取り出す
	my %cook;
	foreach ( split(/;/,$cook) ) {
		my ($key,$val) = split(/=/);
		$key =~ s/\s//g;
		$cook{$key} = $val;
	}
	
	# URLデコード
	my @cook;
	foreach ( split(/<>/,$cook{$cf{cookie_id}}) ) {
		s/%([0-9A-Fa-f][0-9A-Fa-f])/pack("H2", $1)/eg;
		s/[&"'<>]//g;
		
		push(@cook,$_);
	}
	return @cook;
}

#-----------------------------------------------------------
#  アイコンプルダウン
#-----------------------------------------------------------
sub op_icons {
	my $icon = shift;
	
	my $ret;
	for (0 .. $#{$cf{icons}}) {
		my (undef,$nam) = split(/,/,$cf{icons}[$_]);
		
		if ($icon == $_) {
			$ret .= qq|<option value="$_" selected>$nam</option>\n|;
		} else {
			$ret .= qq|<option value="$_">$nam</option>\n|;
		}
	}
	return $ret;
}

#-----------------------------------------------------------
#  投稿チェック
#-----------------------------------------------------------
sub check_post {
	# 投稿チェック
	if ($cf{postonly} && $ENV{REQUEST_METHOD} ne 'POST') {
		error("不正なリクエストです");
	}
	
	# 不要文字カット
	$in{sub}  =~ s|<br>||g;
	$in{name} =~ s|<br>||g;
	$in{pwd}  =~ s|<br>||g;
	$in{captcha} =~ s|<br>||g;
	$in{sub} =~ s|<br>||g;
	$in{icon} =~ s|\D||g;
	$in{comment} =~ s|(<br>)+$||g;
	
	# チェック
	if ($cf{no_wd}) { no_wd(); }
	if ($cf{jp_wd}) { jp_wd(); }
	if ($cf{urlnum} > 0) { urlnum(); }
	
	# 画像認証チェック
	if ($cf{use_captcha} > 0) {
		require $cf{captcha_pl};
		if ($in{captcha} !~ /^\d{$cf{cap_len}}$/) {
			error("画像認証が入力不備です。<br>投稿フォームに戻って再読込み後、再入力してください");
		}
		
		# 投稿キーチェック
		# -1 : キー不一致
		#  0 : 制限時間オーバー
		#  1 : キー一致
		my $chk = cap::check($in{captcha},$in{str_crypt},$cf{captcha_key},$cf{cap_time},$cf{cap_len});
		if ($chk == 0) {
			error("画像認証が制限時間を超過しました。<br>投稿フォームに戻って再読込み後、指定の数字を再入力してください");
		} elsif ($chk == -1) {
			error("画像認証が不正です。<br>投稿フォームに戻って再読込み後、再入力してください");
		}
	}
	
	# 未入力の場合
	if ($in{url} eq "http://") { $in{url} = ""; }
	if ($in{sub} eq "") { $in{sub} = '無題'; }
	
	# フォーム内容をチェック
	my $err;
	if ($in{name} eq "") { $err .= "名前が入力されていません<br>"; }
	if ($in{email} ne '' && $in{email} !~ /^[\w\.\-]+\@[\w\.\-]+\.[a-zA-Z]{2,6}$/) {
		$err .= "Ｅメールの入力内容が不正です<br>";
	}
	if ($in{comment} eq "") { $err .= "コメントが入力されていません<br>"; }
	if ($in{url} ne '' && $in{url} !~ /^https?:\/\/[\w-.!~*'();\/?:\@&=+\$,%#]+$/) {
		$err .= "URLの入力内容が不正です<br>";
	}
	error($err) if ($err);
}

#-----------------------------------------------------------
#  禁止ワードチェック
#-----------------------------------------------------------
sub no_wd {
	my $flg;
	foreach ( split(/,/,$cf{no_wd}) ) {
		if (index("$in{name} $in{comment}",$_) >= 0) {
			$flg = 1;
			last;
		}
	}
	if ($flg) { error("禁止ワードが含まれています"); }
}

#-----------------------------------------------------------
#  日本語チェック
#-----------------------------------------------------------
sub jp_wd {
	if ($in{comment} !~ /(?:[\xC0-\xDF][\x80-\xBF]|[\xE0-\xEF][\x80-\xBF]{2}|[\xF0-\xF7][\x80-\xBF]{3})/x) {
		error("メッセージに日本語が含まれていません");
	}
}

#-----------------------------------------------------------
#  URL個数チェック
#-----------------------------------------------------------
sub urlnum {
	my $com = $in{comment};
	my ($num) = ($com =~ s|(https?://)|$1|ig);
	if ($num > $cf{urlnum}) {
		error("コメント中のURLアドレスは最大$cf{urlnum}個までです");
	}
}

#-----------------------------------------------------------
#  mimeエンコード
#  [quote] http://www.din.or.jp/~ohzaki/perl.htm#JP_Base64
#-----------------------------------------------------------
sub mime_unstructured_header {
  my $oldheader = shift;
  jcode::convert(\$oldheader,'euc','utf8');
  my ($header,@words,@wordstmp,$i);
  my $crlf = $oldheader =~ /\n$/;
  $oldheader =~ s/\s+$//;
  @wordstmp = split /\s+/, $oldheader;
  for ($i = 0; $i < $#wordstmp; $i++) {
    if ($wordstmp[$i] !~ /^[\x21-\x7E]+$/ and
	$wordstmp[$i + 1] !~ /^[\x21-\x7E]+$/) {
      $wordstmp[$i + 1] = "$wordstmp[$i] $wordstmp[$i + 1]";
    } else {
      push(@words, $wordstmp[$i]);
    }
  }
  push(@words, $wordstmp[-1]);
  foreach my $word (@words) {
    if ($word =~ /^[\x21-\x7E]+$/) {
      $header =~ /(?:.*\n)*(.*)/;
      if (length($1) + length($word) > 76) {
	$header .= "\n $word";
      } else {
	$header .= $word;
      }
    } else {
      $header = add_encoded_word($word, $header);
    }
    $header =~ /(?:.*\n)*(.*)/;
    if (length($1) == 76) {
      $header .= "\n ";
    } else {
      $header .= ' ';
    }
  }
  $header =~ s/\n? $//mg;
  $crlf ? "$header\n" : $header;
}
sub add_encoded_word {
  my ($str, $line) = @_;
  my $result;
  my $ascii = '[\x00-\x7F]';
  my $twoBytes = '[\x8E\xA1-\xFE][\xA1-\xFE]';
  my $threeBytes = '\x8F[\xA1-\xFE][\xA1-\xFE]';
  while (length($str)) {
    my $target = $str;
    $str = '';
    if (length($line) + 22 +
	($target =~ /^(?:$twoBytes|$threeBytes)/o) * 8 > 76) {
      $line =~ s/[ \t\n\r]*$/\n/;
      $result .= $line;
      $line = ' ';
    }
    while (1) {
      my $encoded = '=?ISO-2022-JP?B?' .
      b64encode(jcode::jis($target,'euc','z')) . '?=';
      if (length($encoded) + length($line) > 76) {
	$target =~ s/($threeBytes|$twoBytes|$ascii)$//o;
	$str = $1 . $str;
      } else {
	$line .= $encoded;
	last;
      }
    }
  }
  $result . $line;
}
# [quote] http://www.tohoho-web.com/perl/encode.htm
sub b64encode {
    my $buf = shift;
    my ($mode,$tmp,$ret);
    my $b64 = "ABCDEFGHIJKLMNOPQRSTUVWXYZ"
                . "abcdefghijklmnopqrstuvwxyz"
                . "0123456789+/";
	
    $mode = length($buf) % 3;
    if ($mode == 1) { $buf .= "\0\0"; }
    if ($mode == 2) { $buf .= "\0"; }
    $buf =~ s/(...)/{
        $tmp = unpack("B*", $1);
        $tmp =~ s|(......)|substr($b64, ord(pack("B*", "00$1")), 1)|eg;
        $ret .= $tmp;
    }/eg;
    if ($mode == 1) { $ret =~ s/..$/==/; }
    if ($mode == 2) { $ret =~ s/.$/=/; }
    
    return $ret;
}

