#┌──────────────────────────────
#│ HAPPY CART : resize.pl - 2022/04/07
#│ copyright (c) kentweb, 1997-2022
#│ https://www.kent-web.com/
#└──────────────────────────────

# モジュール
use strict;
use ImgResize;

#-----------------------------------------------------------
#  画像リサイズ
#-----------------------------------------------------------
sub img_resize {
	my ($in,$out,$w,$h) = @_;
	
	# サムネイル（引数 -1 は画像モジュール自動認識）
	my $image = new ImgResize( -1 );
	$image->{width}    = $w;
	$image->{height}   = $h;
	$image->{quality}  =  75;
	$image->{ext}      = '.jpg';
	$image->{in}       = $in;
	$image->{out}      = $out;
	$image->{exif_cut} =   1;
	
	# リサイズ
	$image->resize;
}


1;
