#!/usr/local/bin/perl

#
# COSMO GATE : gate.cgi - 2014/02/09
# copyright (c) KentWeb
# http://www.kent-web.com/
#

# W[錾
use strict;
use CGI::Carp qw(fatalsToBrowser);
use lib "./lib";
use Crypt::RC4;

# ݒt@C
require './init.cgi';
my %cf = init();

# f[^󂯎
my %in = parse_form();

# 
if ($in{login}) { login(); }
enter_form();

#-----------------------------------------------------------
#  OCF
#-----------------------------------------------------------
sub login {
	# F
	check_passwd();

	# NbL[L
	if ($in{cook} == 1) {
		set_cookie();
		
	# NbL[폜
	} else {
		print "Set-Cookie: GateID=; expires=Thu, 1-Jan-1970 00:00:00 GMT;\n";
	}

	# HTML
	if ($cf{secet_type} == 0) {
		open(IN,"$cf{secfile}") or error("open err: secret_file");
		print "Content-type: text/html\n\n";
		print <IN>;
		close(IN);

	# CGI
	} elsif ($cf{secet_type} == 1) {
		print qq|Content-type: text/html\n\n|;
		print qq|<html><head><title>secret_file</title></head>\n|;
		print qq|<frameset frameborder="no" border="0" cols="100%,*">\n|;
		print qq|<frame src="$cf{secfile}"></frameset></html>\n|;

	# Location
	} else {
		if ($ENV{PERLXS} eq "PerlIS") {
			print "HTTP/1.0 302 Temporary Redirection\r\n";
			print "Content-type: text/html\n";
		}
		print "Location: $cf{secfile}\n\n";
	}
	exit;
}

#-----------------------------------------------------------
#  F
#-----------------------------------------------------------
sub check_passwd {
	$in{id} =~ s/\W//g;
	$in{pw} =~ s/\W//g;

	# ̓`FbN
	if ($in{id} eq "" || $in{pw} eq "") { error("F؂ł܂"); }

	# t@CI[v
	my $crypt;
	open(IN,"$cf{pwdfile}") or error("open err: $cf{pwdfile}");
	while(<IN>) {
		my ($id,$pw) = split(/:/);

		# IDv
		if ($in{id} eq $id) {
			chomp($pw);
			$crypt = $pw;
			last;
		}
	}
	close(IN);

	# IDYȂ܂͕sƍ̓G[
	if ($crypt eq "" || decrypt($in{pw},$crypt) != 1) {
		error("F؂ł܂");
	}

	# Oۑ
	save_log($in{id});
}

#-----------------------------------------------------------
#  F؉
#-----------------------------------------------------------
sub enter_form {
	# NbL[擾
	my ($id,$pw) = get_cookie();

	# ev[gǂݍ
	open(IN,"$cf{tmpldir}/enter.html") or error("open err: enter.html");
	my $tmpl = join('', <IN>);
	close(IN);

	# u
	$tmpl =~ s/!gate_cgi!/$cf{gate_cgi}/;
	$tmpl =~ s/!id!/$id/;
	$tmpl =~ s/!pw!/$pw/;
	if ($id ne '' && $pw ne '') {
		$tmpl =~ s|<input type="checkbox" name="cook"([^<>]+)>|<input type="checkbox" name="cook" checked="checked" $1>|;
	}
	
	# \
	print "Content-type: text/html; charset=shift_jis\n\n";
	footer($tmpl);
}

#-----------------------------------------------------------
#  ANZXO
#-----------------------------------------------------------
sub save_log {
	my $id = shift;

	# Ԏ擾
	my $date = get_time();

	# zXg擾
	my $host = get_host();

	# uEU
	my $agent = $ENV{HTTP_USER_AGENT};
	$agent =~ s/[<>&"']//g;

	# Ot@C̓ǂݍ
	my ($i,@data);
	open(DAT,"+< $cf{logfile}") or error("open err: $cf{logfile}");
	eval "flock(DAT, 2);";
	while(<DAT>) {
		$i++;
		push(@data,$_);

		last if ($i >= $cf{maxlog} - 1);
	}
	unshift(@data,"$id<>$date<>$host<>$agent<>\n");
	seek(DAT, 0, 0);
	print DAT @data;
	truncate(DAT, tell(DAT));
	close(DAT);
}

#-----------------------------------------------------------
#  cryptƍ
#-----------------------------------------------------------
sub decrypt {
	my ($in,$dec) = @_;

	my $salt = $dec =~ /^\$1\$(.*)\$/ ? $1 : substr($dec, 0, 2);

	if (crypt($in, $salt) eq $dec || crypt($in, '$1$' . $salt) eq $dec) {
		return 1;
	} else {
		return 0;
	}
}

#-----------------------------------------------------------
#  G[
#-----------------------------------------------------------
sub error {
	my $msg = shift;

	open(IN,"$cf{tmpldir}/error.html") or die;
	my $tmpl = join('', <IN>);
	close(IN);

	$tmpl =~ s/!error!/$msg/g;

	print "Content-type: text/html; charset=shift_jis\n\n";
	print $tmpl;
	exit;
}

#-----------------------------------------------------------
#  tb^[
#-----------------------------------------------------------
sub footer {
	my $foot = shift;

	# 쌠\Li폜ցj
	my $copy = <<EOM;
<p align="center" style="margin-top:3em;font-size:10px;font-family:verdana,helvetica,arial,osaka;">
- <a href="http://www.kent-web.com/" target="_top">CosmoGate</a> -
</p>
EOM

	if ($foot =~ /(.+)(<\/body[^>]*>.*)/si) {
		print "$1$copy$2\n";
	} else {
		print "$foot$copy\n";
		print "</body></html>\n";
	}
	exit;
}

#-----------------------------------------------------------
#  zXg擾
#-----------------------------------------------------------
sub get_host {
	my $host = $ENV{REMOTE_HOST};
	my $addr = $ENV{REMOTE_ADDR};

	if ($cf{gethostbyaddr} && ($host eq "" || $host eq $addr)) {
		$host = gethostbyaddr(pack("C4", split(/\./, $addr)), 2);
	}
	if ($host eq "") { $host = $addr; }

	return $host;
}

#-----------------------------------------------------------
#  Ԏ擾
#-----------------------------------------------------------
sub get_time {
	$ENV{TZ} = "JST-9";
	my ($sec,$min,$hour,$mday,$mon,$year) = (localtime(time))[0..5];

	# ̃tH[}bg
	sprintf("%04d/%02d/%02d-%02d:%02d:%02d",
			$year+1900,$mon+1,$mday,$hour,$min,$sec);
}

#-----------------------------------------------------------
#  pX[hL
#-----------------------------------------------------------
sub set_cookie {
	# RC4Íϊ
	my $crypt = RC4($cf{crypt_key},"$in{id}:$in{pw}");

	# oCi16i
	$crypt =~ s/(.)/unpack('H2',$1)/eg;
	$crypt =~ s/\n/n/g;

	# 60ԗL
	my ($sec,$min,$hour,$mday,$mon,$year,$wday,undef,undef) = gmtime(time + 60*24*60*60);
	my @mon  = qw|Jan Feb Mar Apr May Jun Jul Aug Sep Oct Nov Dec|;
	my @week = qw|Sun Mon Tue Wed Thu Fri Sat|;

	# tH[}bg
	my $gmt = sprintf("%s, %02d-%s-%04d %02d:%02d:%02d GMT",
				$week[$wday],$mday,$mon[$mon],$year+1900,$hour,$min,$sec);

	print "Set-Cookie: GateID=$crypt; expires=$gmt\n";
}

#-----------------------------------------------------------
#  pX[h擾
#-----------------------------------------------------------
sub get_cookie {
	# NbL[擾
	my $cook = $ENV{HTTP_COOKIE};

	# YIDo
	my %cook;
	foreach ( split(/;/, $cook) ) {
		my ($key,$val) = split(/=/);
		$key =~ s/\s//g;
		$cook{$key} = $val;
	}
	$cook{GateID} =~ s/\W//g;
	
	# oCi֖߂
	$cook{GateID} =~ s/n/\n/g;
	$cook{GateID} =~ s/([0-9A-Fa-f]{2})/pack('H2',$1)/eg;
	
	# RC4
	my $plain = RC4($cf{crypt_key},$cook{GateID});
	
	return split(/:/,$plain);
}
