#!/usr/local/bin/perl

#┌─────────────────────────────────
#│ HONEY BOARD : honey.cgi - 2019/12/22
#│ copyright (c) kentweb, 1997-2019
#│ http://www.kent-web.com/
#└─────────────────────────────────

# モジュール宣言
use strict;
use CGI::Carp qw(fatalsToBrowser);

# 設定ファイル認識
require "./init.cgi";
my %cf = set_init();

# データ受理
my %in = parse_form();

# 処理分岐
if ($in{del}) { dele_form(); }
if ($in{mode} eq 'form') { form_page(); }
if ($in{mode} eq 'note') { note_page(); }
if ($in{mode} eq 'icon') { icon_page(); }
bbs_list();

#-----------------------------------------------------------
#  記事表示
#-----------------------------------------------------------
sub bbs_list {
	# 検索
	if ($in{q} ne '') { find_page(); }
	
	# トピック表示
	if ($in{bbs} == 1) {
		bbs_topic();
	} else {
		$in{bbs} = 0;
	}
	
	# ページ数定義
	my $pg = $in{pg} || 0;
	
	# データ読み込み
	my ($i,@log,%res);
	open(IN,"$cf{logfile}") or error("open err: $cf{logfile}");
	while (<IN>) {
		my ($no,$reno,$date,$name,$eml,$sub,$ico,$ico2,$com,$col,$url,$host,$pw) = split(/<>/);
		
		++$i if (!$reno);
		next if ($i < $pg + 1);
		next if ($i > $pg + $cf{max_thrd});
		
		if ($reno) {
			$res{$reno} .= "$no<>$date<>$name<>$eml<>$sub<>$ico<>$com<>$col<>$url\0";
			next;
		}
		push(@log,$_);
	}
	close(IN);
	
	# ペイジャー作成
	my $pager = make_pager($i,$pg,$cf{max_thrd});
	
	# 顔アイコン
	my @ico;
	for (@{$cf{icons}}) {
		my ($ico,undef) = split(/,/);
		push(@ico,$ico);
	}
	
	# テンプレート読込
	my %tmpl;
	for (qw(bbs bbs_r bbs_l)) {
		open(IN,"$cf{tmpldir}/$_.html") or error("open err: $_.html");
		$tmpl{$_} = join('',<IN>);
		close(IN);
	}
	
	# 文字置き換え
	$tmpl{bbs} =~ s/!([a-z]+_cgi)!/$cf{$1}/g;
	$tmpl{bbs} =~ s/!(homepage|cmnurl|bbs_title)!/$cf{$1}/g;
	$tmpl{bbs} =~ s/<!-- pager -->/$pager/g;
	$tmpl{bbs} =~ s/!bbs!/$in{bbs}/g;
	
	# 記事展開
	my $art;
	my $i;
	for (@log) {
		my ($no,$reno,$date,$name,$eml,$sub,$ico,$ico2,$com,$col,$url,$host,$pw) = split(/<>/);
		$name = qq|<a href="mailto:$eml">$name</a>| if ($eml);
		$com  = autolink($com) if ($cf{autolink});
		$url &&= qq|<a href="$url" target="_blank"><img src="$cf{cmnurl}/home.png" class="icon" alt=""></a>|;
		
		$i++;
		my $tmp = $i % 2 ? $tmpl{bbs_l} : $tmpl{bbs_r};
		
		$tmp =~ s/class="com"/class="com w-p"/g;
		$tmp =~ s/!num!/$no/g;
		$tmp =~ s/!sub!/$sub/g;
		$tmp =~ s/!comment!/<span style="color:$col">$com<\/span>/g;
		$tmp =~ s/!date!/$date/g;
		$tmp =~ s/!name!/$name/g;
		$tmp =~ s|!icon:(\w+\.\w+)!|<img src="$cf{cmnurl}/$1" alt="$1" class="icon ">|g;
		$tmp =~ s|!face!|<img src="$cf{cmnurl}/face/$ico[$ico]" alt="$ico[$ico]">|g;
		$tmp =~ s/<!-- home -->/$url/g;
		$tmp =~ s|<!-- reply -->|<a href="$cf{bbs_cgi}?mode=form&amp;res=$no"><img src="$cf{cmnurl}/reply.png" alt="返信" class="icon"></a>|g;
		$tmp =~ s|<!-- dele -->|<a href="$cf{bbs_cgi}?del=$no"><img src="$cf{cmnurl}/dele.png" alt="削除" class="icon"></a>|g;
		$tmp =~ s/!bbs_cgi!/$cf{bbs_cgi}/g;
		
		$art .= $tmp;
		
		# レス
		for my $res ( split(/\0/,$res{$no}) ) {
			my ($num,$date,$name,$eml,$sub,$ico,$com,$col,$url) = split(/<>/,$res);
			$name = qq|<a href="mailto:$eml">$name</a>| if ($eml);
			$com  = autolink($com) if ($cf{autolink});
			$url &&= qq|<a href="$url" target="_blank"><img src="$cf{cmnurl}/home.png" class="icon" alt=""></a>|;
			
			my $tmp = $i % 2 ? $tmpl{bbs_r} : $tmpl{bbs_l};
			
			$tmp =~ s/class="com"/class="com w-c"/g;
			$tmp =~ s|!icon:(\w+\.\w+)!|<img src="$cf{cmnurl}/$1" alt="$1" class="icon">|g;
			$tmp =~ s|!face!|<img src="$cf{cmnurl}/face/$ico[$ico]" alt="$ico[$ico]">|g;
			$tmp =~ s/!num!/$num/g;
			$tmp =~ s/!sub!/$sub/g;
			$tmp =~ s/!comment!/<span style="color:$col">$com<\/span>/g;
			$tmp =~ s/!date!/$date/g;
			$tmp =~ s/!name!/$name/g;
			$tmp =~ s/!url!/$url/g;
			$tmp =~ s/!bbs_cgi!/$cf{bbs_cgi}/g;
			$tmp =~ s/<!-- home -->/$url/g;
			$tmp =~ s|<!-- dele -->|<a href="$cf{bbs_cgi}?del=$num"><img src="$cf{cmnurl}/dele.png" alt="削除" class="icon"></a>|g;
			
			$art .= $tmp;
		}
	}
	$tmpl{bbs} =~ s/<!-- article -->/$art/;
	
	# 表示
	print "Content-type: text/html; charset=utf-8\n\n";
	footer($tmpl{bbs});
}

#-----------------------------------------------------------
#  投稿フォーム
#-----------------------------------------------------------
sub form_page {
	if ($in{bbs} eq '') { $in{bbs} = 0; }
	
	my %fm;
	($fm{name},$fm{email},$fm{url},$fm{icon},$fm{col}) = get_cookie();
	if ($fm{url} eq '') { $fm{url} = 'http://'; }
	
	open(IN,"$cf{tmpldir}/form.html") or error("open err: form.html");
	my $tmpl = join('',<IN>);
	close(IN);
	
	# 画像認証作成
	my ($str_plain,$str_crypt);
	if ($cf{use_captcha} > 0) {
		require $cf{captcha_pl};
		($str_plain,$str_crypt) = cap::make($cf{captcha_key},$cf{cap_len});
	} else {
		$tmpl =~ s|<!-- captcha -->.+?<!-- /captcha -->||s;
	}
	
	$tmpl =~ s/!(bbs_title|cmnurl|captcha_cgi|bbs_cgi|post_cgi)!/$cf{$1}/g;
	$tmpl =~ s/!str_crypt!/$str_crypt/g;
	$tmpl =~ s/!(name|email|comment|url)!/$fm{$1}/g;
	$tmpl =~ s/<!-- icons -->/op_icons($fm{icon})/e;
	$tmpl =~ s/<!-- colors -->/btn_col($fm{col})/e;
	$tmpl =~ s/!res!/$in{res}/g;
	$tmpl =~ s/!bbs!/$in{bbs}/g;
	
	# --- 返信のとき
	if ($in{res} > 0) {
		$tmpl =~ s|<!-- article -->(.+?)<!-- /article -->|reply_art($1)|se;
		$tmpl =~ s/!sub!/get_sub()/e;
	} else {
		$tmpl =~ s|<!-- article -->.+?<!-- /article -->||s;
		$tmpl =~ s/!sub!//g;
	}
	
	print "Content-type: text/html; charset=utf-8\n\n";
	print $tmpl;
	exit;
}

#-----------------------------------------------------------
#  留意事項表示
#-----------------------------------------------------------
sub note_page {
	open(IN,"$cf{tmpldir}/note.html") or error("open err: note.html");
	my $tmpl = join('',<IN>);
	close(IN);
	
	$tmpl =~ s/!(bbs_title|cmnurl)!/$cf{$1}/g;
	$tmpl =~ s|!icon:(\w+\.\w+)!|<img src="$cf{cmnurl}/$1" alt="$1" class="icon">|g;
	
	print "Content-type: text/html; charset=utf-8\n\n";
	print $tmpl;
	exit;
}

#-----------------------------------------------------------
#  アイコン一覧
#-----------------------------------------------------------
sub icon_page {
	# テンプレート認識
	open(IN,"$cf{tmpldir}/icon.html") or error("open err: icon.html");
	my $tmpl = join('',<IN>);
	close(IN);
	
	$tmpl =~ s/!([a-z]+_cgi)!/$cf{$1}/g;
	$tmpl =~ s/!(bbs_title|cmnurl)!/$cf{$1}/g;
	
	# テンプレート分割
	my ($head,$loop,$foot) = $tmpl =~ m|(.+)<!-- loop -->(.+?)<!-- /loop -->(.+)|s
			? ($1,$2,$3)
			: error("テンプレート不正");
	
	# 画面展開
	print "Content-type: text/html; charset=utf-8\n\n";
	print $head;
	
	for (0 .. $#{$cf{icons}}) {
		my ($ico,$cap) = split(/,/,$cf{icons}[$_]);
		
		my $tmp = $loop;
		$tmp =~ s|!image!|<img src="$cf{cmnurl}/face/$ico" alt="$cap">|g;
		$tmp =~ s/!caption!/$cap/g;
		print $tmp;
	}
	
	# フッタ
	print $foot;
	exit;
}

#-----------------------------------------------------------
#  返信記事
#-----------------------------------------------------------
sub reply_art {
	my $tmpl = shift;
	
	# 返信テンプレート
	open(IN,"$cf{tmpldir}/form_res.html");
	my $loop = join('',<IN>);
	close(IN);
	
	my ($log,@res);
	open(IN,"$cf{logfile}") or error("open err: $cf{logfile}");
	while (<IN>) {
		my ($no,$reno,$date,$name,$eml,$sub,$ico,$ico2,$com,$col,$url,$host,$pw) = split(/<>/);
		$url &&= qq|<a href="$url" target="_blank"><img src="$cf{cmnurl}/home.png" class="icon" alt="home"></a>|;
		
		if ($in{res} == $no) {
			$log = $_;
			next;
		} elsif ($in{res} == $reno) {
			push(@res,$_);
		}
	}
	close(IN);
	
	my ($no,$reno,$date,$name,$eml,$sub,$ico,$ico2,$com,$col,$url,$host,$pw) = split(/<>/,$log);
	$url &&= qq|<a href="$url" target="_blank"><img src="$cf{cmnurl}/home.png" class="icon" alt="home"></a>|;
	my ($face,$fnam) = split(/,/,$cf{icons}[$ico]);
	
	$tmpl =~ s/!p_sub!/$sub/;
	$tmpl =~ s|!p_com!|<span style="color:$col">$com</span>|;
	$tmpl =~ s/!p_name!/$name/;
	$tmpl =~ s/!p_date!/$date/;
	$tmpl =~ s|!icon:(\w+\.\w+)!|<img src="$cf{cmnurl}/$1" alt="" class="icon">|g;
	$tmpl =~ s/<!-- home -->/$url/g;
	$tmpl =~ s|<!-- face -->|<img src="$cf{cmnurl}/face/$face" alt="$fnam" class="face-icon">|;
	$tmpl =~ s|<!-- dele -->|<a href="$cf{bbs_cgi}?del=$no"><img src="$cf{cmnurl}/dele.png" alt="削除" class="icon"></a>|g;
	$tmpl =~ s/!bbs!/$in{bbs}/g;
	
	my $res;
	for (@res) {
		my ($no,$reno,$date,$name,$eml,$sub,$ico,$ico2,$com,$col,$url,$host,$pw) = split(/<>/);
		$url &&= qq|<a href="$url" target="_blank"><img src="$cf{cmnurl}/home.png" class="icon" alt="home"></a>|;
		my ($face,$fnam) = split(/,/,$cf{icons}[$ico]);
		
		my $tmp = $loop;
		$tmp =~ s/!sub!/$sub/g;
		$tmp =~ s|!comment!|<span style="color:$col">$com</span>|;
		$tmp =~ s/!name!/$name/;
		$tmp =~ s/!date!/$date/;
		$tmp =~ s|!icon:(\w+\.\w+)!|<img src="$cf{cmnurl}/$1" alt="" class="icon">|g;
		$tmp =~ s/<!-- home -->/$url/g;
		$tmp =~ s|<!-- face -->|<img src="$cf{cmnurl}/face/$face" alt="$fnam" class="face-icon">|;
		$tmp =~ s|<!-- dele -->|<a href="$cf{bbs_cgi}?del=$no"><img src="$cf{cmnurl}/dele.png" alt="削除" class="icon"></a>|g;
		$tmp =~ s/!bbs_cgi!/$cf{bbs_cgi}/g;
		$tmp =~ s/!num!/$no/g;
		$tmp =~ s/!bbs!/$in{bbs}/g;
		
		$res .= $tmp;
	}
	
	$tmpl =~ s/<!-- reply -->/$res/;
	return $tmpl;
}

#-----------------------------------------------------------
#  件名取得
#-----------------------------------------------------------
sub get_sub {
	my $resub;
	open(IN,"$cf{logfile}") or error("open err: $cf{logfile}");
	while (<IN>) {
		my ($no,$reno,$date,$name,$eml,$sub,$ico,$ico2,$com,$col,$url,$host,$pw) = split(/<>/);
		
		if ($in{res} == $no) {
			$resub = $sub;
			last;
		}
	}
	close(IN);
	
	return "Re: $resub";
}

#-----------------------------------------------------------
#  アイコンプルダウン
#-----------------------------------------------------------
sub op_icons {
	my $icon = shift;
	
	my $ret;
	for (0 .. $#{$cf{icons}}) {
		my (undef,$nam) = split(/,/,$cf{icons}[$_]);
		
		if ($icon == $_) {
			$ret .= qq|<option value="$_" selected>$nam</option>\n|;
		} else {
			$ret .= qq|<option value="$_">$nam</option>\n|;
		}
	}
	return $ret;
}

#-----------------------------------------------------------
#  色ラジオボタン
#-----------------------------------------------------------
sub btn_col {
	my $col = shift;
	
	my @col = split(/\s+/,$cf{colors});
	my $ret;
	for (0 .. $#col) {
		if ($col == $_) {
			$ret .= qq|<input type="radio" name="color" value="$_" checked>|;
		} else {
			$ret .= qq|<input type="radio" name="color" value="$_">|;
		}
		$ret .= qq|<span style="color:$col[$_]">■</span>\n|;
	}
	$ret;
}

#-----------------------------------------------------------
#  トピックス画面
#-----------------------------------------------------------
sub bbs_topic {
	# クッキー取得
	my ($ck_nam,$ck_eml,$ck_url,$ck_ico,$ck_col) = get_cookie();
	$ck_url ||= 'http://';
	
	# 色選択ボタン
	my @col = split(/\s+/,$cf{colors});
	my $color;
	foreach (0 .. $#col) {
		if ($_ == $ck_col) {
			$color .= qq|<input type="radio" name="color" value="$_" checked>|;
		} else {
			$color .= qq|<input type="radio" name="color" value="$_">|;
		}
		$color .= qq|<span style="color:$col[$_]">■</span>\n|;
	}
	
	# アイコン
	my %op;
	foreach (0 .. $#{$cf{icon}}) {
		my ($file,$name) = split(/,/,$cf{icon}->[$_]);
		if ($ck_ico == $_) {
			$op{icon} .= qq|<option value="$_" selected>$name</option>\n|;
		} else {
			$op{icon} .= qq|<option value="$_">$name</option>\n|;
		}
	}
	
	# ページ数
	my $pg = $in{pg} || 0;
	
	# データ認識
	my ($i,@log,%res,%last);
	open(IN,"$cf{logfile}") or error("open err: $cf{logfile}");
	while(<IN>) {
		my ($no,$reno,$date,$name,$eml,$sub,$ico,$ico2,$com,$col,$url,$host,$pw) = split(/<>/);
		
		if (!$reno) { $i++; }
		next if ($i < $pg + 1);
		next if ($i > $pg + $cf{max_topi});
		
		if ($reno) {
			$res{$reno}++;
			$last{$reno} = qq|<span>$date</span><br>$name|;
		} else {
			$last{$no}   = qq|<span>$date</span><br>$name|;
		}
		
		push(@log,$_) if (!$reno);
	}
	close(IN);
	
	# ペイジャー
	my $pager = make_pager($i,$pg,$cf{max_topi});
	
	# テンプレート読み込み
	open(IN,"$cf{tmpldir}/topic.html") or error("open err: topic.html");
	my $tmpl = join('',<IN>);
	close(IN);
	
	# 文字置換え
	$tmpl =~ s/!(bbs_title|cmnurl|homepage)!/$cf{$1}/g;
	$tmpl =~ s/!([a-z]+_cgi)!/$cf{$1}/g;
	$tmpl =~ s/<!-- pager -->/$pager/g;
	$tmpl =~ s/!color!/$color/g;
	$tmpl =~ s/!fm_sub!//g;
	$tmpl =~ s/!fm_name!/$ck_nam/;
	$tmpl =~ s/!fm_email!/$ck_eml/;
	$tmpl =~ s/!fm_url!/$ck_url/;
	$tmpl =~ s/<!-- op_([a-z]+) -->/$op{$1}/g;
	$tmpl =~ s/!q!/$in{q}/g;
	
	# 分解
	my ($head,$loop,$foot) = $tmpl =~ m|(.+)<!-- loop -->(.+?)<!-- /loop -->(.+)|s
			? ($1,$2,$3)
			: error("テンプレート不正");
	
	# ヘッダ表示
	print "Content-type: text/html; charset=utf-8\n\n";
	print $head;
	
	# 親記事展開
	foreach (@log) {
		my ($no,$reno,$date,$name,$eml,$sub,$com,$url,$host,$pw,$col,$ext,$w,$h,$chk) = split(/<>/);
		
		if ($res{$no} eq '') { $res{$no} = 0; }
		
		my $tmp = $loop;
		$tmp =~ s/!topi-num!/$no/g;
		$tmp =~ s|!topi-ttl!|<a href="$cf{bbs_cgi}?mode=form&amp;res=$no&amp;bbs=1#art">$sub</a>|g;
		$tmp =~ s/!topi-nam!/$name/g;
		$tmp =~ s/!topi-res!/$res{$no}/g;
		$tmp =~ s/!topi-last!/$last{$no}/g;
		print $tmp;
	}
	
	# フッタ
	footer($foot);
}

#-----------------------------------------------------------
#  検索画面
#-----------------------------------------------------------
sub find_page {
	# ページ数定義
	my $pg = $in{pg} || 0;
	
	# UTF-8定義
	my $byte1 = '[\x00-\x7f]';
	my $byte2 = '[\xC0-\xDF][\x80-\xBF]';
	my $byte3 = '[\xE0-\xEF][\x80-\xBF]{2}';
	my $byte4 = '[\xF0-\xF7][\x80-\xBF]{3}';
	
	# キーワード配列化
	$in{q} =~ s/　/ /g;
	my @q = split(/\s+/,$in{q});
	
	# データ読み込み
	my ($i,@log);
	open(IN,"$cf{logfile}") or error("open err: $cf{logfile}");
	while (<IN>) {
		my ($no,$reno,$date,$name,$eml,$sub,$ico,$ico2,$com,$col,$url,$host,$pw) = split(/<>/);
		
		# 検索
		my $flg;
		for my $q (@q) {
			if ("$name $sub $com" =~ /^(?:$byte1|$byte2|$byte3|$byte4)*?\Q$q\E/i) {
				$flg++;
			} else {
				$flg = 0;
				last;
			}
		}
		next if (!$flg);
		
		# ヒット
		$i++;
		next if ($i < $pg + 1);
		next if ($i > $pg + $cf{max_find});
		
		push(@log,$_);
	}
	close(IN);
	
	# ペイジャー
	my $pager = make_pager($i,$pg,$cf{max_find});
	
	open(IN,"$cf{tmpldir}/find.html") or error("open err: find.html");
	my $tmpl = join('',<IN>);
	close(IN);
	
	# 文字置換え
	$tmpl =~ s/!(bbs_title|cmnurl|homepage|bbs_cgi)!/$cf{$1}/g;
	$tmpl =~ s|!icon:(\w+\.\w+)!|<img src="$cf{cmnurl}/$1" alt="" class="icon">|g;
	$tmpl =~ s/!(q|bbs)!/$in{$1}/g;
	$tmpl =~ s/!find-num!/$i/g;
	$tmpl =~ s/<!-- pager -->/$pager/g;
	
	# 分解
	my ($head,$loop,$foot) = $tmpl =~ m|(.+)<!-- loop -->(.+?)<!-- /loop -->(.+)|s
			? ($1,$2,$3)
			: error("テンプレート不正");
	
	# ヘッダ表示
	print "Content-type: text/html; charset=utf-8\n\n";
	print $head;
	
	for (@log) {
		my ($no,$reno,$date,$name,$eml,$sub,$ico,$ico2,$com,$col,$url,$host,$pw) = split(/<>/);
		$url &&= qq|<a href="$url" target="_blank"><img src="$cf{cmnurl}/home.png" class="icon" alt="home"></a>|;
		my ($face,$fnam) = split(/,/,$cf{icons}[$ico]);
		
		my $tmp = $loop;
		$tmp =~ s|<!-- face -->|<img src="$cf{cmnurl}/face/$face" alt="$fnam" class="face-icon">|;
		$tmp =~ s/!sub!/$sub/g;
		$tmp =~ s|!comment!|<span style="color:$col">$com</span>|;
		$tmp =~ s/!name!/$name/;
		$tmp =~ s/!date!/$date/;
		
		print $tmp;
	}
	
	print $foot;
	exit;
}

#-----------------------------------------------------------
#  クッキー取得
#-----------------------------------------------------------
sub get_cookie {
	# クッキー取得
	my $cook = $ENV{HTTP_COOKIE};
	
	# 該当IDを取り出す
	my %cook;
	foreach ( split(/;/, $cook) ) {
		my ($key,$val) = split(/=/);
		$key =~ s/\s//g;
		$cook{$key} = $val;
	}
	
	# URLデコード
	my @cook;
	foreach ( split(/<>/, $cook{$cf{cookie_id}}) ) {
		s/%([0-9A-Fa-f][0-9A-Fa-f])/pack("H2", $1)/eg;
		s/[&"'<>]//g;
		
		push(@cook,$_);
	}
	return @cook;
}

#-----------------------------------------------------------
#  フッター
#-----------------------------------------------------------
sub footer {
	my $foot = shift;
	
	# 著作権表記（削除・改変禁止）
	my $copy = <<EOM;
<p style="margin-top:2.5em;text-align:center;font-family:Verdana,Helvetica,Arial;font-size:10px;">
	- <a href="http://www.kent-web.com/" target="_top">Honey Board</a> -
</p>
EOM

	if ($foot =~ /(.+)(<\/body[^>]*>.*)/si) {
		print "$1$copy$2\n";
	} else {
		print "$foot$copy\n";
		print "</body></html>\n";
	}
	exit;
}

#-----------------------------------------------------------
#  繰越ボタン作成
#-----------------------------------------------------------
sub make_pager {
	my ($i,$pg,$max) = @_;
	$max ||= 5;
	
	# 引数
	my $stat = "&amp;bbs=$in{bbs}";
	if ($in{q} ne '') {
		my $q = url_enc($in{q});
		$stat .= "&amp;q=$q";
	}
	
	# ページ繰越定義
	my $next = $pg + $max;
	my $back = $pg - $max;
	
	# ページ繰越ボタン作成
	my @pg;
	if ($back >= 0 || $next < $i) {
		my $flg;
		my ($w,$x,$y,$z) = (0,1,0,$i);
		while ($z > 0) {
			if ($pg == $y) {
				$flg++;
				push(@pg,qq!<span class="page active">$x</span>!);
			} else {
				push(@pg,qq!<a href="$cf{bbs_cgi}?pg=$y$stat" class="page gradient">$x</a>!);
			}
			$x++;
			$y += $max;
			$z -= $max;
			
			if ($flg) { $w++; }
			last if ($w >= 5 && @pg >= 10);
		}
	}
	while( @pg >= 11 ) { shift(@pg); }
	my $ret = join('',@pg);
	if ($back >= 0) {
		$ret = qq!<a href="$cf{bbs_cgi}?pg=$back$stat" class="page gradient">&laquo;</a>\n! . $ret;
	}
	if ($next < $i) {
		$ret .= qq!<a href="$cf{bbs_cgi}?pg=$next$stat" class="page gradient">&raquo;</a>\n!;
	}
	# 結果を返す
	return $ret ? qq|<div class="pagination">\n$ret</div>| : '';
}

#-----------------------------------------------------------
#  自動リンク
#-----------------------------------------------------------
sub autolink {
	my $text = shift;
	
	$text =~ s/(s?https?:\/\/([\w-.!~*'();\/?:\@=+\$,%#]|&amp;)+)/<a href="$1" target="_blank">$1<\/a>/g;
	return $text;
}

#-----------------------------------------------------------
#  削除フォーム
#-----------------------------------------------------------
sub dele_form {
	$in{del} =~ s/\D//g;
	
	my ($flg,$log);
	open(DAT,"$cf{logfile}") or error("open err: $cf{logfile}");
	while (<DAT>) {
		my ($no,$reno,$date,$name,$eml,$sub,$ico,$ico2,$com,$col,$url,$host,$pw) = split(/<>/);
		
		if ($in{del} == $no) {
			$log = $_;
			next;
		}
		if ($log && $in{del} == $reno) {
			$flg++;
			last;
		}
	}
	close(DAT);
	
	# レス有り
	if ($flg) { error("この記事は返信記事があるため削除できません"); }
	
	my ($no,$reno,$date,$name,$eml,$sub,$ico,$ico2,$com,$col,$url,$host,$pw) = split(/<>/,$log);
	if ($pw eq '') { error("この記事は削除キーが設定されていません"); }
	
	open(IN,"$cf{tmpldir}/dele.html") or error("open err: dele.html");
	my $tmpl = join('',<IN>);
	close(IN);
	
	$tmpl =~ s/!(bbs_title|cmnurl|bbs_cgi|post_cgi)!/$cf{$1}/g;
	$tmpl =~ s/!del!/$in{del}/g;
	$tmpl =~ s/!sub!/$sub/g;
	$tmpl =~ s/!name!/$name/g;
	$tmpl =~ s/!date!/$date/g;
	
	print "Content-type: text/html; charset=utf-8\n\n";
	print $tmpl;
	exit;
}

#-----------------------------------------------------------
#  URLエンコード
#-----------------------------------------------------------
sub url_enc {
	local($_) = @_;
	
	s/(\W)/'%' . unpack('H2', $1)/eg;
	s/\s/+/g;
	$_;
}

