# モジュール宣言/変数初期化
use strict;
my %cf;
#┌─────────────────────────────────
#│ HONEY BOARD : init.cgi - 2019/12/22
#│ copyright (c) kentweb, 1997-2019
#│ http://www.kent-web.com/
#└─────────────────────────────────
$cf{version} = 'Honey Board v6.0';
#┌─────────────────────────────────
#│ [注意事項]
#│ 1. このプログラムはフリーソフトです。このプログラムを使用した
#│    いかなる損害に対して作者は一切の責任を負いません。
#│ 2. 設置に関する質問はサポート掲示板にお願いいたします。
#│    直接メールによる質問は一切お受けいたしておりません。
#└─────────────────────────────────

#===========================================================
# ■ 基本設定
#===========================================================

# 管理用パスワード
$cf{password} = '0123';

# タイトル名
$cf{bbs_title} = "掲示板 - Honey Board";

# 本体プログラムURL
$cf{bbs_cgi} = './honey.cgi';

# 投稿受理プログラムURL
$cf{post_cgi} = './post.cgi';

# 管理プログラムURL
$cf{admin_cgi} = './admin.cgi';

# ログファイル
$cf{logfile} = './data/log.cgi';

# 番号ファイル
$cf{numfile} = './data/num.dat';

# テンプレートディレクトリ【サーバパス】
$cf{tmpldir} = './tmpl';

# 最大記事数（親記事でカウントする。これを超える記事は古い順に削除）
$cf{maxlog} = 50;

# 戻り先【URLパス】
$cf{homepage} = "../index.html";

# 文字コード自動判別（0=no 1=yes）
# → フォーム入力の文字コード判別を行う場合
$cf{conv_code} = 0;

# 共通ディレクトリ【URLパス】
$cf{cmnurl} = './cmn';

# 画像ディレクトリ
$cf{imgurl} = './img';

# 記事の更新は method=POST 限定 (0=no 1=yes)
$cf{postonly} = 1;

# URLの自動リンク (0=no 1=yes)
$cf{autolink} = 1;

# １ページあたりの親記事表示数
# → 順に、スレッド、トピック、検索結果
$cf{max_thrd} = 5;
$cf{max_topi} = 10;
$cf{max_find} = 10;

# 記事 [タイトル] 部の最大文字数
$cf{sub_len} = 15;

# レスがついたらツリー毎トップへ移動 (0=no 1=yes)
$cf{top_sort} = 1;

# 投稿があるとメール通知する (sendmail必須)
# 0 : 通知しない
# 1 : 通知する
$cf{mailing} = 0;

# メールアドレス(メール通知する時)
$cf{mailto} = 'xxx@xxx.xxx';

# sendmailパス（メール通知する時）
$cf{sendmail} = '/usr/lib/sendmail';

# sendmailの -fコマンドが必要な場合
# 0=no 1=yes
$cf{sendm_f} = 0;

# 文字色の設定
# →　スペースで区切る
$cf{colors} = '#800000 #df0000 #008040 #0000ff #c100c1 #ff80c0 #ff8040 #000080 #808000';

# アイコンを定義
# → 前にファイル名、後にアイコン名をコンマで区切る
$cf{icons} = [
	'bear.gif,くま',
	'cat.gif,ねこ',
	'cow.gif,うし',
	'dog.gif,いぬ',
	'fox.gif,きつね',
	'hituji.gif,ひつじ',
	'monkey.gif,さる',
	'zou.gif,ぞう',
	'mouse.gif,ねずみ',
	'panda.gif,パンダ',
	'pig.gif,ぶた',
	'usagi.gif,うさぎ',
	];

# 制限投稿間隔（秒数）
$cf{wait} = 0;

# 禁止ワード
# → 投稿時禁止するワードをコンマで区切る
$cf{no_wd} = '';

# 日本語チェック（投稿時日本語が含まれていなければ拒否する）
# 0=No  1=Yes
$cf{jp_wd} = 1;

# URL個数チェック
# → 投稿コメント中に含まれるURL個数の最大値
$cf{urlnum} = 2;

# １回当りの最大投稿サイズ (bytes)
$cf{maxdata} = 51200;

# ホスト取得方法
# 0 : gethostbyaddr関数を使わない
# 1 : gethostbyaddr関数を使う
$cf{gethostbyaddr} = 0;

# アクセス制限（半角スペースで区切る、アスタリスク可）
#  → 拒否ホスト名を記述（後方一致）【例】*.anonymizer.com
$cf{deny_host} = '';
#  → 拒否IPアドレスを記述（前方一致）【例】210.12.345.*
$cf{deny_addr} = '';

# クッキーID名（特に変更しなくてよい）
# → クッキー保存名
$cf{cookie_id} = "honey_bbs";

# -------------------------------------------------------------- #
# [ 以下は「画像認証機能」機能（スパム対策）を使用する場合の設定 ]
#
# 画像認証機能の使用
# 0 : しない
# 1 : ライブラリ版（pngren.pl）
# 2 : モジュール版（GD::SecurityImage + Image::Magick）→ Image::Magick必須
$cf{use_captcha} = 1;

# 認証用画像生成ファイル【URLパス】
$cf{captcha_cgi} = './captcha.cgi';

# 画像認証プログラム【サーバパス】
$cf{captcha_pl} = './lib/captcha.pl';
$cf{captsec_pl} = './lib/captsec.pl';
$cf{pngren_pl}  = './lib/pngren.pl';

# 画像認証機能用暗号化キー（暗号化/復号化をするためのキー）
# → 適当に変更してください。
$cf{captcha_key} = 'capt_honeybbs';

# 投稿キー許容時間（分単位）
# → 投稿フォーム表示後、送信ボタンが押されるまでの可能時間。
$cf{cap_time} = 30;

# 投稿キーの文字数
# ライブラリ版 : 4～8文字で設定
# モジュール版 : 6～8文字で設定
$cf{cap_len} = 6;

# 画像/フォント格納ディレクトリ【サーバパス】
$cf{bin_dir} = './lib/bin';

# [ライブラリ版] 画像ファイル [ ファイル名のみ ]
$cf{si_png} = "casual.png";

# [モジュール版] 画像フォント [ ファイル名のみ ]
$cf{font_ttl} = "tempest.ttf";

#===========================================================
# ■ 設定完了
#===========================================================

# アイコン追加
push(@{$cf{icon}},"$cf{my_gif},管理者用") if ($cf{my_icon});

# 設定値を返す
sub set_init { return %cf; }

#-----------------------------------------------------------
#  フォームデコード
#-----------------------------------------------------------
sub parse_form {
	my ($buf,%in);
	if ($ENV{REQUEST_METHOD} eq "POST") {
		error('受理できません') if ($ENV{CONTENT_LENGTH} > $cf{maxdata});
		read(STDIN, $buf, $ENV{CONTENT_LENGTH});
	} else {
		$buf = $ENV{QUERY_STRING};
	}
	foreach ( split(/&/,$buf) ) {
		my ($key,$val) = split(/=/);
		$val =~ tr/+/ /;
		$val =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("H2", $1)/eg;
		
		# 無効化
		$val =~ s/&/&amp;/g;
		$val =~ s/</&lt;/g;
		$val =~ s/>/&gt;/g;
		$val =~ s/"/&quot;/g;
		$val =~ s/'/&#39;/g;
		$val =~ s|\r\n|<br>|g;
		$val =~ s|[\n\n]|<br>|g;
		
		$in{$key} .= "\0" if (defined $in{$key});
		$in{$key} .= $val;
	}
	return %in;
}

#-----------------------------------------------------------
#  エラー画面
#-----------------------------------------------------------
sub error {
	my $err = shift;
	
	open(IN,"$cf{tmpldir}/error.html") or die;
	my $tmpl = join('',<IN>);
	close(IN);
	
	$tmpl =~ s/!error!/$err/g;
	$tmpl =~ s/!(cmnurl|bbs_title)!/$cf{$1}/g;
	
	print "Content-type: text/html; charset=utf-8\n\n";
	print $tmpl;
	exit;
}


1;

