#!/usr/local/bin/perl

#┌─────────────────────────────────
#│ HONEY BOARD : admin.cgi - 2019/12/22
#│ copyright (c) kentweb, 1997-2019
#│ http://www.kent-web.com/
#└─────────────────────────────────

# モジュール宣言
use strict;
use CGI::Carp qw(fatalsToBrowser);

# 設定ファイル認識
require "./init.cgi";
my %cf = set_init();

# データ受理
my %in = parse_form();

# 認証
check_passwd();

# 管理モード
admin_mode();

#-----------------------------------------------------------
#  管理モード
#-----------------------------------------------------------
sub admin_mode {
	# 編集フォーム
	if ($in{mode_edit} && $in{no}) {
		if ($in{no} =~ /\0/) { cgi_err('複数記事が選択されています'); }
		
		my $log;
		open(DAT,"$cf{logfile}") or cgi_err("open err: $cf{logfile}");
		while (<DAT>) {
			my ($no) = (split(/<>/))[0];
			
			if ($in{no} == $no) {
				$log = $_;
				last;
			}
		}
		close(DAT);
		
		# 編集フォーム
		edit_form($log);
	
	# 編集実行
	} elsif ($in{mode_edit2} && $in{no}) {
		# URL
		if ($in{url} eq 'http://') { $in{url} = ''; }
		
		# 文字色
		my $color = (split(/\s+/,$cf{colors}))[$in{color}];
		
		my @data;
		open(DAT,"+< $cf{logfile}") or cgi_err("open err: $cf{logfile}");
		eval "flock(DAT,2);";
		while (<DAT>) {
			my ($no,$reno,$date,$nam,$eml,$sub,$ico,$ico2,$com,$col,$url,$host,$pw) = split(/<>/);
			if ($in{no} == $no) {
				$_ = "$no<>$reno<>$date<>$in{name}<>$in{email}<>$in{sub}<>$in{icon}<><>$in{comment}<>$color<>$in{url}<>$host<>$pw<>\n";
			}
			push(@data,$_);
		}
		
		# 更新
		seek(DAT,0,0);
		print DAT @data;
		truncate(DAT,tell(DAT));
		close(DAT);
	
	# 削除処理
	} elsif ($in{mode_dele} && $in{no}) {
		
		my %del;
		for ( split(/\0/,$in{no}) ) { $del{$_}++; }
		
		# 削除情報をマッチングし更新
		my @data;
		open(DAT,"+< $cf{logfile}") or cgi_err("open err: $cf{logfile}");
		eval "flock(DAT,2);";
		while (<DAT>) {
			my ($no,$reno) = (split(/<>/))[0,1];
			next if (defined($del{$no}));
			next if (defined($del{$reno}));
			
			push(@data,$_);
		}
		
		# 更新
		seek(DAT,0,0);
		print DAT @data;
		truncate(DAT,tell(DAT));
		close(DAT);
	}
	
	header("管理モード");
	print <<EOM;
<div id="menu">
<input type="button" value="掲示板" onclick="window.open('$cf{bbs_cgi}','_self')">
<input type="button" value="ログオフ" onclick="window.open('$cf{admin_cgi}','_self')">
</div>
<p>・ 親記事を削除するとレス記事も一括して削除されます。</p>
<form action="$cf{admin_cgi}" method="post">
<input type="hidden" name="pass" value="$in{pass}">
<input type="submit" name="mode_edit" value="修正">
<input type="submit" name="mode_dele" value="削除">
EOM

	my $i = 0;
	open(IN,"$cf{logfile}") or cgi_err("open err: $cf{logfile}");
	while (<IN>) {
		my ($no,$reno,$date,$name,$mail,$sub,$icon,$icon2,$com,$color,$url,$host,$pw) = split(/<>/);
		
		if (!$reno) {
			print qq|<div class="log">|;
		} else {
			print qq|<div class="sub">|;
		}
		
		# 削除チェックボックス
		print qq|<input type="checkbox" name="no" value="$no">|;
		print qq|<b class="sub">$sub</b> 投稿者：<b>$name</b> 日時：$date No.$no [$host]</div>\n|;
		print qq|<div class="com">| . cut_str($com,40) . qq|</div>\n|;
	
	}
	close(IN);
	
	print <<EOM;
</form>
</div>
</body>
</html>
EOM
	exit;
}

#-----------------------------------------------------------
#  編集フォーム
#-----------------------------------------------------------
sub edit_form {
	my $log = shift;
	my ($no,$reno,$date,$name,$eml,$sub,$icon,$icon2,$com,$col,$url,$host,$pw) = split(/<>/,$log);
	$com =~ s|<br( /)?>|\n|g;
	$url ||= 'http://';
	
	# アイコン
	my $op_ico;
	foreach (0 .. $#{$cf{icons}}) {
		my ($file,$name) = split(/,/,$cf{icons}[$_]);
		if ($icon == $_) {
			$op_ico .= qq|<option value="$_" selected>$name\n|;
		} else {
			$op_ico .= qq|<option value="$_">$name\n|;
		}
	}
	
	# 色選択ボタン
	my @col = split(/\s+/,$cf{colors});
	my $op_col;
	foreach (0 .. $#col) {
		if ($col[$_] eq $col) {
			$op_col .= qq|<input type="radio" name="color" value="$_" checked>|;
		} else {
			$op_col .= qq|<input type="radio" name="color" value="$_">|;
		}
		$op_col .= qq|<span style="color:$col[$_]">■</span>\n|;
	}
	
	header('管理TOP &gt; 編集フォーム');
	print <<EOM;
<div id="back-btn">
<form action="$cf{admin_cgi}" method="post">
<input type="hidden" name="pass" value="$in{pass}">
<input type="submit" value="&lt; 前に戻る">
</form>
</div>
<form action="$cf{admin_cgi}" method="post">
<input type="hidden" name="pass" value="$in{pass}">
<input type="hidden" name="mode_edit2" value="1">
<input type="hidden" name="no" value="$in{no}">
<table class="form">
<tr>
	<th>なまえ</th>
	<td><input type="text" name="name" size="30" value="$name"></td>
</tr><tr>
	<th>E-mail</th>
	<td><input type="text" name="email" size="30" value="$eml"></td>
</tr><tr>
	<th>タイトル</th>
	<td><input type="text" name="sub" size="36" value="$sub"></td>
</tr><tr>
	<th>コメント</th>
	<td><textarea name="comment" cols="60" rows="7">$com</textarea></td>
</tr><tr>
	<th>参照先</th>
	<td><input type="text" name="url" size="55" value="$url"></td>
</tr><tr>
	<th>アイコン</th>
	<td>
		<select name="icon">
		$op_ico
		</select>
	</td>
</tr><tr>
	<th>文字色</th>
	<td>$op_col</td>
</tr><tr>
	<th></th>
	<td><input type="submit" value="編集する"></td>
</tr>
</table>
</form>
</div>
</body>
</html>
EOM
	exit;
}

#-----------------------------------------------------------
#  HTMLヘッダー
#-----------------------------------------------------------
sub header {
	my $ttl = shift;
	
	print <<EOM;
Content-type: text/html; charset=utf-8

<!doctype html>
<html lang="ja">
<head>
<meta charset="UTF-8">
<style>
body { font-size:90%; padding:0; margin:0; background:#c8e3e3; font-family:'Hiragino Kaku Gothic ProN','ヒラギノ角ゴ ProN W3',Meiryo,メイリオ,Osaka,'MS PGothic',arial,helvetica,sans-serif; }
div.ttl { border-bottom:1px solid #804000; color:#804000; padding:4px; font-weight:bold; }
p.err { color:#dd0000; }
p.msg { color:#006400; }
.form { border-collapse:collapse; margin:1.2em; }
.form th, .form td { border:1px solid #333; padding:10px; }
.form th { background:#ccc; }
.form td { background:#fff; }
div.log { border-top:1px solid #444; padding:5px; margin-top:1em; }
div.sub { margin-left:2em; }
div.com { margin-left:2em; margin-bottom:1em; color:#002d4c; }
#login { width:400px; margin:3em auto; text-align:center; }
#login fieldset { padding:2em; }
#login input[type="password"] { width:190px; padding:3px; }
#login input[type="submit"] { width:50px; height:27px; }
#head { background:#4e89c6; color:#fff; padding:3px 6px; font-weight:bold; }
#body { padding:6px; }
.icon { vertical-align:middle; }
#back-btn { margin:3px; text-align:right; }
.ta-r { text-align:right; }
#err { margin:2em auto; width:500px; border:1px dotted red; text-align:center; padding:1em; color:red; background:#fff; }
#menu { margin:0 0 0 auto; text-align:center; padding:10px; width:200px; background:#fff; border-radius: 6px; }
#menu input { width:80px; margin:0 5px; }
</style>
<title>$ttl</title>
</head>
<body>
<div id="head">
	<img src="$cf{cmnurl}/admin.png" alt="star" class="icon">
	Honey Board 管理画面 ::
</div>
<div id="body">
EOM
}

#-----------------------------------------------------------
#  パスワード認証
#-----------------------------------------------------------
sub check_passwd {
	# パスワードが未入力の場合は入力フォーム画面
	if ($in{pass} eq "") {
		enter_form();
	
	# パスワード認証
	} elsif ($in{pass} ne $cf{password}) {
		cgi_err("認証できません");
	}
}

#-----------------------------------------------------------
#  入室画面
#-----------------------------------------------------------
sub enter_form {
	header("入室画面");
	print <<EOM;
<form action="$cf{admin_cgi}" method="post">
<div id="login">
	<fieldset><legend> password </legend>
		<input type="password" name="pass">
		<input type="submit" value="認証">
	</fieldset>
</div>
</form>
<script>self.document.forms[0].pass.focus();</script>
</div>
</body>
</html>
EOM
	exit;
}

#-----------------------------------------------------------
#  エラー
#-----------------------------------------------------------
sub cgi_err {
	my $err = shift;
	
	header("ERROR!");
	print <<EOM;
<div id="err">
<p><b>ERROR!</b></p>
<p class="err">$err</p>
<p><input type="button" value="前画面に戻る" onclick="history.back()"></p>
</div>
</div>
</body>
</html>
EOM
	exit;
}

#-----------------------------------------------------------
#  完了メッセージ
#-----------------------------------------------------------
sub message {
	my $msg = shift;
	
	header("完了");
	print <<EOM;
<div align="center" style="margin-top:3em;">
<hr width="350">
<p class="msg">$msg</p>
<hr width="350">
<form action="$cf{admin_cgi}" method="post">
<input type="hidden" name="pass" value="$in{pass}">
<input type="submit" value="管理画面に戻る">
</form>
</div>
</div>
</body>
</html>
EOM
	exit;
}

#-----------------------------------------------------------
#  文字カット for UTF-8
#-----------------------------------------------------------
sub cut_str {
	my ($str,$all) = @_;
	$str =~ s|<br( /)?>||g;
	
	my $i = 0;
	my ($ret,$flg);
	while ($str =~ /([\x00-\x7f]|[\xC0-\xDF][\x80-\xBF]|[\xE0-\xEF][\x80-\xBF]{2}|[\xF0-\xF7][\x80-\xBF]{3})/gx) {
		$i++;
		$ret .= $1;
		if ($i >= $all) {
			$flg++;
			last;
		}
	}
	$ret .= '...' if ($flg);
	
	return $ret;
}

