#!/usr/local/bin/perl

#┌─────────────────────────────────
#│ HONEY BOARD : regist.cgi - 2019/12/22
#│ copyright (c) kentweb, 1997-2019
#│ http://www.kent-web.com/
#└─────────────────────────────────

# モジュール宣言
use strict;
use CGI::Carp qw(fatalsToBrowser);

# 設定ファイル認識
require "./init.cgi";
my %cf = set_init();

# データ受理
my %in = parse_form();

# 条件分岐
if ($in{mode} eq 'post') { post_data(); }
if ($in{mode} eq 'dele') { dele_data(); }
error("不明な処理です");

#-----------------------------------------------------------
#  記事投稿
#-----------------------------------------------------------
sub post_data {
	# 投稿チェック
	if ($cf{postonly} && $ENV{REQUEST_METHOD} ne 'POST') {
		error("不正なリクエストです");
	}
	
	# フォーム入力チェック
	form_check();
	
	# 画像認証チェック
	if ($cf{use_captcha} > 0) {
		require $cf{captcha_pl};
		if ($in{captcha} !~ /^\d{$cf{cap_len}}$/) {
			error("画像認証が入力不備です。<br>投稿フォームに戻って再読込み後、再入力してください");
		}
		
		# 投稿キーチェック
		# -1 : キー不一致
		#  0 : 制限時間オーバー
		#  1 : キー一致
		my $chk = cap::check($in{captcha},$in{str_crypt},$cf{captcha_key},$cf{cap_time},$cf{cap_len});
		if ($chk == 0) {
			error("画像認証が制限時間を超過しました。<br>投稿フォームに戻って再読込み後、指定の数字を再入力してください");
		} elsif ($chk == -1) {
			error("画像認証が不正です。<br>投稿フォームに戻って再読込み後、再入力してください");
		}
	}
	
	# ホスト/時間取得
	my ($host,$addr)  = get_host();
	my ($date,$times) = get_time();
	
	# 記事NO処理
	open(DAT,"+< $cf{numfile}") or error("open err: $cf{numfile}");
	eval "flock(DAT,2);";
	my $top = <DAT>;
	my ($no,$ip,$time2) = split(/<>/,$top);
	
	# 連続投稿チェック
	if ($addr eq $ip && $cf{wait} > $times - $time2) {
		close(DAT);
		error("連続投稿はもうしばらく時間をおいて下さい");
	}
	
	$no++;
	seek(DAT,0,0);
	print DAT "$no<>$addr<>$times<>\n";
	truncate(DAT,tell(DAT));
	close(DAT);
	
	# 文字色
	my $color = (split(/\s+/,$cf{colors}))[$in{color}];
	
	# 削除キー暗号化
	my $crypt = encrypt($in{pwd}) if ($in{pwd} ne "");
	
	open(DAT,"+< $cf{logfile}") or error("open err: $cf{logfile}");
	eval "flock(DAT,2);";
	
	# 親記事の場合
	if ($in{reno} eq "") {
		
		# 最大記事数処理
		my ($i,@data);
		while(<DAT>) {
			my ($no,$res) = split(/<>/);
			
			if (!$res) { $i++; }
			last if ($i >= $cf{maxlog} - 1);
			
			push(@data,$_);
		}
		
		unshift(@data,"$no<><>$date<>$in{name}<>$in{email}<>$in{sub}<>$in{icon}<><>$in{comment}<>$color<>$in{url}<>$host<>$crypt<>\n");
		
		# 更新
		seek(DAT,0,0);
		print DAT @data;
		truncate(DAT,tell(DAT));
		close(DAT);
	
	# レス記事の場合：トップソートあり
	} elsif ($in{reno} && $cf{top_sort}) {
		
		my ($flg,$match,@data,@tmp);
		while(<DAT>) {
			my ($no2,$reno2) = split(/<>/);
			
			if ($in{reno} eq $no2) {
				if ($reno2) { $flg++; last; }
				$match = 1;
				push(@data,$_);
			
			} elsif ($in{reno} eq $reno2) {
				push(@data,$_);
			
			} elsif ($match == 1 && $in{reno} ne $reno2) {
				$match = 2;
				push(@data,"$no<>$in{reno}<>$date<>$in{name}<>$in{email}<>$in{sub}<>$in{icon}<><>$in{comment}<>$color<>$in{url}<>$host<>$crypt<>\n");
				push(@tmp,$_);
			
			} else {
				push(@tmp,$_);
			}
		}
		if ($flg) {
			close(DAT);
			error("不正な返信要求です");
		}
		
		if ($match == 1) {
			push(@data,"$no<>$in{reno}<>$date<>$in{name}<>$in{email}<>$in{sub}<>$in{icon}<><>$in{comment}<>$color<>$in{url}<>$host<>$crypt<>\n");
		}
		push(@data,@tmp);
		
		# 更新
		seek(DAT,0,0);
		print DAT @data;
		truncate(DAT,tell(DAT));
		close(DAT);
	
	# レス記事の場合：トップソートなし
	} else {
		
		my ($flg,$match,@data);
		while(<DAT>) {
			my ($no2,$reno2) = split(/<>/);
			
			if ($match == 0 && $in{reno} eq $no2) {
				if ($reno2) { $flg++; last; }
				$match = 1;
			
			} elsif ($match == 1 && $in{reno} ne $reno2) {
				$match = 2;
				push(@data,"$no<>$in{reno}<>$date<>$in{name}<>$in{email}<>$in{sub}<>$in{icon}<><>$in{comment}<>$color<>$in{url}<>$host<>$crypt<>\n");
			}
			push(@data,$_);
		}
		if ($flg) {
			close(DAT);
			error("不正な返信要求です");
		}
		
		if ($match == 1) {
			push(@data,"$no<>$in{reno}<>$date<>$in{name}<>$in{email}<>$in{sub}<>$in{icon}<><>$in{comment}<>$color<>$in{url}<>$host<>$crypt<>\n");
		}
		
		# 更新
		seek(DAT,0,0);
		print DAT @data;
		truncate(DAT,tell(DAT));
		close(DAT);
	}
	
	# メール通知処理
	mail_to($date,$host) if ($cf{mailing} == 1);
	
	# クッキー格納
	set_cookie($in{name},$in{email},$in{url},$in{icon},$in{color});
	
	# 完了メッセージ
	message("投稿は正常に処理されました");
}

#-----------------------------------------------------------
#  記事削除
#-----------------------------------------------------------
sub dele_data {
	# 投稿チェック
	if ($cf{postonly} && $ENV{REQUEST_METHOD} ne 'POST') {
		error("不正なリクエストです");
	}
	
	$in{del} =~ s/\D//g;
	if ($in{del} eq '' or $in{pwd} eq '') {
		error("削除キーの入力モレ又は記事番号が不明です");
	}
	
	my ($flg,$pflg,@data);
	open(DAT,"+< $cf{logfile}") or error("open err: $cf{logfile}");
	eval "flock(DAT,2);";
	while (<DAT>) {
		my ($no,$reno,$date,$name,$eml,$sub,$ico,$ico2,$com,$col,$url,$host,$pw) = split(/<>/);
		
		# 該当記事
		if ($in{del} == $no) {
			$pflg = 1;
			$flg = 1;
			if ($pw eq '') {
				$flg = 2;
				last;
			}
			# 削除キー照合
			if (decrypt($in{pwd},$pw) != 1) {
				$flg = 3;
				last;
			}
			next;
		}
		if ($pflg && $in{del} == $reno) {
			$flg = 4;
			last;
		}
		push(@data,$_);
	}
	if (!$flg) {
		close(DAT);
		error("該当記事が見当たりません");
	} elsif ($flg == 2) {
		close(DAT);
		error("該当記事には削除キーが設定されていません");
	} elsif ($flg == 3) {
		close(DAT);
		error("削除キーが違います");
	} elsif ($flg == 4) {
		close(DAT);
		error("この記事は返信記事があるため削除できません");
	}
	
	# 更新
	seek(DAT,0,0);
	print DAT @data;
	truncate(DAT,tell(DAT));
	close(DAT);
	
	# 完了
	message("記事を削除しました");
}

#-----------------------------------------------------------
#  メール送信
#-----------------------------------------------------------
sub mail_to {
	my ($date,$host) = @_;
	
	# 件名をMIMEエンコード
	require './lib/jacode.pl';
	my $msub = mime_unstructured_header("BBS : $in{sub}");
	
	# コメント内の改行復元
	my $com = $in{comment};
	$com =~ s/<br>/\n/g;
	$com =~ s/&lt;/>/g;
	$com =~ s/&gt;/</g;
	$com =~ s/&quot;/"/g;
	$com =~ s/&amp;/&/g;
	$com =~ s/&#39;/'/g;
	
	# メール本文を定義
	my $body = <<EOM;
掲示板に投稿がありました。

投稿日：$date
ホスト：$host

件名  ：$in{sub}
お名前：$in{name}
E-mail：$in{email}
URL   ：$in{url}

$com
EOM

	# JISコード変換
	my $mbody;
	for my $tmp ( split(/\n/,$body) ) {
		jcode::convert(\$tmp,'jis','utf8');
		$mbody .= "$tmp\n";
	}
	
	# メールアドレスがない場合は管理者メールに置き換え
	$in{email} ||= $cf{mailto};
	
	# sendmailコマンド
	my $scmd = "$cf{sendmail} -t -i";
	if ($cf{sendm_f}) {	$scmd .= " -f $in{email}"; }
	
	# 送信
	open(MAIL,"| $scmd") or error("送信失敗");
	print MAIL "To: $cf{mailto}\n";
	print MAIL "From: $in{email}\n";
	print MAIL "Subject: $msub\n";
	print MAIL "MIME-Version: 1.0\n";
	print MAIL "Content-type: text/plain; charset=ISO-2022-JP\n";
	print MAIL "Content-Transfer-Encoding: 7bit\n";
	print MAIL "X-Mailer: $cf{version}\n\n";
	print MAIL "$mbody\n";
	close(MAIL);
}

#-----------------------------------------------------------
#  禁止ワードチェック
#-----------------------------------------------------------
sub no_wd {
	my $flg;
	foreach ( split(/,/, $cf{no_wd}) ) {
		if (index("$in{name} $in{sub} $in{comment}", $_) >= 0) {
			$flg = 1;
			last;
		}
	}
	if ($flg) { error("禁止ワードが含まれています"); }
}

#-----------------------------------------------------------
#  日本語チェック
#-----------------------------------------------------------
sub jp_wd {
	if ($in{comment} !~ /(?:[\xC0-\xDF][\x80-\xBF]|[\xE0-\xEF][\x80-\xBF]{2}|[\xF0-\xF7][\x80-\xBF]{3})/x) {
		error("メッセージに日本語が含まれていません");
	}
}

#-----------------------------------------------------------
#  URL個数チェック
#-----------------------------------------------------------
sub urlnum {
	my $com = $in{comment};
	my ($num) = ($com =~ s|(https?://)|$1|ig);
	if ($num > $cf{urlnum}) {
		error("コメント中のURLアドレスは最大$cf{urlnum}個までです");
	}
}

#-----------------------------------------------------------
#  完了メッセージ
#-----------------------------------------------------------
sub message {
	my ($msg) = @_;
	
	open(IN,"$cf{tmpldir}/mesg.html") or error("open err: mesg.html");
	my $tmpl = join('',<IN>);
	close(IN);
	
	$tmpl =~ s/!(bbs_cgi|cmnurl|bbs_title)!/$cf{$1}/g;
	$tmpl =~ s/!message!/$msg/g;
	$tmpl =~ s/!bbs!/$in{bbs} ? 1 : 0/e;
	
	print "Content-type: text/html; charset=utf-8\n\n";
	print $tmpl;
	exit;
}

#-----------------------------------------------------------
#  ホスト名取得
#-----------------------------------------------------------
sub get_host {
	# IP&ホスト取得
	my $host = $ENV{REMOTE_HOST};
	my $addr = $ENV{REMOTE_ADDR};
	
	if ($cf{gethostbyaddr} && ($host eq "" || $host eq $addr)) {
		$host = gethostbyaddr(pack("C4", split(/\./, $addr)), 2);
	}
	
	# IPチェック
	my $flg;
	foreach ( split(/\s+/, $cf{deny_addr}) ) {
		s/\./\\\./g;
		s/\*/\.\*/g;
		
		if ($addr =~ /^$_/i) { $flg = 1; last; }
	}
	if ($flg) {
		&error("アクセスを許可されていません");
	
	# ホストチェック
	} elsif ($host) {
		
		foreach ( split(/\s+/, $cf{deny_host}) ) {
			s/\./\\\./g;
			s/\*/\.\*/g;
			
			if ($host =~ /$_$/i) { $flg = 1; last; }
		}
		if ($flg) {
			&error("アクセスを許可されていません");
		}
	}
	$host ||= $addr;
	return ($host,$addr);
}

#-----------------------------------------------------------
#  時間取得
#-----------------------------------------------------------
sub get_time {
	$ENV{TZ} = "JST-9";
	my $time = time;
	my ($min,$hour,$mday,$mon,$year,$wday) = (localtime($time))[1..6];
	my @week = qw|Sun Mon Tue Wed Thu Fri Sat|;
	
	# 日時のフォーマット
	my $date = sprintf("%04d/%02d/%02d(%s) %02d:%02d",
			$year+1900,$mon+1,$mday,$week[$wday],$hour,$min);
	
	return ($date,$time);
}

#-----------------------------------------------------------
#  crypt暗号
#-----------------------------------------------------------
sub encrypt {
	my $in = shift;
	
	my @wd = ('a'..'z', 'A'..'Z', 0..9, '.', '/');
	srand;
	my $salt = $wd[int(rand(@wd))] . $wd[int(rand(@wd))];
	crypt($in, $salt) || crypt ($in, '$1$' . $salt);
}

#-----------------------------------------------------------
#  crypt照合
#-----------------------------------------------------------
sub decrypt {
	my ($in, $dec) = @_;
	
	return 0 if (!$dec);
	my $salt = $dec =~ /^\$1\$(.*)\$/ ? $1 : substr($dec, 0, 2);
	if (crypt($in, $salt) eq $dec || crypt($in, '$1$' . $salt) eq $dec) {
		return 1;
	} else {
		return 0;
	}
}

#-----------------------------------------------------------
#  フォーム入力チェック
#-----------------------------------------------------------
sub form_check {
	# 不要改行カット
	$in{sub}  =~ s/<br>//g;
	$in{name} =~ s/<br>//g;
	$in{pwd}  =~ s/<br>//g;
	$in{captcha} =~ s/<br>//g;
	$in{color} =~ s/\D//g;
	$in{icon}  =~ s/\D//g;
	$in{comment} =~ s/(<br>)+$//g;
	
	# チェック
	if ($cf{no_wd}) { no_wd(); }
	if ($cf{jp_wd}) { jp_wd(); }
	if ($cf{urlnum} > 0) { urlnum(); }
	
	# 入力値調整
	if ($in{url} eq 'http://') { $in{url} = ''; }
	$in{sub} ||= "無題";
	
	# 入力項目チェック
	my $err;
	if (count_str($in{sub}) > $cf{sub_len}) {
		$err .= "タイトル名は$cf{sub_len}文字以内です<br>";
	}
	if ($in{name} eq "") { $err .= "名前が入力されていません<br>"; }
	if ($in{comment} eq "") { $err .= "コメントが入力されていません<br>"; }
	if ($in{email} ne '' && $in{email} !~ /^[\w\.\-]+\@[\w\.\-]+\.[a-zA-Z]{2,6}$/) {
		$err .= "Ｅメールの入力内容が不正です<br>";
	}
	if ($in{url} ne '' && $in{url} !~ /^https?:\/\/[\w-.!~*'();\/?:\@&=+\$,%#]+$/) {
		$err .= "URL情報が不正です<br>";
	}
	error($err) if ($err);
}

#-----------------------------------------------------------
#  クッキー発行
#-----------------------------------------------------------
sub set_cookie {
	my @data = @_;
	
	my ($sec,$min,$hour,$mday,$mon,$year,$wday,undef,undef) = gmtime(time + 60*24*60*60);
	my @mon  = qw|Jan Feb Mar Apr May Jun Jul Aug Sep Oct Nov Dec|;
	my @week = qw|Sun Mon Tue Wed Thu Fri Sat|;
	
	# 時刻フォーマット
	my $gmt = sprintf("%s, %02d-%s-%04d %02d:%02d:%02d GMT",
				$week[$wday],$mday,$mon[$mon],$year+1900,$hour,$min,$sec);
	
	# URLエンコード
	my $cook;
	foreach (@data) {
		s/(\W)/sprintf("%%%02X", unpack("C", $1))/eg;
		$cook .= "$_<>";
	}
	
	print "Set-Cookie: $cf{cookie_id}=$cook; expires=$gmt\n";
}

#-----------------------------------------------------------
#  文字数カウント for UTF-8
#-----------------------------------------------------------
sub count_str {
	my ($str) = @_;
	
	# UTF-8定義
	my $byte1 = '[\x00-\x7f]';
	my $byte2 = '[\xC0-\xDF][\x80-\xBF]';
	my $byte3 = '[\xE0-\xEF][\x80-\xBF]{2}';
	my $byte4 = '[\xF0-\xF7][\x80-\xBF]{3}';
	
	my $i = 0;
	while ($str =~ /($byte1|$byte2|$byte3|$byte4)/gx) {
		$i++;
	}
	return $i;
}

#-----------------------------------------------------------
#  mimeエンコード
#  [quote] http://www.din.or.jp/~ohzaki/perl.htm#JP_Base64
#-----------------------------------------------------------
sub mime_unstructured_header {
  my $oldheader = shift;
  jcode::convert(\$oldheader,'euc','utf8');
  my ($header,@words,@wordstmp,$i);
  my $crlf = $oldheader =~ /\n$/;
  $oldheader =~ s/\s+$//;
  @wordstmp = split /\s+/, $oldheader;
  for ($i = 0; $i < $#wordstmp; $i++) {
    if ($wordstmp[$i] !~ /^[\x21-\x7E]+$/ and
	$wordstmp[$i + 1] !~ /^[\x21-\x7E]+$/) {
      $wordstmp[$i + 1] = "$wordstmp[$i] $wordstmp[$i + 1]";
    } else {
      push(@words, $wordstmp[$i]);
    }
  }
  push(@words, $wordstmp[-1]);
  foreach my $word (@words) {
    if ($word =~ /^[\x21-\x7E]+$/) {
      $header =~ /(?:.*\n)*(.*)/;
      if (length($1) + length($word) > 76) {
	$header .= "\n $word";
      } else {
	$header .= $word;
      }
    } else {
      $header = add_encoded_word($word, $header);
    }
    $header =~ /(?:.*\n)*(.*)/;
    if (length($1) == 76) {
      $header .= "\n ";
    } else {
      $header .= ' ';
    }
  }
  $header =~ s/\n? $//mg;
  $crlf ? "$header\n" : $header;
}
sub add_encoded_word {
  my ($str, $line) = @_;
  my $result;
  my $ascii = '[\x00-\x7F]';
  my $twoBytes = '[\x8E\xA1-\xFE][\xA1-\xFE]';
  my $threeBytes = '\x8F[\xA1-\xFE][\xA1-\xFE]';
  while (length($str)) {
    my $target = $str;
    $str = '';
    if (length($line) + 22 +
	($target =~ /^(?:$twoBytes|$threeBytes)/o) * 8 > 76) {
      $line =~ s/[ \t\n\r]*$/\n/;
      $result .= $line;
      $line = ' ';
    }
    while (1) {
      my $encoded = '=?ISO-2022-JP?B?' .
      b64encode(jcode::jis($target,'euc','z')) . '?=';
      if (length($encoded) + length($line) > 76) {
	$target =~ s/($threeBytes|$twoBytes|$ascii)$//o;
	$str = $1 . $str;
      } else {
	$line .= $encoded;
	last;
      }
    }
  }
  $result . $line;
}
# [quote] http://www.tohoho-web.com/perl/encode.htm
sub b64encode {
    my $buf = shift;
    my ($mode,$tmp,$ret);
    my $b64 = "ABCDEFGHIJKLMNOPQRSTUVWXYZ"
                . "abcdefghijklmnopqrstuvwxyz"
                . "0123456789+/";
	
    $mode = length($buf) % 3;
    if ($mode == 1) { $buf .= "\0\0"; }
    if ($mode == 2) { $buf .= "\0"; }
    $buf =~ s/(...)/{
        $tmp = unpack("B*", $1);
        $tmp =~ s|(......)|substr($b64, ord(pack("B*", "00$1")), 1)|eg;
        $ret .= $tmp;
    }/eg;
    if ($mode == 1) { $ret =~ s/..$/==/; }
    if ($mode == 2) { $ret =~ s/.$/=/; }
    
    return $ret;
}

