#!/usr/local/bin/perl

#┌─────────────────────────────────
#│ WEB MART : find.cgi - 2021/04/25
#│ copyright (c) kentweb, 1997-2021
#│ https://www.kent-web.com/
#└─────────────────────────────────

# モジュール宣言
use strict;
use CGI::Carp qw(fatalsToBrowser);
use lib "./lib";
use CGI::Minimal;

# 外部ファイル取り込み
require './init.cgi';
my %cf = set_init();

# データ受理
CGI::Minimal::max_read_size($cf{maxdata});
my $cgi = CGI::Minimal->new;
cgi_err('容量オーバー') if ($cgi->truncated);
my %in = parse_form($cgi);

# 処理分岐
find_cart();

#-----------------------------------------------------------
#  商品検索
#-----------------------------------------------------------
sub find_cart {
	# 引数
	$in{pg} =~ s/\D//g;
	$in{sort} =~ s/[^1-4]//g;
	
	# 戻り先を覚える
	my ($back,$url_enc) = set_cookie($in{back}) if ($in{back});
	
	# 軽減税率
	my %red = read_redtax() if ($cf{tax_per} > 0);
	
	# キーワードを配列化
	$in{word} =~ s/　/ /g;
	my @wd = split(/\s+/,$in{word});
	
	# UTF-8定義
	my $byte1 = '[\x00-\x7f]';
	my $byte2 = '[\xC0-\xDF][\x80-\xBF]';
	my $byte3 = '[\xE0-\xEF][\x80-\xBF]{2}';
	my $byte4 = '[\xF0-\xF7][\x80-\xBF]{3}';
	
	# データファイルオープン
	my (@log,@tmp);
	open(IN,"$cf{datadir}/mart.dat") or error("open err: mart.dat");
	while(<IN>) {
		my ($item,$price,$memo) = (split(/<>/))[1..3];
		
		# キーワード
		if ($in{word}) {
			my $flg;
			foreach my $wd (@wd) {
				if ("$item $memo" =~ /^(?:$byte1|$byte2|$byte3|$byte4)*?\Q$wd\E/i) {
					$flg++;
				} else {
					$flg = 0;
					last;
				}
			}
			next if (!$flg);
		}
		
		# ソート振り分け
		if ($in{sort} <= 2) {
			push(@tmp,$price);
		} elsif ($in{sort} == 3) {
			unshift(@log,$_);
			next;
		}
		push(@log,$_);
	}
	close(IN);
	
	# 高価順
	if ($in{sort} == 2) {
		@log = @log[sort {$tmp[$b] <=> $tmp[$a]} 0 .. $#tmp];
	# 安価順
	} elsif ($in{sort} == 1) {
		@log = @log[sort {$tmp[$a] <=> $tmp[$b]} 0 .. $#tmp];
	}
	
	# ヒット数
	my $hits = @log;
	
	# ページ数定義
	my $pg = $in{pg} || 0;
	
	# ページボタン作成
	my $pbtn = make_btn($hits,$pg);
	
	# 表示範囲
	my $begin = $pg;
	my $end   = $pg + $cf{pg_max} - 1;
	if ($end > $hits - 1) { $end = $hits - 1; }
	
	# オプション
	my %sort = (1 => '価格の安い順', 2 => '価格の高い順', 3 => '登録の新着順', 4 => '登録の古い順');
	my $op_sort;
	foreach (1 .. 4) {
		if ($in{sort} == $_) {
			$op_sort .= qq|<option value="$_" selected>$sort{$_}</option>\n|;
		} else {
			$op_sort .= qq|<option value="$_">$sort{$_}</option>\n|;
		}
	}
	
	# テンプレート読み込み
	open(IN,"$cf{tmpldir}/find.html") or error('open err: find.html');
	my $tmpl = join('',<IN>);
	close(IN);
	
	# 置き換え
	$tmpl =~ s/!(\w+_cgi)!/$cf{$1}/g;
	$tmpl =~ s/!cmnurl!/$cf{cmnurl}/g;
	$tmpl =~ s/!word!/$in{word}/g;
	$tmpl =~ s/!hits!/$hits/g;
	$tmpl =~ s/<!-- op_sort -->/$op_sort/g;
	$tmpl =~ s|<!-- page_btn -->|<p>$pbtn</p>|g;
	
	if ($back) {
		print "Set-Cookie: $cf{cookie_find}=$url_enc\n";
	} else {
		$back = get_cookie();
	}
	$tmpl =~ s/!back_list!/$back/g;
	
	# テンプレート分割
	my ($head,$loop,$foot) = $tmpl =~ m|(.+)<!-- loop -->(.+?)<!-- /loop -->(.+)|s
			? ($1,$2,$3)
			: error("テンプレート不正");
	
	# 在庫機能
	my %zan;
	if ($cf{stock}) {
		open(IN,"$cf{datadir}/stock.dat") or error("open err: stock.dat");
		while (<IN>) {
			my ($code,$zan) = split(/<>/);
			$zan{$code} = $zan;
		}
		close(IN);
	} else {
		$loop =~ s|<!-- zai -->.+?<!-- /zai -->||s;
	}
	
	# 画面展開
	print "Content-type: text/html; charset=utf-8\n\n";
	print $head;
	
	# 検索ヒット
	for ($begin .. $end) {
		chomp($log[$_]);
		my ($code,$item,$price,$memo,$back,@ops) = split(/<>/,$log[$_]);
		
		# オプション
		my $opt;
		for my $i (0 .. $#{$cf{options}}) {
			next if ($ops[$i] eq '');
			
			my ($key,$nam) = split(/,/,$cf{options}[$i]);
			$opt .= qq|$nam ： <select name="$key">\n|;
			foreach my $op ( split(/\s+/,$ops[$i]) ) {
				$opt .= qq|<option value="$op">$op</option>\n|;
			}
			$opt .= qq|</select><br>\n|;
		}
		# 税表記
		my $tax;
		if ($cf{tax_per} == 0) {
			$tax = $cf{tax_class}[0];
		} elsif (defined $red{$code}) {
			$tax = $cf{tax_class}[1] . ":軽減税率対象";
		} else {
			$tax = $cf{tax_class}[1];
		}
		
		# 文字置き換え
		my $tmp = $loop;
		$tmp =~ s/!item!/$item/g;
		$tmp =~ s/!price!/comma($price)/eg;
		$tmp =~ s/!code!/$code/g;
		$tmp =~ s/!memo!/$memo/g;
		$tmp =~ s/!back!/$back/g;
		$tmp =~ s/<!-- option -->/$opt/g;
		$tmp =~ s/!tax!/$tax/g;
		
		# 在庫
		if ($cf{stock}) { $tmp =~ s/!zai!/defined($zan{$code}) ? $zan{$code} : 0/eg; }
		
		# 画像
		if (-f "$cf{imgdir}/$code.$cf{img_ext}") {
			$tmp =~ s|<!-- image -->|<img src="$cf{imgurl}/$code.jpg" alt="$code" class="find-img">|;
		}
		
		print $tmp;
	}
	
	# フッター
	print $foot;
	exit;
}

#-----------------------------------------------------------
#  ページボタン作成
#-----------------------------------------------------------
sub make_btn {
	my ($i,$pg) = @_;
	
	# 引数
	my $param = 'word=' . url_encode($in{word}) . "&amp;sort=$in{sort}";
	
	# ページ繰越数
	my $next = $pg + $cf{pg_max};
	my $back = $pg - $cf{pg_max};
	
	# ページ繰越ボタン作成
	my @pg;
	if ($back >= 0 || $next < $i) {
		my $flg;
		my ($w,$x,$y,$z) = (0,1,0,$i);
		while ($z > 0) {
			if ($pg == $y) {
				$flg++;
				push(@pg,qq!<span class="pg-on">$x</span>!);
			} else {
				push(@pg,qq!<span class="pg-off"><a href="$cf{find_cgi}?$param&amp;pg=$y">$x</a></span>!);
			}
			$x++;
			$y += $cf{pg_max};
			$z -= $cf{pg_max};
			
			if ($flg) { $w++; }
			last if ($w >= 5 && @pg >= 10);
		}
	}
	while( @pg >= 11 ) { shift(@pg); }
	my $ret = join('', @pg);
	if ($back >= 0) {
		$ret = qq!<span class="pg-off"><a href="$cf{find_cgi}?$param&amp;pg=$back">&lt;</a></span>\n! . $ret;
	}
	if ($next < $i) {
		$ret .= qq!<span class="pg-off"><a href="$cf{find_cgi}?$param&amp;pg=$next">&gt;</a></span>\n!;
	}
	$ret;
}

#-----------------------------------------------------------
#  URLエンコード
#-----------------------------------------------------------
sub url_encode {
	my $wd = shift;
	$wd =~ s/([^\w ])/'%'.unpack('H2', $1)/eg;
	$wd =~ tr/ /+/;
	return $wd;
}

#-----------------------------------------------------------
#  クッキー取得
#-----------------------------------------------------------
sub get_cookie {
	# クッキー取得
	$ENV{HTTP_COOKIE} =~ /$cf{cookie_find}=([^=;]+);?/;
	my $back = $1;
	$back =~ s/\s//g;
	
	# URLデコード
	$back =~ s/%([0-9A-Fa-f][0-9A-Fa-f])/pack("H2",$1)/eg;
	
	# URL書式をチェック
	if ($back =~ /^https?:\/\/[\w-.!~*'();\/?:\@&=+\$,%#]+$/i) {
		return $back;
	} else {
		return '/';
	}
}

#-----------------------------------------------------------
#  クッキー発行
#-----------------------------------------------------------
sub set_cookie {
	my $back = shift;
	
	if ($back =~ /^https?:\/\/[\w-.!~*'();\/?:\@&=+\$,%#]+$/i) {
		
		# URLエンコード
		my $url_enc = $back;
		$url_enc =~ s/(\W)/sprintf("%%%02X", unpack("C", $1))/eg;
		
		return ($back,$url_enc);
	}
}

