#!/usr/local/bin/perl

#
# MOBILE CART : mobcart.cgi - 2011/10/29
# Copyright (c) KentWeb
# http://www.kent-web.com/
#

# W[錾
use strict;
use CGI::Carp qw(fatalsToBrowser);
use lib "./lib";
use CGI::Minimal;
use Jcode;

# ݒt@CF
require "./init.cgi";
my %cf = &init;

# f[^
CGI::Minimal::max_read_size($cf{maxdata});
my $cgi = CGI::Minimal->new;
&error('eʃI[o[') if ($cgi->truncated);
my %in = &parse_form($cgi);

# 
if ($in{law_list}) { &law_list; }
if ($in{mode} eq 'cart' || $in{cart_in}) { &cart_in; }
if ($in{mode} eq 'addr') { &addr_form; }
if ($in{mode} eq 'haiso') { &haiso_form; }
if ($in{mode} eq 'conf') { &conf_form; }
if ($in{mode} eq 'send') { &send_form; }
&cart_list;

#-----------------------------------------------------------
#  Xgꗗ
#-----------------------------------------------------------
sub cart_list {
	if ($cf{cate_key} && $in{back_catelist}) { &cate_list; }

	# ́iy[Wyэwj
	my ($pg,$cart,$num,$size,$col);
	foreach ( $cgi->param() ) {
		if (/^pg(\d+)/) {
			$pg = $1;
			last;
		} elsif (/^cart(\d+)/) {
			$cart = $1;
			last;
		}
	}
	# ŵƂ
	if ($cart > 0) { &cart_in($cart); }
	$pg ||= 0;

	# JeSʂ̂Ƃ
	if ($cf{cate_key} && $in{cate} eq '') {
		my $flg;
		foreach ( keys(%{$cf{cate}}) ) {
			if (defined($in{"cate$_"})) {
				$flg++;
				$in{cate} = $_;
				last;
			}
		}
		if (!$flg) { &cate_list; }
	}

	# f[^ǂݏo
	my ($i,@log);
	open(IN,"$cf{logfile}") or &error("open err: $cf{logfile}");
	while (<IN>) {
		my ($no,$cate,$code,$nam,$price,$num,$size,$col,$ex) = split(/<>/);

		# W
		next if ($cf{cate_key} && $in{cate} != $cate);

		$i++;
		next if ($i < $pg + 1);
		next if ($i > $pg + $cf{pg_max});

		push(@log,$_);
	}
	close(IN);

	# JSg
	my $cart;
	foreach ( $cgi->param('cart') ) {
		my ($no,$num,$size,$col) = split(/,/);
		$cart .= qq|<input type="hidden" name="cart" value="$_" />\n|;
	}
	if ($in{cate} ne '') {
		$cart .= qq|<input type="hidden" name="cate" value="$in{cate}" />\n|;
	}

	# ev[gǍ
	open(IN,"$cf{tmpldir}/list.html") or &error("open err: list.html");
	my $tmpl = join('', <IN>);
	close(IN);

	# u
	$tmpl =~ s/!cgi_title!/$cf{cgi_title}/g;
	$tmpl =~ s/!([a-z]+_cgi)!/$cf{$1}/g;
	$tmpl =~ s/!homepage!/$cf{homepage}/g;
	$tmpl =~ s/<!-- cart -->/$cart/g;

	if ($cf{cate_key}) {
		$tmpl =~ s/!cate-name!/$cf{cate}->{$in{cate}}/g;
	} else {
		$tmpl =~ s/<!-- catemode_begin -->.+?<!-- catemode_end -->//gs;
	}

	# ev[g
	my ($head,$loop,$foot);
	if ($tmpl =~ /(.+)<!-- loop_begin -->(.+)<!-- loop_end -->(.+)/s) {
		($head,$loop,$foot) = ($1,$2,$3);
	} else {
		&error("ڰĕs");
	}

	# wb_
	print "Content-type: text/html\n\n";
	print $head;

	foreach (@log) {
		chomp;
		my ($no,$cat,$code,$nam,$price,$num,$size,$col,$ex1,$ex2,$ex3) = split(/<>/);

		# 摜
		my $img;
		if ($ex1) { $img .= qq|<a href="$cf{imgurl}/$no-1$ex1">1</a>\n|; }
		if ($ex2) { $img .= qq|<a href="$cf{imgurl}/$no-2$ex2">2</a>\n|; }
		if ($ex3) { $img .= qq|<a href="$cf{imgurl}/$no-3$ex3">3</a>\n|; }

		my $tmp = $loop;
		$tmp =~ s/!num!/$no/g;
		$tmp =~ s/!item!/$nam/g;
		$tmp =~ s/!code!/$code/g;
		$tmp =~ s/!price!/&comma($price)/eg;

		# 摜
		if ($img) {
			$tmp =~ s/!image!/$img/g;
		} else {
			$tmp =~ s/<!-- image_begin -->.+<!-- image_end -->//s;
		}

		# TCY
		if ($size eq '') {
			$tmp =~ s/<!-- size_begin -->.+<!-- size_end -->//s;
		} else {
			$tmp =~ s/<!-- op_size -->/&option($size)/e;
		}
		# F
		if ($col eq '') {
			$tmp =~ s/<!-- color_begin -->.+<!-- color_end -->//s;
		} else {
			$tmp =~ s/<!-- op_color -->/&option($col)/e;
		}

		print $tmp;
	}

	# y[WJz
	my $next = $pg + $cf{pg_max};
	my $back = $pg - $cf{pg_max};

	# Oy[W
	if ($back >= 0) {
		$foot =~ s/!back!/$back/g;
	} else {
		$foot =~ s/<!-- back_begin -->.+<!-- back_end -->//s;
	}
	# y[W
	if ($next < $i) {
		$foot =~ s/!next!/$next/g;
	} else {
		$foot =~ s/<!-- next_begin -->.+<!-- next_end -->//s;
	}

	# tb^
	&footer($foot);
}

#-----------------------------------------------------------
#  v_E쐬
#-----------------------------------------------------------
sub option {
	my $opt = shift;

	my $ret;
	foreach my $op ( split(/,/, $opt) ) {
		$ret .= qq|<option value="$op">$op</option>\n|;
	}
	$ret;
}

#-----------------------------------------------------------
#  JeS
#-----------------------------------------------------------
sub cate_list {
	my $cart;
	foreach ( $cgi->param('cart') ) {
		$cart .= qq|<input type="hidden" name="cart" value="$_">\n|;
	}

	# ev[gǍ
	open(IN,"$cf{tmpldir}/cate.html") or &error("open err: cate.html");
	my $tmpl = join('', <IN>);
	close(IN);

	# u
	$tmpl =~ s/!cgi_title!/$cf{cgi_title}/g;
	$tmpl =~ s/!([a-z]+_cgi)!/$cf{$1}/g;
	$tmpl =~ s/!homepage!/$cf{homepage}/g;
	$tmpl =~ s/<!-- cart -->/$cart/g;

	# ev[g
	my ($head,$loop,$foot);
	if ($tmpl =~ /(.+)<!-- loop_begin -->(.+)<!-- loop_end -->(.+)/s) {
		($head,$loop,$foot) = ($1,$2,$3);
	} else {
		&error("ڰĕs");
	}

	# wb_
	print "Content-type: text/html\n\n";
	print $head;

	foreach ( sort{ $a <=> $b }keys(%{$cf{cate}}) ) {
		my $tmp = $loop;
		$tmp =~ s/!cat-no!/$_/g;
		$tmp =~ s/!cat-name!/$cf{cate}->{$_}/g;
		print $tmp;
	}

	# tb^
	&footer($foot);
}

#-----------------------------------------------------------
#  w
#-----------------------------------------------------------
sub cart_in {
	my ($cart_data) = @_;

	# 폜
	my $del_cart;
	if (!$cart_data) {
		foreach ( $cgi->param() ) {
			if (/^dele(\d+)/) {
				$del_cart = $1;
				last;
			}
		}
	}

	# 
	if ($in{back}) {
		&cart_list;
	} elsif ($in{next}) {
		$in{next} = '';
		&addr_form;
	} elsif ($in{top_back}) {
		&cate_list;
	}

	# JSWJ
	my ($flg,@cart);
	foreach ( $cgi->param('cart') ) {
		my ($no,$num,$size,$col) = split(/,/);

		# JSǉŊɓvfꍇ́AʂAbv
		if ($cart_data && $no == $cart_data && $in{"size$cart_data"} eq $size && $in{"col$cart_data"} eq $col) {
			$flg++;
			$num += $in{"num$cart_data"};
			$_ = "$cart_data,$num,$in{\"size$cart_data\"},$in{\"col$cart_data\"}";
		}
		push(@cart,$_);
	}

	# JS̒gɒǉ
	if ($cart_data && !$flg) {
		unshift(@cart,"$cart_data,$in{\"num$cart_data\"},$in{\"size$cart_data\"},$in{\"col$cart_data\"}");
	}

	# f[^ڔF
	my (%name,%code,%size,%col,%pri);
	open(IN,"$cf{logfile}") or &error("open err: $cf{logfile}");
	while (<IN>) {
		my ($no,$cate,$code,$nam,$price,$num,$size,$col) = split(/<>/);

		$name{$no} = $nam;
		$code{$no} = $code;
		$size{$no} = $size;
		$col{$no}  = $col;
		$pri{$no}  = $price;
	}
	close(IN);

	# ev[gǍ
	open(IN,"$cf{tmpldir}/cart.html") or &error("open err: cart.html");
	my $tmpl = join('', <IN>);
	close(IN);

	# u
	$tmpl =~ s/!cgi_title!/$cf{cgi_title}/g;
	$tmpl =~ s/!([a-z]+_cgi)!/$cf{$1}/g;

	# ev[g
	my ($head,$loop,$foot);
	if ($tmpl =~ /(.+)<!-- loop_begin -->(.+)<!-- loop_end -->(.+)/s) {
		($head,$loop,$foot) = ($1,$2,$3);
	} else {
		&error("ڰĕs");
	}

	# wb_
	print "Content-type: text/html\n\n";
	print $head;

	my $all = 0;
	foreach (@cart) {
		my ($no,$num,$size,$col) = split(/,/);

		# 폜̂Ƃ
		next if ($del_cart && $del_cart == $no);

		# z
		my $kei = $pri{$no} * $num;
		$all += $kei;

		my $tmp = $loop;
		$tmp =~ s/!item!/$name{$no}/g;
		$tmp =~ s/!code!/$code{$no}/g;
		$tmp =~ s/!price!/&comma($kei)/eg;
		$tmp =~ s/!nos!/$num/g;
		$tmp =~ s/!cart!/$no,$num,$size,$col/;
		$tmp =~ s/!num!/$no/g;

		# TCY
		if ($size eq '') {
			$tmp =~ s/<!-- size_begin -->.+<!-- size_end -->//s;
		} else {
			$tmp =~ s/!size!/$size/;
		}
		# F
		if ($col eq '') {
			$tmp =~ s/<!-- color_begin -->.+<!-- color_end -->//s;
		} else {
			$tmp =~ s/!color!/$col/;
		}

		print $tmp;
	}

	# v
	$foot =~ s/!all!/&comma($all)/e;

	# tb^
	&footer($foot);
}

#-----------------------------------------------------------
#  Z͉
#-----------------------------------------------------------
sub addr_form {
	# Oɖ߂
	if ($in{back}) { &cart_in; }

	# 
	my $errflg;
	if ($in{next}) {
		$in{next} = '';

		# `FbN
		my $err;
		if ($in{name} eq '') { $err .= 'O,'; }
		if ($in{email} !~ /^[\w\.\-]+\@[\w\.\-]+\.[a-zA-Z]{2,}$/) { $err .= 'e-mail,'; }
		if ($in{tel} eq '') { $err .= 'db,'; }
		if ($in{zip} eq '') { $err .= 'X֔ԍ,'; }
		if ($in{pref} eq '') { $err .= 's{,'; }
		if ($in{addr} eq '') { $err .= 'Z,'; }

		# 
		if ($err) {
			$err =~ s/,$//;
			$errflg = qq|<span style="color:red">ERROR:$errsł.</span><br />|;
		}
		elsif ($in{haiso} == 0) { &conf_form; }
		elsif ($in{haiso} == 1) { &haiso_form; }
	}

	# JSg
	my $cart;
	foreach ( $cgi->param('cart') ) {
		my ($no,$num,$size,$col) = split(/,/);
		$cart .= qq|<input type="hidden" name="cart" value="$_" />\n|;
	}

	# x@
	my $payment;
	foreach (0 .. $#{$cf{payment}}) {
		my ($val) = (split(/,/, $cf{payment}->[$_]))[0];
		if ($in{payment} == $_) {
			$payment .= qq|<input type="radio" name="payment" value="$_" checked="checked">$val<br />\n|;
		} else {
			$payment .= qq|<input type="radio" name="payment" value="$_">$val<br />\n|;
		}
	}
	# zB
	my $op_deli;
	foreach (0 .. $#{$cf{deli}}) {
		if ($in{deli} eq $_) {
			$op_deli .= qq|<option value="$_" selected="selected">$cf{deli}->[$_]</option>\n|;
		} else {
			$op_deli .= qq|<option value="$_">$cf{deli}->[$_]</option>\n|;
		}
	}
	# s{
	my $op_pref;
	foreach (0 .. $#{$cf{pref}}) {
		my ($val) = (split(/,/, $cf{pref}->[$_]))[0];
		if ($in{pref} eq $_) {
			$op_pref .= qq|<option value="$_" selected="selected">$val</option>\n|;
		} else {
			$op_pref .= qq|<option value="$_">$val</option>\n|;
		}
	}
	# z
	my $haiso;
	my @haiso = ('z͏LZ','z͕ʂ̏Z');
	foreach (0,1) {
		if ($in{haiso} == $_) {
			$haiso .= qq|<input type="radio" name="haiso" value="$_" checked="checked">$haiso[$_]<br />\n|;
		} else {
			$haiso .= qq|<input type="radio" name="haiso" value="$_">$haiso[$_]<br />\n|;
		}
	}

	# ev[gǍ
	open(IN,"$cf{tmpldir}/addr.html") or &error("open err: addr.html");
	my $tmpl = join('', <IN>);
	close(IN);

	# u
	$tmpl =~ s/!cgi_title!/$cf{cgi_title}/g;
	$tmpl =~ s/!([a-z]+_cgi)!/$cf{$1}/g;
	$tmpl =~ s/!payment!/$payment/g;
	$tmpl =~ s/<!-- op_deli -->/$op_deli/g;
	$tmpl =~ s/<!-- op_pref -->/$op_pref/g;
	$tmpl =~ s/!(name|email|tel|zip|addr|mon|day)!/$in{$1}/g;
	$tmpl =~ s/<!-- cart -->/$cart/g;
	$tmpl =~ s/!haiso!/$haiso/g;
	$tmpl =~ s/<!-- error -->/$errflg/g;

	# \
	print "Content-type: text/html\n\n";
	&footer($tmpl);
}

#-----------------------------------------------------------
#  z͉
#-----------------------------------------------------------
sub haiso_form {
	# O
	my $errflg;
	if ($in{back}) {
		$in{back} = '';
		&addr_form;

	# 
	} elsif ($in{next}) {
		# `FbN
		my $err;
		if ($in{name2} eq '') { $err .= 'O,'; }
		if ($in{tel2} eq '') { $err .= 'db,'; }
		if ($in{zip2} eq '') { $err .= 'X֔ԍ,'; }
		if ($in{pref2} eq '') { $err .= 's{,'; }
		if ($in{addr2} eq '') { $err .= 'Z,'; }
		if ($err) {
			$err =~ s/,$//;
			$errflg = qq|<span style="color:red">ERROR:$errsł.</span><br />|;
		} else {
			&conf_form;
		}
	}

	# JSg
	my $cart;
	foreach ( $cgi->param('cart') ) {
		my ($no,$num,$size,$col) = split(/,/);
		$cart .= qq|<input type="hidden" name="cart" value="$_" />\n|;
	}
	# Z
	my @in = qw|payment mon day deli name email tel zip pref addr haiso|;
	my $addr;
	foreach (@in) {
		$addr .= qq|<input type="hidden" name="$_" value="$in{$_}" />\n|;
	}

	# s{
	my $op_pref;
	foreach (0 .. $#{$cf{pref}}) {
		my ($val) = (split(/,/, $cf{pref}->[$_]))[0];
		if ($in{pref2} eq $_) {
			$op_pref .= qq|<option value="$_" selected="selected">$val</option>\n|;
		} else {
			$op_pref .= qq|<option value="$_">$val</option>\n|;
		}
	}

	# ev[gǍ
	open(IN,"$cf{tmpldir}/haiso.html") or &error("open err: haiso.html");
	my $tmpl = join('', <IN>);
	close(IN);

	# u
	$tmpl =~ s/!cgi_title!/$cf{cgi_title}/g;
	$tmpl =~ s/!([a-z]+_cgi)!/$cf{$1}/g;
	$tmpl =~ s/<!-- op_pref -->/$op_pref/g;
	$tmpl =~ s/!(name2|tel2|zip2|addr2)!/$in{$1}/g;
	$tmpl =~ s/<!-- cart -->/$cart/g;
	$tmpl =~ s/<!-- addr -->/$addr/g;
	$tmpl =~ s/<!-- error -->/$errflg/g;

	# wb_
	print "Content-type: text/html\n\n";
	&footer($tmpl);
}

#-----------------------------------------------------------
#  mF
#-----------------------------------------------------------
sub conf_form {
	# f[^ڔF
	my (%name,%code,%size,%col,%pri);
	open(IN,"$cf{logfile}") or &error("open err: $cf{logfile}");
	while (<IN>) {
		my ($no,$cate,$code,$nam,$price,$num,$size,$col) = split(/<>/);

		$name{$no} = $nam;
		$code{$no} = $code;
		$size{$no} = $size;
		$col{$no}  = $col;
		$pri{$no}  = $price;
	}
	close(IN);

	# Z
	my @in = qw|payment mon day deli name email tel zip pref addr haiso name2 tel2 zip2 addr2 pref2|;
	my $addr;
	foreach (@in) {
		$addr .= qq|<input type="hidden" name="$_" value="$in{$_}" />\n|;
	}

	# ev[gǍ
	open(IN,"$cf{tmpldir}/conf.html") or &error("open err: conf.html");
	my $tmpl = join('', <IN>);
	close(IN);

	# u
	$tmpl =~ s/!cgi_title!/$cf{cgi_title}/g;
	$tmpl =~ s/!([a-z]+_cgi)!/$cf{$1}/g;
	#$tmpl =~ s/<!-- op_pref -->/$op_pref/g;
	$tmpl =~ s/!(name2|tel2|zip2|addr2)!/$in{$1}/g;
	$tmpl =~ s/<!-- addr -->/$addr/g;
	#$tmpl =~ s/<!-- error -->/$errflg/g;

	# ev[g
	my ($head,$loop,$foot);
	if ($tmpl =~ /(.+)<!-- loop_begin -->(.+)<!-- loop_end -->(.+)/s) {
		($head,$loop,$foot) = ($1,$2,$3);
	} else {
		&error("ڰĕs");
	}

	# wb_
	print "Content-type: text/html\n\n";
	print $head;

	# JSg
	my $all = 0;
	foreach ( $cgi->param('cart') ) {
		my ($no,$num,$size,$col) = split(/,/);

		# z
		my $kei = $pri{$no} * $num;
		$all += $kei;

		my $tmp = $loop;
		$tmp =~ s/!item!/$name{$no}/g;
		$tmp =~ s/!code!/$code{$no}/g;
		$tmp =~ s/!price!/&comma($kei)/eg;
		$tmp =~ s/!nos!/$num/g;
		$tmp =~ s/!num!/$no/g;

		# TCY
		if ($size eq '') {
			$tmp =~ s/<!-- size_begin -->.+<!-- size_end -->//s;
		} else {
			$tmp =~ s/!size!/$size/;
		}
		# F
		if ($col eq '') {
			$tmp =~ s/<!-- color_begin -->.+<!-- color_end -->//s;
		} else {
			$tmp =~ s/!color!/$col/;
		}

		print $tmp;

		print qq|<input type="hidden" name="cart" value="$_" />\n|;
	}

	# v
	$foot =~ s/!shokei!/&comma($all)/e;

	# /萔
	my ($soryo,$cost) = &calc_cart($all);
	$all = $all + $soryo + $cost;

	$foot =~ s/!cost!/&comma($cost)/e;
	$foot =~ s/!soryo!/&comma($soryo)/e;
	$foot =~ s/!all!/&comma($all)/e;
	$foot =~ s/!(name|email|tel|addr|zip)!/$in{$1}/g;

	# x@
	my ($pay) = (split(/,/,$cf{payment}->[$in{payment}]))[0];
	$foot =~ s/!payment!/$pay/g;

	# zB
	my $deli;
	if ($in{mon} && $in{day}) { $deli = "$in{mon}$in{day} "; }
	if ($in{deli} ne '') { $deli .= $cf{deli}->[$in{deli}]; }
	$foot =~ s/!deli!/$deli/g;

	# s{
	my ($pref) = split(/,/, $cf{pref}->[$in{pref}]);
	$foot =~ s/!pref!/$pref/g;

	# z悠
	if ($in{haiso} == 1) {
		$foot =~ s/!(name2|tel2|addr2|zip2)!/$in{$1}/g;

		my ($pref2) = split(/,/, $cf{pref}->[$in{pref2}]);
		$foot =~ s/!pref2!/$pref2/g;
	} else {
		$foot =~ s/<!-- haiso_begin -->.+<!-- haiso_end -->//s;
	}

	# tb^
	&footer($foot);
}

#-----------------------------------------------------------
#  M
#-----------------------------------------------------------
sub send_form {
	# 
	if ($in{back}) {
		$in{back} = '';
		if ($in{haiso} == 1) { &haiso_form; }
		else { &addr_form; }
	}

	# f[^ڔF
	my (%name,%code,%size,%col,%pri);
	open(IN,"$cf{logfile}") or &error("open err: $cf{logfile}");
	while (<IN>) {
		my ($no,$cate,$code,$nam,$price,$num,$size,$col) = split(/<>/);

		$name{$no} = $nam;
		$code{$no} = $code;
		$size{$no} = $size;
		$col{$no}  = $col;
		$pri{$no}  = $price;
	}
	close(IN);

	# ev[gǍ
	open(IN,"$cf{tmpldir}/mail.txt") or &error("open err: mail.txt");
	my $tmpl = join('', <IN>);
	close(IN);

	my $all = 0;
	my $order;
	foreach ( $cgi->param('cart') ) {
		my ($no,$num,$size,$col) = split(/,/);

		# z
		my $kei = $pri{$no} * $num;
		$all += $kei;
		$kei = &comma($kei);

		$order .= "$name{$no} (:$num)\n$code{$no}\n$kei~\n";

		if ($size ne "") {
			my @size = split(/,/, $size{$no});
			$order .= "$cf{opt_1}:$size[$size]\n";
		}
		if ($col ne "") {
			my @col = split(/,/, $col{$no});
			$order .= "$cf{opt_2}:$col[$col]\n";
		}
		$order .= "\n";
	}
	$order =~ s/\n\n$//;
	$tmpl =~ s/!order!/$order/g;
	$tmpl =~ s/!shokei!/&comma($all)/eg;

	# /萔
	my ($soryo,$cost) = &calc_cart($all);
	$all = $all + $soryo + $cost;

	$tmpl =~ s/!soryo!/&comma($soryo)/eg;
	$tmpl =~ s/!cost!/&comma($cost)/eg;
	$tmpl =~ s/!all!/&comma($all)/eg;
	$tmpl =~ s/!(name|email|tel|zip|addr|name2|tel2|zip2|addr2)!/$in{$1}/g;

	# s{
	my ($pref) = split(/,/, $cf{pref}->[$in{pref}]);
	my ($pref2) = split(/,/, $cf{pref}->[$in{pref}]) if ($in{pref2} ne '');
	$tmpl =~ s/!pref!/$pref/g;
	$tmpl =~ s/!pref2!/$pref2/g;

	# Ԏ擾
	my ($min,$hour,$mday,$mon,$year) = (localtime(time))[1..5];
	my $date  = sprintf("%04d/%02d/%02d-%02d:%02d", $year+1900,$mon+1,$mday,$hour,$min);
	my $date2 = sprintf("%02d%02d%02d", $year-100,$mon+1,$mday);
	my $logdata = "$cf{logdir}/" . sprintf("%04d%02d", $year+1900,$mon+1) . ".cgi";
	$tmpl =~ s/!date!/$date/g;

	# ԍ
	open(DAT,"+< $cf{numfile}") or &error("open err: $cf{numfile}");
	eval "flock(DAT, 2);";
	my $num = <DAT> + 1;
	seek(DAT, 0, 0);
	print DAT $num;
	truncate(DAT, tell(DAT));
	close(DAT);

	# Oۑ
	open(OUT,">> $logdata");
	eval "flock(OUT, 2);";
	print OUT "$date<>$date2-$num<>$all<>$in{name}<>$in{email}<>\n";
	close(OUT);

	# ԍ
	$num = sprintf("%06d", $num);
	$tmpl =~ s/!number!/$num/g;

	# zB
	my $deli;
	if ($in{mon} && $in{day}) { $deli = "$in{mon}$in{day} "; }
	if ($in{deli} ne '') { $deli .= $cf{deli}->[$in{deli}]; }
	$tmpl =~ s/!deli!/$deli/g;

	# x@
	my ($pay) = (split(/,/,$cf{payment}->[$in{payment}]))[0];
	$tmpl =~ s/!pay!/$pay/g;

	# MIMEGR[h
	my $msub = Jcode->new("[($in{name}l)")->mime_encode;

	# {R[hϊ
	Jcode::convert(\$tmpl, 'jis', 'sjis');

	# sendmailR}h
	my $scmd = "$cf{sendmail} -t -i";
	if ($cf{sendm_f}) {
		$scmd .= " -f $in{email}";
	}

	# sendmailM
	open(MAIL,"| $scmd") or &error("Ms");
	print MAIL "To: $cf{master}, $in{email}\n";
	print MAIL "From: $in{email}\n";
	print MAIL "Subject: $msub\n";
	print MAIL "MIME-Version: 1.0\n";
	print MAIL "Content-type: text/plain; charset=ISO-2022-JP\n";
	print MAIL "Content-Transfer-Encoding: 7bit\n";
	print MAIL "X-Mailer: $cf{version}\n\n";
	print MAIL $tmpl;
	close(MAIL);

	# ev[g
	my $file;
	if ($cf{zeus_serv} && $in{payment} == $#{$cf{payment}}) {
		$file = 'send-credit.html';
	} else {
		$file = 'send.html';
	}

	# ev[gǍ
	open(IN,"$cf{tmpldir}/$file") or &error("open err: $file");
	my $tmpl = join('', <IN>);
	close(IN);

	# u
	my $tel = $in{tel};
	$tel =~ s/\D//g;
	$tmpl =~ s/!homepage!/$cf{homepage}/g;
	$tmpl =~ s/!clientip!/$cf{zeus_num}/g;
	$tmpl =~ s/!money!/$all/g;
	$tmpl =~ s/!tel!/$tel/g;
	$tmpl =~ s/!email!/$in{email}/g;
	$tmpl =~ s/!sendid!/$date2-$num/g;

	# ʕ\
	print "Content-type: text/html\n\n";
	print $tmpl;
	exit;
}

#-----------------------------------------------------------
#  /萔vZ
#-----------------------------------------------------------
sub calc_cart {
	my $all = shift;

	# 
	my $soryo = 0;
	if ($in{haiso} == 1) {
		($soryo) = (split(/,/, $cf{pref}->[$in{pref2}]))[1];
	} else {
		($soryo) = (split(/,/, $cf{pref}->[$in{pref}]))[1];
	}
	if ($cf{cari_zero} && $cf{cari_zero} <= $all) {
		$soryo = 0;
	}

	# 萔
	my ($cost) = (split(/,/, $cf{payment}->[$in{payment}]))[1];
	if ($cf{pay_zero} && $cf{pay_zero} < $all) {
		$cost = 0;
	}
	return ($soryo,$cost);
}

#-----------------------------------------------------------
#  菤@
#-----------------------------------------------------------
sub law_list {
	# ev[gǍ
	open(IN,"$cf{tmpldir}/law.html") or &error("open err: law.html");
	my $tmpl = join('', <IN>);
	close(IN);

	my $hidden;
	my @list = qw|payment mon day deli name email tel zip pref addr name2 tel2 zip2 pref2 addr2 haiso|;
	foreach (@list) {
		$hidden .= qq|<input type="hidden" name="$_" value="$in{$_}">\n|;
	}
	foreach ( $cgi->param('cart') ) {
		$hidden .= qq|<input type="hidden" name="cart" value="$_">\n|;
	}

	my $law_list;
	open(IN,"$cf{lawfile}") or &error("open err: $cf{lawfile}");
	while (<IN>) {
		my ($no,$key,$val) = split(/\t/);

		$law_list .= "[$key]<br />$val<br />\n";
	}
	close(IN);

	# u
	$tmpl =~ s/!([a-z]+_cgi)!/$cf{$1}/g;
	$tmpl =~ s/<!-- hidden -->/$hidden/g;
	$tmpl =~ s/!law_list!/$law_list/g;

	print "Content-type: text/html\n\n";
	print $tmpl;
	exit;
}

#-----------------------------------------------------------
#  tb^[
#-----------------------------------------------------------
sub footer {
	my $foot = shift;

	# 쌠\Li폜Eϋ֎~j
	my $copy = <<EOM;
<p style="margin-top:2em;text-align:center;font-family:Verdana,Helvetica,Arial;font-size:10px;">
- <a href="http://www.kent-web.com/" target="_top">Mobile Cart</a> -
</p>
EOM

	if ($foot =~ /(.+)(<\/body[^>]*>.*)/si) {
		print "$1$copy$2\n";
	} else {
		print "$foot$copy\n";
		print "</body></html>\n";
	}
	exit;
}

#-----------------------------------------------------------
#  G[
#-----------------------------------------------------------
sub error {
	my $err = shift;

	open(IN,"$cf{tmpldir}/error.html") or die;
	print "Content-type: text/html\n\n";
	while(<IN>) {
		s/!error!/$err/g;

		print;
	}
	close(IN);
	exit;
}

