#
# jCu holiday v2.0
# holiday.pl - 2011/08/28
# Copyright (c) KentWeb
# http://www.kent-web.com/
#
# yӎEƐӎz
#  R[h́uVtgJISvŋLqĂ܂BKvɉăGfB^
#    ŃR[hϊsĂB
#
# yp̎dz
#  (1) j`FbN[] (߂l: j̖́j
#      $holiday = &holiday::holiday($yyyy, $mm, $dd);
#
#  (2) j`FbN[Pʂ̏j] (߂l: j=1 jȊO=0j
#      %holiday = &holiday::holi_mon($yyyy, $mm);
#
#  (3) j擾 (߂l: 0= 1= ... 6=yj
#      $week = &holiday::get_week($yyyy, $mm, $dd);
#
#  (4) ́uv
#      $last_day = &holiday::last_day($yyyy, $mm);

package holiday;

#-----------------------------------------------------------
#  j`FbNij
#-----------------------------------------------------------
sub holiday {
	my ($y, $m, $d) = @_;
	$m = sprintf("%02d", $m);
	$d = sprintf("%02d", $d);

	# Œt
	#  mm-dd`
	my %holiday = (
		'01-01' => '',
		'02-11' => 'LO̓',
		'05-04' => '݂ǂ̓',
		'05-03' => '@LO',
		'05-05' => 'ǂ̓',
		'11-03' => '̓',
		'11-23' => 'ΘJӂ̓',
		'12-23' => 'Vca',
		'04-29' => 'a̓',
	);

	# nbs[}f[
	#  mm̑扽T
	my %happy = (
		'01-2' => 'l̓',
		'07-3' => 'C̓',
		'09-3' => 'hV̓',
		'10-2' => '̈̓',
	);

	# ̑
	my %others = (
		'furi' => 'U֋x',
		'koku' => '̋x',
	);

	# t̓
	my $shun = &vernal_equinox($y);

	# H̓
	my $shuu = &autumnal_equinox($y);

	$holiday{"03-$shun"} = 't̓';
	$holiday{"09-$shuu"} = 'H̓';

	# ƍ
	if (defined($holiday{"$m-$d"})) {
		return $holiday{"$m-$d"};
	}

	# jȂΐU֋x`FbN
	if (&get_week($y, $m, $d) == 1) {

		# nbs[}f[ƍ
		my $hit = &happy_monday($m, $d, \%happy);
		if ($hit) { return $hit; }

		# O߂
		my ($mday, $mon, $year, $wday) = &get_day($y, $m, $d, -1);

		# OjȂΐU֋x
		if (defined($holiday{"$mon-$mday"})) {
			return $others{'furi'};
		}
	}
	# 2007ȌA5/3,4ĵƂ  5/6U
	if ($y >= 2007 && $m == 5 && $d == 6) {

		if (&get_week($y, 5, 3) == 0 || &get_week($y, 5, 4) == 0) {
			return $others{'furi'};
		}
	}

	# ̋x@@hV̓ƏH̓ɋ܂ꂽj
	if ($y >= 2003 && $m == 9) {

		# O3jihV̓j
		my ($mday, $mon, $year, $wday) = &get_day($y, $m, $d, -1);
		my $mshu = int( ($mday - 1) / 7 ) + 1;

		# H̓
		my ($mday2, $mon2, $year2, $wday2) = &get_day($y, $m, $d, +1);

		if ($mshu == 3 && $wday == 1 && &autumnal_equinox($year2) == $mday2) {
			return $others{'koku'};
		}
	}
	return 0;
}

#-----------------------------------------------------------
#  nbs[}f[mF
#-----------------------------------------------------------
sub happy_monday {
	my ($mm, $dd, $happy) = @_;

	# ̑扽T
	my $mshu = int( ($dd - 1) / 7 ) + 1;

	# nbs[}f[ƍ
	my $hit;
	while ( my ($key, $val) = each(%{$happy}) ) {

		my ($mon, $shu) = split(/-/, $key);

		if ($mm == $mon && $mshu == $shu) {
			$hit = $val;
			last;
		}
	}
	return $hit;
}

#-----------------------------------------------------------
#  j`FbNiPʁj
#-----------------------------------------------------------
sub holi_mon {
	my ($y, $m) = @_;
	$m = sprintf("%02d", $m);

	# Œt
	#  mm-dd`
	my %holiday = (
		'01-01' => 1,
		'02-11' => 1,
		'05-04' => 1,
		'05-03' => 1,
		'05-05' => 1,
		'11-03' => 1,
		'11-23' => 1,
		'12-23' => 1,
		'04-29' => 1,
	);
	my %happy = (
		'01-2' => 1,
		'07-3' => 1,
		'09-3' => 1,
		'10-2' => 1,
	);
	if ($m == 3) {
		my $shun = &vernal_equinox($y);
		$holiday{"03-$shun"} = 1;
	} elsif ($m == 9) {
		my $shuu = &autumnal_equinox($y);
		$holiday{"09-$shuu"} = 1;
	}

	my $w = &get_week($y, $m, 1);
	my $last = &last_day($y,$m);
	my %day;
	foreach my $i (1 .. $last) {
		$i = sprintf("%02d", $i);

		# Œ
		if (defined($holiday{"$m-$i"})) { $day{$i}++; }

		# ĵƂ
		elsif ($w == 1) {

			# nbs[}f[ƍ
			my $hit = &happy_monday($m, $i, \%happy);
			if ($hit) { $day{$i}++; }

			# O߂
			my ($mday, $mon, $year, $wday) = &get_day($y, $m, $i, -1);

			# OjȂΐU֋x
			if (defined($holiday{"$mon-$mday"})) {
				$day{$i}++;
			}
		}

		# 2007ȌA5/3,4ĵƂ  5/6U
		elsif ($y >= 2007 && $m == 5 && $i == 6) {

			if (&get_week($y, 5, 3) == 0 || &get_week($y, 5, 4) == 0) {
				$day{$i}++;
			}
		}

		# ̋x@@hV̓ƏH̓ɋ܂ꂽj
		elsif ($y >= 2003 && $m == 9) {

			# O3jihV̓j
			my ($mday, $mon, $year, $wday) = &get_day($y, $m, $i, -1);
			my $mshu = int( ($mday - 1) / 7 ) + 1;

			# H̓
			my ($mday2, $mon2, $year2, $wday2) = &get_day($y, $m, $i, +1);

			if ($mshu == 3 && $wday == 1 && &autumnal_equinox($year2) == $mday2) {
				$day{$i}++;
			}
		}

		# j
		#my $ret = defined($day{$i}) ? 1 : 0;
		#push(@ret,$ret);

		# T
		$w = $w >= 6 ? 0 : ++$w;
	}
	return %day;
}

#-----------------------------------------------------------
#  TZo
#-----------------------------------------------------------
sub get_week {
	my ($yy, $mm, $dd) = @_;

	if ($mm == 1 || $mm == 2) {
		$yy--;
		$mm += 12;
	}
	int( $yy + int($yy / 4) - int($yy / 100) + int($yy / 400) + int((13 * $mm + 8) / 5) + $dd ) % 7;
}

#-----------------------------------------------------------
#  Zo
#-----------------------------------------------------------
sub get_day {
	my ($yy, $mm, $dd, $key) = @_;

	# 莞ԂZo
	my $time = &timelocal(0, 0, 12, $dd, $mm-1, $yy-1900) + (24 * 60 * 60 * $key);

	# NTZo
	my ($mday, $mon, $year, $wday) = (localtime($time))[3..6];
	$mday = sprintf("%02d", $mday);
	$mon  = sprintf("%02d", $mon+1);
	$year += 1900;
	return ($mday, $mon, $year, $wday);
}

#-----------------------------------------------------------
#  t̓
#-----------------------------------------------------------
sub vernal_equinox {
	my $yy = shift;

	my $dd;
	if ($yy < 2099) {
		$dd = int( 20.8431 + 0.242194 * ($yy - 1980) - int(($yy - 1980) / 4) );
	} elsif ($yy < 2155) {
		$dd = int( 21.8510 + 0.242194 * ($yy - 1980) - int(($yy - 1980) / 4) );
	}
	sprintf("%02d", $dd);
}

#-----------------------------------------------------------
#  H̓
#-----------------------------------------------------------
sub autumnal_equinox {
	my $yy = shift;

	my $dd;
	if ($yy < 2099) {
		$dd = int( 23.2488 + 0.242194 * ($yy - 1980) - int(($yy - 1980) / 4) );
	} elsif ($yy < 2155) {
		$dd = int( 24.2488 + 0.242194 * ($yy - 1980) - int(($yy - 1980) / 4) );
	}
	sprintf("%02d", $dd);
}

#-----------------------------------------------------------
#  ̖
#-----------------------------------------------------------
sub last_day {
	my ($yy, $mm) = @_;

	return (31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31) [$mm - 1]
	+ ($mm == 2 && (($yy % 4 == 0 && $yy % 100 != 0) || $yy % 400 == 0));
}

#-----------------------------------------------------------
#  WCu (timelocal.pl) p
#-----------------------------------------------------------
CONFIG: {
    local($[) = 0;
    @epoch = localtime(0);
    $tzmin = $epoch[2] * 60 + $epoch[1];	# minutes east of GMT
    if ($tzmin > 0) {
	$tzmin = 24 * 60 - $tzmin;		# minutes west of GMT
	$tzmin -= 24 * 60 if $epoch[5] == 70;	# account for the date line
    }

    $SEC = 1;
    $MIN = 60 * $SEC;
    $HR = 60 * $MIN;
    $DAYS = 24 * $HR;
    $YearFix = ((gmtime(946684800))[5] == 100) ? 100 : 0;
    1;
}

sub timegm {
    local($[) = 0;
    $ym = pack(C2, @_[5,4]);
    $cheat = $cheat{$ym} || &cheat;
    return -1 if $cheat<0;
    $cheat + $_[0] * $SEC + $_[1] * $MIN + $_[2] * $HR + ($_[3]-1) * $DAYS;
}

sub timelocal {
    local($[) = 0;
    $time = &timegm + $tzmin*$MIN;
    return -1 if $cheat<0;
    @test = localtime($time);
    $time -= $HR if $test[2] != $_[2];
    $time;
}

sub cheat {
    $year = $_[5];
    $month = $_[4];
    die "Month out of range 0..11 in timelocal.pl\n" 
	if $month > 11 || $month < 0;
    die "Day out of range 1..31 in timelocal.pl\n" 
	if $_[3] > 31 || $_[3] < 1;
    die "Hour out of range 0..23 in timelocal.pl\n"
	if $_[2] > 23 || $_[2] < 0;
    die "Minute out of range 0..59 in timelocal.pl\n"
	if $_[1] > 59 || $_[1] < 0;
    die "Second out of range 0..59 in timelocal.pl\n"
	if $_[0] > 59 || $_[0] < 0;
    $guess = $^T;
    @g = gmtime($guess);
    $year += $YearFix if $year < $epoch[5];
    $lastguess = "";
    while ($diff = $year - $g[5]) {
	$guess += $diff * (363 * $DAYS);
	@g = gmtime($guess);
	if (($thisguess = "@g") eq $lastguess){
	    return -1; #date beyond this machine's integer limit
	}
	$lastguess = $thisguess;
    }
    while ($diff = $month - $g[4]) {
	$guess += $diff * (27 * $DAYS);
	@g = gmtime($guess);
	if (($thisguess = "@g") eq $lastguess){
	    return -1; #date beyond this machine's integer limit
	}
	$lastguess = $thisguess;
    }
    @gfake = gmtime($guess-1); #still being sceptic
    if ("@gfake" eq $lastguess){
	return -1; #date beyond this machine's integer limit
    }
    $g[3]--;
    $guess -= $g[0] * $SEC + $g[1] * $MIN + $g[2] * $HR + $g[3] * $DAYS;
    $cheat{$ym} = $guess;
}


1;

