#!/usr/local/bin/perl

#
# Perl Checker - 2011/09/21
# Copyright (c) KentWeb
# http://www.kent-web.com/
#
#
# [ӎ]
# 1. ̃vO̓t[\tgłB
# 2. ̃vOgpȂ鑹Qɑ΂č҂͈؂̐ӔC
#    ܂B
#

# W[錾
use strict;
use CGI::Carp qw(fatalsToBrowser);

# o[W
my $version = 'PerlChecker v3.1';

#===========================================================
#  {ݒ
#===========================================================

# pX[h
#  pŃpX[hw肷ƁÃvO̎sɂ
#    pX[hK{ƂȂ܂B(p8ȓŎw)
my $password = '';

# CGIt@C̊gqihbg͋LqȂj
my @ext = ('cgi', 'pl');

# ő󗝃f[^iBytesj
# [] 10240Bytes = 10KB
my $maxdata = 1024;

#===========================================================
#  ݒ芮
#===========================================================

# f[^󂯎
my %in = &parse_form;

# ʕ\
&header;
print qq|<div align="center">\n|;

# pX[h`FbN
if ($password ne '') {
	if ($in{pass} eq '') {
		print "<p>pX[h͂Ă</p>\n";
		print qq|<form action="pcheck.cgi" method="post">\n|;
		print qq|<input type="password" name="pass" size="10">\n|;
		print qq|<input type="submit" value=" F "></form>\n|;
		print qq|</div>\n|;
		print qq|</body></html>\n|;
		exit;

	# Fؕs
	} elsif ($in{pass} ne $password) {
		&error('pX[hႢ܂');
	}
}

	# Ώۃt@C̊gq
	my ($msg,$ext);
	foreach (@ext) {
		$msg .= ".$_ ";
		$ext .= "$_|";
	}
	$ext =~ s/\|$//;

print <<"EOM";
<h3>Perl@`FbJ[</h3>
<table border="0" cellspacing="1">
<tr>
	<td>
		<ul>
		<li>tH[Ƀ`FbNt@C͂ĂB
		<li>gq <b>$msg</b> ̂ݗLłB
			<p>
				syntax OK @@㐳<br>
				syntax error @@G[
			</p>
		</ul>
	</td>
</tr>
</table>
<form action="pcheck.cgi" method="post">
<input type="hidden" name="pass" value="$in{pass}">
<input type="text" name="file" size="40" value="$in{file}">
<input type="submit" value="`FbN">
EOM

# ff`FbNJn
if ($in{file}) {

	print qq|<p><b>- ff -</b></p>\n|;

	# t@C`FbN
	if ($in{file} !~ /^[\.\/\w\-]+\.($ext)$/) {
		&error("t@Csł  $in{file}");
	}

	# ݊mF
	if (!-e $in{file}) {
		&error('t@C݂܂');
	}

	# 擪sǂݎ
	open(IN,"$in{file}");
	my $top = <IN>;
	close(IN);

	print <<EOM;
<table border="0" cellspacing="1">
<tr>
	<th>s`</th>
	<td>
EOM

	# s
	my $path;
	if ($top =~ /(.*)\r\n$/) {
		print "CR+LF (Win`)\n";
		$path = $1;

	} elsif ($top =~ /(.*)\r$/) {
		print "CRiMac`)\n";
		$path = $1;

	} elsif ($top =~ /(.*)\x0A$/) {
		print "LF (UNIX`)\n";
		$path = $1;

	} else {
		print "s\n";
		$path = 's';
	}

	print <<EOM;
	</td>
</tr><tr>
	<th>Perl̃pX</th>
	<td class="eng">$path</td>
</tr><tr>
	<th>T[oPerl<br>Ƃ̃`FbN</th>
	<td>
EOM

	# PerlpX`FbN
	$path =~ s/^\#\!\s*//;
	if (-e $path) {
		print "Ă܂B<br>\n";
	} else {
		print "pXŝ悤łB<br>\n";
	}

	# p[~bV
	print <<EOM;
	<span class="eng">$path</span></td>
</tr><tr>
	<th>p[~bV</th>
	<td>
EOM

	if (-x $in{file}) {
		print "sB\n";
	} else {
		print "s܂B\n";
	}

	# @`FbN
	print <<EOM;
	</td>
</tr><tr>
	<th>@`FbN</th>
	<td>
	<pre class="red eng">
EOM

	# Perl@`FbN
	open(PROC,"perl -c $in{file} 2>&1 |");
	print <PROC>;
	close(PROC);

	print <<EOM;
	</pre>
	</td>
</tr>
</table>
EOM
}

# 쌠\LF폜֎~
print <<"EOM";
<p class="eng" style="font-size:10px;">
- <a href="http://www.kent-web.com/">PerlChecker</a> -
</p>
</div>
</body>
</html>
EOM
exit;

#-----------------------------------------------------------
#  G[
#-----------------------------------------------------------
sub error {
	my $err = shift;

	print <<"EOM";
<p>$err</p>
</div>
</body>
</html>
EOM
	exit;
}

#-----------------------------------------------------------
#  wb_[
#-----------------------------------------------------------
sub header {
	print "Content-type: text/html\n\n";
	print <<EOM;
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<html lang="ja">
<head>
<meta http-equiv="content-type" content="text/html; charset=shift_jis">
<meta http-equiv="content-style-type" content="text/css">
<style type="text/css">
<!--
body,th,td { background:#f0f0f0; font-size:80%; }
pre.red { color:#dd0000; }
table { background:#8080c0; }
th { background:#dcdced; padding:10px; }
td { background:#fff; padding:10px; }
.eng { font-family:Verdana,Helvetica,Arial; }
-->
</style>
<title>$version</title>
</head>
<body>
EOM
}

#-----------------------------------------------------------
#  ̓`FbN
#-----------------------------------------------------------
sub sanit {
	local($_) = shift;

	s/[<>&"'%();+\0\r\n]//g;
	$_;
}

#-----------------------------------------------------------
#  tH[fR[h
#-----------------------------------------------------------
sub parse_form {
	my ($buf,%in);
	if ($ENV{REQUEST_METHOD} eq "POST") {
		&error('󗝂ł܂') if ($ENV{CONTENT_LENGTH} > $maxdata);
		read(STDIN, $buf, $ENV{CONTENT_LENGTH});
	} else {
		$buf = $ENV{QUERY_STRING};
	}
	foreach ( split(/&/, $buf) ) {
		my ($key,$val) = split(/=/);
		$val =~ tr/+/ /;
		$val =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("H2", $1)/eg;

		# svR[h
		$val =~ s/&/&amp;/g;
		$val =~ s/</&lt;/g;
		$val =~ s/>/&gt;/g;
		$val =~ s/"/&quot;/g;
		$val =~ s/'/&#39;/g;
		$val =~ s/[\r\n]//g;

		$in{$key} = $val;
	}
	return %in;
}

