#!/usr/local/bin/perl

#┌─────────────────────────────────
#│ Pie Chart : chart.cgi - 2013/11/04
#│ Copyright (c) KentWeb
#│ http://www.kent-web.com/
#└─────────────────────────────────

# モジュール取得
use strict;
use CGI::Carp qw(fatalsToBrowser);

# 設定ファイル
require "./init.cgi";
my %cf = init();

# データ受け取り
my %in = parse_form();

# 処理分岐
if ($in{mode} eq 'chart') { chart_data(); }
form_enq();

#-----------------------------------------------------------
#  グラフ画面
#-----------------------------------------------------------
sub chart_data {
	my $msg = shift;

	# 基本設定
	my %set = read_init();

	# 項目データ
	my %vt;
	open(IN,"$cf{datadir}/vote.dat") or error("open err: vote.dat");
	while(<IN>) {
		chomp;
		my ($no,$vt) = split(/\t/);

		$vt{$no} = $vt;
	}
	close(IN);

	# 投票データ
	my (@log,@tmp);
	open(IN,"$cf{datadir}/item.dat") or error("open err: item.dat");
	while(<IN>) {
		chomp;
		my ($no,$item) = split(/\t/);

		push(@tmp,$vt{$no});
		push(@log,qq|["$item",$vt{$no}],\n|);
	}
	close(IN);

	# ソート
	@log = @log[sort{$tmp[$b] <=> $tmp[$a]} 0 .. $#tmp];

	# スカラ変数化
	my $data = join("\n",@log);
	$data =~ s/,$//;
	$data =~ s/\n$//;

	# テンプレート読み込み
	open(IN,"$cf{tmpldir}/chart.html") or error("open err: chart.html");
	my $tmpl = join('', <IN>);
	close(IN);

	$tmpl =~ s/!chart_cgi!/$cf{chart_cgi}/g;
	$tmpl =~ s/!data!/$data/g;
	$tmpl =~ s/!(title|subttl)!/$set{$1}/g;
	$tmpl =~ s|<!-- message -->|<p>$msg</p>| if ($msg ne '');

	# 3D
	if ($set{solid} == 1) {
		$tmpl =~ s|//is3D:|is3D:|g;
	}

	# 画面表示
	print "Content-type: text/html; charset=utf-8\n\n";
	footer($tmpl);
}

#-----------------------------------------------------------
#  投票画面
#-----------------------------------------------------------
sub form_enq {
	# 基本設定
	my %set = read_init();

	# 投票
	if ($in{vote}) {
		# クッキー処理
		check_cookie($set{wait});

		# 受理
		vote_data($set{sel});
	}

	# 回答フォーム方式（radio or checkbox）
	my ($type,$sel_msg);
	if ($set{sel} == 0) {
		$type = 'radio';
		$sel_msg = '単一回答';
	} else {
		$type = 'checkbox';
		$sel_msg = '複数回答可';
	}

	# テンプレート読み込み
	open(IN,"$cf{tmpldir}/form.html") or error("open err: form.html");
	my $tmpl = join('', <IN>);
	close(IN);

	$tmpl =~ s/!(back_url|chart_cgi)!/$cf{$1}/g;
	$tmpl =~ s/!(title|subttl)!/$set{$1}/g;
	$tmpl =~ s/!select!/$sel_msg/g;

	# テンプレート分割
	my ($head,$loop,$foot) = split(/<!-- loop -->/s,$tmpl);

	# 画面表示
	print "Content-type: text/html; charset=utf-8\n\n";
	print $head;

	open(IN,"$cf{datadir}/item.dat") or error("open err: item.dat");
	while(<IN>) {
		chomp;
		my ($no,$item) = split(/\t/);

		my $tmp = $loop;
		$tmp =~ s/!item!/$item/g;
		$tmp =~ s/!box!/<input type="$type" name="vote" value="$no">/g;
		print $tmp;
	}
	close(IN);

	footer($foot);
}

#-----------------------------------------------------------
#  投票受付
#-----------------------------------------------------------
sub vote_data {
	my $seltype = shift;

	# 入力チェック
	if ($cf{postonly} && $ENV{REQUEST_METHOD} ne 'POST') {
		error("不正な投稿です");
	}

	# 回答形式
	my %sel;
	if ($seltype == 0) {
		if ($in{vote} =~ /\0/) { error("複数回答はできません"); }
		$sel{$in{vote}}++;
	} else {
		foreach ( split(/\0/,$in{vote}) ) {
			$sel{$_}++;
		}
	}

	my @log;
	open(DAT,"+< $cf{datadir}/vote.dat") or error("open err: vote.dat");
	eval "flock(DAT, 2);";
	while(<DAT>) {
		my ($no,$vote) = split(/\t/);

		if (defined($sel{$no})) {
			chomp($vote);
			$vote++;
			$_ = "$no\t$vote\n";
		}
		push(@log,$_);
	}
	seek(DAT, 0, 0);
	print DAT @log;
	truncate(DAT, tell(DAT));
	close(DAT);

	# 完了メッセージ
	chart_data('投票を受け付けました。ありがとうございました。');
}

#-----------------------------------------------------------
#  エラー処理
#-----------------------------------------------------------
sub error {
	my $msg = shift;

	open(IN,"$cf{tmpldir}/mesg.html") or die;
	my $tmpl = join('', <IN>);
	close(IN);

	$tmpl =~ s/!title!/ERROR!/g;
	$tmpl =~ s/!message!/<span style="color:red">$msg<\/spa>/g;
	$tmpl =~ s/!btn-msg!/前画面に戻る/g;
	$tmpl =~ s/!onclick!/history.back()/g;

	print "Content-type: text/html; charset=utf-8\n\n";
	print $tmpl;
	exit;
}

#-----------------------------------------------------------
#  完了文言
#-----------------------------------------------------------
sub doc_msg {
	my $msg = shift;

	open(IN,"$cf{tmpldir}/mesg.html") or error("open err: mesg.html");
	my $tmpl = join('', <IN>);
	close(IN);

	$tmpl =~ s/!title!/完了しました。/g;
	$tmpl =~ s/!message!/$msg/g;
	$tmpl =~ s/!btn-msg!/TOPに戻る/g;
	$tmpl =~ s/!onclick!/javascript:window.location='$cf{chart_cgi}'/g;

	print "Content-type: text/html; charset=utf-8\n\n";
	print $tmpl;
	exit;
}

#-----------------------------------------------------------
#  フッター
#-----------------------------------------------------------
sub footer {
	my $foot = shift;

	# 著作権表記（削除・改変禁止）
	my $copy = <<EOM;
<p style="text-align:center;font-size:10px;font-family:Verdana,Helvetica,Arial;margin-top:3em;">
- <a href="http://www.kent-web.com/" target="_top">PieChart</a> -
</p>
EOM

	if ($foot =~ /(.+)(<\/body[^>]*>.*)/si) {
		print "$1$copy$2\n";
	} else {
		print "$foot$copy\n";
		print "</body></html>\n";
	}
	exit;
}

#-----------------------------------------------------------
#  クッキー処理
#-----------------------------------------------------------
sub check_cookie {
	my $wait = shift;

	# クッキー取得
	$ENV{HTTP_COOKIE} =~ /piechart=(.+);?/;
	my $cook = $1;

	my $time = time;
	if ($cook && $wait && $time - $cook < $wait*60*60) { error('投票はお一人一回までです'); }

	# 90日間有効
	my ($sec,$min,$hour,$mday,$mon,$year,$wday,undef,undef) = gmtime(time + 90*24*60*60);
	my @mon  = qw|Jan Feb Mar Apr May Jun Jul Aug Sep Oct Nov Dec|;
	my @week = qw|Sun Mon Tue Wed Thu Fri Sat|;

	# 時刻フォーマット
	my $gmt = sprintf("%s, %02d-%s-%04d %02d:%02d:%02d GMT",
				$week[$wday],$mday,$mon[$mon],$year+1900,$hour,$min,$sec);

	print "Set-Cookie: piechart=$time; expires=$gmt;\n";
}

