#!/usr/local/bin/perl

#
# PONNY CHAT : init.cgi - 2011/09/12
# Copyright (c) KentWeb
# http://www.kent-web.com/
#

# W[錾
use strict;
use CGI::Carp qw(fatalsToBrowser);

# ݒt@CF
require "./init.cgi";
my %cf = &init;

# f[^
my %in = &parse_form;

# 
if ($in{mode} eq "form") { &form; }
if ($in{mode} eq "into") { &form2; }
if ($in{comment} && $in{mode} eq "regist") { &regist; }
if ($in{mode} eq "out") { &room_out; }
&chat_data;

#-----------------------------------------------------------
#  tH[ : O
#-----------------------------------------------------------
sub form {
	my ($op_retime,$op_colors);
	foreach (@{$cf{retime}}) {
		if ($cf{retime_defo} == $_) {
			$op_retime .= qq|<option value="$_" selected>$_b\n|;
		} else {
			$op_retime .= qq|<option value="$_">$_b\n|;
		}
	}
	foreach (0 .. $#{$cf{colors}}) {
		my (undef,$nam) = split(/,/, $cf{colors}->[$_]);
		$op_colors .= qq|<option value="$_">$nam\n|;
	}

	open(IN,"$cf{tmpldir}/form.html") or &error("open err: form.html");
	my $tmpl = join('', <IN>);
	close(IN);

	$tmpl =~ s/!chat_title!/$cf{chat_title}/g;
	$tmpl =~ s/!chat_cgi!/$cf{chat_cgi}/g;
	$tmpl =~ s/!homepage!/$cf{homepage}/g;
	$tmpl =~ s/<!-- op_retime -->/$op_retime/g;
	$tmpl =~ s/<!-- op_colors -->/$op_colors/g;

	print "Content-type: text/html\n\n";
	print $tmpl;
	exit;
}

#-----------------------------------------------------------
#  tH[ : 
#-----------------------------------------------------------
sub form2 {
	$in{name} ||= $ENV{REMOTE_ADDR};

	# ē
	&regist('into');

	my ($op_retime,$op_colors);
	foreach (@{$cf{retime}}) {
		if ($in{retime} == $_) {
			$op_retime .= qq|<option value="$_" selected>$_b\n|;
		} else {
			$op_retime .= qq|<option value="$_">$_b\n|;
		}
	}
	foreach (0 .. $#{$cf{colors}}) {
		my (undef,$nam) = split(/,/, $cf{colors}->[$_]);
		if ($in{color} == $_) {
			$op_colors .= qq|<option value="$_" selected>$nam\n|;
		} else {
			$op_colors .= qq|<option value="$_">$nam\n|;
		}
	}

	# OGR[h
	my $enam = &url_encode($in{name});

	open(IN,"$cf{tmpldir}/form2.html") or &error("open err: form2.html");
	my $tmpl = join('', <IN>);
	close(IN);

	$tmpl =~ s/!chat_cgi!/$cf{chat_cgi}/g;
	$tmpl =~ s/<!-- op_retime -->/$op_retime/g;
	$tmpl =~ s/<!-- op_colors -->/$op_colors/g;
	$tmpl =~ s/!name!/$in{name}/g;
	$tmpl =~ s/!enam!/$enam/g;

	print "Content-type: text/html\n\n";
	print $tmpl;
	exit;
}

#-----------------------------------------------------------
#  L\
#-----------------------------------------------------------
sub chat_data {
	if ($in{retime} eq '') { $in{retime} = $cf{retime_defo}; }
	my ($retime,$meta);
	if ($in{retime} == 0) {
		$retime = '蓮';
	} else {
		$retime = "$in{retime}b";
		$meta = qq|<meta http-equiv="refresh" content="$in{retime}; url=$cf{chat_cgi}?retime=$in{retime}">|;
	}

	open(IN,"$cf{tmpldir}/data.html") or &error("open err: data.html");
	my $tmpl = join('', <IN>);
	close(IN);

	$tmpl =~ s/!retime!/$retime/g;
	$tmpl =~ s/<!-- meta_refresh -->/$meta/;

	# ev[g
	my ($head,$loop,$foot);
	if ($tmpl =~ /(.+)<!-- loop_begin -->(.+)<!-- loop_end -->(.+)/s) {
		($head,$loop,$foot) = ($1,$2,$3);
	} else {
		&error("ev[gsł");
	}

	print "Content-type: text/html\n\n";
	print $head;

	open(IN,"$cf{logfile}") or &error("open err: $cf{logfile}");
	while (<IN>) {
		my ($date,$name,$com,$col,undef) = split(/<>/);

		my $tmp = $loop;
		$tmp =~ s|!name!|<span style="color:$col">$name</span>|g;
		$tmp =~ s|!comment!|<span style="color:$col">$com</span>|g;
		$tmp =~ s/!date!/$date/g;
		print $tmp;
	}
	close(IN);

	# tb^
	&footer($foot);
}

#-----------------------------------------------------------
#  
#-----------------------------------------------------------
sub regist {
	my $job = shift;

	# 擾
	my ($sec,$min,$hour,$mday,$mon) = (localtime(time))[0..4];
	my $date = sprintf("%02d/%02d-%02d:%02d:%02d",$mon+1,$mday,$hour,$min,$sec);

	# O`Ԃ𔻒f
	my ($name,$color);
	if ($job eq 'into') {
		$in{comment} = "<b>$in{name}</b>$cf{msg_in}";
		$name = $cf{master_name};
		$color = $cf{rep_color};
	} elsif ($job eq 'out') {
		$in{comment} = "<b>$in{enam}</b>$cf{msg_out}";
		$name = $cf{master_name};
		$color = $cf{rep_color};
	} else {
		$name = $in{name};
		($color,undef) = split(/,/, $cf{colors}->[$in{color}]);
	}

	my ($i,@log);
	open(DAT,"+< $cf{logfile}") or &error("open err: $cf{logfile}");
	eval "flock(DAT, 2);";
	while(<DAT>) {
		$i++;
		push(@log,$_);
		last if ($i >= $cf{maxlog}-1);
	}
	unshift (@log,"$date<>$name<>$in{comment}<>$color<>$ENV{REMOTE_ADDR}\n");
	seek(DAT, 0, 0);
	print DAT @log;
	truncate(DAT, tell(DAT));
	close(DAT);
}

#-----------------------------------------------------------
#  ގ
#-----------------------------------------------------------
sub room_out {
	# ގē
	&regist('out');

	open(IN,"$cf{tmpldir}/out.html") or &error("open err: out.html");
	my $tmpl = join('', <IN>);
	close(IN);

	$tmpl =~ s/!name!/$in{enam}/g;
	$tmpl =~ s/!homepage!/$cf{homepage}/g;

	print "Content-type: text/html\n\n";
	print $tmpl;
	exit;
}

#-----------------------------------------------------------
#  tH[fR[h
#-----------------------------------------------------------
sub parse_form {
	my $buf = $ENV{QUERY_STRING};
	my %in;
	foreach ( split(/&/, $buf) ) {
		my ($key,$val) = split(/=/);
		$val =~ tr/+/ /;
		$val =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("H2", $1)/eg;

		# svR[h
		$val =~ s/&/&amp;/g;
		$val =~ s/</&lt;/g;
		$val =~ s/>/&gt;/g;
		$val =~ s/"/&quot;/g;
		$val =~ s/[\r\n]//g;

		$in{$key} = $val;
	}
	return %in;
}

#-----------------------------------------------------------
#  tb^[
#-----------------------------------------------------------
sub footer {
	my $foot = shift;

	# 쌠\Li폜Eϋ֎~j
	my $copy = <<EOM;
<p style="margin-top:2em;text-align:center;font-family:verdana,helvetica,arial;font-size:10px;">
- <a href="http://www.kent-web.com/" target="_top">PONNY CHAT</a> -
</p>
EOM

	if ($foot =~ /(.+)(<\/body[^>]*>.*)/si) {
		print "$1$copy$2\n";
	} else {
		print "$foot$copy\n";
		print "</body></html>\n";
	}
	exit;
}

#-----------------------------------------------------------
#  G[
#-----------------------------------------------------------
sub error {
	my $err = shift;

	open(IN,"$cf{tmpldir}/error.html") or die;
	my $tmpl = join('', <IN>);
	close(IN);

	$tmpl =~ s/!error!/$err/g;

	print "Content-type: text/html\n\n";
	print $tmpl;
	exit;
}

#-----------------------------------------------------------
#  URLGR[h
#-----------------------------------------------------------
sub url_encode {
	my $str = shift;

	$str =~ s/([^\w ])/'%'.unpack('H2', $1)/eg;
	$str =~ tr/ /+/;
	return $str;
}


