#┌─────────────────────────────
#│ reCaptcha v3 認証モジュール v1.00
#│ recaptcha.pl - 2025/08/10
#│ copyright (c) kentweb
#│ https://www.kent-web.com/
#└─────────────────────────────
# [使い方]
# 第1引数 : シークレットキー
# 第2引数 : 'recaptchaToken'の返り値

use strict;
use LWP::UserAgent;
use JSON::PP;

#-----------------------------------------------------------
#  Google reCAPTCHA v3
#-----------------------------------------------------------
sub recaptcha {
	my ($secret,$token) = @_;
	
	my $url = 'https://www.google.com/recaptcha/api/siteverify';
	my $json = JSON::PP->new;
	my $ua = LWP::UserAgent->new();
	
	my $res = $ua->post(
		$url,
		{
			remoteip => $ENV{REMOTE_ADDR},
			response => $token,
			secret   => $secret,
		},
	);
	# トークン検証
	if ( $res->is_success() ) {
		my $cont = $res->decoded_content();
		my $jres = $json->decode($cont);
		
		return $$jres{score};
    } else {
		return;
	}
}



1;

