#!/usr/local/bin/perl

#┌─────────────────────────────────
#│ Quick DB : admin.cgi - 2022/05/28
#│ copyright (c) kentweb, 1997-2022
#│ https://www.kent-web.com/
#└─────────────────────────────────

# モジュール宣言
use strict;
use CGI::Carp qw(fatalsToBrowser);
use vars qw(%in %cf);
use lib "./lib";
use CGI::Minimal;
use CGI::Session;
use Digest::SHA::PurePerl qw(sha256_base64);

# 設定ファイル認識
require "./init.cgi";
%cf = set_init();

# データ受理
CGI::Minimal::max_read_size($cf{maxdata});
my $cgi = CGI::Minimal->new;
error('容量オーバー') if ($cgi->truncated);
%in = parse_form($cgi);

# 認証
require "./lib/login.pl";
auth_login();

# 管理モード
if ($in{add_data}) { add_data(); }
if ($in{edt_data}) { edt_data(); }
if ($in{csv_data}) { csv_data(); }
if ($in{pass_mgr}) { pass_mgr(); }

# メニュー画面
menu_html();

#-----------------------------------------------------------
#  メニュー画面
#-----------------------------------------------------------
sub menu_html {
	header("メニューTOP");
	print <<EOM;
<div class="menu-msg">選択ボタンを押してください。</div>
<form action="$cf{admin_cgi}" method="post">
<input type="hidden" name="sid" value="$in{sid}">
<table class="form-tbl">
<tr>
	<th>選択</th>
	<th width="280">処理メニュー</th>
</tr><tr>
	<td><input type="submit" name="add_data" value="選択"></td>
	<td>新規データ作成</td>
</tr><tr>
	<td><input type="submit" name="edt_data" value="選択"></td>
	<td>データ管理</td>
</tr><tr>
	<td><input type="submit" name="csv_data" value="選択"></td>
	<td>CSVデータ管理</td>
</tr><tr>
	<td><input type="submit" name="pass_mgr" value="選択"></td>
	<td>パスワード管理</td>
</tr><tr>
	<td><input type="submit" name="logoff" value="選択"></td>
	<td>ログアウト</td>
</tr>
</table>
</form>
</div>
</body>
</html>
EOM
	exit;
}

#-----------------------------------------------------------
#  新規データ追加
#-----------------------------------------------------------
sub add_data {
	# 新規追加
	if ($in{job} eq 'new') { new_data(); }
	
	# 修正のとき
	my ($no,$ttl,$com,$cat1,$cat2,$cat3,$ex,$w,$h) = @_;
	$com =~ s/<br>/\n/g;
	my %cat = (1 => $cat1, 2 => $cat2, 3 => $cat3);
	
	# 引数定義
	my $mode = $in{edt_data} ? 'edt_data' : 'add_data';
	my $job = $in{job} ? $in{job} . 2 : 'new';
	
	# 画面表示
	header('登録フォーム');
	back_btn();
	print <<EOM;
<div id="ttl">■ 登録フォーム</div>
<form action="$cf{admin_cgi}" method="post" enctype="multipart/form-data">
<input type="hidden" name="sid" value="$in{sid}">
<input type="hidden" name="$mode" value="1">
<input type="hidden" name="job" value="$job">
<input type="hidden" name="no" value="$in{no}">
<table class="form-tbl">
EOM

	foreach my $i (1 .. 3) {
		print qq|<tr><th>$cf{categ}->[$i-1]</th>|;
		print qq|<td><select name="cat$i">\n|;
		
		foreach my $op (0 .. $#{$cf{"cate$i"}}) {
			if ($cat{$i} == $op) {
				print qq|<option value="$op" selected>$cf{"cate$i"}->[$op]\n|;
			} else {
				print qq|<option value="$op">$cf{"cate$i"}->[$op]\n|;
			}
		}
		
		print qq|</select></td></tr>\n|;
	}
	
	print <<EOM;
<tr>
	<th>タイトル</th>
	<td><input type="text" name="title" size="50" value="$ttl"></td>
</tr><tr>
	<th>本文</th>
	<td><textarea name="comment" cols="70" rows="12">$com</textarea></td>
</tr><tr>
	<th>添付</th>
	<td>
		<input type="file" name="upfile" size="45">
EOM

	if ($ex) {
		print qq|&nbsp; [<a href="$cf{uplurl}/$no.$ex" target="_blank">添付</a>]\n|;
		print qq|<input type="checkbox" name="del" value="1">削除\n|;
	}
	
	print <<EOM;
	</td>
</tr>
</table>
<input type="submit" value="送信する">
</form>
</div>
</div>
</body>
</html>
EOM
	exit;
}

#-----------------------------------------------------------
#  データ管理
#-----------------------------------------------------------
sub edt_data {
	# 修正フォーム
	if ($in{job} eq 'edit' && $in{no}) {
		
		my @log;
		open(DB,"$cf{datadir}/db.cgi") or error('open err: db.cgi');
		while(<DB>) {
			my ($no,$ttl,$com,$cat1,$cat2,$cat3,$ex,$w,$h) = split(/<>/);
			
			if ($in{no} == $no) {
				@log = ($no,$ttl,$com,$cat1,$cat2,$cat3,$ex,$w,$h);
				last;
			}
		}
		close(DB);
		
		add_data(@log);
	
	# 修正実行
	} elsif ($in{job} eq 'edit2' && $in{no}) {
		
		# 入力チェック
		check_input();
		
		# 添付アップロード
		my ($exn,$wn,$hn) = upload($in{no}) if ($in{upfile});
		
		my (@tmp1,@tmp2,@tmp3,@data);
		open(DB,"+< $cf{datadir}/db.cgi") or error('open err: db.cgi');
		while(<DB>) {
			chomp;
			my ($no,$ttl,$com,$cat1,$cat2,$cat3,$ex,$w,$h) = split(/<>/);
			
			if ($in{no} == $no) {
				
				# 新規添付
				if ($exn) {
					# 拡張子が異なる場合
					if ($ex && $ex ne $exn) {
						unlink("$cf{upldir}/$no.$ex");
						unlink("$cf{upldir}/$no-s.$ex") if (-f "$cf{upldir}/$no-s.$ex");
					}
					($ex,$w,$h) = ($exn,$wn,$hn);
				
				# 添付削除
				} elsif ($in{del}) {
					unlink("$cf{upldir}/$no.$ex");
					unlink("$cf{upldir}/$no-s.$ex") if (-f "$cf{upldir}/$no-s.$ex");
					$ex = $w = $h = '';
				}
				$_ = "$no<>$in{title}<>$in{comment}<>$in{cat1}<>$in{cat2}<>$in{cat3}<>$ex<>$w<>$h<>";
				($cat1,$cat2,$cat3) = ($in{cat1},$in{cat2},$in{cat3});
			}
			push(@tmp1,$cat1);
			push(@tmp2,$cat2);
			push(@tmp3,$cat3);
			push(@data,"$_\n");
		}
		
		# ソート
		@data = @data[sort{$tmp1[$a] <=> $tmp1[$b] || $tmp2[$a] <=> $tmp2[$b] || $tmp3[$a] <=> $tmp3[$b]} 0 .. $#tmp1];
		
		# 更新
		seek(DB,0,0);
		print DB @data;
		truncate(DB,tell(DB));
		close(DB);
		
		# 完了画面
		message('修正を完了しました','edt_data');
	
	# 削除
	} elsif ($in{job} eq 'dele' && $in{no}) {
		
		# 削除情報
		my %del;
		foreach ( $cgi->param('no') ) {
			$del{$_}++;
		}
		
		my @log;
		open(DB,"+< $cf{datadir}/db.cgi") or error('open err: db.cgi');
		while(<DB>) {
			chomp;
			my ($no,$ttl,$com,$cat1,$cat2,$cat3,$ex,$w,$h) = split(/<>/);
			
			if (defined($del{$no})) {
				unlink("$cf{upldir}/$no.$ex");
				unlink("$cf{upldir}/$no-s.$ex") if (-f "$cf{upldir}/$no-s.$ex");
				next;
			}
			push(@log,"$_\n");
		}
		seek(DB,0,0);
		print DB @log;
		truncate(DB,tell(DB));
		close(DB);
	}
	
	# 画面表示
	header('データ修正/削除');
	back_btn();
	print <<EOM;
<div id="ttl">■ データ修正/削除</div>
<form action="$cf{admin_cgi}" method="post">
<input type="hidden" name="sid" value="$in{sid}">
<input type="hidden" name="edt_data" value="1">
処理：
<select name="job">
<option value="edit">修正
<option value="dele">削除
</select>
<input type="submit" value="送信">
<br>
<table class="form-tbl">
<tr>
	<th>選択</th>
	<th>分類</th>
	<th>タイトル</th>
	<th>本文</th>
</tr>
EOM

	open(DB,"$cf{datadir}/db.cgi") or error('open err: db.cgi');
	while(<DB>) {
		my ($no,$ttl,$com,$cat1,$cat2,$cat3,$ex,$w,$h) = split(/<>/);
		my $cat = "$cf{cate1}[$cat1] &gt; $cf{cate2}[$cat2] &gt; $cf{cate3}[$cat3]";
		$com = cut_str($com,30);
		
		print qq|<tr><td class="ta-c"><input type="checkbox" name="no" value="$no"></td>|;
		print qq|<td>$cat</td>|;
		print qq|<td>$ttl</td>|;
		print qq|<td>$com</td></tr>\n|;
	}
	close(DB);
	
	print <<EOM;
</table>
</form>
</div>
</div>
</body>
</html>
EOM
	exit;
}

#-----------------------------------------------------------
#  データ作成
#-----------------------------------------------------------
sub new_data {
	# 入力チェック
	check_input();
	
	# 採番
	open(DAT,"+< $cf{datadir}/num.dat") or error('open err: num.dat');
	my $num = <DAT> + 1;
	seek(DAT,0,0);
	print DAT $num;
	truncate(DAT,tell(DAT));
	close(DAT);
	
	# 添付アップロード
	my ($ex,$w,$h) = upload($num) if ($in{upfile});
	
	# データ展開
	my (@tmp1,@tmp2,@tmp3,@data);
	open(DB,"+< $cf{datadir}/db.cgi") or error('open err: db.cgi');
	while(<DB>) {
		my ($no,$ttl,$com,$cat1,$cat2,$cat3,$ex,$w,$h) = split(/<>/);
		
		push(@tmp1,$cat1);
		push(@tmp2,$cat2);
		push(@tmp3,$cat3);
		push(@data,$_);
	}
	
	# 追加データ
	push(@tmp1,$in{cat1});
	push(@tmp2,$in{cat2});
	push(@tmp3,$in{cat3});
	push(@data,"$num<>$in{title}<>$in{comment}<>$in{cat1}<>$in{cat2}<>$in{cat3}<>$ex<>$w<>$h<>\n");
	
	# ソート
	@data = @data[sort{$tmp1[$a] <=> $tmp1[$b] || $tmp2[$a] <=> $tmp2[$b] || $tmp3[$a] <=> $tmp3[$b]} 0 .. $#tmp1];
	
	# 更新
	seek(DB,0,0);
	print DB @data;
	truncate(DB,tell(DB));
	close(DB);
	
	# 完了画面
	message('新規追加しました','new_data');
}

#-----------------------------------------------------------
#  CSVデータ管理
#-----------------------------------------------------------
sub csv_data {
	# ダウン
	if ($in{dl}) {
		require "./lib/jacode.pl";
		
		# 改行
		my $br = $in{br} eq 'win' ? "\r\n" : "\n";
		
		my $items = "データID,タイトル,本文,$cf{categ}[0],$cf{categ}[1],$cf{categ}[2],拡張子,横幅(画像),縦幅(画像)";
		jcode::convert(\$items,'sjis','utf8');
		
		# ダウンロード用ヘッダ
		print "Content-type: application/octet-stream\n";
		print "Content-Disposition: attachment; filename=data.csv\n\n";
		
		# バイナリ出力 (Windowsサーバ環境)
		binmode(STDOUT);
		
		print $items,$br;
		
		open(DB,"$cf{datadir}/db.cgi") or error('open err: db.cgi');
		while( my $db = <DB> ) {
			$db =~ s/,/，/g;
			jcode::convert(\$db,'sjis','utf8');
			my ($no,$ttl,$com,$cat1,$cat2,$cat3,$ex,$w,$h) = split(/<>/,$db);
			
			print qq|$no,$ttl,$com,$cat1,$cat2,$cat3,$ex,$w,$h$br|;
		}
		close(DB);
		
		exit;
	
	# アップ
	} elsif ($in{ul} && $in{upfile}) {
		require "./lib/jacode.pl";
		
		# 一時ファイル
		my $upfile = "$cf{datadir}/tmp/$$.tmp";
		
		# 一時ファイル書き込み
		open(UP,"> $upfile") or error("up err: $upfile");
		binmode(UP);
		print UP $in{upfile};
		close(UP);
		
		open(DAT,"+< $cf{datadir}/num.dat") or error('open err: num.dat');
		my $num = <DAT>;
		
		# 一時 → 本番
		my $i = 0;
		open(IN,"$upfile") or error("open err: $upfile");
		my $top = <IN>;
		open(OUT,"> $cf{datadir}/db.cgi") or error('write err: db.cgi');
		while( my $db = <IN> ) {
			$db =~ s/[\r\n]//g;
			jcode::convert(\$db,'utf8','sjis');
			my ($no,$ttl,$com,$cat1,$cat2,$cat3,$ex,$w,$h) = split(/,/,$db);
			next if ($db eq '');
			
			# ID番号
			if ($no eq '') { $no = ++$num; }
			
			$i++;
			print OUT "$no<>$ttl<>$com<>$cat1<>$cat2<>$cat3<>$ex<>$w<>$h<>\n";
		}
		close(OUT);
		close(IN);
		
		seek(DAT,0,0);
		print DAT $num;
		truncate(DAT,tell(DAT));
		close(DAT);
		
		# 一時ファイル削除
		unlink($upfile);
		
		# 完了画面
		message("$i件のデータをアップしました",'csv_data');
	}
	
	# 分類名
	my $catnam;
	foreach my $i (1 .. 3) {
		$catnam .= "<li>分類$i : ";
		foreach my $op (0 .. $#{$cf{"cate$i"}}) {
			$catnam .= qq|$cf{"cate$i"}[$op]→$op, |;
		}
		$catnam =~ s/, $//;
	}
	
	# 画面表示
	header('CSVデータ管理');
	back_btn();
	print <<EOM;
<div id="ttl">■ CSVデータ管理</div>
<form action="$cf{admin_cgi}" method="post" enctype="multipart/form-data">
<input type="hidden" name="sid" value="$in{sid}">
<input type="hidden" name="csv_data" value="1">
<ul>
<li>データファイルをCSV形式でアップ/ダウンロードすることができます。
<li>CSVの順番は、「ID番号, タイトル, 本文, 分類1, 分類2, 分類3, 添付拡張子, 添付横幅, 添付縦幅」です。
</l>
<table class="form-tbl">
<tr>
	<th>CSVダウンロード</th>
	<td>
		ダウンロード先のマシン環境に合わせて改行形式を選択<br>
		<input type="radio" name="br" value="win" checked>Windows形式
		<input type="radio" name="br" value="mac">Mac/UNIX形式<br>
		<input type="submit" name="dl" value="ダウンロード">
	</td>
</tr><tr>
	<th>CSVアップロード</th>
	<td>
		<input type="file" name="upfile" size="40"><br>
		<input type="submit" name="ul" value="アップロード">
	</td>
</tr>
</table>
<div id="note">
<p>▼ CSVアップロード時の注意点</p>
<ol>
<li>CSVの1行目は項目行として排除されます（2行目以降を反映）。
<li>CSVの中に、「改行」と「コンマ」は絶対に使用しないでください。
<li>添付ファイルの追加、差替、削除はできません。
<li>新規データを追加する場合は、「ID番号」を空白にしてください。
<li>データの削除はできません。
<li>分類1～3は、数字で指定します。init.cgiで指定する小カテゴリを0から数えた数字になります。
	<ul>
	$catnam
	</ul>
</ol>
</div>
</div>
</body>
</html>
EOM
	exit;
}

#-----------------------------------------------------------
#  アップロード
#-----------------------------------------------------------
sub upload {
	my ($num) = @_;
	
	# サムネイル機能
	require './lib/thumb.pl' if ($cf{thumbnail});
	
	# 拡張子取得
	my $ext = $cgi->param_filename('upfile') =~ /\.(\w+)$/ ? $1 : error("拡張子が不明です");
	$ext =~ tr/A-Z/a-z/;
	if ($ext eq 'jpeg') { $ext = 'jpg'; }
	elsif ($ext eq 'mpeg') { $ext = 'mpg'; }
	
	# アップファイル定義
	my $upfile = "$cf{upldir}/$num.$ext";
	
	# 書き込み
	open(UP,"+> $upfile") or error("up err: $upfile");
	binmode(UP);
	print UP $in{upfile};
	close(UP);
	
	# パーミッションを666
	chmod(0666, $upfile);
	
	# 画像サイズ取得
	my ($flg,$w,$h);
	if ($ext eq "jpg") { ($w,$h) = j_size($upfile); $flg++; }
	elsif ($ext eq "gif") { ($w,$h) = g_size($upfile); $flg++; }
	elsif ($ext eq "png") { ($w,$h) = p_size($upfile); $flg++; }
	
	# サムネイル作成
	if ($cf{thumbnail} && $flg) {
		($w,$h) = resize($w,$h);
		my $thumb = "$cf{upldir}/$num-s.$ext";
		make_thumb($upfile,$thumb,$w,$h);
	}
	
	# 結果を返す
	return ($ext,$w,$h);
}

#-----------------------------------------------------------
#  JPEGサイズ認識
#-----------------------------------------------------------
sub j_size {
	my $jpg = shift;
	
	my ($h,$w,$t);
	open(IMG,"$jpg");
	binmode(IMG);
	read(IMG, $t, 2);
	while (1) {
		read(IMG, $t, 4);
		my ($m, $c, $l) = unpack("a a n", $t);
		
		if ($m ne "\xFF") {
			$w = $h = 0;
			last;
		} elsif ((ord($c) >= 0xC0) && (ord($c) <= 0xC3)) {
			read(IMG, $t, 5);
			($h, $w) = unpack("xnn", $t);
			last;
		} else {
			read(IMG, $t, ($l - 2));
		}
	}
	close(IMG);
	
	return ($w,$h);
}

#-----------------------------------------------------------
#  GIFサイズ認識
#-----------------------------------------------------------
sub g_size {
	my $gif = shift;
	
	my $data;
	open(IMG,"$gif");
	binmode(IMG);
	sysread(IMG, $data, 10);
	close(IMG);
	
	if ($data =~ /^GIF/) { $data = substr($data, -4); }
	my $w = unpack("v", substr($data, 0, 2));
	my $h = unpack("v", substr($data, 2, 2));
	
	return ($w,$h);
}

#-----------------------------------------------------------
#  PNGサイズ認識
#-----------------------------------------------------------
sub p_size {
	my $png = shift;
	
	my $data;
	open(IMG,"$png");
	binmode(IMG);
	read(IMG, $data, 24);
	close(IMG);
	
	my $w = unpack("N", substr($data, 16, 20));
	my $h = unpack("N", substr($data, 20, 24));
	
	return ($w,$h);
}

#-----------------------------------------------------------
#  HTMLヘッダー
#-----------------------------------------------------------
sub header {
	my $ttl = shift;
	
	print <<EOM;
Content-type: text/html; charset=utf-8

<!doctype html>
<html lang="ja">
<head>
<meta charset="UTF-8">
<link href="$cf{cmnurl}/admin.css" rel="stylesheet">
<title>$ttl</title>
</head>
<body>
<div id="head"><img src="$cf{cmnurl}/star.png" alt="star" class="icon"> QuickDB 管理画面 :: </div>
<div id="body">
EOM
}

#-----------------------------------------------------------
#  フォームデコード
#-----------------------------------------------------------
sub parse_form {
	my $cgi = shift;
	
	my %in;
	foreach ( $cgi->param() ) {
		my $val = $cgi->param($_);
		
		# 無害化
		if ($_ ne 'upfile') {
			$val =~ s/&/&amp;/g;
			$val =~ s/"/&quot;/g;
			$val =~ s/</&lt;/g;
			$val =~ s/>/&gt;/g;
			$val =~ s/'/&#39;/g;
			$val =~ s/\r\n/<br>/g;
			$val =~ s/\r/<br>/g;
			$val =~ s/\n/<br>/g;
		}
		$in{$_} = $val;
	}
	return %in;
}

#-----------------------------------------------------------
#  完了メッセージ
#-----------------------------------------------------------
sub message {
	my ($msg,$mode) = @_;
	
	header($msg);
	print <<EOM;
<div id="ttl">■ 処理完了</div>
<div id="msg">
<p>$msg</p>
<form action="$cf{admin_cgi}" method="post">
<input type="hidden" name="sid" value="$in{sid}">
<input type="hidden" name="$mode" value="1">
<p><input type="submit" value="当初の画面に戻る"></p>
</form>
</div>
</div>
</body>
</html>
EOM
	exit;
}

#-----------------------------------------------------------
#  エラー
#-----------------------------------------------------------
sub error {
	my $msg = shift;
	
	header("ERROR!");
	print <<EOM;
<div id="err">
<h4>ERROR!</h4>
<p>$msg</p>
<p><input type="button" value="前画面に戻る" onclick="history.back()"></p>
</div>
</div>
</body>
</html>
EOM
	exit;
}

#-----------------------------------------------------------
#  入力チェック
#-----------------------------------------------------------
sub check_input {
	$in{comment} =~ s/(<br>)+$//;
	
	my $err;
	if ($in{title} eq '') { $err .= "タイトルが未入力です<br>"; }
	if ($in{comment} eq '') { $err .= "本文が未入力です<br>"; }
	error($err) if ($err);
}

#-----------------------------------------------------------
#  バックボタン
#-----------------------------------------------------------
sub back_btn {
	print <<EOM;
<div class="back-btn">
<form action="$cf{admin_cgi}" method="post">
<input type="hidden" name="sid" value="$in{sid}">
<input type="submit" value="&lt; メニュー">
</form>
</div>
EOM
}

#-----------------------------------------------------------
#  文字カット for UTF-8
#-----------------------------------------------------------
sub cut_str {
	my ($str,$all) = @_;
	$str =~ s/<br>//g;
	
	my $i = 0;
	my ($ret,$flg);
	while ($str =~ /([\x00-\x7f]|[\xC0-\xDF][\x80-\xBF]|[\xE0-\xEF][\x80-\xBF]{2}|[\xF0-\xF7][\x80-\xBF]{3})/gx) {
		$i++;
		$ret .= $1;
		if ($i >= $all) {
			$flg++;
			last;
		}
	}
	$ret .= '...' if ($flg);
	
	return $ret;
}

