# モジュール宣言/変数初期化
use strict;
my %cf;
#┌─────────────────────────────────
#│ Quick DB : init.cgi - 2022/05/28
#│ copyright (c) kentweb, 1997-2022
#│ https://www.kent-web.com/
#└─────────────────────────────────
$cf{version} = 'Quick DB v4.1';
#┌─────────────────────────────────
#│ [注意事項]
#│ 1. このプログラムはフリーソフトです。このプログラムを使用した
#│    いかなる損害に対して作者は一切の責任を負いません。
#│ 2. 設置に関する質問はサポート掲示板にお願いいたします。
#│    直接メールによる質問は一切お受けいたしておりません。
#└─────────────────────────────────

#===========================================================
# ■ 基本設定
#===========================================================

# 検索システムタイトル
$cf{html_title} = ":: カンタンお料理集 - Quick DB ::";

# サムネイル画像を作成する（要：Image::Magick）
# → 縮小画像を自動生成し、画像記事の表示速度を軽くする機能
# 0=no 1=yes
$cf{thumbnail} = 0;

# 大カテゴリ（3種固定）
$cf{categ} = ['食種','材料','調理法'];

# 小カテゴリ：食種（指定個数は制限なし）
$cf{cate1} = ['和食','洋食','中華','お菓子','その他'];

# 小カテゴリ：材料（指定個数は制限なし）
$cf{cate2} = ['肉','魚介類','野菜','卵','豆腐','ご飯','めん類','その他'];

# 小カテゴリ：調理法（指定個数は制限なし）
$cf{cate3} = ['焼く','煮る','炒める','揚げる','蒸す','炊く','鍋物','その他'];

# 検索プログラム【URLパス】
$cf{db_cgi} = './quick.cgi';

# 管理プログラム【URLパス】
$cf{admin_cgi} = './admin.cgi';

# データディレクトリ【サーバパス】
$cf{datadir} = './data';

# アップロードディレクトリ
# → 順に、サーバパス、URLパス
$cf{upldir} = './upl';
$cf{uplurl} = './upl';

# 共通ディレクトリ【URLパス】
$cf{cmnurl} = './cmn';

# テンプレートディレクトリ【サーバパス】
$cf{tmpldir} = './tmpl';

# URLの自動リンク (0=no 1=yes)
$cf{auto_link} = 1;

# 検索結果ページ当たり表示件数
$cf{logs} = 10;

# 検索画面からの戻り先【URLパス】
$cf{topurl} = '../index.html';

# 投稿受理最大サイズ (bytes)
# → 例 : 102400 = 100KB
$cf{maxdata} = 512000;

# 画像ファイルの最大表示の大きさ（単位：ピクセル）
# → これを超える画像は縮小表示します
$cf{max_img_w} = 200;	# 横幅
$cf{max_img_h} = 150;	# 縦幅

# 拡張子アイコン
# → 各アイコンは$cf{iconurl}内に格納すること
$cf{ext} = {
	pdf => 'pdf.png',
	xls => 'xls.png',
	xlsx => 'xls.png',
	doc => 'doc.png',
	docx => 'doc.png',
	zip => 'zip.png',
	rm  => 'rm.png',
	mov => 'mov.png',
	wmv => 'wmv.png',
	txt => 'txt.png',
	};

# 上記以外の拡張子アイコン
$cf{ext_o} = 'bin.png';

#===========================================================
# ■ 設定完了
#===========================================================

# 設定値を返す
sub set_init { return %cf; }

#-----------------------------------------------------------
#  画像リサイズ
#-----------------------------------------------------------
sub resize {
	my ($w,$h) = @_;
	
	# 画像表示縮小
	if ($w > $cf{max_img_w} || $h > $cf{max_img_h}) {
		my $w2 = $cf{max_img_w} / $w;
		my $h2 = $cf{max_img_h} / $h;
		my $key;
		if ($w2 < $h2) { $key = $w2; } else { $key = $h2; }
		$w = int ($w * $key) || 1;
		$h = int ($h * $key) || 1;
	}
	
	return ($w,$h);
}



1;

