#!/usr/local/bin/perl

#┌─────────────────────────────────
#│ Web Quiz : quiz.cgi - 2014/11/24
#│ copyright (c) KentWeb, 1997-2014
#│ http://www.kent-web.com/
#└─────────────────────────────────

# モジュール宣言
use strict;
use CGI::Carp qw(fatalsToBrowser);

# 設定ファイル認識
require "./init.cgi";
my %cf = set_init();

# データ受理
my %in = parse_form();

# メイン処理
if ($in{mode} eq 'quiz') { quiz_form(); }
if ($in{mode} eq 'rank') { quiz_rank(); }
if ($in{mode} eq 'reco') { quiz_reco(); }
if ($in{mode} eq 'qoff') { quiz_off(); }
top_page();

#-----------------------------------------------------------
#  スタートページ
#-----------------------------------------------------------
sub top_page {
	# クッキー取得
	my ($name,$cid,$chal) = get_cookie();
	
	# テンプレート読み込み
	open(IN,"$cf{tmpldir}/quiz.html") or error('open err: quiz.html');
	my $tmpl = join('',<IN>);
	close(IN);
	
	# 文字置き換え
	$tmpl =~ s/!name!/$name/g;
	$tmpl =~ s/!(quiz_ttl|quiz_all|quiz_ttl|chal_time|admin_cgi|quiz_cgi|home_url)!/$cf{$1}/g;
	$tmpl =~ s|!icon:(\w+\.\w+)!|<img src="$cf{iconurl}/$1" alt="" class="icon" />|g;
	
	# 画面展開
	print "Content-type: text/html; charset=utf-8\n\n";
	footer($tmpl);
}

#-----------------------------------------------------------
#  出題フォーム
#-----------------------------------------------------------
sub quiz_form {
	# 入室チェック
	enter_check();
	
	# クッキー取得
	my (undef,$cid,$chal) = get_cookie();
	if ($cid !~ /^\w{25}$/ or $chal !~ /^\d+$/) { $cid = ''; $chal = 0; }
	
	# index読み込み
	open(DAT,"$cf{datadir}/quiz.idx") or error('open err: quiz.idx');
	my $all = <DAT>;
	close(DAT);
	
	# 乱数発生
	my @tmp = (1 .. $all);
	for ( my $i = @tmp; --$i; ) {
		my $j = int(rand($i + 1));
		next if ($i == $j);
		@tmp[$i,$j] = @tmp[$j,$i];
	}
	
	# 抽出設問（行数）
	my %key;
	for ( 0 .. $cf{quiz_all} - 1 ) {
		$key{$tmp[$_]}++;
	}
	
	# 設問ファイル読み込み
	my ($i,@q);
	open(IN,"$cf{datadir}/quiz.dat") or error('open err: quiz.dat');
	while(<IN>) {
		$i++;
		if (defined($key{$i})) {
			push(@q,$_);
		}
	}
	close(IN);
	
	# 設問をかき混ぜる
	for ( my $i = @q; --$i; ) {
		my $j = int(rand($i + 1));
		next if ($i == $j);
		@q[$i,$j] = @q[$j,$i];
	}
	
	# テンプレート読み込み
	open(IN,"$cf{tmpldir}/form.html") or error('open err: form.html');
	my $tmpl = join('',<IN>);
	close(IN);
	
	# 文字置き換え
	$tmpl =~ s/!(quiz_cgi|quiz_ttl)!/$cf{$1}/g;
	$tmpl =~ s/!name!/$in{name}/g;
	$tmpl =~ s|!icon:(\w+\.\w+)!|<img src="$cf{iconurl}/$1" alt="" class="icon" />|g;
	
	# テンプレート分割
	my ($head,$loop,$foot) = split(/<!-- loop -->/s,$tmpl);
	
	# 設問フォーム作成
	my ($num,$mon,$form);
	for (@q) {
		my ($no,$q,$op,undef,$img) = split(/<>/);
		$mon .= "$no,";
		
		my $ansfm;
		my $i = 0;
		for my $tmp ( split(/\s+/,$op) ) {
			$i++;
			$ansfm .= qq|<input type="radio" name="q:$no" value="$i" />$tmp\n|;
		}
		
		my $tmp = $loop;
		$tmp =~ s/!num!/++$num/e;
		$tmp =~ s/!question!/$q/g;
		$tmp =~ s/!ans-form!/$ansfm/g;
		$tmp =~ s|<!-- image -->|<img src="$cf{imgurl}/$img" alt="" align="right" class="resize" />|g if ($img);
		$form .= $tmp;
	}
	$mon =~ s/,$//;

	# セッション作成
	my $ses = make_ses($mon,$cid,$chal);
	
	# 文字置き換え
	for ($head,$foot) {
		s/!ses!/$ses/g;
	}
	
	# 画面展開
	print "Content-type: text/html; charset=utf-8\n\n";
	print $head, $form;
	footer($foot);
}

#-----------------------------------------------------------
#  回答合わせ
#-----------------------------------------------------------
sub quiz_off {
	# セッション確認
	$in{ses} =~ s/\W//g;
	if ($in{ses} !~ /^\w{25}$/ or !-f "$cf{datadir}/ses/$in{ses}.dat") {
		error('セッションが不正です。<br />TOPから再度やり直して下さい','top');
	}
	
	# セッションデータ読み込み
	open(DAT,"$cf{datadir}/ses/$in{ses}.dat");
	my $log = <DAT>;
	close(DAT);
	
	# セッションデータ分解
	my ($name,$time,$mon,$cid,$chal) = split(/\t/,$log);
	$chal++;
	
	# セッションデータ削除
	unlink("$cf{datadir}/ses/$in{ses}.dat");
	
	# 経過時間
	my $ptime = time - $time;
	
	# 設問No
	my %key;
	for ( split(/,/,$mon) ) { $key{$_}++; }

	# 設問ファイル読み込み
	my %ans;
	my $ans = 0;
	open(IN,"$cf{datadir}/quiz.dat");
	while(<IN>) {
		my ($no,undef,undef,$kai,undef) = split(/<>/);
		next if (!defined($key{$no}));
		
		if ($in{"q:$no"} == $kai) {
			$ans{$no} = 1;
			$ans += 1;
		} else {
			$ans{$no} = 0;
		}
	}
	close(IN);
	
	# ポイント算出
	my $pt = $ans > 0 ? ($ans * 30) + ($cf{quiz_all} * 10 - $ptime) : 0;
	
	# 最高点
	my $max = ($cf{quiz_all} * 30) + ($cf{quiz_all} * 10);
	
	# 結果スタンプ判定
	my $res_img =
			$pt >= $max * 0.85 ? "st-saiko.gif" :
			$pt >= $max * 0.80 ? "st-appare.gif" :
			$pt >= $max * 0.75 ? "st-yoku.gif" :
			$pt >= $max * 0.70 ? "st-yaya.gif" :
			$pt >= $max * 0.60 ? "st-futsu.gif" :
			$pt >= $max * 0.48 ? "st-motto.gif" :
			$pt >= $max * 0.40 ? "st-soutou.gif" :
			$pt >= $max * 0.30 ? "st-kanari.gif" :
			$pt >= $max * 0.20 ? "st-michi.gif" :
			$pt >= $max * 0.10 ? "st-naki.gif" :
				"st-namida.gif";
	
	# ランキング更新
	my $hit = set_rank($pt,$name,$cid,$chal,$ans,$ptime);
	
	# メッセージ
	my $msg = $hit
			? "おめでとうございます。<br />ランキング入りしました！"
			: "残念ながら<br />ランキング圏外です。";
	
	# テンプレート読み込み
	open(IN,"$cf{tmpldir}/result.html") or error('open err: result.html');
	my $tmpl = join('',<IN>);
	close(IN);
	
	# 文字置き換え
	$tmpl =~ s/!(quiz_ttl|quiz_cgi)!/$cf{$1}/g;
	$tmpl =~ s/!name!/$name/g;
	$tmpl =~ s/!point!/$pt/g;
	$tmpl =~ s/!ans!/$ans/g;
	$tmpl =~ s/!time!/$ptime/g;
	$tmpl =~ s/!all!/$cf{quiz_all}/g;
	$tmpl =~ s/!maxpt!/$max/g;
	$tmpl =~ s|!icon:(\w+\.\w+)!|<img src="$cf{iconurl}/$1" alt="" class="icon" />|g;
	$tmpl =~ s|!result-image!|<img src="$cf{iconurl}/$res_img" alt="" /><p>$msg</p>|g;
	
	# 回答合わせ
	if ($cf{check_ans} == 1) {
		my %ox = (1 => '○', 0 => '×');
		my ($i,$td_no,$td_ox);
		for ( split(/,/,$mon) ) {
			$i++;
			$td_no .= qq|<td>$i問</td>|;
			$td_ox .= qq|<td>$ox{$ans{$_}}</td>|;
		}
		$tmpl =~ s/<!-- td:no -->/$td_no/;
		$tmpl =~ s/<!-- td:ox -->/$td_ox/;
	} else {
		$tmpl =~ s/<!-- check_ans -->.+?<!-- check_ans -->//s;
	}
	
	# クッキー更新
	set_cookie($name,$cid,$chal);
	
	# 画面展開
	print "Content-type: text/html; charset=utf-8\n\n";
	footer($tmpl);
}

#-----------------------------------------------------------
#  ランキング画面
#-----------------------------------------------------------
sub quiz_rank {
	# セッション掃除
	clean_ses();
	
	# ランクindex
	open(IN,"$cf{datadir}/rank.idx") or error('open err: rank.idx');
	my $date = <IN>;
	close(IN);
	
	# 当月フォーマット
	$date =~ s/^(\d+)\-(\d+)/$1年$2月/;
	
	# テンプレート読み込み
	open(IN,"$cf{tmpldir}/rank.html") or error('open err: rank.html');
	my $tmpl = join('',<IN>);
	close(IN);
	
	# 文字置き換え
	$tmpl =~ s/!(quiz_cgi|quiz_ttl)!/$cf{$1}/g;
	$tmpl =~ s/!month!/$date/g;
	$tmpl =~ s|!icon:(\w+\.\w+)!|<img src="$cf{iconurl}/$1" alt="" class="icon" />|g;
	
	# テンプレート分割
	my ($head,$loop,$foot) = split(/<!-- loop -->/s,$tmpl);
	
	# 画面展開
	print "Content-type: text/html; charset=utf-8\n\n";
	print $head;
	
	my ($i,$rank,$bpt,$brk);
	open(IN,"$cf{datadir}/rank.dat") or error('open err: rank.dat');
	while(<IN>) {
		my ($time,$name,$pt,$cid,$chal,$ip) = split(/\t/);
		
		# 表示ランキング
		$i++;
		my $rank = $pt == $bpt ? $brk : $i;
		
		# 表示停止
		last if ($cf{rank_list} < $rank);
		
		my $tmp = $loop;
		$tmp =~ s/!rank!/$rank/g;
		$tmp =~ s/!date!/chg_date($time)/eg;
		$tmp =~ s/!name!/$name/g;
		$tmp =~ s/!point!/$pt/g;
		
		$bpt = $pt;
		$brk = $rank;
		
		print $tmp;
	}
	close(IN);
	
	footer($foot);
}

#-----------------------------------------------------------
#  成績画面
#-----------------------------------------------------------
sub quiz_reco {
	# ランクindex
	my $i = 0;
	my %all;
	open(IN,"$cf{datadir}/log.dat") or error('open err: log.dat');
	while(<IN>) {
		$i++;
		my ($time,$name,$pt,$cid,$chal,$ans,$ptm,$ip) = split(/\t/);
		
		$all{pt}  += $pt;
		$all{ans} += $ans;
		$all{ptm} += $ptm;
	}
	close(IN);
	
	my %av;
	$av{point} = $all{pt} > 0 ? sprintf("%.1f", $all{pt}/$i) : '0.0';
	$av{ans}   = $all{ans} > 0 ? sprintf("%.1f", $all{ans}/$i) : '0.0';
	$av{time}  = $all{ptm} > 0 ? sprintf("%.1f", $all{ptm}/$i) : '0.0';
	$av{ans_per} = $all{ans} > 0 ? sprintf("%.1f", $av{ans}/$cf{quiz_all}*100) : '0.0';
	$av{all}   = $i;
	
	# テンプレート読み込み
	open(IN,"$cf{tmpldir}/record.html") or error('open err: record.html');
	my $tmpl = join('',<IN>);
	close(IN);

	# 文字置き換え
	$tmpl =~ s/!(quiz_cgi|quiz_ttl)!/$cf{$1}/g;
	$tmpl =~ s/!(point|ans|time|ans_per|all)!/$av{$1}/g;
	$tmpl =~ s|!icon:(\w+\.\w+)!|<img src="$cf{iconurl}/$1" alt="" class="icon" />|g;

	# 画面展開
	print "Content-type: text/html; charset=utf-8\n\n";
	footer($tmpl);
}

#-----------------------------------------------------------
#  フォームデコード
#-----------------------------------------------------------
sub parse_form {
	my ($buf,%in);
	if ($ENV{REQUEST_METHOD} eq "POST") {
		error('受理できません') if ($ENV{CONTENT_LENGTH} > $cf{maxdata});
		read(STDIN, $buf, $ENV{CONTENT_LENGTH});
	} else {
		$buf = $ENV{QUERY_STRING};
	}
	foreach ( split(/&/, $buf) ) {
		my ($key,$val) = split(/=/);
		$key =~ tr/+/ /;
		$key =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("H2", $1)/eg;
		$val =~ tr/+/ /;
		$val =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("H2", $1)/eg;

		# 無効化
		$key =~ s/[<>"'&\r\n]//g;
		$val =~ s/&/&amp;/g;
		$val =~ s/</&lt;/g;
		$val =~ s/>/&gt;/g;
		$val =~ s/"/&quot;/g;
		$val =~ s/'/&#39;/g;
		$val =~ s/[\r\n\t]//g;

		$in{$key} .= "\0" if (defined($in{$key}));
		$in{$key} .= $val;
	}
	return %in;
}

#-----------------------------------------------------------
#  入室チェック
#-----------------------------------------------------------
sub enter_check {
	if ($in{name} eq '') { error('名前が未入力です'); }
	
	# IP
	my $addr = $ENV{REMOTE_ADDR};
	
	# 許容時間
	my $time = time;
	my $allow = $time - $cf{chal_time} * 60;
	
	my ($flg,@log);
	open(DAT,"+< $cf{datadir}/ip.dat") or error('open err: ip.dat');
	eval "flock(DAT,2);";
	while(<DAT>) {
		chomp;
		my ($tm,$ip) = split(/\t/);
		next if ($allow > $tm);
		
		if ($addr eq $ip) {
			$flg++;
			last;
		}
		push(@log,$_);
	}
	unshift(@log,"$time\t$addr\n");
	seek(DAT, 0, 0);
	print DAT @log;
	truncate(DAT, tell(DAT));
	close(DAT);
	
	if ($flg) { error("再チャレンジは$cf{chal_time}分間お待ちください"); }
}

#-----------------------------------------------------------
#  セッション作成
#-----------------------------------------------------------
sub make_ses {
	my ($mon,$cid,$chal) = @_;
	if (!$cid) { $cid = make_rand(); }
	
	# 時間
	my $time = time;
	
	# セッション発行
	my $ses = make_rand();
	
	# 生成
	open(DAT,"> $cf{datadir}/ses/$ses.dat") or error("write err: $ses.dat");
	print DAT "$in{name}\t$time\t$mon\t$cid\t$chal";
	close(DAT);
	
	return $ses;
}

#-----------------------------------------------------------
#  乱数作成
#-----------------------------------------------------------
sub make_rand {
	my @wd = (0 .. 9, 'a' .. 'z', 'A' .. 'Z', '_');
	my $ret;
	for (1 .. 25) {	$ret .= $wd[int(rand(@wd))]; }
	
	return $ret;
}

#-----------------------------------------------------------
#  ランク更新
#-----------------------------------------------------------
sub set_rank {
	my ($pt,$nam,$cid,$chal,$ans,$ptime) = @_;
	
	# 現在時間
	my $time = time;

	# ログデータ更新
	my ($i,@log);
	open(DAT,"+< $cf{datadir}/log.dat") or error('open err: log.dat');
	eval "flock(DAT,2);";
	while(<DAT>) {
		$i++;
		push(@log,$_);
		
		last if ($i >= $cf{log_max} - 1);
	}
	unshift(@log,"$time\t$nam\t$pt\t$cid\t$chal\t$ans\t$ptime\t$ENV{REMOTE_ADDR}\n");
	seek(DAT, 0, 0);
	print DAT @log;
	truncate(DAT, tell(DAT));
	close(DAT);
	
	# 0点は記録なし
	if ($pt == 0) { return; }
	
	# ランキング入り有無
	my $hit;
	
	# 今月
	my ($mon,$year) = (localtime())[4,5];
	my $this = sprintf("%02d-%02d",$year+1900,$mon+1);
	
	# ログindex更新
	my $flg;
	open(DAT,"+< $cf{datadir}/rank.idx") or error('open err: rank.idx');
	eval "flock(DAT,2);";
	my $idx = <DAT>;
	
	# 読むだけ（当月まま）
	if ($idx eq $this) {
		close(DAT);
		
	# 書き換え（月替り）
	} else {
		$flg++;
		seek(DAT, 0, 0);
		print DAT $this;
		truncate(DAT, tell(DAT));
		close(DAT);
	}
	
	# ランクデータ（当月まま）
	if (!$flg) {
		# 更新
		my ($i,$rank,$bpt,$brk,@log);
		open(DAT,"+< $cf{datadir}/rank.dat") or error('open err: rank.dat');
		eval "flock(DAT,2);";
		while(<DAT>) {
			my ($pts) = (split(/\t/))[2];

			# ランク
			$i++;
			my $rank = $pts == $bpt ? $brk : $i;

			# ログ中の点数以上のとき → 上位に追加
			if (!$hit && $pt >= $pts) {
				$hit++;
				
				if ($i == 1) {
					unshift(@log,"$time\t$nam\t$pt\t$cid\t$chal\t$ENV{REMOTE_ADDR}\n");
				} else {
					push(@log,"$time\t$nam\t$pt\t$cid\t$chal\t$ENV{REMOTE_ADDR}\n");
				}
				
				$bpt = $pts;
				$brk = $rank;
				$i++;
				$rank = $pt == $bpt ? $brk : $i;
			}
			
			last if ($cf{rank_list} < $rank);
			
			push(@log,$_);
			
			$bpt = $pts;
			$brk = $rank;
		}
		
		# ランク入りなし、且つ、順位が10位足らず → 最下位に追加
		if (!$hit && @log < $cf{rank_list}) {
			$hit++;
			push(@log,"$time\t$nam\t$pt\t$cid\t$chal\t$ENV{REMOTE_ADDR}\n");
		}
		
		# 更新あり
		if ($hit) {
			seek(DAT, 0, 0);
			print DAT @log;
			truncate(DAT, tell(DAT));
		}
		close(DAT);
	
	# ログクリア（月替り）
	} else {
		$hit++;
		open(DAT,"> $cf{datadir}/rank.dat") or error('write err: rank.dat');
		print DAT "$time\t$nam\t$pt\t$cid\t$chal\t$ENV{REMOTE_ADDR}\n";
		close(DAT);
	}
	
	return $hit;
}

#-----------------------------------------------------------
#  フッター
#-----------------------------------------------------------
sub footer {
	my $foot = shift;

	# 著作権表記（削除・改変禁止）
	my $copy = <<EOM;
<p style="margin-top:2em;text-align:center;font-family:Verdana,Helvetica,Arial;font-size:10px;">
	- <a href="http://www.kent-web.com/" target="_top">WebQuiz</a> -
</p>
EOM

	if ($foot =~ /(.+)(<\/body[^>]*>.*)/si) {
		print "$1$copy$2\n";
	} else {
		print "$foot$copy\n";
		print "</body></html>\n";
	}
	exit;
}

#-----------------------------------------------------------
#  エラー画面
#-----------------------------------------------------------
sub error {
	my ($err,$key) = @_;

	open(IN,"$cf{tmpldir}/error.html") or die;
	my $tmpl = join('', <IN>);
	close(IN);

	$tmpl =~ s/!error!/$err/g;
	$tmpl =~ s/!quiz_ttl!/$cf{quiz_ttl}/g;
	$tmpl =~ s|!icon:(\w+\.\w+)!|<img src="$cf{iconurl}/$1" alt="" class="icon" />|g;
	
	if ($key eq 'top') {
		$tmpl =~ s|<input (.+) onclick=".+" (.+)>|<input $1 onclick="window.open('$cf{quiz_cgi}','_self')" $2>|;
	}

	print "Content-type: text/html; charset=utf-8\n\n";
	print $tmpl;
	exit;
}

#-----------------------------------------------------------
#  クッキー発行
#-----------------------------------------------------------
sub set_cookie {
	my @data = @_;

	# 60日間有効
	my ($sec,$min,$hour,$mday,$mon,$year,$wday,undef,undef) = gmtime(time + 60*24*60*60);
	my @mon  = qw(Jan Feb Mar Apr May Jun Jul Aug Sep Oct Nov Dec);
	my @week = qw(Sun Mon Tue Wed Thu Fri Sat);

	# 時刻フォーマット
	my $gmt = sprintf("%s, %02d-%s-%04d %02d:%02d:%02d GMT",
				$week[$wday],$mday,$mon[$mon],$year+1900,$hour,$min,$sec);

	# URLエンコード
	my $cook;
	foreach (@data) {
		s/(\W)/sprintf("%%%02X", unpack("C", $1))/eg;
		$cook .= "$_<>";
	}

	print "Set-Cookie: webquiz=$cook; expires=$gmt\n";
}

#-----------------------------------------------------------
#  クッキー取得
#-----------------------------------------------------------
sub get_cookie {
	# クッキー取得
	my $cook = $ENV{HTTP_COOKIE};

	# 該当IDを取り出す
	my %ck;
	foreach ( split(/;/,$cook) ) {
		my ($key,$val) = split(/=/);
		$key =~ s/\s//g;
		$ck{$key} = $val;
	}

	# URLデコード
	my @cook;
	foreach ( split(/<>/,$ck{webquiz}) ) {
		s/%([0-9A-Fa-f][0-9A-Fa-f])/pack("H2", $1)/eg;
		s/[&"'<>]//g;

		push(@cook,$_);
	}
	return @cook;
}

#-----------------------------------------------------------
#  セッション掃除
#-----------------------------------------------------------
sub clean_ses {
	# 削除対象：60分以上古いファイル
	my $del = time - 60 * 60;
	
	opendir(DIR,"$cf{datadir}/ses");
	while( my $dir = readdir(DIR) ) {
		next if ($dir !~ /\.dat$/);
		
		my ($mtime) = (stat("$cf{datadir}/ses/$dir"))[9];
		if ($mtime < $del) { unlink("$cf{datadir}/ses/$dir"); }
	}
	closedir(DIR);
}

