#!/usr/local/bin/perl

#
# RANDOM IMAGE : list.cgi - 2011/08/22
# Copyright (c) KentWeb
# http://www.kent-web.com/
#

# W[錾
use strict;
use CGI::Carp qw(fatalsToBrowser);

# ݒt@CF
require "./init.cgi";
my %cf = &init;

# 
&list_page;

#-----------------------------------------------------------
#  Xg
#-----------------------------------------------------------
sub list_page {
	open(IN,"$cf{tmpldir}/list.html") or die;
	my $tmpl = join('', <IN>);
	close(IN);

	$tmpl =~ /(.+)<!-- loop_begin -->(.+)<!-- loop_end -->(.+)/s;
	my ($head,$loop,$foot) = ($1,$2,$3);

	my ($all,@sort,@data,%cnt);
	open(IN,"$cf{logfile}") or die;
	while(<IN>) {
		my ($img,$cnt) = split(/<>/);

		push(@sort,$cnt);
		push(@data,$img);

		$cnt{$img} = $cnt;
		$all += $cnt;
	}
	close(IN);

	# \[g
	@data = @data[sort {$sort[$b] <=> $sort[$a]} 0 .. $#sort];

	# N
	my %url;
	foreach (@{$cf{target}}) {
		my ($img,$url) = split(/,/);

		$url{$img} = $url;
	}

	# ʓWJ
	print "Content-type: text/html\n\n";
	print $head;

	my ($i,$bef_c,$bef_r);
	foreach (@data) {
		$i++;
		my ($per,$wid);
		if ($all > 0) {
			$per = sprintf("%.1f", $cnt{$_} * 100 / $all);
			if ($per > 100) { $per = 100; }
			$wid = int($per * 5);
			if ($wid < 1) { $wid = 1; }
		} else {
			$per = "0.0";
			$wid = 1;
		}

		# ʒ`
		my $rank = $cnt{$_} ne $bef_c ? $i : $bef_r;
		$bef_c = $cnt{$_};
		$bef_r = $rank;

		my $tmp = $loop;
		$tmp =~ s|!item!|<a href="$url{$_}">$_</a>|g;
		$tmp =~ s/!count!/&comma($cnt{$_})/eg;
		$tmp =~ s|!graph!|<img src="$cf{graph}" height="8" width="$wid"> $per%|g;
		$tmp =~ s/!rank!/$rank/g;
		print $tmp;
	}

	$foot =~ s/!all!/$all/;
	print $foot;
	exit;
}

#-----------------------------------------------------------
#  ؂
#-----------------------------------------------------------
sub comma {
	local($_) = @_;

	1 while s/(.*\d)(\d\d\d)/$1,$2/;
	$_;
}

