# モジュール宣言/変数初期化
use strict;
my %cf;
#┌─────────────────────────────────
#│ ROBOCHAT : init.cgi - 2011/10/02
#│ Copyright (c) KentWeb
#│ http://www.kent-web.com/
#└─────────────────────────────────
$cf{version} = 'ROBOCHAT v2.1';
#┌─────────────────────────────────
#│ [注意事項]
#│ 1. このスクリプトはフリーソフトです。このスクリプトを使用した
#│    いかなる損害に対して作者は一切の責任を負いません。
#│ 2. 設置に関する質問はサポート掲示板にお願いいたします。
#│    直接メールによる質問は一切お受けいたしておりません。
#└─────────────────────────────────

#===========================================================
# ■ 基本設定
#===========================================================

# 管理パスワード
$cf{password} = '0123';

# ロボットの名前
$cf{roboname} = '美香';

# ロボットの文字色
$cf{robocol} = "#5f00bd";

# 戻り先のURL【URLパス】
$cf{homepage} = '../index.html';

# 最大記事数
$cf{maxlog} = 30;

# リロード時間の選択秒数
$cf{retime} = [0,30,40,50,60];

# リロード時間の初期値
$cf{retime_defo} = 40;

# 表示行数
$cf{lines} = [10,20,30,40,50];

# 行数の初期値
$cf{lines_defo} = 30;

# 文字色
# → 文字色とその名前をコンマで区切る
$cf{colors} = [
	'#0000FF,青',
	'#DF0000,赤',
	'#008040,みどり',
	'#800000,茶',
	'#C100C1,紫',
	'#FF80C0,ピンク',
	'#FF8040,オレンジ',
	'#000080,紺',
	];

# タイトル名
$cf{chat_title} = "CHAT ROOM";

# ポインタの形状（ログ表示部で「名前」の前につく）
$cf{pointer} = "★";

# チャット本体プログラム【URLパス】
$cf{chat_cgi}  = './robo.cgi';

# 管理プログラム【URLパス】
$cf{admin_cgi} = './admin.cgi';

# 発言ログファイル【サーバパス】
$cf{logfile} = './data/log.cgi';

# 参加者表示ファイル【サーバパス】
$cf{memfile} = './data/mem.cgi';

# IP拒否アドレスのログ【サーバパス】
$cf{denyfile} = './data/deny.cgi';

# 辞書ファイル（応答用）
# → 順に、基本・応用
$cf{dic1file} = './data/dic1.dat';
$cf{dic2file} = './data/dic2.dat';

# テンプレートディレクトリ【サーバパス】
$cf{tmpldir} = './tmpl';

# 入退室案内名
$cf{master} = "MASTER";

# 入退室メッセージ
$cf{msg_in}  = "さん、いらっしゃい。";	# 入室時
$cf{msg_out} = "さん、さようなら～。";	# 退室時

# 入退室メッセージの色
$cf{rep_color} = "#808080";

# 顔文字
$cf{faces} = [
	'(＾_＾)', '(＾_＾；)', '(*＾＾*)', '(；_；)', '(ーー；', '  ｍ（_ _）ｍ',
	'(・_・)', '(＾＾）/~~', '(＠_＠)', '＼（＾Ｏ＾）／', '(？_？)','(｀・ω・´) ',
	];

# 最大受理サイズ（バイト数）
$cf{maxdata} = 10240;

#===========================================================
# ■ 設定完了
#===========================================================

# 設定値を返す
sub init {
	return %cf;
}

#-----------------------------------------------------------
#  フォームデコード
#-----------------------------------------------------------
sub parse_form {
	my ($buf,%in);
	if ($ENV{REQUEST_METHOD} eq "POST") {
		&error('受理できません') if ($ENV{CONTENT_LENGTH} > $cf{maxdata});
		read(STDIN, $buf, $ENV{CONTENT_LENGTH});
	} else {
		$buf = $ENV{QUERY_STRING};
	}
	foreach ( split(/&/, $buf) ) {
		my ($key,$val) = split(/=/);
		$val =~ tr/+/ /;
		$val =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("H2", $1)/eg;

		# 不要コード
		$val =~ s/&/&amp;/g;
		$val =~ s/</&lt;/g;
		$val =~ s/>/&gt;/g;
		$val =~ s/"/&quot;/g;
		$val =~ s/'/&#39;/g;
		$val =~ s/[\r\n]//g;

		$in{$key} .= "\0" if (defined($in{$key}));
		$in{$key} .= $val;
	}
	return %in;
}


1;

