#!/usr/local/bin/perl

#┌─────────────────────────────────
#│ ROBOCHAT : admin.cgi - 2011/09/24
#│ Copyright (c) KentWeb
#│ http://www.kent-web.com/
#└─────────────────────────────────

# モジュール宣言
use strict;
use CGI::Carp qw(fatalsToBrowser);

# 設定ファイル認識
require "./init.cgi";
my %cf = &init;

# データ受理
my %in = &parse_form;

# 認証
&check_passwd;

# 処理分岐
if ($in{mente_addr}) { &mente_addr; }
if ($in{mente_data}) { &mente_data; }
if ($in{mente_dic1}) { &mente_dic1; }
if ($in{mente_dic2}) { &mente_dic2; }

# メニュー画面
&menu_html;

#-----------------------------------------------------------
#  メニュー画面
#-----------------------------------------------------------
sub menu_html {
	&header("メニューTOP");

	print <<EOM;
<div align="center">
<p>選択ボタンを押してください。</p>
<form action="$cf{admin_cgi}" method="post">
<input type="hidden" name="pass" value="$in{pass}">
<table class="deco">
<tr>
	<th>選択</th>
	<th width="250">処理メニュー</th>
</tr><tr>
	<td><input type="submit" name="mente_addr" value="選択"></td>
	<td>&nbsp; 拒否IP設定</td>
</tr><tr>
	<td><input type="submit" name="mente_data" value="選択"></td>
	<td>&nbsp; 記事データ</td>
</tr><tr>
	<td><input type="submit" name="mente_dic1" value="選択"></td>
	<td>&nbsp; 辞書基本ファイルメンテ</td>
</tr><tr>
	<td><input type="submit" name="mente_dic2" value="選択"></td>
	<td>&nbsp; 辞書応用ファイルメンテ</td>
</tr><tr>
	<td><input type="button" value="選択" onclick="javascript:window.location='$cf{admin_cgi}'"></td>
	<td>&nbsp; ログアウト</td>
</tr>
</table>
</form>
</div>
</body>
</html>
EOM
	exit;
}

#-----------------------------------------------------------
#  拒否IP登録
#-----------------------------------------------------------
sub mente_addr {
	# 追加登録処理
	if ($in{add} && $in{ip}) {

		# 追加上書き
		open(DAT,">> $cf{denyfile}") || &error("write err: $cf{denyfile}");
		eval "flock(DAT, 2);";
		print DAT "$in{ip}\n";
		close(DAT);

	# 削除処理
	} elsif ($in{del}) {

		my %del;
		foreach ( split(/\0/, $in{del}) ) {
			$del{$_}++;
		}

		my @log;
		open(DAT,"+< $cf{denyfile}") || &error("open err: $cf{denyfile}");
		eval "flock(DAT, 2);";
		while(<DAT>) {
			chomp;
			if (!defined($del{$_})) { push(@log,"$_\n"); }
		}
		seek(DAT, 0, 0);
		print DAT @log;
		truncate(DAT, tell(DAT));
		close(DAT);
	}

	# 登録フォーム
	&header("拒否IP設定");
	&back_btn;
	print <<EOM;
<div class="ttl">■拒否IP登録フォーム</div>
<form action="$cf{admin_cgi}" method="post">
<input type="hidden" name="pass" value="$in{pass}">
<input type="hidden" name="mente_addr" value="1">
<input type="text" name="ip" size="35">
<input type="submit" name="add" value="登録">
<p>
【注意】
拒否したいアドレスが、<font color="#DD0000">206.109.6.69</font> だと仮定した場合、<font color="#DD0000">206.109.6.*</font><br>
というように4区切り目をワイルドカード (*) で指定するとよい。
</p>
<div class="ttl">■拒否IPメンテナンス</div>
<p>チェックボックスにチェックを入れて削除ボタンを押す。</p>
<input type="submit" value="削除する">
<dl>
EOM

	# ログを読み込み
	open(IN,"$cf{denyfile}") || &error("open err: $cf{denyfile}");
	while(<IN>) {
		chomp;

		print qq|<dt><input type="checkbox" name="del" value="$_">$_\n|;
	}
	close(IN);

	print <<EOM;
</dl>
</form>
</body>
</html>
EOM
	exit;
}

#-----------------------------------------------------------
#  発言ログメンテ
#-----------------------------------------------------------
sub mente_data {
	# 削除処理
	if ($in{del}) {

		my %del;
		foreach ( split(/\0/, $in{del}) ) {
			$del{$_}++;
		}

		my @log;
		open(DAT,"+< $cf{logfile}") || &error("open err: $cf{logfile}");
		eval "flock(DAT, 2);";
		while(<DAT>) {
			my ($date) = (split(/<>/))[0];
			if (!defined($del{$date})) { push(@log,$_); }
		}
		seek(DAT, 0, 0);
		print DAT @log;
		truncate(DAT, tell(DAT));
		close(DAT);
	}

	# 登録フォーム
	&header("記事データ");
	&back_btn;
	print <<EOM;
<div class="ttl">■記事データ削除</div>
<form action="$cf{admin_cgi}" method="post">
<input type="hidden" name="pass" value="$in{pass}">
<input type="hidden" name="mente_data" value="1">
<p>チェックボックスにチェックを入れて削除ボタンを押す。</p>
<input type="submit" value="削除する">
<dl>
EOM

	open(DB,"$cf{logfile}") || &error("open err: $cf{logfile}");
	while(<DB>) {
		my ($date,$name,$eml,$com,$col,$host) = split(/<>/);

		print qq|<dt><input type="checkbox" name="del" value="$date">\n|;
		print qq|<B>$name</B> &gt; $com ($date)\n|;
	}
	close(DB);

	print <<EOM;
</dl>
</form>
</body>
</html>
EOM
	exit;
}

#-----------------------------------------------------------
#  辞書基本ファイルメンテ
#-----------------------------------------------------------
sub mente_dic1 {
	# 新規追加
	if ($in{key} ne '' && $in{val} ne '' && $in{add}) {

		open(DAT,"+< $cf{dic1file}") || &error("open err: $cf{dic1file}");
		my @log = <DAT>;
		my ($no,undef,undef) = split(/<>/, $log[0]);
		$no++;
		unshift(@log,"$no<>$in{key}<>$in{val}\n");
		seek(DAT, 0, 0);
		print DAT @log;
		truncate(DAT, tell(DAT));
		close(DAT);

	# 削除処理
	} elsif ($in{del}) {

		my %del;
		foreach ( split(/\0/, $in{del}) ) {
			$del{$_}++;
		}

		my @log;
		open(DAT,"+< $cf{dic1file}") || &error("open err: $cf{dic1file}");
		while(<DAT>) {
			my ($no,undef,undef) = split(/<>/);
			if (!defined($del{$no})) { push(@log,$_); }
		}
		seek(DAT, 0, 0);
		print DAT @log;
		truncate(DAT, tell(DAT));
		close(DAT);
	}

	# 登録フォーム
	&header("辞書基本ファイルメンテ");
	&back_btn;
	print <<EOM;
<div class="ttl">■辞書基本ファイルメンテ</div>
<form action="$cf{admin_cgi}" method="post">
<input type="hidden" name="pass" value="$in{pass}">
<input type="hidden" name="mente_dic1" value="1">
<p><b>◎辞書追加</b></p>
・ 発言に「キー」が含まれていると、「応答文」を返します。<br>
・「キー」にはアスタリスク (*) が使用できます。<br>
・「応答文」に「NAME」と入れると相手の名前に置き換えます。<br>
キー <input type="text" name="key" size="7">
応答文 <input type="text" name="val" size="20">
<input type="submit" name="add" value="追加">
<p><b>◎辞書削除</b></p>
<input type="submit" value="削除する">
<dl>
EOM

	open(DB,"$cf{dic1file}") || &error("open err: $cf{dic1file}");
	while(<DB>) {
		chomp;
		my ($no,$key,$val) = split(/<>/);

		print qq|<dt><input type="checkbox" name="del" value="$no">$key &gt; $val\n|;
	}
	close(DB);

	print <<EOM;
</dl>
</form>
</body>
</html>
EOM
	exit;
}

#-----------------------------------------------------------
#  辞書応用ファイルメンテ
#-----------------------------------------------------------
sub mente_dic2 {
	# 新規追加
	if ($in{val} ne '' && $in{add}) {

		open(DAT,"+< $cf{dic2file}") || &error("open err: $cf{dic2file}");
		my @log = <DAT>;
		my ($no,undef) = split(/<>/, $log[0]);
		$no++;
		unshift(@log,"$no<>$in{val}\n");
		seek(DAT, 0, 0);
		print DAT @log;
		truncate(DAT, tell(DAT));
		close(DAT);

	# 削除処理
	} elsif ($in{del}) {

		my %del;
		foreach ( split(/\0/, $in{del}) ) {
			$del{$_}++;
		}

		my @log;
		open(DAT,"+< $cf{dic2file}") || &error("open err: $cf{dic2file}");
		while(<DAT>) {
			my ($no,undef) = split(/<>/);
			if (!defined($del{$no})) { push(@log,$_); }
		}
		seek(DAT, 0, 0);
		print DAT @log;
		truncate(DAT, tell(DAT));
		close(DAT);
	}

	# 登録フォーム
	&header("辞書応用ファイルメンテ");
	&back_btn;
	print <<EOM;
<div class="ttl">■辞書応用ファイルメンテ</div>
<form action="$cf{admin_cgi}" method="post">
<input type="hidden" name="pass" value="$in{pass}">
<input type="hidden" name="mente_dic2" value="1">
<p><b>◎辞書追加</b></p>
・「応答文」に「NAME」と入れると相手の名前に置き換えます。<br>
応答文 <input type="text" name="val" size="20">
<input type="submit" name="add" value="追加">
<p><b>◎辞書削除</b></p>
<input type="submit" value="削除する">
<dl>
EOM

	open(DB,"$cf{dic2file}") || &error("open err: $cf{dic2file}");
	while(<DB>) {
		chomp;
		my ($no,$val) = split(/<>/);

		print qq|<dt><input type="checkbox" name="del" value="$no">$val\n|;
	}
	close(DB);

	print <<EOM;
</dl>
</form>
</body>
</html>
EOM
	exit;
}

#-----------------------------------------------------------
#  パスワード認証
#-----------------------------------------------------------
sub check_passwd {
	# パスワードが未入力の場合は入力フォーム画面
	if ($in{pass} eq "") {
		&enter_form;

	# パスワード認証
	} elsif ($in{pass} ne $cf{password}) {
		&error("認証できません");
	}
}

#-----------------------------------------------------------
#  入室画面
#-----------------------------------------------------------
sub enter_form {
	&header("入室画面");
	print <<EOM;
<div align="center">
<form action="$cf{admin_cgi}" method="post">
<table width="380" style="margin-top:50px">
<tr>
	<td height="40" align="center">
		<fieldset><legend>管理パスワード入力</legend><br>
		<input type="password" name="pass" value="" size="20">
		<input type="submit" value=" 認証 "><br><br>
		</fieldset>
	</td>
</tr>
</table>
</form>
<script language="javascript">
<!--
self.document.forms[0].pass.focus();
//-->
</script>
</div>
</body>
</html>
EOM
	exit;
}

#-----------------------------------------------------------
#  エラー
#-----------------------------------------------------------
sub error {
	my $err = shift;

	&header("ERROR!");
	print <<EOM;
<div align="center">
<hr width="350">
<h3>ERROR!</h3>
<p class="err">$err</p>
<hr width="350">
<form>
<input type="button" value="前画面に戻る" onclick="history.back()">
</form>
</div>
</body>
</html>
EOM
	exit;
}

#-----------------------------------------------------------
#  完了メッセージ
#-----------------------------------------------------------
sub message {
	my $msg = shift;

	&header("完了");
	print <<EOM;
<div align="center" style="margin-top:3em;">
<hr width="350">
<p class="msg">$msg</p>
<hr width="350">
<form action="$cf{admin_cgi}" method="post">
<input type="hidden" name="pass" value="$in{pass}">
<input type="submit" value="管理画面に戻る">
</form>
</div>
</body>
</html>
EOM
	exit;
}

#-----------------------------------------------------------
#  HTMLヘッダー
#-----------------------------------------------------------
sub header {
	my $ttl = shift;

	print "Content-type: text/html\n\n";
	print <<EOM;
<html>
<head>
<meta http-equiv="content-type" content="text/html; charset=utf-8">
<meta http-equiv="content-style-type" content="text/css">
<style type="text/css">
<!--
body,td,th { font-size:80%; background:#f0f0f0; }
div.ttl { font-weight:bold; color:#004080; border-bottom:1px solid #004080; padding:2px; }
p.err { color:#dd0000; }
p.msg { color:#006400; }
table.deco { border:1px solid #8080C0; border-collapse:collapse; margin:1em 0; }
table.deco th { border:1px solid #8080C0; background:#DCDCED; padding:4px; }
table.deco td { border:1px solid #8080C0; background:#fff; padding:4px; }
-->
</style>
<title>$ttl</title>
</head>
<body>
EOM
}

#-----------------------------------------------------------
#  戻りボタン
#-----------------------------------------------------------
sub back_btn {
	my $mode = shift;

	print <<EOM;
<div align="right">
<form action="$cf{admin_cgi}" method="post">
<input type="hidden" name="pass" value="$in{pass}">
@{[ $mode ? qq|<input type="submit" name="$mode" value="&lt; 前画面">| : "" ]}
<input type="submit" value="&lt; メニュー">
</form>
</div>
EOM
}

