#!/usr/local/bin/perl

#┌─────────────────────────────────
#│ TOPICS BOARD : topics.cgi - 2021/07/25
#│ copyright (c) kentweb, 1997-2021
#│ https://www.kent-web.com/
#└─────────────────────────────────

# モジュール宣言
use strict;
use CGI::Carp qw(fatalsToBrowser);
use lib "./lib";
use CGI::Minimal;

# 設定ファイル認識
require "./init.cgi";
my %cf = set_init();

# データ受理
CGI::Minimal::max_read_size($cf{maxdata});
my $cgi = CGI::Minimal->new;
error('容量オーバー') if ($cgi->truncated);
my %in = parse_form($cgi);

# 処理分岐
find_log() if ($in{find});
bbs_list();

#-----------------------------------------------------------
#  記事表示
#-----------------------------------------------------------
sub bbs_list {
	# ページ数
	my $pg = $in{pg} or 0;
	
	# データ認識
	my ($i,@log);
	open(IN,"$cf{datadir}/topics.dat") or error("open err: topics.dat");
	while(<IN>) {
		$i++;
		next if ($i < $pg + 1);
		next if ($i > $pg + $cf{pg_max});
		
		push(@log,$_);
	}
	close(IN);
	
	# 繰越ボタン作成
	my $pager = make_pager($i,$pg);
	
	# テンプレート読み込み
	open(IN,"$cf{tmpldir}/bbs.html") or error("open err: bbs.html");
	my $tmpl = join('',<IN>);
	close(IN);
	
	$tmpl =~ s/!(bbs_title|homepage|cmnurl|[a-z]+_cgi)!/$cf{$1}/g;
	$tmpl =~ s/<!-- pager -->/$pager/g;
	if ($cf{rss_make} == 1) {
		$tmpl =~ s|<!-- rss -->|<a href="$cf{rssurl}"><img src="$cf{cmnurl}/rss.png" class="icon"></a>|;
	}
	
	# テンプレート分割
	my ($head,$loop,$foot) = $tmpl =~ m|(.+)<!-- loop -->(.+?)<!-- /loop -->(.+)|s
			? ($1,$2,$3)
			: error("テンプレート不正");
	
	# ヘッダ表示
	print "Content-type: text/html; charset=utf-8\n\n";
	print $head;
	
	# 記事展開
	for (@log) {
		my ($no,$date,$sub,$com,$e1,$w1,$h1,$e2,$w2,$h2,$e3,$w3,$h3,$tag,$att,$tube) = split(/<>/);
		$com =~ s/\t/<br>/g;
		if ($tag == 1) {
			$com = tag($com);
		} elsif ($cf{autolink}) {
			$com = auto_link($com);
		}
		
		# YouTube
		my $clip;
		if ($att eq 't') {
			$clip = qq|<div class="youtube">| . tag($tube) . qq|</div>| if ($tube);
		
		# UPファイル
		} else {
			$clip = attach($no,$e1,$w1,$h1,$e2,$w2,$h2,$e3,$w3,$h3);
		}
		$clip &&= "<p>$clip</p>";
		
		# 文字置換
		my $tmp = $loop;
		$tmp =~ s/!date!/$date/g;
		$tmp =~ s/!subject!/$sub/g;
		$tmp =~ s/!comment!/$com/g;
		$tmp =~ s/<!-- clip -->/$clip/g;
		$tmp =~ s/!id!/$no/g;
		print $tmp;
	}
	
	# フッタ
	footer($foot);
}

#-----------------------------------------------------------
#  ワード検索
#-----------------------------------------------------------
sub find_log {
	# 条件
	$in{cond} =~ s/\D//g;
	$in{word} =~ s/\t//g;
	
	# 検索条件プルダウン
	my %op = (1 => 'AND', 0 => 'OR');
	my $op_cond;
	for (1,0) {
		if ($in{cond} eq $_) {
			$op_cond .= qq|<option value="$_" selected>$op{$_}</option>\n|;
		} else {
			$op_cond .= qq|<option value="$_">$op{$_}</option>\n|;
		}
	}
	
	# 検索実行
	my @log = search($in{word},$in{cond}) if ($in{word} ne '');
	
	# テンプレート
	open(IN,"$cf{tmpldir}/find.html") or error("open err: find.html");
	my $tmpl = join('',<IN>);
	close(IN);
	
	$tmpl =~ s/!(bbs_cgi|cmnurl)!/$cf{$1}/g;
	$tmpl =~ s/<!-- op_cond -->/$op_cond/;
	$tmpl =~ s/!word!/$in{word}/;
	
	# テンプレート分割
	my ($head,$loop,$foot) = $tmpl =~ m|(.+)<!-- loop -->(.+?)<!-- /loop -->(.+)|s
			? ($1,$2,$3)
			: error("テンプレート不正");
	
	# ヘッダ部
	print "Content-type: text/html; charset=utf-8\n\n";
	print $head;
	
	# ループ部
	for (@log) {
		my ($no,$date,$sub,$com,$e1,$w1,$h1,$e2,$w2,$h2,$e3,$w3,$h3,$tag,$att,$tube) = split(/<>/);
		$com =~ s/\t/<br>/g;
		if ($tag == 1) {
			$com = tag($com);
		} elsif ($cf{autolink}) {
			$com = auto_link($com);
		}
		
		# YouTube
		my $clip;
		if ($att eq 't') {
			$clip = tag($tube) if ($tube);
		
		# UPファイル
		} else {
			$clip = attach($no,$e1,$w1,$h1,$e2,$w2,$h2,$e3,$w3,$h3);
		}
		$clip &&= "<p>$clip</p>";
		
		my $tmp = $loop;
		$tmp =~ s/!subject!/$sub/g;
		$tmp =~ s/!date!/$date/g;
		$tmp =~ s/!comment!/$com/g;
		$tmp =~ s/<!-- clip -->/$clip/g;
		print $tmp;
	}
	
	# フッタ部
	footer($foot);
}

#-----------------------------------------------------------
#  検索実行
#-----------------------------------------------------------
sub search {
	my ($word,$cond) = @_;
	
	# キーワードを配列化
	$word =~ s/　/ /g;
	my @wd = split(/\s+/,$word);
	
	# UTF-8定義
	my $byte1 = '[\x00-\x7f]';
	my $byte2 = '[\xC0-\xDF][\x80-\xBF]';
	my $byte3 = '[\xE0-\xEF][\x80-\xBF]{2}';
	my $byte4 = '[\xF0-\xF7][\x80-\xBF]{3}';
	
	# 検索処理
	my @log;
	open(IN,"$cf{datadir}/topics.dat");
	while (<IN>) {
		my ($no,$date,$nam,$eml,$sub,$com,$url,$hos,$pw,$tim) = split(/<>/);
		
		my $flg;
		for my $wd (@wd) {
			if ("$nam $eml $sub $com $url" =~ /^(?:$byte1|$byte2|$byte3|$byte4)*?\Q$wd\E/i) {
				$flg++;
				if ($cond == 0) { last; }
			} else {
				if ($cond == 1) { $flg = 0; last; }
			}
		}
		next if (!$flg);
		
		push(@log,$_);
	}
	close(IN);
	
	# 検索結果
	return @log;
}

#-----------------------------------------------------------
#  ペイジャー作成
#-----------------------------------------------------------
sub make_pager {
	my ($i,$pg) = @_;
	
	# ページ繰越定義
	my $next = $pg + $cf{pg_max};
	my $back = $pg - $cf{pg_max};
	
	# ページ繰越ボタン作成
	my @pg;
	if ($back >= 0 or $next < $i) {
		my $flg;
		my ($w,$x,$y,$z) = (0,1,0,$i);
		while ($z > 0) {
			if ($pg == $y) {
				$flg++;
				push(@pg,qq!<span class="page active">$x</span>\n!);
			} else {
				push(@pg,qq!<a href="$cf{bbs_cgi}?pg=$y" class="page gradient">$x</a>\n!);
			}
			$x++;
			$y += $cf{pg_max};
			$z -= $cf{pg_max};
			
			if ($flg) { $w++; }
			last if ($w >= 5 && @pg >= 10);
		}
	}
	while( @pg >= 11 ) { shift(@pg); }
	my $ret = join('',@pg);
	if ($back >= 0) {
		$ret = qq!<a href="$cf{bbs_cgi}?pg=$back" class="page gradient">&laquo;</a>\n! . $ret;
	}
	if ($next < $i) {
		$ret .= qq!<a href="$cf{bbs_cgi}?pg=$next" class="page gradient">&raquo;</a>\n!;
	}
	# 結果を返す
	return $ret ? qq|<div class="pagination">\n$ret</div>| : '';
}

#-----------------------------------------------------------
#  フッター
#-----------------------------------------------------------
sub footer {
	my $foot = shift;
	
	# 著作権表記（削除・改変禁止）
	my $copy = <<EOM;
<p style="margin-top:2em;text-align:center;font-family:Verdana,Helvetica,Arial;font-size:10px;">
	- <a href="https://www.kent-web.com/" target="_top">Topics Board</a> -
</p>
EOM

	if ($foot =~ /(.+)(<\/body[^>]*>.*)/si) {
		print "$1$copy$2\n";
	} else {
		print "$foot$copy\n";
		print "</body></html>\n";
	}
	exit;
}

#-----------------------------------------------------------
#  自動リンク
#-----------------------------------------------------------
sub auto_link {
	my $text = shift;
	
	$text =~ s/(s?https?:\/\/([\w-.!~*'();\/?:\@=+\$,%#]|&amp;)+)/<a href="$1" target="_blank">$1<\/a>/g;
	return $text;
}

#-----------------------------------------------------------
#  タグ復元
#-----------------------------------------------------------
sub tag {
	local($_) = @_;
	
	# 変換
	s/&lt;/</g;
	s/&gt;/>/g;
	s/&amp;/&/g;
	s/&quot;/"/g;
	$_;
}

#-----------------------------------------------------------
#  添付表示
#-----------------------------------------------------------
sub attach {
	my $no = shift;
	my (%e,%w,%h);
	($e{1},$w{1},$h{1},$e{2},$w{2},$h{2},$e{3},$w{3},$h{3}) = @_;
	
	my $ret;
	for my $i (1 .. 3) {
		next if (!$e{$i});
		
		# 指定アイコン
		if (defined($cf{icons}{$e{$i}})) {
			my $size = -s "$cf{upldir}/$no-$i$e{$i}";
			$size = int(($size / 1024) + 0.5) . 'KB';
			$ret .= qq|<a href="$cf{uplurl}/$no-$i$e{$i}" target="_blank"><img src="$cf{cmnurl}/$cf{icons}{$e{$i}}" alt="" class="icon" /></a> ($size)\n|;
		
		# 画像の場合
		} elsif ($e{$i} =~ /^\.(jpg|gif|png)$/) {
			if (-f "$cf{upldir}/$no-s-$i$e{$i}") {
				$ret .= qq|<a href="$cf{uplurl}/$no-$i$e{$i}" target="_blank"><img src="$cf{uplurl}/$no-s-$i$e{$i}" class="img" alt="$no-s-$i$e{$i}" /></a>|;
			} else {
				my ($w,$h) = resize($w{$i},$h{$i});
				$ret .= qq|<a href="$cf{uplurl}/$no-$i$e{$i}" target="_blank"><img src="$cf{uplurl}/$no-$i$e{$i}" width="$w" height="$h" class="img" alt="$no-$i$e{$i}" /></a>|;
			}
		
		# 画像以外
		} else {
			my $size = -s "$cf{upldir}/$no-$i$e{$i}";
			$size = int(($size / 1024) + 0.5) . 'KB';
			$ret .= qq|[添付]: <a href="$cf{uplurl}/$no-$i$e{$i}" target="_blank">$no-$i$e{$i}</a> ($size)\n|;
		}
	}
	return $ret;
}

#-----------------------------------------------------------
#  エラー画面
#-----------------------------------------------------------
sub error {
	my $err = shift;
	
	open(IN,"$cf{tmpldir}/error.html") or die;
	my $tmpl = join('',<IN>);
	close(IN);
	
	$tmpl =~ s/!error!/$err/g;
	$tmpl =~ s/!cmnurl!/$cf{cmnurl}/;
	
	print "Content-type: text/html; charset=utf-8\n\n";
	print $tmpl;
	exit;
}

