# モジュール宣言/変数初期化
use strict;
my %cf;
#┌─────────────────────────────────
#│ TOPICS BOARD : init.cgi - 2021/02/13
#│ copyright (c) kentweb, 1997-2022
#│ https://www.kent-web.com/
#└─────────────────────────────────
$cf{version} = 'TopicsBoard v5.3';
#┌─────────────────────────────────
#│ [注意事項]
#│ 1. このプログラムはフリーソフトです。このプログラムを使用した
#│    いかなる損害に対して作者は一切の責任を負いません。
#│ 2. 設置に関する質問はサポート掲示板にお願いいたします。
#│    直接メールによる質問は一切お受けいたしておりません。
#└─────────────────────────────────

#===========================================================
# ■ 設定項目
#===========================================================

# サムネイル画像を作成する（要：Image::Magick）
# → 縮小画像を自動生成し、画像記事の表示速度を軽くする機能
# 0=no 1=yes
$cf{thumbnail} = 0;

# 掲示板タイトル
$cf{bbs_title} = "新着情報";

# 掲示板プログラムURL【URLパス】
$cf{bbs_cgi} = './topics.cgi';

# 管理プログラムURL【URLパス】
$cf{admin_cgi} = './admin.cgi';

# データディレクトリ【サーバパス】
$cf{datadir} = './data';

# テンプレートディレクトリ【サーバパス】
$cf{tmpldir} = './tmpl';

# アップディレクトリ【サーバパス】
$cf{upldir} = './upl';

# アップディレクトリ【URLパス】
$cf{uplurl} = './upl';

# 共通ディレクトリ【URLパス】
$cf{cmnurl} = './cmn';

# アイコン定義
# → 拡張子とファイル名のペア
$cf{icons} = {
	'.pdf'  => 'pdf.png',
	'.doc'  => 'word.png',
	'.docx' => 'word.png',
	'.xls'  => 'excel.png',
	'.xlsx' => 'excel.png',
	'.ppt'  => 'ppt.png',
	'.pptx' => 'ppt.png',
	'.txt'  => 'text.png',
	'.zip'  => 'zip.png',
	};

# 投稿受理最大サイズ (bytes)
# → 例 : 102400 = 100KB
$cf{maxdata} = 3072000;

# 画像ファイルの最大表示の大きさ（単位：ピクセル）
# → これを超える画像は縮小表示します
$cf{max_img_w} = 300;	# 横幅
$cf{max_img_h} = 150;	# 縦幅

# １ページ当たりの記事表示数 (親記事)
$cf{pg_max} = 5;

# URLの自動リンク (0=no 1=yes)
$cf{autolink} = 1;

# 最大記事数
# → これを超える記事は古い順に自動削除されます
$cf{max} = 200;

# --- ここからは RSSファイル生成向け設定
# RSSを生成する（0=no 1=yes）
$cf{rss_make} = 1;

# 掲示板説明文（RSS用に定義）
$cf{description} = '当サイトからの新着情報ニュース';

# topics.cgiのURLパス（フルパスで定義）
$cf{topiurl} = 'http://www.example.com/topics/topics.cgi';

# RSSのURLパス（フルパスで定義）
$cf{rssurl} = 'http://www.example.com/topics/index.xml';

# RSSのサーバパス（topics.cgiから見た位置）
$cf{rssfile} = './index.xml';

# 管理パスワードの最大間違い制限
# → この回数以上パスワードを間違うとロックします
$cf{max_failpass} = 5;

# 管理パスワードのロック期間：自動解除を日数で指定
# → この値を 0 にすると自動解除しません。
$cf{lock_days} = 14;

#===========================================================
# ■ 設定完了
#===========================================================

# 設定内容を返す
sub set_init { return %cf; }

#-----------------------------------------------------------
#  フォームデコード
#-----------------------------------------------------------
sub parse_form {
	my $cgi = shift;
	
	my %in;
	for ( $cgi->param() ) {
		my $val = $cgi->param($_);
		
		if (!/^upfile\d$/) {
			# 無効化
			$val =~ s/&/&amp;/g;
			$val =~ s/</&lt;/g;
			$val =~ s/>/&gt;/g;
			$val =~ s/"/&quot;/g;
			$val =~ s/'/&#39;/g;
			
			# 改行変換
			$val =~ s/\r\n/\t/g;
			$val =~ s/\n/\t/g;
			$val =~ s/\r/\t/g;
		}
		$in{$_} = $val;
	}
	return %in;
}

#-----------------------------------------------------------
#  画像リサイズ
#-----------------------------------------------------------
sub resize {
	my ($w,$h) = @_;
	
	# 画像表示縮小
	if ($w > $cf{max_img_w} || $h > $cf{max_img_h}) {
		my $w2 = $cf{max_img_w} / $w;
		my $h2 = $cf{max_img_h} / $h;
		my $key;
		if ($w2 < $h2) { $key = $w2; } else { $key = $h2; }
		$w = int ($w * $key) || 1;
		$h = int ($h * $key) || 1;
	}
	return ($w,$h);
}


1;

