#!/usr/local/bin/perl

#┌─────────────────────────────────
#│ TOPICS BOARD : admin.cgi - 2021/07/25
#│ copyright (c) kentweb, 1997-2021
#│ https://www.kent-web.com/
#└─────────────────────────────────

# モジュール宣言
use strict;
use CGI::Carp qw(fatalsToBrowser);
use vars qw(%in %cf);
use lib "./lib";
use CGI::Minimal;
use CGI::Session;
use Digest::SHA::PurePerl qw(sha256_base64);

# 設定ファイル認識
require "./init.cgi";
%cf = set_init();

# データ受理
CGI::Minimal::max_read_size($cf{maxdata});
my $cgi = CGI::Minimal->new;
error('容量オーバー') if ($cgi->truncated);
%in = parse_form($cgi);

# 認証
require "./lib/login.pl";
auth_login();

# 処理分岐
if ($in{data_new}) { data_new(); }
if ($in{data_men}) { data_men(); }
if ($in{pass_mgr}) { pass_mgr(); }

# メニュー画面
menu_html();

#-----------------------------------------------------------
#  メニュー画面
#-----------------------------------------------------------
sub menu_html {
	header("メニューTOP");
	
	print <<EOM;
<div align="center">
<p>選択ボタンを押してください。</p>
<form action="$cf{admin_cgi}" method="post">
<input type="hidden" name="sid" value="$in{sid}">
<table class="form-tbl">
<tr>
	<th>&nbsp;</th>
	<th width="280">処理メニュー</th>
</tr><tr>
	<td><input type="submit" name="data_new" value="選択"></td>
	<td>新規記事作成</td>
</tr><tr>
	<td><input type="submit" name="data_men" value="選択"></td>
	<td>記事メンテナンス（修正・削除）</td>
</tr><tr>
	<td><input type="submit" name="pass_mgr" value="選択"></td>
	<td>パスワード管理</td>
</tr><tr>
	<td><input type="button" value="選択" onclick="javascript:window.location='$cf{admin_cgi}'"></td>
	<td>ログアウト</td>
</tr>
</table>
</form>
</div>
</body>
</html>
EOM
	exit;
}

#-----------------------------------------------------------
#  新規記事
#-----------------------------------------------------------
sub data_new {
	$in{tag} = 1;
	
	# 新規作成実行
	if ($in{job} eq 'new2') { add_data(); }
	
	# 編集時
	my $log = shift;
	my ($no,$date,$sub,$com,$e1,$w1,$h1,$e2,$w2,$h2,$e3,$w3,$h3,$tag,$att,$tube) = split(/<>/,$log);
	$com =~ s/\t/\n/g;
	$com =~ s|<br( /)?>|\n|g;
	
	# 添付
	my %chk;
	if ($att eq 't') {
		$chk{y} = "checked";
		$chk{i} = "";
	} else {
		$chk{y} = "";
		$chk{i} = "checked";
	}
	
	# パラメータ定義
	my $job = $in{job} ? "edit2" : "new2";
	
	# 新規投稿時は年月日を取得
	my ($hidden,$md);
	if ($in{data_new}) {
		$ENV{TZ} = "JST-9";
		my ($mday,$mon,$year) = (localtime(time))[3..5];
		$date = sprintf("%04d/%02d/%02d", $year+1900,$mon+1,$mday);
		$hidden = qq|<input type="hidden" name="data_new" value="1">|;
	} else {
		$hidden = qq|<input type="hidden" name="data_men" value="1">|;
		$md = 'data_men';
	}
	
	# フォーム表示
	header("投稿フォーム","js");
	back_btn($md);
	print <<EOM;
<div class="ttl">■ 投稿フォーム</div>
<ul>
<li>ファイルのアップロードまたはYouTubeタグ（ニコ動画等も可）を貼り付けることができます（任意）。
</ul>
<form action="$cf{admin_cgi}" method="post" enctype="multipart/form-data">
<input type="hidden" name="sid" value="$in{sid}">
$hidden
<input type="hidden" name="job" value="$job">
<input type="hidden" name="no" value="$no">
<table class="form-tbl">
<tr>
	<th class="w-item">年月日</th>
	<td><input type="text" name="date" value="$date" size="40"></td>
</tr><tr>
	<th class="w-item">件名</th>
	<td><input type="text" name="sub" value="$sub" size="40"></td>
</tr><tr>
	<th class="w-item">本文</th>
	<td>
		<input type="checkbox" onclick="toggleHtmlEditor(this.checked,'myArea3','full')">エディタ起動<br>
		<textarea name="comment" style="width:700px;height:400px;" id="myArea3">$com</textarea>
	</td>
</tr><tr>
	<th class="w-item">貼付種別</th>
	<td>
		<input type="radio" name="clip" value="i" onclick="entryChange1();" $chk{i}>ファイルアップ
		<input type="radio" name="clip" value="t" onclick="entryChange1();" $chk{y}>YouTube
	</td>
</tr><tr id="ibox">
	<th class="w-item">ファイル<br>アップ</th>
	<td nowrap>
EOM

	my %e = (1 => $e1, 2 => $e2, 3 => $e3);
	for my $i (1 .. 3) {
		print qq|添付$i : <input type="file" name="upfile$i" size="40">\n|;
		if ($e{$i}) {
			print qq|&nbsp;<input type="checkbox" name="del$i" value="1">削除\n|;
			print qq|[<a href="$cf{uplurl}/$no-$i$e{$i}" target="_blank">添付</a>]\n|;
		}
		print "<br>\n";
	}
	
	print <<EOM;
	</td>
</tr><tr id="ybox">
	<th class="w-item">YouTube<br>タグ</th>
	<td><textarea name="tube" cols="60" rows="8">$tube</textarea></td>
</tr><tr>
	<th class="w-item"></th>
	<td><input type="submit" value="送信する"></td>
</tr>
</table>
</form>
EOM

	nic_edit();
	
	print <<EOM;
</body>
</html>
EOM
	exit;
}

#-----------------------------------------------------------
#  nicEdit定義
#-----------------------------------------------------------
sub nic_edit {
	print <<'EOM';
<script>
var html_editor = new Array();
var html_editor_loaded = false;
function loadHtmlEditor() {
	if (!html_editor_loaded) {
		var scripts = document.getElementsByTagName('script');
		for (var i=0; i<scripts.length; i++) {
			if (scripts[i].src.search(/nicEdit\.js$/) != -1) return true;
		}
		var header = document.getElementsByTagName('head')[0];
		var loader = document.createElement('script');
		loader.setAttribute('type','text/javascript');
EOM

	# パス指定
	print qq|loader.setAttribute('src','$cf{cmnurl}/nicEdit.js');\n|;

	print <<'EOM';
		header.appendChild(loader);
		html_editor_loaded = true;
	}
}
function updateHtmlEditor(this_id) {
	if (html_editor[this_id] != null) {
		html_editor[this_id].updateInstance(this_id);
	}
}
function toggleHtmlEditor(open,this_id,panel_type) {
	if (open) {
		if (typeof nicEditor == "undefined") {
			loadHtmlEditor();
			setTimeout(function() { toggleHtmlEditor(open,this_id,panel_type) },500);
		} else {
			if (html_editor[this_id] == null) html_editor[this_id] = new nicEditor({panelType : panel_type}).panelInstance(this_id);
		}
	} else if (html_editor[this_id] != null) {
		html_editor[this_id].removeInstance(this_id);
		html_editor[this_id] = null;
	}
}
</script>
EOM
}

#-----------------------------------------------------------
#  記事メンテナンス
#-----------------------------------------------------------
sub data_men {
	$in{tag} = 1;
	
	# 削除
	if ($in{job} eq "dele" && $in{no}) {
		
		my @data;
		open(DAT,"+< $cf{datadir}/topics.dat");
		while (<DAT>) {
			my ($no,$date,$sub,$com,$e1,$w1,$h1,$e2,$w2,$h2,$e3,$w3,$h3,$tag,$att,$tube) = split(/<>/);
			if ($in{no} == $no) {
				if ($e1) {
					unlink("$cf{upldir}/$no-1$e1");
					unlink("$cf{upldir}/$no-s-1$e1") if (-f "$cf{upldir}/$no-s-1$e1");
				}
				if ($e2) {
					unlink("$cf{upldir}/$no-2$e2");
					unlink("$cf{upldir}/$no-s-2$e2") if (-f "$cf{upldir}/$no-s-2$e2");
				}
				if ($e3) {
					unlink("$cf{upldir}/$no-3$e3");
					unlink("$cf{upldir}/$no-s-3$e3") if (-f "$cf{upldir}/$no-s-3$e3");
				}
				next;
			}
			push(@data,$_);
		}
		seek(DAT,0,0);
		print DAT @data;
		truncate(DAT,tell(DAT));
		close(DAT);
		
		# RSS作成
		make_rss(@data) if ($cf{rss_make} == 1);
	
	# 修正フォーム
	} elsif ($in{job} eq "edit" && $in{no}) {
		
		my $log;
		open(IN,"$cf{datadir}/topics.dat");
		while (<IN>) {
			my ($no,$date,$sub,$com,$e1,$w1,$h1,$e2,$w2,$h2,$e3,$w3,$h3,$tag,$att,$tube) = split(/<>/);
			if ($in{no} == $no) {
				$log = $_;
				last;
			}
		}
		close(IN);
		
		# 修正画面
		data_new($log);
	
	# 修正実行
	} elsif ($in{job} eq "edit2" && $in{no}) {
		
		# 入力チェック
		input_check();
		$in{tube} =~ s|<br( /)?>||g;
		
		# 画像アップ
		my ($e1n,$w1n,$h1n,$e2n,$w2n,$h2n,$e3n,$w3n,$h3n);
		if ($in{upfile1} || $in{upfile2} || $in{upfile3}) {
			($e1n,$w1n,$h1n,$e2n,$w2n,$h2n,$e3n,$w3n,$h3n) = upload($in{no});
		}
		
		my @data;
		open(DAT,"+< $cf{datadir}/topics.dat");
		while (<DAT>) {
			chomp;
			my ($no,$date,$sub,$com,$e1,$w1,$h1,$e2,$w2,$h2,$e3,$w3,$h3,$tag,$clip,$tube) = split(/<>/);
			
			if ($in{no} == $no) {
				
				# 画像削除のとき
				if ($in{del1}) {
					unlink("$cf{upldir}/$no-1$e1");
					unlink("$cf{upldir}/$no-s-1$e1") if (-f "$cf{upldir}/$no-s-1$e1");
					$e1 = $w1 = $h1 = "";
				}
				if ($in{del2}) {
					unlink("$cf{upldir}/$no-2$e2");
					unlink("$cf{upldir}/$no-s-2$e2") if (-f "$cf{upldir}/$no-s-2$e2");
					$e2 = $w2 = $h2 = "";
				}
				if ($in{del3}) {
					unlink("$cf{upldir}/$no-3$e3");
					unlink("$cf{upldir}/$no-s-3$e3") if (-f "$cf{upldir}/$no-s-3$e3");
					$e3 = $w3 = $h3 = "";
				}
				# 画像差替（拡張子が異なる場合）
				if ($e1n && $e1n ne $e1) {
					unlink("$cf{upldir}/$no-1$e1");
					unlink("$cf{upldir}/$no-s-1$e1") if (-f "$cf{upldir}/$no-s-1$e1");
				}
				if ($e2n && $e2n ne $e2) {
					unlink("$cf{upldir}/$no-2$e2");
					unlink("$cf{upldir}/$no-s-2$e2") if (-f "$cf{upldir}/$no-s-2$e2");
				}
				if ($e3n && $e3n ne $e3) {
					unlink("$cf{upldir}/$no-3$e3");
					unlink("$cf{upldir}/$no-s-3$e3") if (-f "$cf{upldir}/$no-s-3$e3");
				}
				
				# 画像差替
				if ($e1n) { $e1 = $e1n; $w1 = $w1n; $h1 = $h1n; }
				if ($e2n) { $e2 = $e2n; $w2 = $w2n; $h2 = $h2n; }
				if ($e3n) { $e3 = $e3n; $w3 = $w3n; $h3 = $h3n; }
				
				$_ = "$no<>$in{date}<>$in{sub}<>$in{comment}<>$e1<>$w1<>$h1<>$e2<>$w2<>$h2<>$e3<>$w3<>$h3<>$in{tag}<>$in{clip}<>$in{tube}<>";
			}
			push(@data,"$_\n");
		}
		seek(DAT,0,0);
		print DAT @data;
		truncate(DAT,tell(DAT));
		close(DAT);
		
		# RSS作成
		make_rss(@data) if ($cf{rss_make} == 1);
	
	# ソート
	} elsif ($in{job} eq "sort") {
		
		my (@sort,@data);
		open(DAT,"+< $cf{datadir}/topics.dat");
		while (<DAT>) {
			my ($no,$date,$sub,$com,$e1,$w1,$h1,$e2,$w2,$h2,$e3,$w3,$h3,$tag,$clip,$tube) = split(/<>/);
			
			push(@sort,$in{"sort:$no"});
			push(@data,$_);
		}
		
		# ソート
		@data = @data[sort {$sort[$a] <=> $sort[$b]} 0 .. $#sort];
		
		# 更新
		seek(DAT,0,0);
		print DAT @data;
		truncate(DAT,tell(DAT));
		close(DAT);
		
		# RSS作成
		make_rss(@data) if ($cf{rss_make} == 1);
	}
	
	header("メニュー &gt; 記事メンテナンス");
	back_btn();
	print <<"EOM";
<div class="ttl">■ 記事メンテナンス</div>
<ul>
<li>処理を選択して送信ボタンを押してください。
<li>並び替えは「ソ\ート」を選択し、順番の数字を変更して送信ボタンを押してください。
</ul>
<form action="$cf{admin_cgi}" method="post">
<input type="hidden" name="sid" value="$in{sid}">
<input type="hidden" name="data_men" value="1">
処理：
<select name="job">
<option value="edit">修正
<option value="sort">ソート
<option value="dele">削除
</select>
<input type="submit" value="送信する">
<table class="form-tbl">
<tr>
  <th nowrap>選択</th>
  <th nowrap>順番</th>
  <th nowrap>タイトル</th>
  <th nowrap>日付</th>
  <th nowrap>添付</th>
</tr>
EOM

	# ログ展開
	my $i = 0;
	open(IN,"$cf{datadir}/topics.dat") or error("open err: topics.dat");
	while (<IN>) {
		my ($no,$date,$sub,$com,$e1,$w1,$h1,$e2,$w2,$h2,$e3,$w3,$h3,$tag,$clip,$tube) = split(/<>/);
		$i++;
		
		print qq|<tr><td class="ta-c"><input type="radio" name="no" value="$no"></td>|;
		print qq|<td><input type="text" name="sort:$no" value="$i" size="3"></td>|;
		print qq|<td><b>$sub</b></td>|;
		print qq|<td nowrap>$date</td><td>|;
		print qq|[<a href="$cf{uplurl}/$no-1$e1" target="_blank">1</a>]\n| if ($e1);
		print qq|[<a href="$cf{uplurl}/$no-2$e2" target="_blank">2</a>]\n| if ($e2);
		print qq|[<a href="$cf{uplurl}/$no-3$e3" target="_blank">3</a>]\n| if ($e3);
		print qq|<br></td></tr>\n|;
	}
	close(IN);
	
	print <<EOM;
</table>
</form>
</body>
</html>
EOM
	exit;
}

#-----------------------------------------------------------
#  記事追加
#-----------------------------------------------------------
sub add_data {
	# 入力チェック
	input_check();
	$in{tube} =~ s|<br( /)?>||g;
	
	# データオープン
	my ($num,@file);
	open(DAT,"+< $cf{datadir}/topics.dat");
	while (<DAT>) {
		my ($no) = (split(/<>/))[0];
		
		if ($num < $no) { $num = $no; }
		push(@file,$_);
	}
	
	# 採番
	$num++;
	
	# 画像アップ
	my ($e1,$w1,$h1,$e2,$w2,$h2,$e3,$w3,$h3)
			= $in{upfile1} || $in{upfile2} || $in{upfile3} ? upload($num) : ();
	
	# 最大記事数調整
	while ( $cf{max} - 1 <= @file ) {
		my $del = pop(@file);
		my ($no,$date,$sub,$com,$e1,$w1,$h1,$e2,$w2,$h2,$e3,$w3,$h3,$tag,$clip,$tube) = split(/<>/,$del);
		if ($e1) {
			unlink("$cf{upldir}/$no-1$e1");
			unlink("$cf{upldir}/$no-s-1$e1") if (-f "$cf{upldir}/$no-s-1$e1");
		}
		if ($e2) {
			unlink("$cf{upldir}/$no-2$e2");
			unlink("$cf{upldir}/$no-s-2$e2") if (-f "$cf{upldir}/$no-s-2$e2");
		}
		if ($e3) {
			unlink("$cf{upldir}/$no-3$e3");
			unlink("$cf{upldir}/$no-s-3$e3") if (-f "$cf{upldir}/$no-s-3$e3");
		}
	}
	
	# 更新
	unshift(@file,"$num<>$in{date}<>$in{sub}<>$in{comment}<>$e1<>$w1<>$h1<>$e2<>$w2<>$h2<>$e3<>$w3<>$h3<>$in{tag}<>$in{clip}<>$in{tube}<>\n");
	seek(DAT,0,0);
	print DAT @file;
	truncate(DAT,tell(DAT));
	close(DAT);
	
	# RSS作成
	make_rss(@file) if ($cf{rss_make} == 1);
	
	# 完了
	message("新規記事を追加しました");
}

#-----------------------------------------------------------
#  画像アップロード
#-----------------------------------------------------------
sub upload {
	my $no = shift;
	
	# サムネイル機能
	require './lib/thumb.pl' if ($cf{thumbnail});
	
	my @ret;
	for my $i (1 .. 3) {
		# 拡張子取得
		my $ext;
		if ($cgi->param_filename("upfile$i") =~ /(\.\w+)$/i) {
			$ext = $1;
		} else {
			push(@ret,('','',''));
			next;
		}
		$ext =~ tr/A-Z/a-z/;
		if ($ext eq '.jpeg') { $ext = '.jpg'; }
		
		# 添付ファイル定義
		my $upfile = "$cf{upldir}/$no-$i$ext";
		
		# アップロード書き込み
		open(UP,"> $upfile") or error("up err: $upfile");
		binmode(UP);
		print UP $in{"upfile$i"};
		close(UP);
		
		# パーミッション付与
		chmod(0666,$upfile);
		
		# 画像の場合サイズ取得
		my ($flg,$w,$h);
		if ($ext eq ".jpg") { ($w,$h) = j_size($upfile); $flg++; }
		elsif ($ext eq ".gif") { ($w,$h) = g_size($upfile); $flg++; }
		elsif ($ext eq ".png") { ($w,$h) = p_size($upfile); $flg++; }
		
		# サムネイル作成
		if ($flg && $cf{thumbnail}) {
			($w,$h) = resize($w,$h);
			my $thumb = "$cf{upldir}/$no-s-$i$ext";
			make_thumb($upfile,$thumb,$w,$h);
		}
		
		# 拡張子, 横幅, 縦幅 の順
		push(@ret,($ext,$w,$h));
	}
	# 結果を返す
	return @ret;
}

#-----------------------------------------------------------
#  JPEGサイズ認識
#-----------------------------------------------------------
sub j_size {
	my $jpg = shift;
	
	my ($h, $w, $t);
	open(IMG,"$jpg");
	binmode(IMG);
	read(IMG, $t, 2);
	while (1) {
		read(IMG, $t, 4);
		my ($m, $c, $l) = unpack("a a n", $t);
		
		if ($m ne "\xFF") {
			$w = $h = 0;
			last;
		} elsif ((ord($c) >= 0xC0) && (ord($c) <= 0xC3)) {
			read(IMG, $t, 5);
			($h, $w) = unpack("xnn", $t);
			last;
		} else {
			read(IMG, $t, ($l - 2));
		}
	}
	close(IMG);
	
	return ($w,$h);
}

#-----------------------------------------------------------
#  GIFサイズ認識
#-----------------------------------------------------------
sub g_size {
	my $gif = shift;
	
	my $data;
	open(IMG,"$gif");
	binmode(IMG);
	sysread(IMG, $data, 10);
	close(IMG);
	
	if ($data =~ /^GIF/) { $data = substr($data, -4); }
	my $w = unpack("v", substr($data, 0, 2));
	my $h = unpack("v", substr($data, 2, 2));
	
	return ($w,$h);
}

#-----------------------------------------------------------
#  PNGサイズ認識
#-----------------------------------------------------------
sub p_size {
	my $png = shift;
	
	my $data;
	open(IMG,"$png");
	binmode(IMG);
	read(IMG, $data, 24);
	close(IMG);
	
	my $w = unpack("N", substr($data, 16, 20));
	my $h = unpack("N", substr($data, 20, 24));
	
	return ($w,$h);
}

#-----------------------------------------------------------
#  HTMLヘッダー
#-----------------------------------------------------------
sub header {
	my ($ttl,$js) = @_;
	
	print <<EOM;
Content-type: text/html; charset=utf-8

<!DOCTYPE html>
<html lang="ja">
<head>
<meta charset="utf-8">
<link href="$cf{cmnurl}/admin.css" rel="stylesheet">
EOM

	if ($js eq 'js') {
		print <<EOM;
<script>
// referer: http://5am.jp/javascript/form_change_javascript/
function entryChange1(){
	radio = document.getElementsByName('clip');
	if(radio[0].checked) {
		//フォーム
		document.getElementById('ibox').style.display = "";
		document.getElementById('ybox').style.display = "none";
	}else if(radio[1].checked) {
		//フォーム
		document.getElementById('ibox').style.display = "none";
		document.getElementById('ybox').style.display = "";
	}
}
//オンロードさせ、リロード時に選択を保持
window.onload = entryChange1;
</script>
EOM
	}
	
	print <<EOM;
<title>$ttl</title>
</head>
<body>
<div id="head">
	<img src="$cf{cmnurl}/star.png" alt="star" class="icon">
	TopicsBoard 管理画面 ::
</div>
EOM
}

#-----------------------------------------------------------
#  エラー
#-----------------------------------------------------------
sub error {
	my $err = shift;
	
	header("ERROR!");
	print <<EOM;
<div align="center">
<hr width="350">
<h3>ERROR!</h3>
<p class="err">$err</p>
<hr width="350">
<p><input type="button" value="前画面に戻る" onclick="history.back()"></p>
</div>
</body>
</html>
EOM
	exit;
}

#-----------------------------------------------------------
#  完了メッセージ
#-----------------------------------------------------------
sub message {
	my $msg = shift;
	
	header("完了");
	print <<EOM;
<div align="center" style="margin-top:3em;">
<hr width="350">
<p class="msg">$msg</p>
<hr width="350">
<form action="$cf{admin_cgi}" method="post">
<input type="hidden" name="sid" value="$in{sid}">
<input type="submit" value="管理画面に戻る">
</form>
</div>
</body>
</html>
EOM
	exit;
}

#-----------------------------------------------------------
#  戻りボタン
#-----------------------------------------------------------
sub back_btn {
	my $mode = shift;
	
	print <<EOM;
<div id="body">
<div class="ta-r">
<form action="$cf{admin_cgi}" method="post">
<input type="hidden" name="sid" value="$in{sid}">
@{[ $mode ? qq|<input type="submit" name="$mode" value="&lt; 前画面">| : "" ]}
<input type="submit" value="&lt; メニュー">
</form>
</div>
EOM
}

#-----------------------------------------------------------
#  入力チェック
#-----------------------------------------------------------
sub input_check {
	my $err;
	if (!$in{date}) { $err .= "日付が未入力です<br>"; }
	if (!$in{sub}) { $err .= "タイトルが未入力です<br>"; }
	if (!$in{comment}) { $err .= "メッセージが未入力です<br>"; }
	error($err) if ($err);
	
	# タグ復元
#	if ($in{tag} == 1) { $in{comment} =~ s/<br>//g; }
}

#-----------------------------------------------------------
#  RSS2.0 作成
#-----------------------------------------------------------
sub make_rss {
	my @log = @_;
	
	# RSS
	my $rss = <<EOM;
<?xml version="1.0" encoding="UTF-8" ?>
<rss version="2.0">
	<channel>
		<title>$cf{bbs_title}</title>
		<link>$cf{topiurl}</link>
		<description>$cf{description}</description>
		<language>ja</language>
		<generator>$cf{version}</generator>
EOM

	# 月/週
	my @mon  = qw(Jan Feb Mar Apr May Jun Jul Aug Sep Oct Nov Dec);
	my @week = qw(Sun Mon Tue Wed Thu Fri Sat);
	
	my $i;
	for (@log) {
		my ($no,$date,$sub,$com,$e1,$w1,$h1,$e2,$w2,$h2,$e3,$w3,$h3,$tag,$clip,$tube) = split(/<>/);
		my ($y,$m,$d) = split(/\//,$date);
		
		# 曜日
		my $w = get_week($d,$m,$y);
		
		# 文字カット: description
		my $char = strcutbytes_utf8($com,150);
		
		$rss .= qq|\t\t<item>\n|;
		$rss .= qq|\t\t\t<title>$sub</title>\n|;
		$rss .= qq|\t\t\t<link>$cf{rssurl}#$no</link>\n|;
		$rss .= qq|\t\t\t<description>$char</description>\n|;
		$rss .= qq|\t\t\t<pubDate>$week[$w], $d $mon[$m-1] $y 00:00:00 +0900</pubDate>\n|;
		$rss .= qq|\t\t</item>\n|;
		
		$i++;
		last if ($i >= $cf{pg_max});
	}
	$rss .= "\t</channel>\n</rss>\n";
	
	# RSS書込
	open(RSS,"> $cf{rssfile}") or error("write err: $cf{rssfile}");
	print RSS $rss;
	close(RSS);
}

#-----------------------------------------------------------
#  ツェラー公式
#-----------------------------------------------------------
sub get_week {
	my ($day,$month,$year) = @_;
	if ($month == 1 || $month == 2) {
		$year--;
		$month += 12;
	}
	return int($year + int($year/4) - int($year/100) + int($year/400) + int((13*$month+8)/5) + $day) % 7;
}

#-----------------------------------------------------------
#  文字カット for UTF-8
#  [quote] http://linkage.white-void.net/development/server/perl-utf8-strcut.html
#-----------------------------------------------------------
sub strcutbytes_utf8 {
	my ($src,$maxlen) = @_;
	$src =~ s/[\t\n]//g;
	$src =~ s/&lt;.*?&gt;//g;
	
	my $srclen = length($src);
	my $srcpos = 0;
	while($srcpos < $srclen) {
		my $character = substr($src, $srcpos, 1);
		my $value = ord($character);
		if($value < 0x80) { # ASCII characters
			$srcpos++;
			next;
		}
		my $width = 6;
		$width = 5 if ($value < 0xFC);
		$width = 4 if ($value < 0xF8);
		$width = 3 if ($value < 0xF0);
		$width = 2 if ($value < 0xE0);
		my $nextpos = $srcpos + $width;
		last if($nextpos > $maxlen);
		last if($nextpos > $srclen); # sequence is incomplete
		$srcpos = $nextpos;
	}
	return substr($src, 0, $srcpos);
}

